// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file was generated by:
//   ./tools/json_schema_compiler/compiler.py.

/** @fileoverview Interface for quickUnlockPrivate that can be overriden. */

assertNotReached('Interface file for Closure Compiler should not be executed.');

/** @interface */
function QuickUnlockPrivate() {}

QuickUnlockPrivate.prototype = {
  /**
   * Returns the set of quick unlock modes that are available for the user to
   * use. Some quick unlock modes may be disabled by policy.
   * @param {function(!Array<!chrome.quickUnlockPrivate.QuickUnlockMode>):void}
   *     onComplete
   * @see https://developer.chrome.com/extensions/quickUnlockPrivate#method-getAvailableModes
   */
  getAvailableModes: assertNotReached,

  /**
   * Returns the quick unlock modes that are currently enabled and usable on the
   * lock screen.
   * @param {function(!Array<!chrome.quickUnlockPrivate.QuickUnlockMode>):void}
   *     onComplete
   * @see https://developer.chrome.com/extensions/quickUnlockPrivate#method-getActiveModes
   */
  getActiveModes: assertNotReached,

  /**
   * Update the set of quick unlock modes that are currently active/enabled.
   * @param {string} accountPassword The password associated with the account
   *     (e.g. the GAIA password). This is required to change the quick unlock
   *     credentials.
   * @param {!Array<!chrome.quickUnlockPrivate.QuickUnlockMode>} modes The quick
   *     unlock modes that should be active.
   * @param {!Array<string>} credentials The associated credential for each
   *     mode. To keep the credential the same for the associated mode, pass an
   *     empty string.
   * @param {function(boolean):void} onComplete Called with true if the quick
   *     unlock state was updated, false otherwise. The update is treated as a
   *     single atomic operation.
   * @see https://developer.chrome.com/extensions/quickUnlockPrivate#method-setModes
   */
  setModes: assertNotReached,
};

/**
 * Called after the active set of quick unlock modes has changed.
 * @type {!ChromeEvent}
 * @see https://developer.chrome.com/extensions/quickUnlockPrivate#event-onActiveModesChanged
 */
QuickUnlockPrivate.prototype.onActiveModesChanged;
