# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventgrid import EventGridManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventGridManagementPartnerRegistrationsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventGridManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_partner_registrations_get(self, resource_group):
        response = self.client.partner_registrations.get(
            resource_group_name=resource_group.name,
            partner_registration_name="str",
            api_version="2025-02-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_partner_registrations_begin_create_or_update(self, resource_group):
        response = self.client.partner_registrations.begin_create_or_update(
            resource_group_name=resource_group.name,
            partner_registration_name="str",
            partner_registration_info={
                "location": "str",
                "id": "str",
                "name": "str",
                "partnerRegistrationImmutableId": "str",
                "provisioningState": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
            api_version="2025-02-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_partner_registrations_begin_delete(self, resource_group):
        response = self.client.partner_registrations.begin_delete(
            resource_group_name=resource_group.name,
            partner_registration_name="str",
            api_version="2025-02-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_partner_registrations_begin_update(self, resource_group):
        response = self.client.partner_registrations.begin_update(
            resource_group_name=resource_group.name,
            partner_registration_name="str",
            partner_registration_update_parameters={"tags": {"str": "str"}},
            api_version="2025-02-15",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_partner_registrations_list_by_subscription(self, resource_group):
        response = self.client.partner_registrations.list_by_subscription(
            api_version="2025-02-15",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_partner_registrations_list_by_resource_group(self, resource_group):
        response = self.client.partner_registrations.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-02-15",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
