# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.mgmt.core import AsyncARMPipelineClient
from azure.mgmt.core.policies import AsyncARMAutoResourceProviderRegistrationPolicy
from azure.profiles import KnownProfiles, ProfileDefinition
from azure.profiles.multiapiclient import MultiApiClientMixin

from .._serialization import Deserializer, Serializer
from ._configuration import StorageManagementClientConfiguration

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential

class _SDKClient(object):
    def __init__(self, *args, **kwargs):
        """This is a fake class to support current implemetation of MultiApiClientMixin."
        Will be removed in final version of multiapi azure-core based client
        """
        pass

class StorageManagementClient(MultiApiClientMixin, _SDKClient):
    """The Azure Storage Management API.

    This ready contains multiple API versions, to help you deal with all of the Azure clouds
    (Azure Stack, Azure Government, Azure China, etc.).
    By default, it uses the latest API version available on public Azure.
    For production, you should stick to a particular api-version and/or profile.
    The profile sets a mapping between an operation group and its API version.
    The api-version parameter sets the default API version if the operation
    group is not described in the profile.

    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param api_version: API version to use if no profile is provided, or if missing in profile.
    :type api_version: str
    :param base_url: Service URL
    :type base_url: str
    :param profile: A profile definition, from KnownProfiles to dict.
    :type profile: azure.profiles.KnownProfiles
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    DEFAULT_API_VERSION = '2024-01-01'
    _PROFILE_TAG = "azure.mgmt.storage.StorageManagementClient"
    LATEST_PROFILE = ProfileDefinition({
        _PROFILE_TAG: {
            None: DEFAULT_API_VERSION,
            'usage': '2017-10-01',
        }},
        _PROFILE_TAG + " latest"
    )

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        api_version: Optional[str] = None,
        base_url: str = "https://management.azure.com",
        profile: KnownProfiles = KnownProfiles.default,
        **kwargs: Any
    ) -> None:
        if api_version:
            kwargs.setdefault('api_version', api_version)
        self._config = StorageManagementClientConfiguration(credential, subscription_id, **kwargs)
        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                AsyncARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(base_url=base_url, policies=_policies, **kwargs)
        super(StorageManagementClient, self).__init__(
            api_version=api_version,
            profile=profile
        )

    @classmethod
    def _models_dict(cls, api_version):
        return {k: v for k, v in cls.models(api_version).__dict__.items() if isinstance(v, type)}

    @classmethod
    def models(cls, api_version=DEFAULT_API_VERSION):
        """Module depends on the API version:

           * 2016-01-01: :mod:`v2016_01_01.models<azure.mgmt.storage.v2016_01_01.models>`
           * 2017-10-01: :mod:`v2017_10_01.models<azure.mgmt.storage.v2017_10_01.models>`
           * 2019-06-01: :mod:`v2019_06_01.models<azure.mgmt.storage.v2019_06_01.models>`
           * 2024-01-01: :mod:`v2024_01_01.models<azure.mgmt.storage.v2024_01_01.models>`
        """
        if api_version == '2016-01-01':
            from ..v2016_01_01 import models
            return models
        elif api_version == '2017-10-01':
            from ..v2017_10_01 import models
            return models
        elif api_version == '2019-06-01':
            from ..v2019_06_01 import models
            return models
        elif api_version == '2024-01-01':
            from ..v2024_01_01 import models
            return models
        raise ValueError("API version {} is not available".format(api_version))

    @property
    def blob_containers(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`BlobContainersOperations<azure.mgmt.storage.v2019_06_01.aio.operations.BlobContainersOperations>`
           * 2024-01-01: :class:`BlobContainersOperations<azure.mgmt.storage.v2024_01_01.aio.operations.BlobContainersOperations>`
        """
        api_version = self._get_api_version('blob_containers')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations import BlobContainersOperations as OperationClass
        elif api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import BlobContainersOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'blob_containers'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def blob_inventory_policies(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`BlobInventoryPoliciesOperations<azure.mgmt.storage.v2019_06_01.aio.operations.BlobInventoryPoliciesOperations>`
           * 2024-01-01: :class:`BlobInventoryPoliciesOperations<azure.mgmt.storage.v2024_01_01.aio.operations.BlobInventoryPoliciesOperations>`
        """
        api_version = self._get_api_version('blob_inventory_policies')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations import BlobInventoryPoliciesOperations as OperationClass
        elif api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import BlobInventoryPoliciesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'blob_inventory_policies'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def blob_services(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`BlobServicesOperations<azure.mgmt.storage.v2019_06_01.aio.operations.BlobServicesOperations>`
           * 2024-01-01: :class:`BlobServicesOperations<azure.mgmt.storage.v2024_01_01.aio.operations.BlobServicesOperations>`
        """
        api_version = self._get_api_version('blob_services')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations import BlobServicesOperations as OperationClass
        elif api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import BlobServicesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'blob_services'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def deleted_accounts(self):
        """Instance depends on the API version:

           * 2024-01-01: :class:`DeletedAccountsOperations<azure.mgmt.storage.v2024_01_01.aio.operations.DeletedAccountsOperations>`
        """
        api_version = self._get_api_version('deleted_accounts')
        if api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import DeletedAccountsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'deleted_accounts'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def encryption_scopes(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`EncryptionScopesOperations<azure.mgmt.storage.v2019_06_01.aio.operations.EncryptionScopesOperations>`
           * 2024-01-01: :class:`EncryptionScopesOperations<azure.mgmt.storage.v2024_01_01.aio.operations.EncryptionScopesOperations>`
        """
        api_version = self._get_api_version('encryption_scopes')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations import EncryptionScopesOperations as OperationClass
        elif api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import EncryptionScopesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'encryption_scopes'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def file_services(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`FileServicesOperations<azure.mgmt.storage.v2019_06_01.aio.operations.FileServicesOperations>`
           * 2024-01-01: :class:`FileServicesOperations<azure.mgmt.storage.v2024_01_01.aio.operations.FileServicesOperations>`
        """
        api_version = self._get_api_version('file_services')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations import FileServicesOperations as OperationClass
        elif api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import FileServicesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'file_services'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def file_shares(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`FileSharesOperations<azure.mgmt.storage.v2019_06_01.aio.operations.FileSharesOperations>`
           * 2024-01-01: :class:`FileSharesOperations<azure.mgmt.storage.v2024_01_01.aio.operations.FileSharesOperations>`
        """
        api_version = self._get_api_version('file_shares')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations import FileSharesOperations as OperationClass
        elif api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import FileSharesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'file_shares'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def local_users(self):
        """Instance depends on the API version:

           * 2024-01-01: :class:`LocalUsersOperations<azure.mgmt.storage.v2024_01_01.aio.operations.LocalUsersOperations>`
        """
        api_version = self._get_api_version('local_users')
        if api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import LocalUsersOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'local_users'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def management_policies(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`ManagementPoliciesOperations<azure.mgmt.storage.v2019_06_01.aio.operations.ManagementPoliciesOperations>`
           * 2024-01-01: :class:`ManagementPoliciesOperations<azure.mgmt.storage.v2024_01_01.aio.operations.ManagementPoliciesOperations>`
        """
        api_version = self._get_api_version('management_policies')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations import ManagementPoliciesOperations as OperationClass
        elif api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import ManagementPoliciesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'management_policies'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def network_security_perimeter_configurations(self):
        """Instance depends on the API version:

           * 2024-01-01: :class:`NetworkSecurityPerimeterConfigurationsOperations<azure.mgmt.storage.v2024_01_01.aio.operations.NetworkSecurityPerimeterConfigurationsOperations>`
        """
        api_version = self._get_api_version('network_security_perimeter_configurations')
        if api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import NetworkSecurityPerimeterConfigurationsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'network_security_perimeter_configurations'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def object_replication_policies(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`ObjectReplicationPoliciesOperations<azure.mgmt.storage.v2019_06_01.aio.operations.ObjectReplicationPoliciesOperations>`
           * 2024-01-01: :class:`ObjectReplicationPoliciesOperations<azure.mgmt.storage.v2024_01_01.aio.operations.ObjectReplicationPoliciesOperations>`
        """
        api_version = self._get_api_version('object_replication_policies')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations import ObjectReplicationPoliciesOperations as OperationClass
        elif api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import ObjectReplicationPoliciesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'object_replication_policies'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def operations(self):
        """Instance depends on the API version:

           * 2017-10-01: :class:`Operations<azure.mgmt.storage.v2017_10_01.aio.operations.Operations>`
           * 2019-06-01: :class:`Operations<azure.mgmt.storage.v2019_06_01.aio.operations.Operations>`
           * 2024-01-01: :class:`Operations<azure.mgmt.storage.v2024_01_01.aio.operations.Operations>`
        """
        api_version = self._get_api_version('operations')
        if api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations import Operations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations import Operations as OperationClass
        elif api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import Operations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'operations'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def private_endpoint_connections(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`PrivateEndpointConnectionsOperations<azure.mgmt.storage.v2019_06_01.aio.operations.PrivateEndpointConnectionsOperations>`
           * 2024-01-01: :class:`PrivateEndpointConnectionsOperations<azure.mgmt.storage.v2024_01_01.aio.operations.PrivateEndpointConnectionsOperations>`
        """
        api_version = self._get_api_version('private_endpoint_connections')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations import PrivateEndpointConnectionsOperations as OperationClass
        elif api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import PrivateEndpointConnectionsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'private_endpoint_connections'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def private_link_resources(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`PrivateLinkResourcesOperations<azure.mgmt.storage.v2019_06_01.aio.operations.PrivateLinkResourcesOperations>`
           * 2024-01-01: :class:`PrivateLinkResourcesOperations<azure.mgmt.storage.v2024_01_01.aio.operations.PrivateLinkResourcesOperations>`
        """
        api_version = self._get_api_version('private_link_resources')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations import PrivateLinkResourcesOperations as OperationClass
        elif api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import PrivateLinkResourcesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'private_link_resources'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def queue(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`QueueOperations<azure.mgmt.storage.v2019_06_01.aio.operations.QueueOperations>`
           * 2024-01-01: :class:`QueueOperations<azure.mgmt.storage.v2024_01_01.aio.operations.QueueOperations>`
        """
        api_version = self._get_api_version('queue')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations import QueueOperations as OperationClass
        elif api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import QueueOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'queue'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def queue_services(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`QueueServicesOperations<azure.mgmt.storage.v2019_06_01.aio.operations.QueueServicesOperations>`
           * 2024-01-01: :class:`QueueServicesOperations<azure.mgmt.storage.v2024_01_01.aio.operations.QueueServicesOperations>`
        """
        api_version = self._get_api_version('queue_services')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations import QueueServicesOperations as OperationClass
        elif api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import QueueServicesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'queue_services'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def skus(self):
        """Instance depends on the API version:

           * 2017-10-01: :class:`SkusOperations<azure.mgmt.storage.v2017_10_01.aio.operations.SkusOperations>`
           * 2019-06-01: :class:`SkusOperations<azure.mgmt.storage.v2019_06_01.aio.operations.SkusOperations>`
           * 2024-01-01: :class:`SkusOperations<azure.mgmt.storage.v2024_01_01.aio.operations.SkusOperations>`
        """
        api_version = self._get_api_version('skus')
        if api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations import SkusOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations import SkusOperations as OperationClass
        elif api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import SkusOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'skus'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def storage_accounts(self):
        """Instance depends on the API version:

           * 2016-01-01: :class:`StorageAccountsOperations<azure.mgmt.storage.v2016_01_01.aio.operations.StorageAccountsOperations>`
           * 2017-10-01: :class:`StorageAccountsOperations<azure.mgmt.storage.v2017_10_01.aio.operations.StorageAccountsOperations>`
           * 2019-06-01: :class:`StorageAccountsOperations<azure.mgmt.storage.v2019_06_01.aio.operations.StorageAccountsOperations>`
           * 2024-01-01: :class:`StorageAccountsOperations<azure.mgmt.storage.v2024_01_01.aio.operations.StorageAccountsOperations>`
        """
        api_version = self._get_api_version('storage_accounts')
        if api_version == '2016-01-01':
            from ..v2016_01_01.aio.operations import StorageAccountsOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations import StorageAccountsOperations as OperationClass
        elif api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations import StorageAccountsOperations as OperationClass
        elif api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import StorageAccountsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'storage_accounts'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def storage_task_assignment_instances_report(self):
        """Instance depends on the API version:

           * 2024-01-01: :class:`StorageTaskAssignmentInstancesReportOperations<azure.mgmt.storage.v2024_01_01.aio.operations.StorageTaskAssignmentInstancesReportOperations>`
        """
        api_version = self._get_api_version('storage_task_assignment_instances_report')
        if api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import StorageTaskAssignmentInstancesReportOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'storage_task_assignment_instances_report'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def storage_task_assignments(self):
        """Instance depends on the API version:

           * 2024-01-01: :class:`StorageTaskAssignmentsOperations<azure.mgmt.storage.v2024_01_01.aio.operations.StorageTaskAssignmentsOperations>`
        """
        api_version = self._get_api_version('storage_task_assignments')
        if api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import StorageTaskAssignmentsOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'storage_task_assignments'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def storage_task_assignments_instances_report(self):
        """Instance depends on the API version:

           * 2024-01-01: :class:`StorageTaskAssignmentsInstancesReportOperations<azure.mgmt.storage.v2024_01_01.aio.operations.StorageTaskAssignmentsInstancesReportOperations>`
        """
        api_version = self._get_api_version('storage_task_assignments_instances_report')
        if api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import StorageTaskAssignmentsInstancesReportOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'storage_task_assignments_instances_report'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def table(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`TableOperations<azure.mgmt.storage.v2019_06_01.aio.operations.TableOperations>`
           * 2024-01-01: :class:`TableOperations<azure.mgmt.storage.v2024_01_01.aio.operations.TableOperations>`
        """
        api_version = self._get_api_version('table')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations import TableOperations as OperationClass
        elif api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import TableOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'table'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def table_services(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`TableServicesOperations<azure.mgmt.storage.v2019_06_01.aio.operations.TableServicesOperations>`
           * 2024-01-01: :class:`TableServicesOperations<azure.mgmt.storage.v2024_01_01.aio.operations.TableServicesOperations>`
        """
        api_version = self._get_api_version('table_services')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations import TableServicesOperations as OperationClass
        elif api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import TableServicesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'table_services'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def usage(self):
        """Instance depends on the API version:

           * 2016-01-01: :class:`UsageOperations<azure.mgmt.storage.v2016_01_01.aio.operations.UsageOperations>`
           * 2017-10-01: :class:`UsageOperations<azure.mgmt.storage.v2017_10_01.aio.operations.UsageOperations>`
        """
        api_version = self._get_api_version('usage')
        if api_version == '2016-01-01':
            from ..v2016_01_01.aio.operations import UsageOperations as OperationClass
        elif api_version == '2017-10-01':
            from ..v2017_10_01.aio.operations import UsageOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'usage'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    @property
    def usages(self):
        """Instance depends on the API version:

           * 2019-06-01: :class:`UsagesOperations<azure.mgmt.storage.v2019_06_01.aio.operations.UsagesOperations>`
           * 2024-01-01: :class:`UsagesOperations<azure.mgmt.storage.v2024_01_01.aio.operations.UsagesOperations>`
        """
        api_version = self._get_api_version('usages')
        if api_version == '2019-06-01':
            from ..v2019_06_01.aio.operations import UsagesOperations as OperationClass
        elif api_version == '2024-01-01':
            from ..v2024_01_01.aio.operations import UsagesOperations as OperationClass
        else:
            raise ValueError("API version {} does not have operation group 'usages'".format(api_version))
        self._config.api_version = api_version
        return OperationClass(self._client, self._config, Serializer(self._models_dict(api_version)), Deserializer(self._models_dict(api_version)), api_version)

    async def close(self):
        await self._client.close()
    async def __aenter__(self):
        await self._client.__aenter__()
        return self
    async def __aexit__(self, *exc_details):
        await self._client.__aexit__(*exc_details)
