# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource_py3 import ProxyResource


class Webhook(ProxyResource):
    """Definition of the webhook type.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :param is_enabled: Gets or sets the value of the enabled flag of the
     webhook. Default value: False .
    :type is_enabled: bool
    :param uri: Gets or sets the webhook uri.
    :type uri: str
    :param expiry_time: Gets or sets the expiry time.
    :type expiry_time: datetime
    :param last_invoked_time: Gets or sets the last invoked time.
    :type last_invoked_time: datetime
    :param parameters: Gets or sets the parameters of the job that is created
     when the webhook calls the runbook it is associated with.
    :type parameters: dict[str, str]
    :param runbook: Gets or sets the runbook the webhook is associated with.
    :type runbook: ~azure.mgmt.automation.models.RunbookAssociationProperty
    :param run_on: Gets or sets the name of the hybrid worker group the
     webhook job will run on.
    :type run_on: str
    :param creation_time: Gets or sets the creation time.
    :type creation_time: datetime
    :param last_modified_time: Gets or sets the last modified time.
    :type last_modified_time: datetime
    :param last_modified_by: Details of the user who last modified the Webhook
    :type last_modified_by: str
    :param description: Gets or sets the description.
    :type description: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'is_enabled': {'key': 'properties.isEnabled', 'type': 'bool'},
        'uri': {'key': 'properties.uri', 'type': 'str'},
        'expiry_time': {'key': 'properties.expiryTime', 'type': 'iso-8601'},
        'last_invoked_time': {'key': 'properties.lastInvokedTime', 'type': 'iso-8601'},
        'parameters': {'key': 'properties.parameters', 'type': '{str}'},
        'runbook': {'key': 'properties.runbook', 'type': 'RunbookAssociationProperty'},
        'run_on': {'key': 'properties.runOn', 'type': 'str'},
        'creation_time': {'key': 'properties.creationTime', 'type': 'iso-8601'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'properties.lastModifiedBy', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
    }

    def __init__(self, *, is_enabled: bool=False, uri: str=None, expiry_time=None, last_invoked_time=None, parameters=None, runbook=None, run_on: str=None, creation_time=None, last_modified_time=None, last_modified_by: str=None, description: str=None, **kwargs) -> None:
        super(Webhook, self).__init__(**kwargs)
        self.is_enabled = is_enabled
        self.uri = uri
        self.expiry_time = expiry_time
        self.last_invoked_time = last_invoked_time
        self.parameters = parameters
        self.runbook = runbook
        self.run_on = run_on
        self.creation_time = creation_time
        self.last_modified_time = last_modified_time
        self.last_modified_by = last_modified_by
        self.description = description
