# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class OperationTagResourceContractProperties(Model):
    """Operation Entity contract Properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Identifier of the operation in form /operations/{operationId}.
    :type id: str
    :ivar name: Operation name.
    :vartype name: str
    :ivar api_name: Api Name.
    :vartype api_name: str
    :ivar api_revision: Api Revision.
    :vartype api_revision: str
    :ivar api_version: Api Version.
    :vartype api_version: str
    :ivar description: Operation Description.
    :vartype description: str
    :ivar method: A Valid HTTP Operation Method. Typical Http Methods like
     GET, PUT, POST but not limited by only them.
    :vartype method: str
    :ivar url_template: Relative URL template identifying the target resource
     for this operation. May include parameters. Example:
     /customers/{cid}/orders/{oid}/?date={date}
    :vartype url_template: str
    """

    _validation = {
        'name': {'readonly': True},
        'api_name': {'readonly': True},
        'api_revision': {'readonly': True},
        'api_version': {'readonly': True},
        'description': {'readonly': True},
        'method': {'readonly': True},
        'url_template': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'api_name': {'key': 'apiName', 'type': 'str'},
        'api_revision': {'key': 'apiRevision', 'type': 'str'},
        'api_version': {'key': 'apiVersion', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'method': {'key': 'method', 'type': 'str'},
        'url_template': {'key': 'urlTemplate', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationTagResourceContractProperties, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.name = None
        self.api_name = None
        self.api_revision = None
        self.api_version = None
        self.description = None
        self.method = None
        self.url_template = None
