/*
 * MenuIndexConstants
 * 
 * Copyright (c) 2000, 2001, 2002, 2003, 2004, 2005, 2006 Marco Schmidt.
 * All rights reserved.
 */

package net.sourceforge.jiu.apps;

/**
 * Constant int values for all menu items.
 * Some of these menu items denote operations which can be performed by
 * {@link OperationProcessor}.
 *
 * @author Marco Schmidt
 */
public interface MenuIndexConstants
{
	int FILE = 0;
	int FILE_OPEN = 1;
	int FILE_SAVEAS = 2;
	int FILE_SAVEAS_GIF = 83;
	int FILE_SAVEAS_PALM = 81;
	int FILE_SAVEAS_PBM = 3;
	int FILE_SAVEAS_PGM = 4;
	int FILE_SAVEAS_PNG = 82;
	int FILE_SAVEAS_PPM = 5;
	int FILE_SAVEAS_SUNRASTER = 6;
	int FILE_SAVEAS_WINDOWSBMP = 7;
	int FILE_IMAGE_1 = 84;
	int FILE_CLOSE = 8;
	int FILE_EXIT = 9;
	int EDIT = 67;
	int EDIT_UNDO = 68;
	int EDIT_REDO = 69;
	int COLOR = 10;
	int COLOR_ADJUST = 11;
	int COLOR_ADJUST_BRIGHTNESS = 12;
	int COLOR_ADJUST_CONTRAST = 13;
	int COLOR_ADJUST_GAMMA = 14;
	int COLOR_ADJUST_HUESATURATIONVALUE = 15;
	int COLOR_HISTOGRAM = 16;
	int COLOR_HISTOGRAM_COUNTCOLORSUSED = 17;
	int COLOR_HISTOGRAM_EQUALIZE = 18;
	int COLOR_HISTOGRAM_NORMALIZE = 19;
	int COLOR_HISTOGRAM_TEXTUREPROPERTIES = 70;
	int COLOR_HISTOGRAM_SAVEHISTOGRAMAS = 66;
	int COLOR_HISTOGRAM_SAVECOOCCURRENCEMATRIXAS = 20;
	int COLOR_HISTOGRAM_SAVECOOCCURRENCEFREQUENCYMATRIXAS = 21;
	int COLOR_PALETTE = 22;
	int COLOR_PALETTE_SAVEAS = 23;
	int COLOR_PROMOTE = 24;
	int COLOR_PROMOTE_PROMOTETOPALETTED = 25;
	int COLOR_PROMOTE_PROMOTETOGRAY8 = 26;
	int COLOR_PROMOTE_PROMOTETOGRAY16 = 27;
	int COLOR_PROMOTE_PROMOTETORGB24 = 28;
	int COLOR_PROMOTE_PROMOTETORGB48 = 29;
	int COLOR_REDUCE = 30;
	int COLOR_REDUCE_REDUCETOBILEVELTHRESHOLD = 31;
	int COLOR_REDUCE_REDUCENUMBEROFSHADESOFGRAY = 32;
	int COLOR_REDUCE_CONVERTTOGRAYSCALE = 33;
	int COLOR_REDUCE_MEDIANCUT = 34;
	int COLOR_REDUCE_OCTREE = 35;
	int COLOR_REDUCE_UNIFORMPALETTE = 36;
	int COLOR_REDUCE_MAPTOARBITRARYPALETTE = 37;
	int COLOR_INVERT = 38;
	int COLOR_CONVERTTOMINIMUMCOLORTYPE = 39;
	int TRANSFORMATIONS = 40;
	int TRANSFORMATIONS_FLIP = 41;
	int TRANSFORMATIONS_MIRROR = 42;
	int TRANSFORMATIONS_ROTATELEFT90 = 43;
	int TRANSFORMATIONS_ROTATERIGHT90 = 44;
	int TRANSFORMATIONS_ROTATE180 = 45;
	int TRANSFORMATIONS_CROP = 46;
	int TRANSFORMATIONS_SCALE = 47;
	int TRANSFORMATIONS_SHEAR = 48;
	int FILTERS = 49;
	int FILTERS_BLUR = 50;
	int FILTERS_SHARPEN = 51;
	int FILTERS_EDGEDETECTION = 52;
	int FILTERS_EMBOSS = 53;
	int FILTERS_PSYCHEDELICDISTILLATION = 54;
	int FILTERS_LITHOGRAPH = 55;
	int FILTERS_HORIZONTALSOBEL = 56;
	int FILTERS_VERTICALSOBEL = 57;
	int FILTERS_HORIZONTALPREWITT = 58;
	int FILTERS_VERTICALPREWITT = 59;
	int FILTERS_MINIMUM = 71;
	int FILTERS_MAXIMUM = 72;
	int FILTERS_MEDIAN = 60;
	int FILTERS_MEAN = 61;
	int FILTERS_OIL = 62;
	int VIEW = 73;
	int VIEW_ZOOMIN = 74;
	int VIEW_ZOOMOUT = 75;
	int VIEW_SETORIGINALSIZE = 76;
	int VIEW_INTERPOLATIONTYPE = 77;
	int VIEW_INTERPOLATIONTYPE_NEARESTNEIGHBOR = 78;
	int VIEW_INTERPOLATIONTYPE_BILINEAR = 79;
	int VIEW_INTERPOLATIONTYPE_BICUBIC = 80;
	int HELP = 63;
	int HELP_ABOUT = 64;
	int HELP_SYSTEMINFORMATION = 65;
	
	int NUM_CONSTANTS = 85;
}
