; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s --mtriple=wasm32-unknown-unknown | FileCheck %s

%alloca_cell = type ptr addrspace(1)

; We have a set of tests in which we set a local and then reload the
; local.  If the load immediately follows the set, the DAG combiner will
; infer that the reloaded value is the same value that was set, which
; isn't what we want to test.  To inhibit this optimization, we include
; an opaque call between the store and the load.
declare void @inhibit_store_to_load_forwarding()

define i32 @ir_local_i32(i32 %arg) {
; CHECK-LABEL: ir_local_i32:
; CHECK:         .functype ir_local_i32 (i32) -> (i32)
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    call inhibit_store_to_load_forwarding
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    # fallthrough-return
 %retval = alloca i32, addrspace(1)
 store i32 %arg, %alloca_cell %retval
 call void @inhibit_store_to_load_forwarding()
 %reloaded = load i32, %alloca_cell %retval
 ret i32 %reloaded
}

define i64 @ir_local_i64(i64 %arg) {
; CHECK-LABEL: ir_local_i64:
; CHECK:         .functype ir_local_i64 (i64) -> (i64)
; CHECK-NEXT:    .local i64
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    call inhibit_store_to_load_forwarding
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    # fallthrough-return
 %retval = alloca i64, addrspace(1)
 store i64 %arg, %alloca_cell %retval
 call void @inhibit_store_to_load_forwarding()
 %reloaded = load i64, %alloca_cell %retval
 ; See note in ir_local_i32.
 ret i64 %reloaded
}

define float @ir_local_f32(float %arg) {
; CHECK-LABEL: ir_local_f32:
; CHECK:         .functype ir_local_f32 (f32) -> (f32)
; CHECK-NEXT:    .local f32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    call inhibit_store_to_load_forwarding
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    # fallthrough-return
 %retval = alloca float, addrspace(1)
 store float %arg, %alloca_cell %retval
 call void @inhibit_store_to_load_forwarding()
 %reloaded = load float, %alloca_cell %retval
 ret float %reloaded
}

define double @ir_local_f64(double %arg) {
; CHECK-LABEL: ir_local_f64:
; CHECK:         .functype ir_local_f64 (f64) -> (f64)
; CHECK-NEXT:    .local f64
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    local.get 0
; CHECK-NEXT:    local.set 1
; CHECK-NEXT:    call inhibit_store_to_load_forwarding
; CHECK-NEXT:    local.get 1
; CHECK-NEXT:    # fallthrough-return
 %retval = alloca double, addrspace(1)
 store double %arg, %alloca_cell %retval
 call void @inhibit_store_to_load_forwarding()
 %reloaded = load double, %alloca_cell %retval
 ret double %reloaded
}

define void @ir_unreferenced_local() {
; CHECK-LABEL: ir_unreferenced_local:
; CHECK:         .functype ir_unreferenced_local () -> ()
; CHECK-NEXT:    .local i32
; CHECK-NEXT:  # %bb.0:
; CHECK-NEXT:    # fallthrough-return
 %unused = alloca i32, addrspace(1)
 ret void
}
