/*********************************************************************/
/* Copyright 2009, 2010 The University of Texas at Austin.           */
/* All rights reserved.                                              */
/*                                                                   */
/* Redistribution and use in source and binary forms, with or        */
/* without modification, are permitted provided that the following   */
/* conditions are met:                                               */
/*                                                                   */
/*   1. Redistributions of source code must retain the above         */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer.                                                  */
/*                                                                   */
/*   2. Redistributions in binary form must reproduce the above      */
/*      copyright notice, this list of conditions and the following  */
/*      disclaimer in the documentation and/or other materials       */
/*      provided with the distribution.                              */
/*                                                                   */
/*    THIS  SOFTWARE IS PROVIDED  BY THE  UNIVERSITY OF  TEXAS AT    */
/*    AUSTIN  ``AS IS''  AND ANY  EXPRESS OR  IMPLIED WARRANTIES,    */
/*    INCLUDING, BUT  NOT LIMITED  TO, THE IMPLIED  WARRANTIES OF    */
/*    MERCHANTABILITY  AND FITNESS FOR  A PARTICULAR  PURPOSE ARE    */
/*    DISCLAIMED.  IN  NO EVENT SHALL THE UNIVERSITY  OF TEXAS AT    */
/*    AUSTIN OR CONTRIBUTORS BE  LIABLE FOR ANY DIRECT, INDIRECT,    */
/*    INCIDENTAL,  SPECIAL, EXEMPLARY,  OR  CONSEQUENTIAL DAMAGES    */
/*    (INCLUDING, BUT  NOT LIMITED TO,  PROCUREMENT OF SUBSTITUTE    */
/*    GOODS  OR  SERVICES; LOSS  OF  USE,  DATA,  OR PROFI_BOBCAT;  OR    */
/*    BUSINESS INTERRUPTION) HOWEVER CAUSED  AND ON ANY THEORY OF    */
/*    LIABILITY, WHETHER  IN CONTRACT, STRICT  LIABILITY, OR TORT    */
/*    (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY WAY OUT    */
/*    OF  THE  USE OF  THIS  SOFTWARE,  EVEN  IF ADVISED  OF  THE    */
/*    POSSIBILITY OF SUCH DAMAGE.                                    */
/*                                                                   */
/* The views and conclusions contained in the software and           */
/* documentation are those of the authors and should not be          */
/* interpreted as representing official policies, either expressed   */
/* or implied, of The University of Texas at Austin.                 */
/*********************************************************************/

#include <stdio.h>
#include <string.h>
#include "common.h"

#ifdef BUILD_KERNEL
#include "kernel_BOBCAT.h"
#endif

#undef DEBUG

static void init_parameter(void);

gotoblas_t TABLE_NAME = {
  DTB_DEFAULT_ENTRIES ,

  GEMM_DEFAULT_OFFSET_A, GEMM_DEFAULT_OFFSET_B, GEMM_DEFAULT_ALIGN,

#ifdef BUILD_BFLOAT16
  0, 0, 0,
  SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N,
#ifdef SBGEMM_DEFAULT_UNROLL_MN
 SBGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SBGEMM_DEFAULT_UNROLL_M, SBGEMM_DEFAULT_UNROLL_N),
#endif

  sbstobf16_k_BOBCAT, sbdtobf16_k_BOBCAT, sbf16tos_k_BOBCAT, dbf16tod_k_BOBCAT,

  samax_k_BOBCAT,  samin_k_BOBCAT,  smax_k_BOBCAT,  smin_k_BOBCAT,
  isamax_k_BOBCAT, isamin_k_BOBCAT, ismax_k_BOBCAT, ismin_k_BOBCAT,
  snrm2_k_BOBCAT,  sasum_k_BOBCAT, ssum_k_BOBCAT, scopy_k_BOBCAT, sbdot_k_BOBCAT,
  dsdot_k_BOBCAT,
  srot_k_BOBCAT,   saxpy_k_BOBCAT,  sscal_k_BOBCAT, sswap_k_BOBCAT,
  sbgemv_n_BOBCAT, sbgemv_t_BOBCAT, sger_k_BOBCAT,
  ssymv_L_BOBCAT, ssymv_U_BOBCAT,

  sbgemm_kernel_BOBCAT, sbgemm_beta_BOBCAT,
#if SBGEMM_DEFAULT_UNROLL_M != SBGEMM_DEFAULT_UNROLL_N
  sbgemm_incopy_BOBCAT, sbgemm_itcopy_BOBCAT,
#else
  sbgemm_oncopy_BOBCAT, sbgemm_otcopy_BOBCAT,
#endif
  sbgemm_oncopy_BOBCAT, sbgemm_otcopy_BOBCAT,

  strsm_kernel_LN_BOBCAT, strsm_kernel_LT_BOBCAT, strsm_kernel_RN_BOBCAT, strsm_kernel_RT_BOBCAT,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_BOBCAT, strsm_iunncopy_BOBCAT, strsm_iutucopy_BOBCAT, strsm_iutncopy_BOBCAT,
  strsm_ilnucopy_BOBCAT, strsm_ilnncopy_BOBCAT, strsm_iltucopy_BOBCAT, strsm_iltncopy_BOBCAT,
#else
  strsm_ounucopy_BOBCAT, strsm_ounncopy_BOBCAT, strsm_outucopy_BOBCAT, strsm_outncopy_BOBCAT,
  strsm_olnucopy_BOBCAT, strsm_olnncopy_BOBCAT, strsm_oltucopy_BOBCAT, strsm_oltncopy_BOBCAT,
#endif
  strsm_ounucopy_BOBCAT, strsm_ounncopy_BOBCAT, strsm_outucopy_BOBCAT, strsm_outncopy_BOBCAT,
  strsm_olnucopy_BOBCAT, strsm_olnncopy_BOBCAT, strsm_oltucopy_BOBCAT, strsm_oltncopy_BOBCAT,
  strmm_kernel_RN_BOBCAT, strmm_kernel_RT_BOBCAT, strmm_kernel_LN_BOBCAT, strmm_kernel_LT_BOBCAT,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_BOBCAT, strmm_iunncopy_BOBCAT, strmm_iutucopy_BOBCAT, strmm_iutncopy_BOBCAT,
  strmm_ilnucopy_BOBCAT, strmm_ilnncopy_BOBCAT, strmm_iltucopy_BOBCAT, strmm_iltncopy_BOBCAT,
#else
  strmm_ounucopy_BOBCAT, strmm_ounncopy_BOBCAT, strmm_outucopy_BOBCAT, strmm_outncopy_BOBCAT,
  strmm_olnucopy_BOBCAT, strmm_olnncopy_BOBCAT, strmm_oltucopy_BOBCAT, strmm_oltncopy_BOBCAT,
#endif
  strmm_ounucopy_BOBCAT, strmm_ounncopy_BOBCAT, strmm_outucopy_BOBCAT, strmm_outncopy_BOBCAT,
  strmm_olnucopy_BOBCAT, strmm_olnncopy_BOBCAT, strmm_oltucopy_BOBCAT, strmm_oltncopy_BOBCAT,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_BOBCAT, ssymm_iltcopy_BOBCAT,
#else
  ssymm_outcopy_BOBCAT, ssymm_oltcopy_BOBCAT,
#endif
  ssymm_outcopy_BOBCAT, ssymm_oltcopy_BOBCAT,

#ifndef NO_LAPACK
  sneg_tcopy_BOBCAT, slaswp_ncopy_BOBCAT,
#else
  NULL,NULL,
#endif
#ifdef SMALL_MATRIX_OPT
  sbgemm_small_matrix_permit_BOBCAT,
  sbgemm_small_kernel_nn_BOBCAT, sbgemm_small_kernel_nt_BOBCAT, sbgemm_small_kernel_tn_BOBCAT, sbgemm_small_kernel_tt_BOBCAT,
  sbgemm_small_kernel_b0_nn_BOBCAT, sbgemm_small_kernel_b0_nt_BOBCAT, sbgemm_small_kernel_b0_tn_BOBCAT, sbgemm_small_kernel_b0_tt_BOBCAT,
#endif
#endif

#if ( BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  0, 0, 0,
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N,
#ifdef SGEMM_DEFAULT_UNROLL_MN
 SGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif
#endif

#ifdef HAVE_EXCLUSIVE_CACHE
  1,
#else
  0,
#endif

#if (BUILD_SINGLE==1 ) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  samax_k_BOBCAT,  samin_k_BOBCAT,  smax_k_BOBCAT,  smin_k_BOBCAT,
  isamax_k_BOBCAT, isamin_k_BOBCAT, ismax_k_BOBCAT, ismin_k_BOBCAT,
  snrm2_k_BOBCAT,  sasum_k_BOBCAT,
#endif 
#if BUILD_SINGLE == 1  
  ssum_k_BOBCAT,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  scopy_k_BOBCAT, sdot_k_BOBCAT,
//  dsdot_k_BOBCAT,
  srot_k_BOBCAT,   saxpy_k_BOBCAT,  
#endif
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1) || (BUILD_COMPLEX16==1)
  sscal_k_BOBCAT,
#endif 
#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
  sswap_k_BOBCAT,
  sgemv_n_BOBCAT,  sgemv_t_BOBCAT,
#endif
#if BUILD_SINGLE == 1  
  sger_k_BOBCAT,
  ssymv_L_BOBCAT, ssymv_U_BOBCAT,
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) || (BUILD_COMPLEX==1)
#ifdef ARCH_X86_64
  sgemm_direct_BOBCAT,
  sgemm_direct_performant_BOBCAT,	
#endif

  sgemm_kernel_BOBCAT, sgemm_beta_BOBCAT,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  sgemm_incopy_BOBCAT, sgemm_itcopy_BOBCAT,
#else
  sgemm_oncopy_BOBCAT, sgemm_otcopy_BOBCAT,
#endif
  sgemm_oncopy_BOBCAT, sgemm_otcopy_BOBCAT,
#endif

#if BUILD_SINGLE == 1
#ifdef SMALL_MATRIX_OPT
  sgemm_small_matrix_permit_BOBCAT,
  sgemm_small_kernel_nn_BOBCAT, sgemm_small_kernel_nt_BOBCAT, sgemm_small_kernel_tn_BOBCAT, sgemm_small_kernel_tt_BOBCAT,
  sgemm_small_kernel_b0_nn_BOBCAT, sgemm_small_kernel_b0_nt_BOBCAT, sgemm_small_kernel_b0_tn_BOBCAT, sgemm_small_kernel_b0_tt_BOBCAT,
#endif
#endif

#if (BUILD_SINGLE==1) || (BUILD_DOUBLE==1) 
  strsm_kernel_LN_BOBCAT, strsm_kernel_LT_BOBCAT, strsm_kernel_RN_BOBCAT, strsm_kernel_RT_BOBCAT,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strsm_iunucopy_BOBCAT, strsm_iunncopy_BOBCAT, strsm_iutucopy_BOBCAT, strsm_iutncopy_BOBCAT,
  strsm_ilnucopy_BOBCAT, strsm_ilnncopy_BOBCAT, strsm_iltucopy_BOBCAT, strsm_iltncopy_BOBCAT,
#else
  strsm_ounucopy_BOBCAT, strsm_ounncopy_BOBCAT, strsm_outucopy_BOBCAT, strsm_outncopy_BOBCAT,
  strsm_olnucopy_BOBCAT, strsm_olnncopy_BOBCAT, strsm_oltucopy_BOBCAT, strsm_oltncopy_BOBCAT,
#endif
  strsm_ounucopy_BOBCAT, strsm_ounncopy_BOBCAT, strsm_outucopy_BOBCAT, strsm_outncopy_BOBCAT,
  strsm_olnucopy_BOBCAT, strsm_olnncopy_BOBCAT, strsm_oltucopy_BOBCAT, strsm_oltncopy_BOBCAT,
#endif
#if BUILD_SINGLE == 1
  strmm_kernel_RN_BOBCAT, strmm_kernel_RT_BOBCAT, strmm_kernel_LN_BOBCAT, strmm_kernel_LT_BOBCAT,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  strmm_iunucopy_BOBCAT, strmm_iunncopy_BOBCAT, strmm_iutucopy_BOBCAT, strmm_iutncopy_BOBCAT,
  strmm_ilnucopy_BOBCAT, strmm_ilnncopy_BOBCAT, strmm_iltucopy_BOBCAT, strmm_iltncopy_BOBCAT,
#else
  strmm_ounucopy_BOBCAT, strmm_ounncopy_BOBCAT, strmm_outucopy_BOBCAT, strmm_outncopy_BOBCAT,
  strmm_olnucopy_BOBCAT, strmm_olnncopy_BOBCAT, strmm_oltucopy_BOBCAT, strmm_oltncopy_BOBCAT,
#endif
  strmm_ounucopy_BOBCAT, strmm_ounncopy_BOBCAT, strmm_outucopy_BOBCAT, strmm_outncopy_BOBCAT,
  strmm_olnucopy_BOBCAT, strmm_olnncopy_BOBCAT, strmm_oltucopy_BOBCAT, strmm_oltncopy_BOBCAT,
#if SGEMM_DEFAULT_UNROLL_M != SGEMM_DEFAULT_UNROLL_N
  ssymm_iutcopy_BOBCAT, ssymm_iltcopy_BOBCAT,
#else
  ssymm_outcopy_BOBCAT, ssymm_oltcopy_BOBCAT,
#endif
  ssymm_outcopy_BOBCAT, ssymm_oltcopy_BOBCAT,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)
#ifndef NO_LAPACK
  sneg_tcopy_BOBCAT, slaswp_ncopy_BOBCAT,
#else
  NULL,NULL,
#endif
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  0, 0, 0,
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N,
#ifdef DGEMM_DEFAULT_UNROLL_MN
 DGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif
#endif


#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  damax_k_BOBCAT,  damin_k_BOBCAT,  dmax_k_BOBCAT,  dmin_k_BOBCAT,
  idamax_k_BOBCAT, idamin_k_BOBCAT, idmax_k_BOBCAT, idmin_k_BOBCAT,
  dnrm2_k_BOBCAT, dasum_k_BOBCAT,
#endif  
#if  (BUILD_DOUBLE==1)  
  dsum_k_BOBCAT,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dcopy_k_BOBCAT, ddot_k_BOBCAT,
#endif
#if  (BUILD_SINGLE==1) || (BUILD_DOUBLE==1)  
  dsdot_k_BOBCAT,
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  drot_k_BOBCAT,
  daxpy_k_BOBCAT,
  dscal_k_BOBCAT, 
  dswap_k_BOBCAT,
  dgemv_n_BOBCAT,  dgemv_t_BOBCAT,
#endif
#if  (BUILD_DOUBLE==1)  
  dger_k_BOBCAT,
  dsymv_L_BOBCAT,  dsymv_U_BOBCAT,
#endif

#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)  
  dgemm_kernel_BOBCAT, dgemm_beta_BOBCAT,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dgemm_incopy_BOBCAT, dgemm_itcopy_BOBCAT,
#else
  dgemm_oncopy_BOBCAT, dgemm_otcopy_BOBCAT,
#endif
  dgemm_oncopy_BOBCAT, dgemm_otcopy_BOBCAT,
#endif

#if  (BUILD_DOUBLE==1)  
#ifdef SMALL_MATRIX_OPT
  dgemm_small_matrix_permit_BOBCAT,
  dgemm_small_kernel_nn_BOBCAT, dgemm_small_kernel_nt_BOBCAT, dgemm_small_kernel_tn_BOBCAT, dgemm_small_kernel_tt_BOBCAT,
  dgemm_small_kernel_b0_nn_BOBCAT, dgemm_small_kernel_b0_nt_BOBCAT, dgemm_small_kernel_b0_tn_BOBCAT, dgemm_small_kernel_b0_tt_BOBCAT,
#endif
  dtrsm_kernel_LN_BOBCAT, dtrsm_kernel_LT_BOBCAT, dtrsm_kernel_RN_BOBCAT, dtrsm_kernel_RT_BOBCAT,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrsm_iunucopy_BOBCAT, dtrsm_iunncopy_BOBCAT, dtrsm_iutucopy_BOBCAT, dtrsm_iutncopy_BOBCAT,
  dtrsm_ilnucopy_BOBCAT, dtrsm_ilnncopy_BOBCAT, dtrsm_iltucopy_BOBCAT, dtrsm_iltncopy_BOBCAT,
#else
  dtrsm_ounucopy_BOBCAT, dtrsm_ounncopy_BOBCAT, dtrsm_outucopy_BOBCAT, dtrsm_outncopy_BOBCAT,
  dtrsm_olnucopy_BOBCAT, dtrsm_olnncopy_BOBCAT, dtrsm_oltucopy_BOBCAT, dtrsm_oltncopy_BOBCAT,
#endif
  dtrsm_ounucopy_BOBCAT, dtrsm_ounncopy_BOBCAT, dtrsm_outucopy_BOBCAT, dtrsm_outncopy_BOBCAT,
  dtrsm_olnucopy_BOBCAT, dtrsm_olnncopy_BOBCAT, dtrsm_oltucopy_BOBCAT, dtrsm_oltncopy_BOBCAT,
  dtrmm_kernel_RN_BOBCAT, dtrmm_kernel_RT_BOBCAT, dtrmm_kernel_LN_BOBCAT, dtrmm_kernel_LT_BOBCAT,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dtrmm_iunucopy_BOBCAT, dtrmm_iunncopy_BOBCAT, dtrmm_iutucopy_BOBCAT, dtrmm_iutncopy_BOBCAT,
  dtrmm_ilnucopy_BOBCAT, dtrmm_ilnncopy_BOBCAT, dtrmm_iltucopy_BOBCAT, dtrmm_iltncopy_BOBCAT,
#else
  dtrmm_ounucopy_BOBCAT, dtrmm_ounncopy_BOBCAT, dtrmm_outucopy_BOBCAT, dtrmm_outncopy_BOBCAT,
  dtrmm_olnucopy_BOBCAT, dtrmm_olnncopy_BOBCAT, dtrmm_oltucopy_BOBCAT, dtrmm_oltncopy_BOBCAT,
#endif
  dtrmm_ounucopy_BOBCAT, dtrmm_ounncopy_BOBCAT, dtrmm_outucopy_BOBCAT, dtrmm_outncopy_BOBCAT,
  dtrmm_olnucopy_BOBCAT, dtrmm_olnncopy_BOBCAT, dtrmm_oltucopy_BOBCAT, dtrmm_oltncopy_BOBCAT,
#if DGEMM_DEFAULT_UNROLL_M != DGEMM_DEFAULT_UNROLL_N
  dsymm_iutcopy_BOBCAT, dsymm_iltcopy_BOBCAT,
#else
  dsymm_outcopy_BOBCAT, dsymm_oltcopy_BOBCAT,
#endif
  dsymm_outcopy_BOBCAT, dsymm_oltcopy_BOBCAT,

#ifndef NO_LAPACK
  dneg_tcopy_BOBCAT, dlaswp_ncopy_BOBCAT,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  qamax_k_BOBCAT,  qamin_k_BOBCAT,  qmax_k_BOBCAT,  qmin_k_BOBCAT,
  iqamax_k_BOBCAT, iqamin_k_BOBCAT, iqmax_k_BOBCAT, iqmin_k_BOBCAT,
  qnrm2_k_BOBCAT,  qasum_k_BOBCAT,  qsum_k_BOBCAT, qcopy_k_BOBCAT, qdot_k_BOBCAT,
  qrot_k_BOBCAT,   qaxpy_k_BOBCAT,  qscal_k_BOBCAT, qswap_k_BOBCAT,
  qgemv_n_BOBCAT,  qgemv_t_BOBCAT,  qger_k_BOBCAT,
  qsymv_L_BOBCAT,  qsymv_U_BOBCAT,

  qgemm_kernel_BOBCAT, qgemm_beta_BOBCAT,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qgemm_incopy_BOBCAT, qgemm_itcopy_BOBCAT,
#else
  qgemm_oncopy_BOBCAT, qgemm_otcopy_BOBCAT,
#endif
  qgemm_oncopy_BOBCAT, qgemm_otcopy_BOBCAT,
  qtrsm_kernel_LN_BOBCAT, qtrsm_kernel_LT_BOBCAT, qtrsm_kernel_RN_BOBCAT, qtrsm_kernel_RT_BOBCAT,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrsm_iunucopy_BOBCAT, qtrsm_iunncopy_BOBCAT, qtrsm_iutucopy_BOBCAT, qtrsm_iutncopy_BOBCAT,
  qtrsm_ilnucopy_BOBCAT, qtrsm_ilnncopy_BOBCAT, qtrsm_iltucopy_BOBCAT, qtrsm_iltncopy_BOBCAT,
#else
  qtrsm_ounucopy_BOBCAT, qtrsm_ounncopy_BOBCAT, qtrsm_outucopy_BOBCAT, qtrsm_outncopy_BOBCAT,
  qtrsm_olnucopy_BOBCAT, qtrsm_olnncopy_BOBCAT, qtrsm_oltucopy_BOBCAT, qtrsm_oltncopy_BOBCAT,
#endif
  qtrsm_ounucopy_BOBCAT, qtrsm_ounncopy_BOBCAT, qtrsm_outucopy_BOBCAT, qtrsm_outncopy_BOBCAT,
  qtrsm_olnucopy_BOBCAT, qtrsm_olnncopy_BOBCAT, qtrsm_oltucopy_BOBCAT, qtrsm_oltncopy_BOBCAT,
  qtrmm_kernel_RN_BOBCAT, qtrmm_kernel_RT_BOBCAT, qtrmm_kernel_LN_BOBCAT, qtrmm_kernel_LT_BOBCAT,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qtrmm_iunucopy_BOBCAT, qtrmm_iunncopy_BOBCAT, qtrmm_iutucopy_BOBCAT, qtrmm_iutncopy_BOBCAT,
  qtrmm_ilnucopy_BOBCAT, qtrmm_ilnncopy_BOBCAT, qtrmm_iltucopy_BOBCAT, qtrmm_iltncopy_BOBCAT,
#else
  qtrmm_ounucopy_BOBCAT, qtrmm_ounncopy_BOBCAT, qtrmm_outucopy_BOBCAT, qtrmm_outncopy_BOBCAT,
  qtrmm_olnucopy_BOBCAT, qtrmm_olnncopy_BOBCAT, qtrmm_oltucopy_BOBCAT, qtrmm_oltncopy_BOBCAT,
#endif
  qtrmm_ounucopy_BOBCAT, qtrmm_ounncopy_BOBCAT, qtrmm_outucopy_BOBCAT, qtrmm_outncopy_BOBCAT,
  qtrmm_olnucopy_BOBCAT, qtrmm_olnncopy_BOBCAT, qtrmm_oltucopy_BOBCAT, qtrmm_oltncopy_BOBCAT,
#if QGEMM_DEFAULT_UNROLL_M != QGEMM_DEFAULT_UNROLL_N
  qsymm_iutcopy_BOBCAT, qsymm_iltcopy_BOBCAT,
#else
  qsymm_outcopy_BOBCAT, qsymm_oltcopy_BOBCAT,
#endif
  qsymm_outcopy_BOBCAT, qsymm_oltcopy_BOBCAT,

#ifndef NO_LAPACK
  qneg_tcopy_BOBCAT, qlaswp_ncopy_BOBCAT,
#else
  NULL, NULL,
#endif

#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  0, 0, 0,
  CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N,
#ifdef CGEMM_DEFAULT_UNROLL_MN
 CGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(CGEMM_DEFAULT_UNROLL_M, CGEMM_DEFAULT_UNROLL_N),
#endif
  camax_k_BOBCAT, camin_k_BOBCAT, icamax_k_BOBCAT, icamin_k_BOBCAT,
#endif
#if (BUILD_COMPLEX)
  cnrm2_k_BOBCAT, casum_k_BOBCAT, csum_k_BOBCAT,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  ccopy_k_BOBCAT,  cdotu_k_BOBCAT, cdotc_k_BOBCAT,
#endif
#if (BUILD_COMPLEX)
 csrot_k_BOBCAT,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  caxpy_k_BOBCAT,
  caxpyc_k_BOBCAT, 
  cscal_k_BOBCAT, 
  cswap_k_BOBCAT,

  cgemv_n_BOBCAT, cgemv_t_BOBCAT, cgemv_r_BOBCAT, cgemv_c_BOBCAT,
  cgemv_o_BOBCAT, cgemv_u_BOBCAT, cgemv_s_BOBCAT, cgemv_d_BOBCAT,
#endif
#if (BUILD_COMPLEX)
  cgeru_k_BOBCAT, cgerc_k_BOBCAT, cgerv_k_BOBCAT, cgerd_k_BOBCAT,
  csymv_L_BOBCAT, csymv_U_BOBCAT,
  chemv_L_BOBCAT, chemv_U_BOBCAT, chemv_M_BOBCAT, chemv_V_BOBCAT,
#endif
#if (BUILD_COMPLEX || BUILD_COMPLEX16)
  cgemm_kernel_n_BOBCAT, cgemm_kernel_l_BOBCAT, cgemm_kernel_r_BOBCAT, cgemm_kernel_b_BOBCAT,
  cgemm_beta_BOBCAT,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  cgemm_incopy_BOBCAT, cgemm_itcopy_BOBCAT,
#else
  cgemm_oncopy_BOBCAT, cgemm_otcopy_BOBCAT,
#endif
  cgemm_oncopy_BOBCAT, cgemm_otcopy_BOBCAT,

#ifdef SMALL_MATRIX_OPT
  cgemm_small_matrix_permit_BOBCAT,
  cgemm_small_kernel_nn_BOBCAT, cgemm_small_kernel_nt_BOBCAT, cgemm_small_kernel_nr_BOBCAT, cgemm_small_kernel_nc_BOBCAT,
  cgemm_small_kernel_tn_BOBCAT, cgemm_small_kernel_tt_BOBCAT, cgemm_small_kernel_tr_BOBCAT, cgemm_small_kernel_tc_BOBCAT,
  cgemm_small_kernel_rn_BOBCAT, cgemm_small_kernel_rt_BOBCAT, cgemm_small_kernel_rr_BOBCAT, cgemm_small_kernel_rc_BOBCAT,
  cgemm_small_kernel_cn_BOBCAT, cgemm_small_kernel_ct_BOBCAT, cgemm_small_kernel_cr_BOBCAT, cgemm_small_kernel_cc_BOBCAT,
  cgemm_small_kernel_b0_nn_BOBCAT, cgemm_small_kernel_b0_nt_BOBCAT, cgemm_small_kernel_b0_nr_BOBCAT, cgemm_small_kernel_b0_nc_BOBCAT,
  cgemm_small_kernel_b0_tn_BOBCAT, cgemm_small_kernel_b0_tt_BOBCAT, cgemm_small_kernel_b0_tr_BOBCAT, cgemm_small_kernel_b0_tc_BOBCAT,
  cgemm_small_kernel_b0_rn_BOBCAT, cgemm_small_kernel_b0_rt_BOBCAT, cgemm_small_kernel_b0_rr_BOBCAT, cgemm_small_kernel_b0_rc_BOBCAT,
  cgemm_small_kernel_b0_cn_BOBCAT, cgemm_small_kernel_b0_ct_BOBCAT, cgemm_small_kernel_b0_cr_BOBCAT, cgemm_small_kernel_b0_cc_BOBCAT,
#endif

  ctrsm_kernel_LN_BOBCAT, ctrsm_kernel_LT_BOBCAT, ctrsm_kernel_LR_BOBCAT, ctrsm_kernel_LC_BOBCAT,
  ctrsm_kernel_RN_BOBCAT, ctrsm_kernel_RT_BOBCAT, ctrsm_kernel_RR_BOBCAT, ctrsm_kernel_RC_BOBCAT,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrsm_iunucopy_BOBCAT,  ctrsm_iunncopy_BOBCAT,  ctrsm_iutucopy_BOBCAT,  ctrsm_iutncopy_BOBCAT,
  ctrsm_ilnucopy_BOBCAT,  ctrsm_ilnncopy_BOBCAT,  ctrsm_iltucopy_BOBCAT,  ctrsm_iltncopy_BOBCAT,
#else
  ctrsm_ounucopy_BOBCAT,  ctrsm_ounncopy_BOBCAT,  ctrsm_outucopy_BOBCAT,  ctrsm_outncopy_BOBCAT,
  ctrsm_olnucopy_BOBCAT,  ctrsm_olnncopy_BOBCAT,  ctrsm_oltucopy_BOBCAT,  ctrsm_oltncopy_BOBCAT,
#endif
  ctrsm_ounucopy_BOBCAT,  ctrsm_ounncopy_BOBCAT,  ctrsm_outucopy_BOBCAT,  ctrsm_outncopy_BOBCAT,
  ctrsm_olnucopy_BOBCAT,  ctrsm_olnncopy_BOBCAT,  ctrsm_oltucopy_BOBCAT,  ctrsm_oltncopy_BOBCAT,
#endif
#if (BUILD_COMPLEX)

  ctrmm_kernel_RN_BOBCAT,  ctrmm_kernel_RT_BOBCAT,  ctrmm_kernel_RR_BOBCAT,  ctrmm_kernel_RC_BOBCAT,
  ctrmm_kernel_LN_BOBCAT,  ctrmm_kernel_LT_BOBCAT,  ctrmm_kernel_LR_BOBCAT,  ctrmm_kernel_LC_BOBCAT,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  ctrmm_iunucopy_BOBCAT,  ctrmm_iunncopy_BOBCAT,  ctrmm_iutucopy_BOBCAT,  ctrmm_iutncopy_BOBCAT,
  ctrmm_ilnucopy_BOBCAT,  ctrmm_ilnncopy_BOBCAT,  ctrmm_iltucopy_BOBCAT,  ctrmm_iltncopy_BOBCAT,
#else
  ctrmm_ounucopy_BOBCAT,  ctrmm_ounncopy_BOBCAT,  ctrmm_outucopy_BOBCAT,  ctrmm_outncopy_BOBCAT,
  ctrmm_olnucopy_BOBCAT,  ctrmm_olnncopy_BOBCAT,  ctrmm_oltucopy_BOBCAT,  ctrmm_oltncopy_BOBCAT,
#endif
  ctrmm_ounucopy_BOBCAT,  ctrmm_ounncopy_BOBCAT,  ctrmm_outucopy_BOBCAT,  ctrmm_outncopy_BOBCAT,
  ctrmm_olnucopy_BOBCAT,  ctrmm_olnncopy_BOBCAT,  ctrmm_oltucopy_BOBCAT,  ctrmm_oltncopy_BOBCAT,

#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  csymm_iutcopy_BOBCAT,  csymm_iltcopy_BOBCAT,
#else
  csymm_outcopy_BOBCAT,  csymm_oltcopy_BOBCAT,
#endif
  csymm_outcopy_BOBCAT,  csymm_oltcopy_BOBCAT,
#if CGEMM_DEFAULT_UNROLL_M != CGEMM_DEFAULT_UNROLL_N
  chemm_iutcopy_BOBCAT,  chemm_iltcopy_BOBCAT,
#else
  chemm_outcopy_BOBCAT,  chemm_oltcopy_BOBCAT,
#endif
  chemm_outcopy_BOBCAT,  chemm_oltcopy_BOBCAT,

  0, 0, 0,

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N, MAX(CGEMM3M_DEFAULT_UNROLL_M, CGEMM3M_DEFAULT_UNROLL_N),
#else
  SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N, MAX(SGEMM_DEFAULT_UNROLL_M, SGEMM_DEFAULT_UNROLL_N),
#endif


  cgemm3m_kernel_BOBCAT,

  cgemm3m_incopyb_BOBCAT,  cgemm3m_incopyr_BOBCAT,
  cgemm3m_incopyi_BOBCAT,  cgemm3m_itcopyb_BOBCAT,
  cgemm3m_itcopyr_BOBCAT,  cgemm3m_itcopyi_BOBCAT,
  cgemm3m_oncopyb_BOBCAT,  cgemm3m_oncopyr_BOBCAT,
  cgemm3m_oncopyi_BOBCAT,  cgemm3m_otcopyb_BOBCAT,
  cgemm3m_otcopyr_BOBCAT,  cgemm3m_otcopyi_BOBCAT,

  csymm3m_iucopyb_BOBCAT,  csymm3m_ilcopyb_BOBCAT,
  csymm3m_iucopyr_BOBCAT,  csymm3m_ilcopyr_BOBCAT,
  csymm3m_iucopyi_BOBCAT,  csymm3m_ilcopyi_BOBCAT,
  csymm3m_oucopyb_BOBCAT,  csymm3m_olcopyb_BOBCAT,
  csymm3m_oucopyr_BOBCAT,  csymm3m_olcopyr_BOBCAT,
  csymm3m_oucopyi_BOBCAT,  csymm3m_olcopyi_BOBCAT,

  chemm3m_iucopyb_BOBCAT,  chemm3m_ilcopyb_BOBCAT,
  chemm3m_iucopyr_BOBCAT,  chemm3m_ilcopyr_BOBCAT,
  chemm3m_iucopyi_BOBCAT,  chemm3m_ilcopyi_BOBCAT,

  chemm3m_oucopyb_BOBCAT,  chemm3m_olcopyb_BOBCAT,
  chemm3m_oucopyr_BOBCAT,  chemm3m_olcopyr_BOBCAT,
  chemm3m_oucopyi_BOBCAT,  chemm3m_olcopyi_BOBCAT,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif
#endif

#if (BUILD_COMPLEX || BUILD_COMPLEX16)
#ifndef NO_LAPACK
  cneg_tcopy_BOBCAT,
  
   claswp_ncopy_BOBCAT,
#else
  NULL, NULL,
#endif

#endif

#if BUILD_COMPLEX16 == 1
  0, 0, 0,
  ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N,
#ifdef ZGEMM_DEFAULT_UNROLL_MN
 ZGEMM_DEFAULT_UNROLL_MN,
#else
 MAX(ZGEMM_DEFAULT_UNROLL_M, ZGEMM_DEFAULT_UNROLL_N),
#endif

  zamax_k_BOBCAT, zamin_k_BOBCAT, izamax_k_BOBCAT, izamin_k_BOBCAT,
  znrm2_k_BOBCAT, zasum_k_BOBCAT, zsum_k_BOBCAT, zcopy_k_BOBCAT,
  zdotu_k_BOBCAT, zdotc_k_BOBCAT, zdrot_k_BOBCAT,
  zaxpy_k_BOBCAT, zaxpyc_k_BOBCAT, zscal_k_BOBCAT, zswap_k_BOBCAT,

  zgemv_n_BOBCAT, zgemv_t_BOBCAT, zgemv_r_BOBCAT, zgemv_c_BOBCAT,
  zgemv_o_BOBCAT, zgemv_u_BOBCAT, zgemv_s_BOBCAT, zgemv_d_BOBCAT,
  zgeru_k_BOBCAT, zgerc_k_BOBCAT, zgerv_k_BOBCAT, zgerd_k_BOBCAT,
  zsymv_L_BOBCAT, zsymv_U_BOBCAT,
  zhemv_L_BOBCAT, zhemv_U_BOBCAT, zhemv_M_BOBCAT, zhemv_V_BOBCAT,

  zgemm_kernel_n_BOBCAT, zgemm_kernel_l_BOBCAT, zgemm_kernel_r_BOBCAT, zgemm_kernel_b_BOBCAT,
  zgemm_beta_BOBCAT,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zgemm_incopy_BOBCAT, zgemm_itcopy_BOBCAT,
#else
  zgemm_oncopy_BOBCAT, zgemm_otcopy_BOBCAT,
#endif
  zgemm_oncopy_BOBCAT, zgemm_otcopy_BOBCAT,

#ifdef SMALL_MATRIX_OPT
  zgemm_small_matrix_permit_BOBCAT,
  zgemm_small_kernel_nn_BOBCAT, zgemm_small_kernel_nt_BOBCAT, zgemm_small_kernel_nr_BOBCAT, zgemm_small_kernel_nc_BOBCAT,
  zgemm_small_kernel_tn_BOBCAT, zgemm_small_kernel_tt_BOBCAT, zgemm_small_kernel_tr_BOBCAT, zgemm_small_kernel_tc_BOBCAT,
  zgemm_small_kernel_rn_BOBCAT, zgemm_small_kernel_rt_BOBCAT, zgemm_small_kernel_rr_BOBCAT, zgemm_small_kernel_rc_BOBCAT,
  zgemm_small_kernel_cn_BOBCAT, zgemm_small_kernel_ct_BOBCAT, zgemm_small_kernel_cr_BOBCAT, zgemm_small_kernel_cc_BOBCAT,
  zgemm_small_kernel_b0_nn_BOBCAT, zgemm_small_kernel_b0_nt_BOBCAT, zgemm_small_kernel_b0_nr_BOBCAT, zgemm_small_kernel_b0_nc_BOBCAT,
  zgemm_small_kernel_b0_tn_BOBCAT, zgemm_small_kernel_b0_tt_BOBCAT, zgemm_small_kernel_b0_tr_BOBCAT, zgemm_small_kernel_b0_tc_BOBCAT,
  zgemm_small_kernel_b0_rn_BOBCAT, zgemm_small_kernel_b0_rt_BOBCAT, zgemm_small_kernel_b0_rr_BOBCAT, zgemm_small_kernel_b0_rc_BOBCAT,
  zgemm_small_kernel_b0_cn_BOBCAT, zgemm_small_kernel_b0_ct_BOBCAT, zgemm_small_kernel_b0_cr_BOBCAT, zgemm_small_kernel_b0_cc_BOBCAT,
#endif

  ztrsm_kernel_LN_BOBCAT, ztrsm_kernel_LT_BOBCAT, ztrsm_kernel_LR_BOBCAT, ztrsm_kernel_LC_BOBCAT,
  ztrsm_kernel_RN_BOBCAT, ztrsm_kernel_RT_BOBCAT, ztrsm_kernel_RR_BOBCAT, ztrsm_kernel_RC_BOBCAT,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrsm_iunucopy_BOBCAT,  ztrsm_iunncopy_BOBCAT,  ztrsm_iutucopy_BOBCAT,  ztrsm_iutncopy_BOBCAT,
  ztrsm_ilnucopy_BOBCAT,  ztrsm_ilnncopy_BOBCAT,  ztrsm_iltucopy_BOBCAT,  ztrsm_iltncopy_BOBCAT,
#else
  ztrsm_ounucopy_BOBCAT,  ztrsm_ounncopy_BOBCAT,  ztrsm_outucopy_BOBCAT,  ztrsm_outncopy_BOBCAT,
  ztrsm_olnucopy_BOBCAT,  ztrsm_olnncopy_BOBCAT,  ztrsm_oltucopy_BOBCAT,  ztrsm_oltncopy_BOBCAT,
#endif
  ztrsm_ounucopy_BOBCAT,  ztrsm_ounncopy_BOBCAT,  ztrsm_outucopy_BOBCAT,  ztrsm_outncopy_BOBCAT,
  ztrsm_olnucopy_BOBCAT,  ztrsm_olnncopy_BOBCAT,  ztrsm_oltucopy_BOBCAT,  ztrsm_oltncopy_BOBCAT,

  ztrmm_kernel_RN_BOBCAT,  ztrmm_kernel_RT_BOBCAT,  ztrmm_kernel_RR_BOBCAT,  ztrmm_kernel_RC_BOBCAT,
  ztrmm_kernel_LN_BOBCAT,  ztrmm_kernel_LT_BOBCAT,  ztrmm_kernel_LR_BOBCAT,  ztrmm_kernel_LC_BOBCAT,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  ztrmm_iunucopy_BOBCAT,  ztrmm_iunncopy_BOBCAT,  ztrmm_iutucopy_BOBCAT,  ztrmm_iutncopy_BOBCAT,
  ztrmm_ilnucopy_BOBCAT,  ztrmm_ilnncopy_BOBCAT,  ztrmm_iltucopy_BOBCAT,  ztrmm_iltncopy_BOBCAT,
#else
  ztrmm_ounucopy_BOBCAT,  ztrmm_ounncopy_BOBCAT,  ztrmm_outucopy_BOBCAT,  ztrmm_outncopy_BOBCAT,
  ztrmm_olnucopy_BOBCAT,  ztrmm_olnncopy_BOBCAT,  ztrmm_oltucopy_BOBCAT,  ztrmm_oltncopy_BOBCAT,
#endif
  ztrmm_ounucopy_BOBCAT,  ztrmm_ounncopy_BOBCAT,  ztrmm_outucopy_BOBCAT,  ztrmm_outncopy_BOBCAT,
  ztrmm_olnucopy_BOBCAT,  ztrmm_olnncopy_BOBCAT,  ztrmm_oltucopy_BOBCAT,  ztrmm_oltncopy_BOBCAT,

#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zsymm_iutcopy_BOBCAT,  zsymm_iltcopy_BOBCAT,
#else
  zsymm_outcopy_BOBCAT,  zsymm_oltcopy_BOBCAT,
#endif
  zsymm_outcopy_BOBCAT,  zsymm_oltcopy_BOBCAT,
#if ZGEMM_DEFAULT_UNROLL_M != ZGEMM_DEFAULT_UNROLL_N
  zhemm_iutcopy_BOBCAT,  zhemm_iltcopy_BOBCAT,
#else
  zhemm_outcopy_BOBCAT,  zhemm_oltcopy_BOBCAT,
#endif
  zhemm_outcopy_BOBCAT,  zhemm_oltcopy_BOBCAT,

  0, 0, 0,
#if (USE_GEMM3M)
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N, MAX(ZGEMM3M_DEFAULT_UNROLL_M, ZGEMM3M_DEFAULT_UNROLL_N),
#else
  DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N, MAX(DGEMM_DEFAULT_UNROLL_M, DGEMM_DEFAULT_UNROLL_N),
#endif


  zgemm3m_kernel_BOBCAT,

  zgemm3m_incopyb_BOBCAT,  zgemm3m_incopyr_BOBCAT,
  zgemm3m_incopyi_BOBCAT,  zgemm3m_itcopyb_BOBCAT,
  zgemm3m_itcopyr_BOBCAT,  zgemm3m_itcopyi_BOBCAT,
  zgemm3m_oncopyb_BOBCAT,  zgemm3m_oncopyr_BOBCAT,
  zgemm3m_oncopyi_BOBCAT,  zgemm3m_otcopyb_BOBCAT,
  zgemm3m_otcopyr_BOBCAT,  zgemm3m_otcopyi_BOBCAT,

  zsymm3m_iucopyb_BOBCAT,  zsymm3m_ilcopyb_BOBCAT,
  zsymm3m_iucopyr_BOBCAT,  zsymm3m_ilcopyr_BOBCAT,
  zsymm3m_iucopyi_BOBCAT,  zsymm3m_ilcopyi_BOBCAT,
  zsymm3m_oucopyb_BOBCAT,  zsymm3m_olcopyb_BOBCAT,
  zsymm3m_oucopyr_BOBCAT,  zsymm3m_olcopyr_BOBCAT,
  zsymm3m_oucopyi_BOBCAT,  zsymm3m_olcopyi_BOBCAT,

  zhemm3m_iucopyb_BOBCAT,  zhemm3m_ilcopyb_BOBCAT,
  zhemm3m_iucopyr_BOBCAT,  zhemm3m_ilcopyr_BOBCAT,
  zhemm3m_iucopyi_BOBCAT,  zhemm3m_ilcopyi_BOBCAT,

  zhemm3m_oucopyb_BOBCAT,  zhemm3m_olcopyb_BOBCAT,
  zhemm3m_oucopyr_BOBCAT,  zhemm3m_olcopyr_BOBCAT,
  zhemm3m_oucopyi_BOBCAT,  zhemm3m_olcopyi_BOBCAT,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  zneg_tcopy_BOBCAT, zlaswp_ncopy_BOBCAT,
#else
  NULL, NULL,
#endif

#endif

#ifdef EXPRECISION

  0, 0, 0,
  XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N, MAX(XGEMM_DEFAULT_UNROLL_M, XGEMM_DEFAULT_UNROLL_N),

  xamax_k_BOBCAT, xamin_k_BOBCAT, ixamax_k_BOBCAT, ixamin_k_BOBCAT,
  xnrm2_k_BOBCAT, xasum_k_BOBCAT, xsum_k_BOBCAT, xcopy_k_BOBCAT,
  xdotu_k_BOBCAT, xdotc_k_BOBCAT, xqrot_k_BOBCAT,
  xaxpy_k_BOBCAT, xaxpyc_k_BOBCAT, xscal_k_BOBCAT, xswap_k_BOBCAT,

  xgemv_n_BOBCAT, xgemv_t_BOBCAT, xgemv_r_BOBCAT, xgemv_c_BOBCAT,
  xgemv_o_BOBCAT, xgemv_u_BOBCAT, xgemv_s_BOBCAT, xgemv_d_BOBCAT,
  xgeru_k_BOBCAT, xgerc_k_BOBCAT, xgerv_k_BOBCAT, xgerd_k_BOBCAT,
  xsymv_L_BOBCAT, xsymv_U_BOBCAT,
  xhemv_L_BOBCAT, xhemv_U_BOBCAT, xhemv_M_BOBCAT, xhemv_V_BOBCAT,

  xgemm_kernel_n_BOBCAT, xgemm_kernel_l_BOBCAT, xgemm_kernel_r_BOBCAT, xgemm_kernel_b_BOBCAT,
  xgemm_beta_BOBCAT,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xgemm_incopy_BOBCAT, xgemm_itcopy_BOBCAT,
#else
  xgemm_oncopy_BOBCAT, xgemm_otcopy_BOBCAT,
#endif
  xgemm_oncopy_BOBCAT, xgemm_otcopy_BOBCAT,

  xtrsm_kernel_LN_BOBCAT, xtrsm_kernel_LT_BOBCAT, xtrsm_kernel_LR_BOBCAT, xtrsm_kernel_LC_BOBCAT,
  xtrsm_kernel_RN_BOBCAT, xtrsm_kernel_RT_BOBCAT, xtrsm_kernel_RR_BOBCAT, xtrsm_kernel_RC_BOBCAT,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrsm_iunucopy_BOBCAT,  xtrsm_iunncopy_BOBCAT,  xtrsm_iutucopy_BOBCAT,  xtrsm_iutncopy_BOBCAT,
  xtrsm_ilnucopy_BOBCAT,  xtrsm_ilnncopy_BOBCAT,  xtrsm_iltucopy_BOBCAT,  xtrsm_iltncopy_BOBCAT,
#else
  xtrsm_ounucopy_BOBCAT,  xtrsm_ounncopy_BOBCAT,  xtrsm_outucopy_BOBCAT,  xtrsm_outncopy_BOBCAT,
  xtrsm_olnucopy_BOBCAT,  xtrsm_olnncopy_BOBCAT,  xtrsm_oltucopy_BOBCAT,  xtrsm_oltncopy_BOBCAT,
#endif
  xtrsm_ounucopy_BOBCAT,  xtrsm_ounncopy_BOBCAT,  xtrsm_outucopy_BOBCAT,  xtrsm_outncopy_BOBCAT,
  xtrsm_olnucopy_BOBCAT,  xtrsm_olnncopy_BOBCAT,  xtrsm_oltucopy_BOBCAT,  xtrsm_oltncopy_BOBCAT,

  xtrmm_kernel_RN_BOBCAT,  xtrmm_kernel_RT_BOBCAT,  xtrmm_kernel_RR_BOBCAT,  xtrmm_kernel_RC_BOBCAT,
  xtrmm_kernel_LN_BOBCAT,  xtrmm_kernel_LT_BOBCAT,  xtrmm_kernel_LR_BOBCAT,  xtrmm_kernel_LC_BOBCAT,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xtrmm_iunucopy_BOBCAT,  xtrmm_iunncopy_BOBCAT,  xtrmm_iutucopy_BOBCAT,  xtrmm_iutncopy_BOBCAT,
  xtrmm_ilnucopy_BOBCAT,  xtrmm_ilnncopy_BOBCAT,  xtrmm_iltucopy_BOBCAT,  xtrmm_iltncopy_BOBCAT,
#else
  xtrmm_ounucopy_BOBCAT,  xtrmm_ounncopy_BOBCAT,  xtrmm_outucopy_BOBCAT,  xtrmm_outncopy_BOBCAT,
  xtrmm_olnucopy_BOBCAT,  xtrmm_olnncopy_BOBCAT,  xtrmm_oltucopy_BOBCAT,  xtrmm_oltncopy_BOBCAT,
#endif
  xtrmm_ounucopy_BOBCAT,  xtrmm_ounncopy_BOBCAT,  xtrmm_outucopy_BOBCAT,  xtrmm_outncopy_BOBCAT,
  xtrmm_olnucopy_BOBCAT,  xtrmm_olnncopy_BOBCAT,  xtrmm_oltucopy_BOBCAT,  xtrmm_oltncopy_BOBCAT,

#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xsymm_iutcopy_BOBCAT,  xsymm_iltcopy_BOBCAT,
#else
  xsymm_outcopy_BOBCAT,  xsymm_oltcopy_BOBCAT,
#endif
  xsymm_outcopy_BOBCAT,  xsymm_oltcopy_BOBCAT,
#if XGEMM_DEFAULT_UNROLL_M != XGEMM_DEFAULT_UNROLL_N
  xhemm_iutcopy_BOBCAT,  xhemm_iltcopy_BOBCAT,
#else
  xhemm_outcopy_BOBCAT,  xhemm_oltcopy_BOBCAT,
#endif
  xhemm_outcopy_BOBCAT,  xhemm_oltcopy_BOBCAT,

  0, 0, 0,
#if (USE_GEMM3M)
  QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N, MAX(QGEMM_DEFAULT_UNROLL_M, QGEMM_DEFAULT_UNROLL_N),

  xgemm3m_kernel_BOBCAT,

  xgemm3m_incopyb_BOBCAT,  xgemm3m_incopyr_BOBCAT,
  xgemm3m_incopyi_BOBCAT,  xgemm3m_itcopyb_BOBCAT,
  xgemm3m_itcopyr_BOBCAT,  xgemm3m_itcopyi_BOBCAT,
  xgemm3m_oncopyb_BOBCAT,  xgemm3m_oncopyr_BOBCAT,
  xgemm3m_oncopyi_BOBCAT,  xgemm3m_otcopyb_BOBCAT,
  xgemm3m_otcopyr_BOBCAT,  xgemm3m_otcopyi_BOBCAT,

  xsymm3m_iucopyb_BOBCAT,  xsymm3m_ilcopyb_BOBCAT,
  xsymm3m_iucopyr_BOBCAT,  xsymm3m_ilcopyr_BOBCAT,
  xsymm3m_iucopyi_BOBCAT,  xsymm3m_ilcopyi_BOBCAT,
  xsymm3m_oucopyb_BOBCAT,  xsymm3m_olcopyb_BOBCAT,
  xsymm3m_oucopyr_BOBCAT,  xsymm3m_olcopyr_BOBCAT,
  xsymm3m_oucopyi_BOBCAT,  xsymm3m_olcopyi_BOBCAT,

  xhemm3m_iucopyb_BOBCAT,  xhemm3m_ilcopyb_BOBCAT,
  xhemm3m_iucopyr_BOBCAT,  xhemm3m_ilcopyr_BOBCAT,
  xhemm3m_iucopyi_BOBCAT,  xhemm3m_ilcopyi_BOBCAT,

  xhemm3m_oucopyb_BOBCAT,  xhemm3m_olcopyb_BOBCAT,
  xhemm3m_oucopyr_BOBCAT,  xhemm3m_olcopyr_BOBCAT,
  xhemm3m_oucopyi_BOBCAT,  xhemm3m_olcopyi_BOBCAT,
#else
  0, 0, 0,

  NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,

  NULL, NULL,
  NULL, NULL,
  NULL, NULL,
#endif

#ifndef NO_LAPACK
  xneg_tcopy_BOBCAT, xlaswp_ncopy_BOBCAT,
#else
  NULL, NULL,
#endif

#endif

  init_parameter,

  SNUMOPT, DNUMOPT, QNUMOPT,
#if BUILD_SINGLE == 1
  saxpby_k_BOBCAT,
#endif
#if BUILD_DOUBLE  == 1
  daxpby_k_BOBCAT,
#endif
#if BUILD_COMPLEX == 1
  caxpby_k_BOBCAT,
#endif
#if BUILD_COMPLEX16== 1
  zaxpby_k_BOBCAT,
#endif

#if BUILD_SINGLE == 1
  somatcopy_k_cn_BOBCAT, somatcopy_k_ct_BOBCAT, somatcopy_k_rn_BOBCAT, somatcopy_k_rt_BOBCAT,
#endif
#if BUILD_DOUBLE== 1
  domatcopy_k_cn_BOBCAT, domatcopy_k_ct_BOBCAT, domatcopy_k_rn_BOBCAT, domatcopy_k_rt_BOBCAT,
#endif
#if BUILD_COMPLEX == 1
  comatcopy_k_cn_BOBCAT, comatcopy_k_ct_BOBCAT, comatcopy_k_rn_BOBCAT, comatcopy_k_rt_BOBCAT,
  comatcopy_k_cnc_BOBCAT, comatcopy_k_ctc_BOBCAT, comatcopy_k_rnc_BOBCAT, comatcopy_k_rtc_BOBCAT,
#endif
#if BUILD_COMPLEX16 == 1
  zomatcopy_k_cn_BOBCAT, zomatcopy_k_ct_BOBCAT, zomatcopy_k_rn_BOBCAT, zomatcopy_k_rt_BOBCAT,
  zomatcopy_k_cnc_BOBCAT, zomatcopy_k_ctc_BOBCAT, zomatcopy_k_rnc_BOBCAT, zomatcopy_k_rtc_BOBCAT,
#endif

#if BUILD_SINGLE == 1
  simatcopy_k_cn_BOBCAT, simatcopy_k_ct_BOBCAT, simatcopy_k_rn_BOBCAT, simatcopy_k_rt_BOBCAT,
#endif
#if BUILD_DOUBLE== 1
  dimatcopy_k_cn_BOBCAT, dimatcopy_k_ct_BOBCAT, dimatcopy_k_rn_BOBCAT, dimatcopy_k_rt_BOBCAT,
#endif
#if BUILD_COMPLEX== 1
  cimatcopy_k_cn_BOBCAT, cimatcopy_k_ct_BOBCAT, cimatcopy_k_rn_BOBCAT, cimatcopy_k_rt_BOBCAT,
  cimatcopy_k_cnc_BOBCAT, cimatcopy_k_ctc_BOBCAT, cimatcopy_k_rnc_BOBCAT, cimatcopy_k_rtc_BOBCAT,
#endif
#if BUILD_COMPLEX16==1
  zimatcopy_k_cn_BOBCAT, zimatcopy_k_ct_BOBCAT, zimatcopy_k_rn_BOBCAT, zimatcopy_k_rt_BOBCAT,
  zimatcopy_k_cnc_BOBCAT, zimatcopy_k_ctc_BOBCAT, zimatcopy_k_rnc_BOBCAT, zimatcopy_k_rtc_BOBCAT,
#endif

#if BUILD_SINGLE == 1
  sgeadd_k_BOBCAT,
#endif
#if BUILD_DOUBLE==1
  dgeadd_k_BOBCAT,
#endif
#if BUILD_COMPLEX==1
  cgeadd_k_BOBCAT,
#endif
#if BUILD_COMPLEX16==1
  zgeadd_k_BOBCAT
#endif
};

#if (ARCH_ARM64)
static void init_parameter(void) {
#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX== 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if (BUILD_BFLOAT16)
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
#endif
#if BUILD_DOUBLE==1 
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if (USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif

}
#else // (ARCH_ARM64)
#if defined(ARCH_MIPS64)
static void init_parameter(void) {
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;

  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = 640;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;

#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.qgemm_r = QGEMM_DEFAULT_R;
  TABLE_NAME.xgemm_r = XGEMM_DEFAULT_R;
#endif

#if defined(USE_GEMM3M)
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif

#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif

#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = TABLE_NAME.sgemm_q;
#endif

#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = TABLE_NAME.dgemm_q;
#endif

#ifdef CGEMM3M_DEFAULT_R
  TABLE_NAME.cgemm3m_r = CGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.cgemm3m_r = TABLE_NAME.sgemm_r;
#endif

#ifdef ZGEMM3M_DEFAULT_R
  TABLE_NAME.zgemm3m_r = ZGEMM3M_DEFAULT_R;
#else
  TABLE_NAME.zgemm3m_r = TABLE_NAME.dgemm_r;
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
  TABLE_NAME.xgemm3m_q = TABLE_NAME.qgemm_q;
  TABLE_NAME.xgemm3m_r = TABLE_NAME.qgemm_r;
#endif
#endif
}
#else // (ARCH_MIPS64)
#if (ARCH_POWER)
static void init_parameter(void) {

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
  TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
  TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
  TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
  TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //POWER

#if (ARCH_ZARCH)
static void init_parameter(void) {
#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
#endif
	TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
	TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
	TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
	TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;

#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
#endif
	TABLE_NAME.sgemm_r = SGEMM_DEFAULT_R;
	TABLE_NAME.dgemm_r = DGEMM_DEFAULT_R;
	TABLE_NAME.cgemm_r = CGEMM_DEFAULT_R;
	TABLE_NAME.zgemm_r = ZGEMM_DEFAULT_R;


#ifdef BUILD_BFLOAT16
	TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
	TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
	TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
	TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
	TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
}
#else //ZARCH

#ifdef ARCH_X86
static int get_l2_size_old(void){
  int i, eax, ebx, ecx, edx, cpuid_level;
  int info[15];

  cpuid(2, &eax, &ebx, &ecx, &edx);

  info[ 0] = BITMASK(eax,  8, 0xff);
  info[ 1] = BITMASK(eax, 16, 0xff);
  info[ 2] = BITMASK(eax, 24, 0xff);

  info[ 3] = BITMASK(ebx,  0, 0xff);
  info[ 4] = BITMASK(ebx,  8, 0xff);
  info[ 5] = BITMASK(ebx, 16, 0xff);
  info[ 6] = BITMASK(ebx, 24, 0xff);

  info[ 7] = BITMASK(ecx,  0, 0xff);
  info[ 8] = BITMASK(ecx,  8, 0xff);
  info[ 9] = BITMASK(ecx, 16, 0xff);
  info[10] = BITMASK(ecx, 24, 0xff);

  info[11] = BITMASK(edx,  0, 0xff);
  info[12] = BITMASK(edx,  8, 0xff);
  info[13] = BITMASK(edx, 16, 0xff);
  info[14] = BITMASK(edx, 24, 0xff);

  for (i = 0; i < 15; i++){

    switch (info[i]){

      /* This table is from http://www.sandpile.org/ia32/cpuid.htm */

    case 0x1a :
      return 96;

    case 0x39 :
    case 0x3b :
    case 0x41 :
    case 0x79 :
    case 0x81 :
      return 128;

    case 0x3a :
      return 192;

    case 0x21 :
    case 0x3c :
    case 0x42 :
    case 0x7a :
    case 0x7e :
    case 0x82 :
      return 256;

    case 0x3d :
      return 384;

    case 0x3e :
    case 0x43 :
    case 0x7b :
    case 0x7f :
    case 0x83 :
    case 0x86 :
      return 512;

    case 0x44 :
    case 0x78 :
    case 0x7c :
    case 0x84 :
    case 0x87 :
      return 1024;

    case 0x45 :
    case 0x7d :
    case 0x85 :
      return 2048;

    case 0x48 :
      return 3184;

    case 0x49 :
      return 4096;

    case 0x4e :
      return 6144;
    }
  }
//  return 0;
fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
return 256;
}
#endif

static __inline__ int get_l2_size(void){

  int eax, ebx, ecx, edx, l2;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  l2 = BITMASK(ecx, 16, 0xffff);

#ifndef ARCH_X86
  if (l2 <= 0) {
     fprintf (stderr,"OpenBLAS WARNING - could not determine the L2 cache size on this system, assuming 256k\n");
     return 256;
  }
  return l2;

#else

  if (l2 > 0) return l2;

  return get_l2_size_old();
#endif
}

static __inline__ int get_l3_size(void){

  int eax, ebx, ecx, edx;

  cpuid(0x80000006, &eax, &ebx, &ecx, &edx);

  return BITMASK(edx, 18, 0x3fff) * 512;
}


static void init_parameter(void) {

  int l2 = get_l2_size();

  (void) l2; /* dirty trick to suppress unused variable warning for targets */
             /* where the GEMM unrolling parameters do not depend on l2 */
  
#ifdef BUILD_BFLOAT16
  TABLE_NAME.sbgemm_p = SBGEMM_DEFAULT_P;
  TABLE_NAME.sbgemm_r = SBGEMM_DEFAULT_R;
  TABLE_NAME.sbgemm_q = SBGEMM_DEFAULT_Q;
#endif
#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_q = SGEMM_DEFAULT_Q;
#endif
#if  (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_q = DGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm_q = CGEMM_DEFAULT_Q;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_q = ZGEMM_DEFAULT_Q;
#endif

#if BUILD_COMPLEX == 1
#ifdef CGEMM3M_DEFAULT_Q
  TABLE_NAME.cgemm3m_q = CGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.cgemm3m_q = SGEMM_DEFAULT_Q;
#endif
#endif

#if BUILD_COMPLEX16 == 1
#ifdef ZGEMM3M_DEFAULT_Q
  TABLE_NAME.zgemm3m_q = ZGEMM3M_DEFAULT_Q;
#else
  TABLE_NAME.zgemm3m_q = DGEMM_DEFAULT_Q;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_q = QGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm_q = XGEMM_DEFAULT_Q;
  TABLE_NAME.xgemm3m_q = QGEMM_DEFAULT_Q;
#endif

#if defined(CORE_KATMAI)  || defined(CORE_COPPERMINE) || defined(CORE_BANIAS) || defined(CORE_YONAH) || defined(CORE_ATHLON)

#ifdef DEBUG
  fprintf(stderr, "Katmai, Coppermine, Banias, Athlon\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  64 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  32 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  16 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  16 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   8 * (l2 >> 7);
#endif
#endif

#ifdef CORE_NORTHWOOD

#ifdef DEBUG
  fprintf(stderr, "Northwood\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  96 * (l2 >> 7);
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1 
  TABLE_NAME.cgemm_p =  48 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  24 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  24 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  12 * (l2 >> 7);
#endif
#endif

#ifdef ATOM

#ifdef DEBUG
  fprintf(stderr, "Atom\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 256;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p = 128;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = 128;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  64;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  64;
  TABLE_NAME.xgemm_p =  32;
#endif
#endif

#ifdef CORE_PRESCOTT

#ifdef DEBUG
  fprintf(stderr, "Prescott\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE ==1 
  TABLE_NAME.dgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm_p =  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =   7 * (l2 >> 7);
#endif
#endif

#ifdef CORE2

#ifdef DEBUG
  fprintf(stderr, "Core2\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  92 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_p =  46 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  46 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  23 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  92 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  46 * (l2 >> 9) + 4;
#endif
#endif

#ifdef PENRYN

#ifdef DEBUG
  fprintf(stderr, "Penryn\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE == 1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif

#ifdef DUNNINGTON

#ifdef DEBUG
  fprintf(stderr, "Dunnington\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_DOUBLE ==1
  TABLE_NAME.dgemm_p =  42 * (l2 >> 9) + 8;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p =  21 * (l2 >> 9) + 4;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p =  21 * (l2 >> 9) + 4;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  42 * (l2 >> 9) + 8;
  TABLE_NAME.xgemm_p =  21 * (l2 >> 9) + 4;
#endif
#endif


#ifdef NEHALEM

#ifdef DEBUG
  fprintf(stderr, "Nehalem\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef SANDYBRIDGE

#ifdef DEBUG
  fprintf(stderr, "Sandybridge\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef HASWELL

#ifdef DEBUG
  fprintf(stderr, "Haswell\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if (BUILD_DOUBLE==1) || (BUILD_COMPLEX16)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#if defined(SKYLAKEX) || defined(COOPERLAKE)

#ifdef DEBUG
  fprintf(stderr, "SkylakeX\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef OPTERON

#ifdef DEBUG
  fprintf(stderr, "Opteron\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = 224 +  56 * (l2 >> 7);
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = 112 +  28 * (l2 >> 7);
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p =  56 +  14 * (l2 >> 7);
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p =  56 +  14 * (l2 >> 7);
  TABLE_NAME.xgemm_p =  28 +   7 * (l2 >> 7);
#endif
#endif

#ifdef BARCELONA

#ifdef DEBUG
  fprintf(stderr, "Barcelona\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BOBCAT

#ifdef DEBUG
  fprintf(stderr, "Bobcate\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef BULLDOZER

#ifdef DEBUG
  fprintf(stderr, "Bulldozer\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef EXCAVATOR

#ifdef DEBUG
  fprintf(stderr, "Excavator\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef PILEDRIVER

#ifdef DEBUG
  fprintf(stderr, "Piledriver\n");
#endif

#if (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef STEAMROLLER

#ifdef DEBUG
  fprintf(stderr, "Steamroller\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif

#ifdef ZEN

#ifdef DEBUG
  fprintf(stderr, "Zen\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if BUILD_DOUBLE
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if BUILD_COMPLEX16
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif
#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif
#endif


#ifdef NANO

#ifdef DEBUG
  fprintf(stderr, "NANO\n");
#endif

#if  (BUILD_SINGLE==1) || (BUILD_COMPLEX==1)
  TABLE_NAME.sgemm_p = SGEMM_DEFAULT_P;
#endif
#if  (BUILD_DOUBLE==1)
  TABLE_NAME.dgemm_p = DGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX==1)
  TABLE_NAME.cgemm_p = CGEMM_DEFAULT_P;
#endif
#if (BUILD_COMPLEX16==1)
  TABLE_NAME.zgemm_p = ZGEMM_DEFAULT_P;
#endif


#ifdef EXPRECISION
  TABLE_NAME.qgemm_p = QGEMM_DEFAULT_P;
  TABLE_NAME.xgemm_p = XGEMM_DEFAULT_P;
#endif

#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_P
  TABLE_NAME.cgemm3m_p = CGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.cgemm3m_p = TABLE_NAME.sgemm_p;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_P
  TABLE_NAME.zgemm3m_p = ZGEMM3M_DEFAULT_P;
#else
  TABLE_NAME.zgemm3m_p = TABLE_NAME.dgemm_p;
#endif
#endif

#ifdef EXPRECISION
  TABLE_NAME.xgemm3m_p = TABLE_NAME.qgemm_p;
#endif


#if BUILD_SINGLE == 1
  TABLE_NAME.sgemm_p = ((TABLE_NAME.sgemm_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_DOUBLE== 1
  TABLE_NAME.dgemm_p = ((TABLE_NAME.dgemm_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX==1
  TABLE_NAME.cgemm_p = ((TABLE_NAME.cgemm_p + CGEMM_DEFAULT_UNROLL_M - 1)/CGEMM_DEFAULT_UNROLL_M) * CGEMM_DEFAULT_UNROLL_M;
#endif
#if BUILD_COMPLEX16==1
  TABLE_NAME.zgemm_p = ((TABLE_NAME.zgemm_p + ZGEMM_DEFAULT_UNROLL_M - 1)/ZGEMM_DEFAULT_UNROLL_M) * ZGEMM_DEFAULT_UNROLL_M;
#endif

#if BUILD_COMPLEX==1
#ifdef CGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + CGEMM3M_DEFAULT_UNROLL_M - 1)/CGEMM3M_DEFAULT_UNROLL_M) * CGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.cgemm3m_p = ((TABLE_NAME.cgemm3m_p + SGEMM_DEFAULT_UNROLL_M - 1)/SGEMM_DEFAULT_UNROLL_M) * SGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#if BUILD_COMPLEX16==1
#ifdef ZGEMM3M_DEFAULT_UNROLL_M
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + ZGEMM3M_DEFAULT_UNROLL_M - 1)/ZGEMM3M_DEFAULT_UNROLL_M) * ZGEMM3M_DEFAULT_UNROLL_M;
#else
  TABLE_NAME.zgemm3m_p = ((TABLE_NAME.zgemm3m_p + DGEMM_DEFAULT_UNROLL_M - 1)/DGEMM_DEFAULT_UNROLL_M) * DGEMM_DEFAULT_UNROLL_M;
#endif
#endif

#ifdef QUAD_PRECISION
  TABLE_NAME.qgemm_p = ((TABLE_NAME.qgemm_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm_p = ((TABLE_NAME.xgemm_p + XGEMM_DEFAULT_UNROLL_M - 1)/XGEMM_DEFAULT_UNROLL_M) * XGEMM_DEFAULT_UNROLL_M;
  TABLE_NAME.xgemm3m_p = ((TABLE_NAME.xgemm3m_p + QGEMM_DEFAULT_UNROLL_M - 1)/QGEMM_DEFAULT_UNROLL_M) * QGEMM_DEFAULT_UNROLL_M;
#endif

#ifdef DEBUG
  fprintf(stderr, "L2 = %8d DGEMM_P  .. %d\n", l2, TABLE_NAME.dgemm_p);
#endif

#if BUILD_SINGLE==1
  TABLE_NAME.sgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.sgemm_p * TABLE_NAME.sgemm_q *  4 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.sgemm_q *  4) - 15) & ~15);
#endif

#if BUILD_DOUBLE==1
  TABLE_NAME.dgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.dgemm_p * TABLE_NAME.dgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.dgemm_q *  8) - 15) & ~15);
#endif

#ifdef EXPRECISION
  TABLE_NAME.qgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.qgemm_p * TABLE_NAME.qgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.qgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX ==1 
  TABLE_NAME.cgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm_p * TABLE_NAME.cgemm_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 ==1
  TABLE_NAME.zgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm_p * TABLE_NAME.zgemm_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm_q * 16) - 15) & ~15);
#endif

#if BUILD_COMPLEX == 1
  TABLE_NAME.cgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.cgemm3m_p * TABLE_NAME.cgemm3m_q *  8 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.cgemm3m_q *  8) - 15) & ~15);
#endif

#if BUILD_COMPLEX16 == 1
  TABLE_NAME.zgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.zgemm3m_p * TABLE_NAME.zgemm3m_q * 16 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
			       ) / (TABLE_NAME.zgemm3m_q * 16) - 15) & ~15);
#endif



#ifdef EXPRECISION
  TABLE_NAME.xgemm_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm_p * TABLE_NAME.xgemm_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm_q * 32) - 15) & ~15);

  TABLE_NAME.xgemm3m_r = (((BUFFER_SIZE -
			       ((TABLE_NAME.xgemm3m_p * TABLE_NAME.xgemm3m_q * 32 + TABLE_NAME.offsetA
				 + TABLE_NAME.align) & ~TABLE_NAME.align)
		       ) / (TABLE_NAME.xgemm3m_q * 32) - 15) & ~15);

#endif



}
#endif //POWER
#endif //ZARCH
#endif //(ARCH_MIPS64)
#endif //(ARCH_ARM64)
