%%
%% This is file `easybook.cls'.
%%
%% Copyright (C) 2021 by Qu Yi <texeasybook@foxmail.com>
%%
%% This work may be distributed and/or modified under the
%% conditions of the CC-BY 4.0 License.
%% The latest version of this license is in
%%   https://creativecommons.org/licenses/by/4.0/legalcode
\NeedsTeXFormat{LaTeX2e}
\RequirePackage{l3keys2e}
\ProvidesExplClass{easybook}{2021/01/19}{1.21h}{}

\cs_generate_variant:Nn \keys_define:nn {nx}
\cs_generate_variant:Nn \int_to_arabic:n {v}
\cs_generate_variant:Nn \dim_add:Nn {NV}
\cs_new_protected:Npn \__ctex_define:nn #1
  {\keys_define:nn {ctex/#1}}
\cs_new_protected:Npn \__put_ctexbook:n #1
  {\PassOptionsToClass{#1}{ctexbook}}
\cs_new_protected:Npn \__patch_cmd:Nnn #1#2#3
  {\ctex_patch_cmd_once:NnnnTF #1{}{#2}{#3}{}{\ctex_patch_failure:N #1}}
\cs_new_protected:Npn \__appto_cmd:Nn #1#2
  {\ctex_appto_cmd:NnnTF #1{}{#2}{}{\ctex_patch_failure:N #1}}

\bool_set_false:N \l__draft_bool
\bool_set_false:N \l__newline_bool
\bool_set_false:N \l__enstyle_bool
\bool_set_false:N \l__myfont_bool
\bool_set_true:N  \l__zhtitle_bool
\bool_set_true:N  \l__lang_chinese_bool
\bool_set_true:N  \l__page_twoside_bool
\clist_new:N      \g__options_clist

\keys_define:nn {easybook}
  {
    draft         .code:n = {\bool_set_true:N  \l__draft_bool},
    newline       .code:n = {\bool_set_true:N  \l__newline_bool},
    enstyle       .code:n = {\bool_set_true:N  \l__enstyle_bool},
    entitle       .code:n = {\bool_set_false:N \l__zhtitle_bool},
    english       .code:n = {\bool_set_false:N \l__lang_chinese_bool},

    font          .choice:,
    font          .value_required:n = true,
    font/overleaf .code:n = {},
    font/adobe    .code:n =
      {\__put_ctexbook:n {fontset = #1}},
    font/founder  .code:n =
      {\__put_ctexbook:n {fontset = #1}},
    font/mac      .code:n =
      {\__put_ctexbook:n {fontset = #1}},
    font/windows  .code:n =
      {\__put_ctexbook:n {fontset = #1}},
    font/linux    .code:n =
      {\__put_ctexbook:n {fontset = ubuntu}},
    font/none     .code:n =
      {\__put_ctexbook:n {fontset = #1}},
    font/myfont   .code:n =
      {
        \bool_set_true:N \l__myfont_bool
        \__put_ctexbook:n {fontset = none}
      },
    font          .initial:n = overleaf,

    paper         .choice:,
    paper         .value_required:n = true,
    paper/unknown .code:n =
      {\PassOptionsToPackage{#1}{geometry}},
    paper         .initial:n = a4paper,

    oneside       .value_forbidden:n = true,
    twoside       .value_forbidden:n = true,
    oneside       .code:n =
      {\bool_set_false:N \l__page_twoside_bool},

    unknown       .code:n =
      {\clist_gput_right:No \g__options_clist{\CurrentOption}}
  }

\ProcessKeysOptions{easybook}

\bool_if:NT \l__enstyle_bool
  {
    \bool_set_false:N \l__lang_chinese_bool
    \bool_set_false:N \l__zhtitle_bool
    \bool_set_true:N  \l__newline_bool
  }
\bool_if:NTF \l__lang_chinese_bool
  {\__put_ctexbook:n {scheme = chinese}}
  {\__put_ctexbook:n {scheme = plain}}

\__put_ctexbook:n {\g__options_clist}
\PassOptionsToPackage{CJKmath = true}{xeCJK}
\LoadClass[UTF8]{ctexbook}

\bool_new:N \l__capdash_bool
\bool_new:N \l__multoc_bool
\bool_new:N \l__chap_withpart_bool
\bool_new:N \l__foot_perpart_bool
\bool_new:N \l__foot_perpage_bool
\tl_new:N   \g__config_tl

\ctex_define:n
  {
    style               .meta:nn = {ctex/style}{#1},
    link                .meta:nn = {ctex/link}{#1},
    spread              .meta:nn = {ctex/spread}{#1},
    elfont              .meta:nn = {ctex/elfont}{#1},
    bibset              .meta:nn = {ctex/bibset}{#1},
    thmset              .meta:nn = {ctex/thmset}{#1},
    geoset              .meta:nn = {ctex/geoset}{#1},
    tocset              .meta:nn = {ctex/tocset}{#1},
    config              .tl_set:N = \g__config_tl,
    lstlistlistingname  .tl_set:N = \lstlistlistingname,
    lstlistingname      .tl_set:N = \lstlistingname
  }
\__ctex_define:nn {style}
  {
    capdash   .bool_set:N = \l__capdash_bool,
    capdash   .default:n = true,
    capdash   .initial:n = false,
    multoc    .bool_set:N = \l__multoc_bool,
    multoc    .default:n = true,
    multoc    .initial:n = false,
    withpart  .bool_set:N = \l__chap_withpart_bool,
    withpart  .default:n = true,
    withpart  .initial:n = false,
    perpart   .bool_set:N = \l__foot_perpart_bool,
    perpart   .default:n = true,
    perpart   .initial:n = false,
    perpage   .bool_set:N = \l__foot_perpage_bool,
    perpage   .default:n = true,
    perpage   .initial:n = false
  }

\RequirePackage[svgnames]{xcolor}
\RequirePackage{pdfpages,subfiles}
\includepdfset{fitpaper = true}
\RequirePackage[hang,stable]{footmisc}
\RequirePackage{setspace,zhlineskip}
\RequirePackage{amsthm,thmtools,cases}
\RequirePackage[noto,upint]{newtxmath}
\RequirePackage{chemformula}
\RequirePackage{chemfig}
\RequirePackage{siunitx,physics,bm}
\RequirePackage[normalem]{ulem}
\RequirePackage[protrusion = false]{microtype}
\RequirePackage{rotfloat}
\RequirePackage{geometry,marginnote,changepage}
\RequirePackage{nccfoots,tablefootnote}
\RequirePackage{fancyhdr,fancybox,titletoc}
\RequirePackage{caption,bicaption,subcaption}
\RequirePackage{graphicx,wrapfig}
\RequirePackage{zhlipsum,fontawesome,pifont}
\RequirePackage{tabularx,multirow,makecell,booktabs}
\RequirePackage{paralist,tasks}
\RequirePackage[shortlabels,inline]{enumitem}
\RequirePackage[most]{tcolorbox}
\RequirePackage[xindy]{imakeidx}
\RequirePackage[
  lang = {chinese-utf8},
  type = {CC},
  modifier = {by},
  version = {4.0}
  ]{doclicense}
\cs_new_eq:NN \github\faGithub
\cs_new:Npn   \git{\textcolor[HTML]{c71d23}{\faGit}}
\cs_new:Npn   \edge{\textcolor[HTML]{00c2ff}{\faEdge}}
\ctex_at_end_preamble:n
  {
    \tl_if_empty:NF \g__config_tl
      {\file_input:n {\g__config_tl}}
  }

\sys_if_engine_xetex:TF
  {
    \cs_new_eq:NN \__set_family:nnn  \xeCJK_set_family:nnn
    \cs_new_eq:NN \__switch_family:n \xeCJK_switch_family:n
  }{
    \cs_new_eq:NN \__set_family:nnn  \ctex_ltj_set_family:nnn
    \cs_new_eq:NN \__switch_family:n \ctex_ltj_switch_family:n
  }

\cs_new_protected:Npn \__setmainfont:nn #1#2
  {\__fontspec_main_setmainfont:nn {#2}{#1}}
\cs_new_protected:Npn \__setsansfont:nn #1#2
  {\__fontspec_main_setsansfont:nn {#2}{#1}}
\cs_new_protected:Npn \__setmonofont:nn #1#2
  {\__fontspec_main_setmonofont:nn {#2}{#1}}
\cs_new_protected:Npn \__setCJKmainfont:nn #1#2
  {\__set_family:nnn {\CJKrmdefault}{#2}{#1}}
\cs_new_protected:Npn \__setCJKsansfont:nn #1#2
  {\__set_family:nnn {\CJKsfdefault}{#2}{#1}}
\cs_new_protected:Npn \__setCJKmonofont:nn #1#2
  {\__set_family:nnn {\CJKttdefault}{#2}{#1}}
\cs_new_protected:Npn \__set_zhfont_songti:nn #1#2
  {\__set_family:nnn {songti}{#2}{#1}}
\cs_new_protected:Npn \__set_zhfont_heiti:nn #1#2
  {\__set_family:nnn {heiti}{#2}{#1}}
\cs_new_protected:Npn \__set_zhfont_kaishu:nn #1#2
  {\__set_family:nnn {kaishu}{#2}{#1}}
\cs_new_protected:Npn \__set_zhfont_fangsong:nn #1#2
  {\__set_family:nnn {fangsong}{#2}{#1}}

\tl_const:Nn \__option_zhfont:
  {UprightFont = *,AutoFakeBold = 1.5,ItalicFont = *}
\cs_new_protected:Npx \__setCJKmainfont:n #1
  {\__setCJKmainfont:nn {#1}{\__option_zhfont:}}
\cs_new_protected:Npx \__setCJKsansfont:n #1
  {\__setCJKsansfont:nn {#1}{\__option_zhfont:}}
\cs_new_protected:Npx \__setCJKmonofont:n #1
  {\__setCJKmonofont:nn {#1}{\__option_zhfont:}}
\cs_new_protected:Npx \__set_zhfont_songti:n #1
  {\__set_zhfont_songti:nn {#1}{\__option_zhfont:}}
\cs_new_protected:Npx \__set_zhfont_heiti:n #1
  {\__set_zhfont_heiti:nn {#1}{\__option_zhfont:}}
\cs_new_protected:Npx \__set_zhfont_kaishu:n #1
  {\__set_zhfont_kaishu:nn {#1}{\__option_zhfont:}}
\cs_new_protected:Npx \__set_zhfont_fangsong:n #1
  {\__set_zhfont_fangsong:nn {#1}{\__option_zhfont:}}

\bool_if:NT \l__myfont_bool
  {
    \__setmainfont:nn {NotoSerif}
      {
        Extension = .ttf,
        UprightFont = *-Regular,
        BoldFont = *-Bold,
        ItalicFont = *-Italic
      }
    \__setsansfont:nn {NotoSans}
      {
        Extension = .ttf,
        UprightFont = *-Regular,
        BoldFont = *-Bold,
        ItalicFont = *-Italic
      }
    \__setmonofont:nn {NotoSansMono}
      {
        Extension = .ttf,
        UprightFont = *-Regular,
        BoldFont = *-Bold
      }
    \__setCJKmainfont:nn {FZShuSong-Z01S}
      {
        UprightFont = *,
        BoldFont = FZHei-B01S,
        ItalicFont = FZKai-Z03S
      }
    \__setCJKsansfont:n {FZHei-B01S}
    \__setCJKmonofont:n {FZFangSong-Z02S}
    \__set_zhfont_songti:n {FZShuSong-Z01S}
    \__set_zhfont_heiti:n {FZHei-B01S}
    \__set_zhfont_kaishu:n {FZKai-Z03S}
    \__set_zhfont_fangsong:n {FZFangSong-Z02S}
    \cs_new_protected:Npn \songti{\__switch_family:n {songti}}
    \cs_new_protected:Npn \heiti{\__switch_family:n {heiti}}
    \cs_new_protected:Npn \kaishu{\__switch_family:n {kaishu}}
    \cs_new_protected:Npn \fangsong{\__switch_family:n {fangsong}}
  }
\cs_if_exist:NF \kaishu{\cs_gset_eq:NN \kaishu\normalfont}

\clist_new:N \g__geometry_clist
\__ctex_define:nn {geoset}
  {
    unknown .code:n =
      {
        \clist_gput_right:Nx \g__geometry_clist
          {
            \l_keys_key_str
            \tl_if_empty:NF \l_keys_value_tl{ = {#1}}
          }
      }
  }
\geometry
  {
    vmargin = 2.54cm,
    hmargin = 3.17cm,
    columnsep = 2\ccwd,
    headheight = 2.04cm,
    headsep = 0.5cm,
    footskip = 0.79cm,
    footnotesep = 0.5cm,
    marginparsep = 8pt,
    marginparwidth = 2.54cm
  }

\cs_gset:Npn \cleardoublepage
  {
    \clearpage
    \bool_if:NT \l__page_twoside_bool
      {
        \int_if_odd:nF \c@page
          {\hbox:n {}\thispagestyle{empty}\clearpage}
      }
  }
\cs_gset:Npn \frontmatter
  {
    \cleardoublepage
    \@mainmatterfalse
    \pagenumbering{Roman}
  }

\ctex_define:n
  {
    hdrset  .tl_set:N = \l__fancyhf_content_tl,
    hdrset  .initial:n =
      {
        \fancyhead[EC]{\color{ctex@frame}\kaishu\leftmark}
        \fancyhead[OC]{\color{ctex@frame}\kaishu\rightmark}
        \fancyhead[EL,OR]{\color{ctex@frame}\thepage}
      }
  }
\ctex_at_end_preamble:n
  {
    \exp_args:NV \geometry\g__geometry_clist
    \pagestyle{fancy}
    \fancyhf{}
    \bool_if:NTF \l__page_twoside_bool
      {
        \cs_gset:Npn \chaptermark#1
          {
            \markboth
              {
                \MakeUppercase
                  {
                    \ifnum\c@secnumdepth>\m@ne
                      \if@mainmatter
                        \ifodd\CTEX@chapter@numbering
                          \CTEXthechapter\hspace{\ccwd}
                        \fi
                      \fi
                    \fi#1
                  }
              }{
                \MakeUppercase
                  {
                    \ifnum\c@secnumdepth>\m@ne
                      \if@mainmatter
                        \ifodd\CTEX@chapter@numbering
                          \CTEXthechapter\hspace{\ccwd}
                        \fi
                      \fi
                    \fi#1
                  }
              }
          }
        \l__fancyhf_content_tl
        \cs_gset_eq:NN \ps@plain\ps@empty
      }{
        \cs_gset:Npn \chaptermark#1
          {
            \markboth
              {
                \MakeUppercase
                  {
                    \ifnum\c@secnumdepth>\m@ne
                      \if@mainmatter
                        \ifodd\CTEX@chapter@numbering
                          \CTEXthechapter\hspace{\ccwd}
                        \fi
                      \fi
                    \fi#1
                  }
              }{}
          }
        \l__fancyhf_content_tl
        \cs_gset_eq:NN \ps@plain\ps@empty
      }
    \cs_gset:Npn \sectionmark#1
      {
        \markright
          {
            \ifnum\c@secnumdepth>\z@
              \ifodd\CTEX@section@numbering
                \CTEXthesection\hspace{0.5\ccwd}
              \fi
            \fi#1
          }
      }
    \cs_gset:Npn \headrule
      {
        \color{ctex@frame}\vspace{2.5pt}
        \hrule width\textwidth height 0.75pt
      }
    \bool_if:NT \l__draft_bool
      {
        \bool_if:NTF \l__page_twoside_bool
          {\fancyfoot[C]{\color{gray!60}\sffamily\today}}
          {\fancyhead[L]{\color{gray!60}\sffamily\today}}
        \geometry{showframe}
      }
  }

\ctex_define:n
  {
    tocset/part       .meta:nn = {ctex/tocset/part}{#1},
    tocset/chapter    .meta:nn = {ctex/tocset/chapter}{#1},
    tocset/section    .meta:nn = {ctex/tocset/section}{#1},
    tocset/subsection .meta:nn = {ctex/tocset/subsection}{#1},
    tocset/list       .meta:nn = {ctex/tocset/list}{#1},
  }
\__ctex_define:nn {tocset}
  {
    part/format       .tl_set:N = \l__toc_part_format_tl,
    part/format       .initial:n =
      {\addvspace{1pc}\sffamily\large},
    part/indent       .tl_set:N = \l__toc_part_indent_tl,
    part/indent       .initial:n = 0\ccwd,
    part/rule         .tl_set:N = \l__toc_part_rule_tl,
    part/rule         .initial:n = \tocrule{}[\bfseries],

    chapter/format    .tl_set:N = \l__toc_chap_format_tl,
    chapter/format    .initial:n =
      {\addvspace{1pc}\sffamily\large},
    chapter/indent    .tl_set:N = \l__toc_chap_indent_tl,
    chapter/indent    .initial:n = 0\ccwd,
    chapter/rule      .tl_set:N = \l__toc_chap_rule_tl,
    chapter/rule      .initial:n = \tocrule{$\cdot$}[\bfseries],

    section/format    .tl_set:N = \l__toc_sec_format_tl,
    section/format    .initial:n = \addvspace{0.35pc},
    section/indent    .tl_set:N = \l__toc_sec_indent_tl,
    section/indent    .initial:n = 1.5\ccwd,    
    section/rule      .tl_set:N = \l__toc_sec_rule_tl,
    section/rule      .initial:n = \tocrule{$\cdot$},

    subsection/format .tl_set:N = \l__toc_subsec_format_tl,
    subsection/forma  .initial:n = \addvspace{0.35pc},
    subsection/indent .tl_set:N = \l__toc_subsec_indent_tl,
    subsection/indent .initial:n = 3.8\ccwd,
    subsection/rule   .tl_set:N = \l__toc_subsec_rule_tl,
    subsection/rule   .initial:n = \tocrule{$\cdot$},

    lists/format      .tl_set:N = \l__toc_lists_format_tl,
    lists/format      .initial:n = \addvspace{0.2pc},
    lists/indent      .tl_set:N = \l__toc_lists_indent_tl,
    lists/indent      .initial:n = 0\ccwd,
    lists/rule        .tl_set:N = \l__toc_lists_rule_tl,
    lists/rule        .initial:n = \tocrule{$\cdot$},
    lists/lolskip     .dim_set:N = \l__toc_lolskip_dim,
    lists/lolskip     .initial:n = 0.8pc,
    lists/belowoffset .dim_set:N = \l__toc_listsoffset_dim,
    lists/belowoffset .initial:n = 0pc,

    belowoffset       .dim_set:N = \l__toc_offset_dim,
    belowoffset       .initial:n = -1pc
  }

\NewDocumentCommand{\tocrule}{O{0.7pc}O{1.2}mO{}}
  {
    \normalsize\normalfont
    \titlerule*[#1]{\scalebox{#2}{#3}}#4\contentspage
  }
\titlecontents{part}
  [\l__toc_part_indent_tl]
  {\l__toc_part_format_tl}{}{}
  {\l__toc_part_rule_tl}
\titlecontents{chapter}
  [\l__toc_chap_indent_tl]
  {\l__toc_chap_format_tl}{}{}
  {\l__toc_chap_rule_tl}
\titlecontents{section}
  [\l__toc_sec_indent_tl]
  {\l__toc_sec_format_tl}{}{}
  {\l__toc_sec_rule_tl}
\titlecontents{subsection}
  [\l__toc_subsec_indent_tl]
  {\l__toc_subsec_format_tl}{}{}
  {\l__toc_subsec_rule_tl}
\titlecontents{figure}
  [\l__toc_lists_indent_tl]
  {\l__toc_lists_format_tl}{}{}
  {\l__toc_lists_rule_tl}
\titlecontents{table}
  [\l__toc_lists_indent_tl]
  {\l__toc_lists_format_tl}{}{}
  {\l__toc_lists_rule_tl}
\contentsuse{lstlisting}{lol}
\titlecontents{lstlisting}
  [\l__toc_lists_indent_tl]
  {\l__toc_lists_format_tl}{}{}
  {\l__toc_lists_rule_tl}
\ctex_patch_cmd:Nnn \caption@@@addcontentsline
  {\addcontentsline{#1}{#2}{\protect\numberline{#3}{#4}}}
  {\addcontentsline{#1}{#2}{#3\hspace{\ccwd}#4}}
\ctex_patch_cmd:Nnn \lst@MakeCaption
  {
    \addcontentsline{lol}{lstlisting}
      {\protect\numberline{\thelstlisting}\lst@@caption}
  }{
    \addcontentsline{lol}{lstlisting}
      {\thelstlisting\hspace{\ccwd}\lst@@caption}
  }
\__appto_cmd:Nn \@chapter
  {
    \addtocontents{lol}
      {\protect\addvspace{\dim_use:N \l__toc_lolskip_dim}}
  }

\cs_new_protected:Npn \__markboth:n #1
  {
    \bool_if:NTF \l__page_twoside_bool
      {\markboth{\MakeUppercase#1}{\MakeUppercase#1}}
      {\markboth{\MakeUppercase#1}{}}
  }
\cs_new_protected:Npn \__title_mark_intoc:n #1
  {
    \chapter*{\phantomsection#1}
    \CTEX@addtocline{chapter}{#1}
    \__markboth:n #1
  }
\cs_new_protected:Npn \__title_mark:n #1
  {
    \chapter*{\phantomsection#1}
    \__markboth:n #1
  }
\cs_gset:Npn \tableofcontents
  {
    \if@twocolumn
      \@restonecoltrue\onecolumn
      \bool_if:NT \l__multoc_bool{\twocolumn}
    \else
      \@restonecolfalse
      \bool_if:NT \l__multoc_bool{\twocolumn}
    \fi
    \__title_mark:n {\contentsname}
    \vspace*{\dim_use:N \l__toc_offset_dim}
    \@starttoc{toc}
    \if@restonecol
      \twocolumn
    \else
      \onecolumn
    \fi
  }
\cs_gset:Npn \listoffigures
  {
    \if@twocolumn
      \@restonecoltrue\onecolumn
      \bool_if:NT \l__multoc_bool{\twocolumn}
    \else
      \@restonecolfalse
      \bool_if:NT \l__multoc_bool{\twocolumn}
    \fi
    \__title_mark_intoc:n {\listfigurename}
    \dim_add:NV \l__toc_offset_dim\l__toc_listsoffset_dim
    \vspace*{\dim_use:N \l__toc_offset_dim}
    \@starttoc{lof}
    \if@restonecol
      \twocolumn
    \else
      \onecolumn
    \fi
  }
\cs_gset:Npn \listoftables
  {
    \if@twocolumn
      \@restonecoltrue\onecolumn
      \bool_if:NT \l__multoc_bool{\twocolumn}
    \else
      \@restonecolfalse
      \bool_if:NT \l__multoc_bool{\twocolumn}
    \fi
    \__title_mark_intoc:n {\listtablename}
    \dim_add:NV \l__toc_offset_dim\l__toc_listsoffset_dim
    \vspace*{\dim_use:N \l__toc_offset_dim}
    \@starttoc{lot}
    \if@restonecol
      \twocolumn
    \else
      \onecolumn
    \fi
  }
\cs_new:Npn \listoflistings
  {
    \group_begin:
    \@ifundefined{@restonecoltrue}{}
      {
        \if@twocolumn
          \@restonecoltrue\onecolumn
          \bool_if:NT \l__multoc_bool{\twocolumn}
        \else
          \@restonecolfalse
          \bool_if:NT \l__multoc_bool{\twocolumn}
        \fi
      }
    \__title_mark_intoc:n {\lstlistlistingname}
    \dim_add:NV \l__toc_offset_dim\l__toc_listsoffset_dim
    \vspace*{\dim_use:N \l__toc_offset_dim}
    \@starttoc{lol}
    \@ifundefined{@restonecoltrue}{}
      {
        \if@restonecol
          \twocolumn
        \else
          \onecolumn
        \fi
      }
    \group_end:
  }

\makeindex[
  intoc,
  options = -M~texindy~-C~utf8,
  program = truexindy,
  columns = 2,
  columnsep = 2\ccwd
  ]
\indexsetup
  {
    level = \chapter*,
    toclevel = chapter,
    firstpagestyle = plain
  }
\__patch_cmd:Nnn \imki@indexheaders
  {\@mkboth{\MakeUppercase\indexname}{\MakeUppercase\indexname}}
  {\__markboth:n \indexname}

\tl_new:N \l__tab_font_tl
\tl_new:N \l__fig_font_tl
\tl_new:N \l__lst_font_tl
\tl_new:N \l__foot_font_tl
\tl_new:N \l__margin_font_tl

\__ctex_define:nn {elfont}
  {
    tabfont .tl_set:N = \l__tab_font_tl,
    tabfont .initial:n = \sffamily\small,
    figfont .tl_set:N = \l__fig_font_tl,
    figfont .initial:n = \sffamily\small,
    lstfont .tl_set:N = \l__lst_font_tl,
    lstfont .initial:n = \sffamily\small,
    fnfont  .tl_set:N = \l__foot_font_tl,
    fnfont  .initial:n = \rmfamily,
    marfont .tl_set:N = \l__margin_font_tl,
    marfont .initial:n = \rmfamily\footnotesize
  }

\DeclareCaptionLabelSeparator{ccwd}{\hspace{\ccwd}}
\DeclareCaptionLabelFormat{parens}{\bothIfFirst{#1}{~}(#2)}
\DeclareCaptionFont{tabfont}{\l__tab_font_tl}
\DeclareCaptionFont{figfont}{\l__fig_font_tl}
\DeclareCaptionFont{lstfont}{\l__lst_font_tl}
\captionsetup
  {
    format = hang,
    % figurewithin = section,
    % tablewithin = section,
    labelsep = ccwd,
    belowskip = 0pt,aboveskip = 10pt
  }
\captionsetup[table]
  {
    labelfont = {tabfont,color = ctex@frame},
    textfont = {tabfont,stretch = \l__cap_spread_tl}
  }
\captionsetup[figure]
  {
    labelfont = {figfont,color = ctex@frame},
    textfont = {figfont,stretch = \l__cap_spread_tl}
  }
\captionsetup[subfigure]
  {
    labelformat = parens,
    belowskip = 2pt,aboveskip = 6pt
  }
\captionsetup[lstlisting]
  {
    singlelinecheck = false,
    labelfont = {lstfont,color = ctex@frame},
    textfont = {lstfont,stretch = \l__cap_spread_tl}
  }
\captionsetup[figure][bi-second]{name = Figure}
\captionsetup[table][bi-second]{name = Table}
\cs_new:Npn \__arabic:n #1{\int_to_arabic:v {c@#1}}
\AtBeginDocument
  {
    \bool_if:NT \l__capdash_bool
      {
        \cs_gset:Npn \thefigure{\thechapter\textendash\__arabic:n {figure}}
        \cs_gset:Npn \thetable{\thechapter\textendash\__arabic:n {table}}
        \cs_gset:Npn \thelstlisting{\thechapter\textendash\__arabic:n {lstlisting}}
      }
  }
\AtBeginEnvironment{tabularx}
  {\exp_args:Nx \linespread{\fp_use:N \l__tab_spread_fp}\selectfont\ignorespaces}
\AtBeginEnvironment{tabular}
  {\exp_args:Nx \linespread{\fp_use:N \l__tab_spread_fp}\selectfont\ignorespaces}

\fp_new:N \l__line_spread_fp
\fp_new:N \l__tab_spread_fp
\tl_new:N \l__math_spread_tl
\tl_new:N \l__cap_spread_tl
\tl_new:N \l__foot_spread_tl
\tl_new:N \l__foot_fnsep_tl

\__ctex_define:nn {spread}
  {
    linespread  .fp_set:N = \l__line_spread_fp,
    linespread  .initial:n = 1.3,
    tabspread   .fp_set:N = \l__tab_spread_fp,
    tabspread   .initial:n = 1,
    mathspread  .tl_set:N = \l__math_spread_tl,
    mathspread  .initial:n = 1,
    capspread   .tl_set:N = \l__cap_spread_tl,
    capspread   .initial:n = 1,
    fnspread    .tl_set:N = \l__foot_spread_tl,
    fnspread    .initial:n = 1,
    fnsep       .tl_set:N = \l__foot_fnsep_tl,
    fnsep       .initial:n = 0ex
  }

\skip_set:Nn \parskip{0pt plus 2pt minus 1pt}
\skip_set:Nn \floatsep{12pt plus 2pt minus 2pt}
\skip_set:Nn \intextsep{14pt plus 2pt minus 2pt}
\skip_set:Nn \textfloatsep{16pt plus 2pt minus 4pt}
\skip_set:Nn \dbltextfloatsep{16pt plus 2pt minus 4pt}
\skip_set:Nn \@fpsep{8pt plus 2.0fil}
\setcounter{topnumber}{4}
\setcounter{bottomnumber}{4}
\setcounter{totalnumber}{8}
\cs_gset:Npn \textfraction{0.18}
\cs_gset:Npn \topfraction{0.85}
\cs_gset:Npn \bottomfraction{0.65}
\cs_gset:Npn \floatpagefraction{0.60}
\ctex_after_end_preamble:n
  {\exp_args:Nx \linespread{\fp_use:N \l__line_spread_fp}\selectfont}

\newcolumntype{L}{X}
\newcolumntype{C}{>{\centering\arraybackslash}X}
\newcolumntype{R}{>{\raggedleft\arraybackslash}X}
\graphicspath{{figures/}}
\DeclareGraphicsExtensions{.pdf,.png,.jpg,.eps,.tif}

\setlist
  {
    labelsep = .75\ccwd,listparindent = 2\ccwd,
    itemsep = .75ex plus .1ex,parsep = 0ex,topsep = .75ex plus .1ex,partopsep = 0ex
  }
\setlist[itemize,1]
  {label = \color{ctex@emph}\ensuremath{\bullet},leftmargin = *}
\setlist[itemize,2]
  {label = \color{ctex@emph}\ensuremath{\circ},leftmargin = *}
\setlist[enumerate,1]
  {label = \color{ctex@emph}\arabic*.,ref = \arabic*,leftmargin = *}
\setlist[enumerate,2]
  {label = \color{ctex@emph}(\alph*),ref = \theenumi(\alph*),leftmargin = *}
\setlist[description]
  {font = \color{ctex@emph}\sf,labelwidth = *,leftmargin = 2\ccwd}
\newlist{outlinelist}{itemize}{1}
\setlist[outlinelist]
  {label = \color{ctex@emph}\upshape\ding{112},itemsep = .5ex plus .1ex,leftmargin = *}
\skip_set:Nn \pltopsep{.75ex plus .1ex}
\skip_set:Nn \plpartopsep{0ex}
\skip_set:Nn \plitemsep{.75ex plus .1ex}
\skip_set:Nn \plparsep{0ex}
\cs_new:Npn \circled#1
  {
    \lower .7ex
    \hbox{\tikz\draw(0pt,0pt)circle(.5\ccwd)node{\makebox[\ccwd][c]{\small#1}};}
  }

\cs_new_protected:Npn \__thmname_set:nn #1#2
  {\tl_const:cn {c__name_#1_tl}{#2}}
\bool_if:NTF \l__lang_chinese_bool
  {
    \clist_map_inline:nn
      {
        {theorem}{定理},
        {definition}{定义},
        {lemma}{引理},
        {corollary}{推论},
        {proposition}{性质},
        {example}{例},
        {remark}{注},
        {exercise}{练习}
      }{\__thmname_set:nn #1}
  }{
    \clist_map_inline:nn
      {
        {theorem}{Theorem},
        {definition}{Definition},
        {lemma}{Lemma},
        {corollary}{Corollary},
        {proposition}{Proposition},
        {example}{Example},
        {remark}{Remark},
        {exercise}{Exercise}
      }{\__thmname_set:nn #1}
  }

\bool_new:N \l__thmbox_bool
\tl_new:N \l__thm_numberwith_tl
\tl_new:N \l__thm_headpunct_tl
\tl_new:N \l__thm_bodyfont_tl
\tl_new:N \l__thm_notefont_tl
\tl_new:N \l__thm_headindent_tl
\tl_new:N \l__thm_spaceabove_tl
\tl_new:N \l__thm_spacebelow_tl

\__ctex_define:nn {thmset}
  {
    thmbox      .bool_set:N = \l__thmbox_bool,
    thmbox      .default:n = true,
    thmbox      .initial:n = false,
    numberwith  .tl_set:N = \l__thm_numberwith_tl,
    numberwith  .initial:n = {chapter},
    headpunct   .tl_set:N = \l__thm_headpunct_tl,
    headpunct   .initial:n = {},
    bodyfont    .tl_set:N = \l__thm_bodyfont_tl,
    bodyfont    .initial:n = {},
    notefont    .tl_set:N = \l__thm_notefont_tl,
    notefont    .initial:n = {},
    headfont    .tl_set:N = \l__thm_headfont_tl,
    headfont    .initial:n = {\color{ctex@emph}\sffamily},
    headindent  .tl_set:N = \l__thm_headindent_tl,
    headindent  .initial:n = {0\ccwd},
    spaceabove  .tl_set:N = \l__thm_spaceabove_tl,
    spaceabove  .initial:n = {.75ex plus .1ex},
    spacebelow  .tl_set:N = \l__thm_spacebelow_tl,
    spacebelow  .initial:n = {.75ex plus .1ex},
    spacepost   .tl_set:N = \l__thm_spacepost_tl,
    spacepost   .initial:n = {\ccwd}
  }
\ctex_at_end_preamble:n
  {
    \declaretheoremstyle[
      spaceabove = \l__thm_spaceabove_tl,
      spacebelow = \l__thm_spacebelow_tl,
      headindent = \l__thm_headindent_tl,
      headfont = \l__thm_headfont_tl,
      notefont = \l__thm_notefont_tl,
      notebraces = {}{},
      bodyfont = \l__thm_bodyfont_tl,
      headpunct = \l__thm_headpunct_tl,
      postheadspace = \l__thm_spacepost_tl,
      numberwithin = \l__thm_numberwith_tl,
      headformat = \NAME\space\NUMBER\NOTE
      ]{mythm}
    \declaretheorem[style = mythm,name = \c__name_theorem_tl]{theorem}
    \declaretheorem[style = mythm,name = \c__name_definition_tl]{definition}
    \declaretheorem[style = mythm,name = \c__name_lemma_tl]{lemma}
    \declaretheorem[style = mythm,name = \c__name_corollary_tl]{corollary}
    \declaretheorem[style = mythm,name = \c__name_proposition_tl]{proposition}
    \declaretheorem[style = mythm,name = \c__name_example_tl]{example}
    \cs_gset_eq:NN \proof\relax
    \declaretheorem{remark}[
      style = mythm,
      name = \c__name_remark_tl,
      numbered = no
      ]
    \declaretheorem{proof}[
      style = mythm,
      name = \proofname,
      numbered = no,
      qed = \qedsymbol
      ]
  }

\settasks
  {
    label = (\Alph*),
    after-item-skip = 0ex plus .1ex,
    column-sep = .5\ccwd,
    item-indent = 2\ccwd,
    label-width = 1.5\ccwd
  }
\setchemformula
  {
    math-scripts = false,
    charge-hshift = 0.25\ccwd,
    subscript-vshift = -0.2ex
  }
\sisetup
  {
    detect-family,
    detect-weight,
    detect-shape,
    detect-inline-family = math,
    detect-inline-weight = math,
    detect-display-math,
    unit-math-rm = \mathrm,
    number-math-rm = \mathrm,
    table-parse-only,
    group-digits = false
  }
\allowdisplaybreaks[4]
\cs_gset:Npn \ULthickness{.75pt}
\SetMathEnvironmentSinglespace{\l__math_spread_tl}
\skip_set:Nn \jot{4pt plus 1pt minus 1pt}
\ctex_after_end_preamble:n
  {
    \skip_set:Nn \abovedisplayskip{5pt plus 1pt minus 1pt}
    \skip_set:Nn \belowdisplayskip{5pt plus 1pt minus 1pt}
    \skip_set:Nn \abovedisplayshortskip{0pt}
    \skip_set:Nn \belowdisplayshortskip{5pt plus 1pt minus 1pt}
  }
\cs_gset:Npn \tagform@#1
  {\maketag@@@{\color{ctex@emph}(\ignorespaces#1\unskip\@@italiccorr)}}

\tcbset
  {
    thmsty/.style =
      {
        enhanced~jigsaw,pad~at~break* = 3pt,
        opacityback = 0,
        colframe = ctex@emph,
        left = .2pc,right = .2pc,top = .5pc,bottom = .5pc,middle= .5pc,
        arc = 0pt
      },
    outlinesty/.style =
      {
        enhanced,nofloat,
        tikznode~boxed~title,
        interior~style = white,colframe = ctex@emph,
        colbacktitle = white,coltitle = ctex@emph,
        fonttitle = \large\sffamily,fontupper = \itshape,
        boxed~title~style = {size = normal,opacityframe = 0,boxrule = 0pt},
        attach~boxed~title~to~top~center = {yshift = -\tcboxedtitleheight/2},
        arc = 3pt,
        after~skip = 3ex,
        left = 1.5pc,right = 1.5pc,top = 1pc,bottom = 0.5pc,
        boxsep = 5pt
      },
    exsty/.style =
      {
        enhanced,on~line,
        arc = 5pt,
        fontupper = \sffamily\Large,
        boxrule = 1pt,boxsep = 0pt,
        left = 6pt,right = 6pt,top = 3.5pt,bottom = 3.5pt,
        before~skip = 4ex,after~skip = 2.25ex
      },
    breakable,
    boxrule = .75pt
  }
\ctex_at_end_preamble:n
  {
    \bool_if:NT \l__thmbox_bool
      {
        \tcolorboxenvironment{theorem}{thmsty}
        \tcolorboxenvironment{definition}{thmsty}
        \tcolorboxenvironment{lemma}{thmsty}
        \tcolorboxenvironment{corollary}{thmsty}
        \tcolorboxenvironment{proposition}{thmsty}
        \tcolorboxenvironment{example}{thmsty}
      }
  }
\NewDocumentEnvironment{outline}{O{\abstractname}}
  {
    \begin{tcolorbox}[outlinesty,title = #1]
      \begin{outlinelist}
  }{
      \end{outlinelist}
    \end{tcolorbox}
  }
\NewDocumentEnvironment{exercise}{sO{black}O{1.}O{\c__name_exercise_tl}}
  {
    \IfBooleanF{#1}
      {
        \CTEX@ifnametrue
        \refstepcounter{section}
        \CTEX@addtocline{section}{#4}
        \markright{\CTEXthesection\hspace{0.5\ccwd}#4}
      }
    \begin{center}
      \bool_if:NTF \l__thmbox_bool
        {
          \tcbox[
            exsty,
            colback = #2!8!white,colframe = #2!50!black,
            drop~fuzzy~shadow = #2!50!white,
            ]{\IfBooleanF{#1}{\CTEXthesection\hspace{0.5\ccwd}}#4}
        }{
          \sffamily\Large\IfBooleanF{#1}{\CTEXthesection\hspace{0.5\ccwd}}#4
        }
    \end{center}
    \begin{compactenum}[#3]
  }{
    \end{compactenum}
  }
\DeclareTColorBox{mybox}{so}
  {
    enhanced~jigsaw,pad~at~break* = 3pt,
    IfBooleanF = {#1}{opacityback = 0,colframe = ctex@emph},
    coltitle = black,opacitybacktitle = 0,
    fonttitle = \sffamily,
    left = .2pc,right = .2pc,top = .5pc,bottom = .5pc,middle= .5pc,
    arc = 0pt,
    toptitle = 2pt,bottomtitle = 2pt,
    beforeafter~skip=2ex,
    halign~upper = left,halign~lower = left,
    center~title,
    IfValueT = {#2}{title = #2}
  }
\NewTCBox{\fuzzy}{O{DarkSeaGreen}O{}}
  {nobeforeafter,tcbox~raise~base,blank,fuzzy~halo = 2pt~with~#1,#2}
\DeclareTotalTCBox{\concise}{O{Aqua}O{}v}
  {
    nobeforeafter,tcbox~raise~base,
    top = 2pt,bottom = 2.5pt,left = 2pt,right = 2pt,
    boxsep = 0pt,arc = 1pt,
    colback = #1!15!white,#2
  }{#3}

\bool_set_true:N \l__backend_bibtex_bool
\tl_new:N \l__bib_mysty_tl
\tl_new:N \l__bib_style_tl
\tl_new:N \l__bib_citesty_tl
\tl_new:N \l__bib_file_tl

\__ctex_define:nn {bibset}
  {
    backend             .choice:,
    backend/bibtex      .code:n = {},
    backend/biblatex    .code:n =
      {\bool_set_false:N \l__backend_bibtex_bool},

    bibstyle            .choice:,
    bibstyle            .value_required:n = true,
    bibstyle/number     .code:n =
      {
        \tl_set:Nn  \l__bib_style_tl{#1}
        \tl_clear:N \l__bib_mysty_tl
      },
    bibstyle/authoryear .code:n =
      {
        \tl_set:Nn  \l__bib_style_tl{#1}
        \tl_clear:N \l__bib_mysty_tl
      },
    bibstyle/unknown    .code:n =
      {\tl_set_eq:NN \l__bib_mysty_tl\l_keys_value_tl},
    bibstyle            .initial:n = number,

    citestyle           .code:n =
      {\tl_set:Nn \l__bib_citesty_tl{#1}},
    bibfile             .tl_set:N = \l__bib_file_tl,
    bibfile             .initial:n = ref/refs.bib
  }

\cs_new_protected:Npn \__bibtex_set:
  {
    \tl_if_empty:NTF \l__bib_mysty_tl
      {
        \tl_if_eq:VnT \l__bib_style_tl{number}
          {
            \bibliographystyle{gbt7714-numerical}
            \setcitestyle{square,comma,super}
          }
        \tl_if_eq:VnT \l__bib_style_tl{authoryear}
          {\bibliographystyle{gbt7714-author-year}}
        \cs_set_eq:NN \cite\citep
      }{
        \exp_args:NV \bibliographystyle\l__bib_mysty_tl
      }
    \cs_set:Npn \bibsection{\__title_mark_intoc:n \bibname}
    \skip_set:Nn \bibsep{0ex}
    \NewDocumentCommand\printbibliography{o}
      {\exp_args:NV \bibliography\l__bib_file_tl}
  }
\cs_new_protected:Npn \__put_biblatex:n #1
  {\PassOptionsToPackage{#1}{biblatex}}
\cs_new_protected:Npn \__biblatex_pre_set:
  {
    \tl_if_empty:NTF \l__bib_mysty_tl
      {
        \tl_if_eq:VnT \l__bib_style_tl{number}
          {\__put_biblatex:n {style = gb7714-2015}}
        \tl_if_eq:VnT \l__bib_style_tl{authoryear}
          {\__put_biblatex:n {style = gb7714-2015ay}}
      }{
        \__put_biblatex:n {style = \l__bib_mysty_tl}
      }
    \tl_if_empty:NF \l__bib_citesty_tl
      {\__put_biblatex:n {citestyle = \l__bib_mysty_tl}}
    \__put_biblatex:n {backend = biber}
  }
\cs_new_protected:Npn \__biblatex_after_set:
  {
    \exp_args:NV \addbibresource\l__bib_file_tl
    \defbibheading{bibliography}[\bibname]{\__title_mark_intoc:n {##1}}
    \skip_set:Nn \bibitemsep{0ex}
  }
\ctex_at_end_preamble:n
  {
    \bool_if:NTF \l__backend_bibtex_bool
      {
        \RequirePackage[sort&compress]{natbib}
        \__bibtex_set:
      }{
        \__biblatex_pre_set:
        \RequirePackage{biblatex}
        \__biblatex_after_set:
      }
  }

\ctex_at_end_preamble:n
  {
    \skip_set:Nn \footnotemargin{0.5\ccwd}
    \skip_set:Nn \footnotesep{\l__foot_fnsep_tl}
    \cs_gset:Npn \hangfootparskip{0ex}
    \cs_gset:Npn \footnoterule
      {
        \color{ctex@frame}\hrule width 0.35\columnwidth height 0.75pt
        \vspace*{2.6pt}\color{black}
      }
    \bool_if:NT \l__lang_chinese_bool
      {\cs_gset:Npn \hangfootparindent{2\ccwd}}
    \bool_if:NT \l__chap_withpart_bool
      {\counterwithin*{chapter}{part}}
    \bool_if:NT \l__foot_perpart_bool
      {
        \counterwithout*{footnote}{chapter}
        \counterwithin*{footnote}{part}
      }
    \bool_if:NT \l__foot_perpage_bool
      {
        \counterwithout*{footnote}{chapter}
        \counterwithin*{footnote}{page}
      }
  }
\__patch_cmd:Nnn \@footnotetext
  {\def\baselinestretch{\ZhLS@footlinespread}\reset@font}
  {\def\baselinestretch{\l__foot_spread_tl}\l__foot_font_tl}
\__patch_cmd:Nnn \@mpfootnotetext
  {\def\baselinestretch{\ZhLS@footlinespread}\reset@font}
  {\def\baselinestretch{\l__foot_spread_tl}\l__foot_font_tl}
\__patch_cmd:Nnn \@makefnmark
  {\normalfont}{\l__foot_font_tl}
\cs_gset:Npn \marginfont{\l__margin_font_tl}

\lstdefinestyle{mystyle}
  {
    language = [LaTeX]TeX,
    texcsstyle = *\lst@ifdisplaystyle\bfseries\color{ctex@emph}\else\color{ctex@verb}\fi,
    basicstyle = \ttfamily\lst@ifdisplaystyle\small\else\color{ctex@verb}\fi,
    framexleftmargin = 0pt,
    framexrightmargin = 0pt,
    xleftmargin = 0pt,
    xrightmargin = 0pt,
    framesep = 3pt,
    frame = lines,
    rulecolor = \color{ctex@frame},
    commentstyle = \color{gray},
    emphstyle = \color{ctex@emph},
    emph =
      {
        bibset,bibtex,biber,caption,config,easybook,elfont,linktopage,subcaption,tabularx,thmtools
      },
    keywordstyle = \lst@ifdisplaystyle\bfseries\color{ctex@emph}\else\color{ctex@verb}\fi,
    morekeywords =
      {
        includegraphics,setmainfont,setsansfont,setmonofont,setCJKmainfont,setCJKsansfont,setCJKmonofont,setCJKfamilyfont,RequirePackage
      }
  }
\lstset
  {
    style = mystyle,
    breaklines = true,
    resetmargins = true,
    numbers = left,
    numberstyle = \small,
    abovecaptionskip = -1ex,
    belowcaptionskip = 1ex,
    aboveskip = 1.5ex plus .2ex minus .1ex,
    belowskip = 0.55ex plus .2ex minus .1ex,
    keepspaces = true,
    framerule = 0.75pt,
    columns = flexible
  }
\lstloadlanguages{C,C++,Java,Python,Matlab}
\AtBeginEnvironment{verbatim}{\microtypesetup{activate=false}}

\clist_new:N \l__hyperref_clist
\cs_new_protected:Npn \__put_hyperref:n #1
  {\clist_put_right:Nn \l__hyperref_clist{#1}}
\cs_new_protected:Npn \__define_linkcolor:nnn #1#2#3
  {\definecolorset{HTML}{ctex@}{}{link,#1;url,#2;cite,#3}}
\cs_new_protected:Npn \__define_themecolor:nnn #1#2#3
  {\definecolorset{HTML}{ctex@}{}{frame,#1;emph,#2;verb,#3}}
\cs_new:Npn \__linkcolor_set:n #1
  {
    linkcolor/\clist_item:nn {#1}{1} .code:n =
      {
        \__define_linkcolor:nnn
          {\clist_item:nn {#1}{2}}
          {\clist_item:nn {#1}{3}}
          {\clist_item:nn {#1}{4}}
        \__put_hyperref:n
          {
            linkcolor = ctex@link,linkbordercolor = ctex@link,
            urlcolor = ctex@url,urlbordercolor = ctex@url,
            citecolor = ctex@cite,citebordercolor = ctex@cite
          }
      },
  }
\cs_new:Npn \__themecolor_set:n #1
  {
    color/\clist_item:nn {#1}{1} .code:n =
      {
        \__define_themecolor:nnn
          {\clist_item:nn {#1}{2}}
          {\clist_item:nn {#1}{3}}
          {\clist_item:nn {#1}{4}}
      },
  }

\cs_new:Npn \__allow_urlbreak:
  {
    \cs_new:Npn \__add_urlbreak_points:
      {\tl_map_function:NN \c__urlbreak_points_tl\do}
    \__appto_cmd:Nn
      \UrlBreaks{\UrlOrds\__add_urlbreak_points:}
  }
\tl_const:Nn \c__urlbreak_points_tl
  {ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789}

\keys_define:nx {ctex/link}
  {
    hyperlink         .choice:,
    hyperlink/edge    .code:n = {},
    hyperlink/various .code:n = {\__put_hyperref:n {colorlinks}},
    hyperlink/none    .code:n = {\__put_hyperref:n {hidelinks}},
    hyperlink         .default:n = edge,
    hyperlink         .initial:n = edge,

    linkcolor         .choice:,
    \clist_map_function:nN
      {
        {graphite,  626262,0000B2,005752},
        {cutepink,  ff69b4,9d5196,57b5e5},
        {skyblue,   0000ff,004986,eb6877},
        {crimson,   dc143c,00c1c9,afcd20}
      }
      \__linkcolor_set:n,
    linkcolor         .default:n = graphite,
    linkcolor         .initial:n = graphite,

    linktopage        .choice:,
    linktopage/true   .code:n = {\__put_hyperref:n {linktocpage}},
    linktopage/false  .code:n = {},
    linktopage        .default:n = true,
    linktopage        .initial:n = false
  }
\keys_define:nx {ctex/style}
  {
    color             .choice:,
    color             .value_required:n = true,
    \clist_map_function:nN
      {
        {none,      000000,000000,000000},
        {forest,    005752,004986,a40000},
        {energy,    f39800,00a0e9,893895},
        {cyberpunk, 005982,eb6877,a4005b}
      }
      \__themecolor_set:n,
    color             .initial:n = none
  }

\ctex_at_end_preamble:n
  {
    \RequirePackage[pdfstartview = FitH,bookmarksnumbered]{hyperref}
    \RequirePackage{cleveref}
    \urlstyle{same}
    \exp_args:NV \hypersetup\l__hyperref_clist
    \__allow_urlbreak:

    \bool_if:NTF \l__lang_chinese_bool
      {
        \keys_set_known:nn {ctex}
          {
            contentsname = {目\hspace{\ccwd}录},
            indexname = {索\hspace{\ccwd}引},
            listfigurename = {图片索引},
            listtablename = {表格索引},
            abstractname = {摘\hspace{\ccwd}要},
            lstlistlistingname = {代码索引},
            lstlistingname = {\faCode 代码}
          }
        \crefformat{equation}{#2式（#1）#3}
        \crefformat{align}{#2式（#1）#3}
        \crefformat{multline}{#2式（#1）#3}
        \crefformat{gather}{#2式（#1）#3}
        \crefformat{figure}{#2图#1#3}
        \crefformat{table}{#2表#1#3}
        \crefformat{chapter}{#2第#1章#3}
        \crefformat{section}{#2节#1#3}
        \crefformat{subsection}{#2小节#1#3}
        \crefformat{theorem}{#2定理#1#3}
        \crefformat{definition}{#2定义#1#3}
        \crefformat{lemma}{#2引理#1#3}
        \crefformat{corollary}{#2推论#1#3}
        \crefformat{proposition}{#2性质#1#3}
        \crefformat{example}{#2例#1#3}
      }{
        \keys_set_known:nn {ctex}
          {
            abstractname = {Abstract},
            lstlistlistingname = {List~of~Listings},
            lstlistingname = {\faCode\space Code}
          }
        \crefformat{equation}{#2Equation~(#1)#3}
        \crefformat{align}{#2Equation~(#1)#3}
        \crefformat{multline}{#2Equation~(#1)#3}
        \crefformat{gather}{#2Equation~(#1)#3}
        \crefformat{figure}{#2Figure~#1#3}
        \crefformat{table}{#2Table~#1#3}
        \crefformat{chapter}{#2Chapter~#1#3}
        \crefformat{section}{#2Section~#1#3}
        \crefformat{subsection}{#2Subsection~#1#3}
        \crefformat{theorem}{#2Theorem~#1#3}
        \crefformat{definition}{#2Definition~#1#3}
        \crefformat{lemma}{#2Lemma~#1#3}
        \crefformat{corollary}{#2Corollary~#1#3}
        \crefformat{proposition}{#2Proposition~#1#3}
        \crefformat{example}{#2Example~#1#3}
      }
  }

\ctex_set:n
  {
    secnumdepth = 3,
    tocdepth = 1,
    part =
      {
        pagestyle = empty,
        number =
          {\bool_if:NTF \l__zhtitle_bool{\chinese{part}}{\thepart}},
        format = {\color{ctex@frame}\sffamily\Huge},
        aftername =
          {\bool_if:NTF \l__newline_bool{\par\nobreak}{\hspace{\ccwd}}},
        tocline = {\CTEXifname{\CTEXthepart\hspace{\ccwd}}{}#2}
      },
    chapter =
      {
        % pagestyle = fancy,
        number =
          {\bool_if:NTF \l__zhtitle_bool{\chinese{chapter}}{\thechapter}},
        format =
          {
            \color{ctex@frame}\sffamily\LARGE
            \bool_if:NF \l__newline_bool{\centering}
          },
        aftername =
          {
            \bool_if:NTF \l__newline_bool
              {\par\nobreak\vskip 1.5pc}{\hspace{\ccwd}}
          },
        beforeskip = {-1.5ex},
        afterskip = {3ex},
        lotskip = {0.8pc},
        lofskip = {0.8pc},
        tocline = {\CTEXifname{\CTEXthechapter\hspace{\ccwd}}{}#2}
      },
    section =
      {
        hang = true,
        format = {\color{ctex@frame}\sffamily\Large},
        aftername = {\hspace{0.5\ccwd}},
        beforeskip = {1.5ex plus .2ex minus .1ex},
        afterskip = {1.5ex plus .2ex minus .1ex},
        tocline = {\CTEXifname{\CTEXthesection\hspace{\ccwd}}{}#2}
      },
    subsection =
      {
        hang = true,
        format = {\color{ctex@frame}\sffamily\large},
        aftername = {\hspace{0.5\ccwd}},
        beforeskip = {1.3ex plus .2ex minus .1ex},
        afterskip = {1.3ex plus .2ex minus .1ex},
        tocline = {\CTEXifname{\CTEXthesubsection\hspace{\ccwd}}{}#2}
      },
    subsubsection =
      {
        hang = true,
        format = {\color{ctex@frame}\sffamily},
        aftername = {\hspace{0.5\ccwd}},
        beforeskip = {\parskip},
        afterskip = {\parskip}
      }
  }

\bool_if:NF \l__newline_bool
  {
    \ctex_set:n
      {
        part/hang = true,
        chapter/hang = true
      }
  }
%%
%% End of file `easybook.cls'.