// Label collision warning.

function Controller() {
    // Services.
    const passpet = XPS('@passpet.org/passpet;1', XPI.IPasspet);

    // Dialog elements.
    const dialog = document.documentElement;
    const extra1Button = dialog.getButton('extra1');
    const extra2Button = dialog.getButton('extra2');
    const buttonBox = dom.tags('hbox', 'dialog-button-box')[0];

    // Parameters.
    var petname = window.arguments[0];
    var siteid = window.arguments[1];
    var collidingSiteid = window.arguments[2];
    var result = window.arguments[3];
    print('petname', petname);
    print('siteid', siteid);
    print('collidingSiteid', collidingSiteid);

    // Initialization.
    put('colliding-label', petname);
    put('foo', 'qwoqiwewqe');
    //dom.put($('foo'), 'oijawoiejf');

    var newParts = splitSiteIdentifier(siteid);
    var newKey = newParts[0], newField = newParts[1], newName = newParts[2];
    var oldParts = splitSiteIdentifier(collidingSiteid);
    var oldKey = oldParts[0], oldField = oldParts[1], oldName = oldParts[2];

    put('current-site-field', newField == 'O' ? 'Name' : 'Domain');
    put('current-site-name', newName);
    dom.set($('current-site-deck'), 'selectedIndex', newKey ? 1 : 0);
    if (newKey) {
        print('new CA key', newKey);
        put('current-site-issuer', passpet.getCAName(newKey) || '(unknown)');
    }

    put('previous-site-field', oldField == 'O' ? 'Name' : 'Domain');
    put('previous-site-name', oldName);
    dom.set($('previous-site-deck'), 'selectedIndex', oldKey ? 1 : 0);
    if (oldKey) {
        print('old CA key', oldKey);
        put('previous-site-issuer', passpet.getCAName(oldKey) || '(unknown)');
    }

    if (newKey && oldKey) {
        dom.set($('issuer-comparison-deck'), 'selectedIndex',
                newKey == oldKey ? 0 : 1);
    } else {
        dom.hide($('issuer-arrows'), $('issuer-comparison-row'));
    }

    extra1Button.label = 'I am sure these sites are the same';
    extra2Button.label = "Don't assign this label";
    dom.set(extra2Button, 'default', true);

    window.sizeToContent();
    dom.listen(dialog, 'dialogextra1', accept);
    dom.listen(dialog, 'dialogextra2', cancel);

    function splitSiteIdentifier(siteid) {
        var slash = siteid.indexOf('/');
        var key = siteid.substring(0, slash);
        var rest = siteid.substring(slash + 1);
        var equals = rest.indexOf('=');
        var field = rest.substring(0, equals);
        var name = rest.substring(equals + 1);
        return [key, field, name];
    }

    function put(class, text) {
        var tags = dom.tags('span', class);
        print('class', class, 'tags', tags.length);
        map(tags, function(span) { dom.put(span, text); });
    }

    function accept(event) {
        print('accept');
        result.accepted = true;
        window.close();
    }

    function cancel(event) {
        print('cancel');
        result.accepted = false;
        window.close();
    }
}

window.addEventListener('load', function() { new Controller(); }, false);
