/*
 * Decompiled with CFR 0.152.
 */
package org.mozdev.MacroTracker.toolkit;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.mozdev.MacroTracker.toolkit.MMenuItem;

public class MTextArea
extends JTextArea
implements ActionListener,
MouseListener,
UndoableEditListener {
    private JPopupMenu rclickMenu;
    private MMenuItem mnuUndo = new MMenuItem("Undo", "/images/Undo16.gif");
    private MMenuItem mnuRedo = new MMenuItem("Redo", "/images/Redo16.gif");
    private MMenuItem mnuCut = new MMenuItem("Cut", "/images/Cut16.gif");
    private MMenuItem mnuCopy = new MMenuItem("Copy", "/images/Copy16.gif");
    private MMenuItem mnuPaste = new MMenuItem("Paste", "/images/Paste16.gif");
    private MMenuItem mnuSelectAll = new MMenuItem("Select All");
    private UndoManager undo;

    public MTextArea() {
        this("");
    }

    public MTextArea(String aText) {
        super(aText);
        this.rclickMenu = new JPopupMenu();
        this.rclickMenu.add(this.mnuUndo);
        this.rclickMenu.add(this.mnuRedo);
        this.rclickMenu.addSeparator();
        this.rclickMenu.add(this.mnuCut);
        this.rclickMenu.add(this.mnuCopy);
        this.rclickMenu.add(this.mnuPaste);
        this.rclickMenu.addSeparator();
        this.rclickMenu.add(this.mnuSelectAll);
        this.mnuUndo.addActionListener(this);
        this.mnuRedo.addActionListener(this);
        this.mnuCut.addActionListener(this);
        this.mnuCopy.addActionListener(this);
        this.mnuPaste.addActionListener(this);
        this.mnuSelectAll.addActionListener(this);
        this.addMouseListener(this);
        this.undo = new UndoManager();
        this.getDocument().addUndoableEditListener(this);
    }

    public void undo() {
        System.out.println("Performing Undo.");
        this.undo.undo();
    }

    public void redo() {
        this.undo.redo();
    }

    public boolean canRedo() {
        return this.undo.canRedo();
    }

    public boolean canUndo() {
        return this.undo.canUndo();
    }

    public void clear() {
        super.setText("");
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mnuCut) {
            this.cut();
        } else if (e.getSource() == this.mnuCopy) {
            this.copy();
        } else if (e.getSource() == this.mnuPaste) {
            this.paste();
        } else if (e.getSource() == this.mnuSelectAll) {
            this.selectAll();
        } else if (e.getSource() == this.mnuUndo) {
            if (this.canUndo()) {
                this.undo();
            }
        } else if (e.getSource() == this.mnuRedo && this.canRedo()) {
            this.redo();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public void mouseReleased(MouseEvent e) {
        this.maybeShowPopup(e);
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            try {
                this.rclickMenu.show(e.getComponent(), e.getX(), e.getY());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        this.undo.addEdit(e.getEdit());
        System.out.println("Edits: " + e.getEdit().getUndoPresentationName());
    }
}

