/* about.js
 * Copyright (C) 2006 Surekha Sastry <surekhasastry@gmail.com> 
 * Copyright (C) 2006 Srinivasa Raghavan <raghavan.kandala@gmail.com>
 */

/***** BEGIN LICENSE BLOCK ***** 
  * Indic IME is free software; you can redistribute it and/or modify 
  * it under the terms of the GNU General Public License as published by 
  * the Free Software Foundation; either version 2 of the License, or 
  * (at your option) any later version. 

  * This program is distributed in the hope that it will be useful, 
  * but WITHOUT ANY WARRANTY; without even the implied warranty of 
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
  * GNU General Public License for more details. 

  * You should have received a copy of the GNU General Public License 
  * along with this program; if not, write to the Free Software 
  * Foundation, Inc., 59 Temple Place, Suite 330,  
  * Boston, MA 02111-1307, USA. 
  *
  * ***** END LICENSE BLOCK *****/ 

// Loads the extension home page in a new tab
function visitHomePage()
{
    const preferencesService = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");
    const url                = "http://mail.sarai.net:8080/indic/";

    var parentWindow = null;

    // If there is a parent window
    if(window.opener)
    {
        // If there is a grand parent window
        if(window.opener.opener)
        {
            parentWindow = window.opener.opener;
        }
        else
        {
            parentWindow = window.opener;
        }
    }

    // If a parent window was found
    if(parentWindow)
    {
        // If the open in windows preference is set to true
        if(preferencesService.prefHasUserValue("indicime.open.tabs") && preferencesService.getBoolPref("indicime.open.tabs"))
        {
            const newTab = parentWindow.getBrowser().addTab(url);

            // If the open tabs in background preference is not set or is set to false
            if(!preferencesService.prefHasUserValue("indicime.open.tabs.background") || !preferencesService.getBoolPref("indicime.open.tabs.background"))
            {
                parentWindow.getBrowser().selectedTab = newTab;
            }
        }
        else
        {
            parentWindow.open(url);
        }

        window.close();
    }
}
