include("chrome://jslib/content/io/dir.js");
include("chrome://jslib/content/io/file.js");
include("chrome://jslib/content/utils/date.js");

var dir;
var directoryList;

//This global file is used to parse a file to queue
var file;


function readDirectory(path) {
  dir = new Dir(path);
  directoryList = dir.readDir();


  var tree = document.getElementById('local');
  var treechildrenTemp = tree.getElementsByTagName("treechildren")[0];
  var treeitem;
  var treerow;
  var treecellFilename;
  var treecellFilesize;

  treechildren = treechildrenTemp.cloneNode(false);
  tree.removeChild(treechildrenTemp);
  tree.appendChild(treechildren);

  currentDirectory = document.getElementById('currentDirectory');
  currentDirectory.setAttribute('value', dir.path);


  if(dir.parent != null) {
    var parentDir = dir.parent;
    //parentDir.leaf = "..";
    directoryList.unshift(parentDir);
  }


  for(var x=0; x<directoryList.length; x++) {
    treeitem = document.createElement('treeitem');
    treerow = document.createElement('treerow');
    treecellFilename = document.createElement('treecell');
    treecellSize = document.createElement('treecell');
    treecellDateModified = document.createElement('treecell');
    treecellPermissons = document.createElement('treecell');

    treerow.setAttribute('directoryIndex', x);

    treecellFilename.setAttribute('label', directoryList[x].leaf);
    if(directoryList[x].isDir()) {
//      treecellFilename.setAttribute('properties', 'folder');
    }
    if(directoryList[x].isFile()) {
//      treecellFilename.setAttribute('properties', 'file');
    }
    treecellSize.setAttribute('label', directoryList[x].size);
    treecellDateModified.setAttribute('label', date('d.m.Y H:i', directoryList[x].dateModified));
    treecellPermissons.setAttribute('label', directoryList[x].path);
    //treecellPermissons.setAttribute('label', directoryList[x].permissons);

    treerow.appendChild(treecellFilename);
    treerow.appendChild(treecellSize);
    treerow.appendChild(treecellDateModified);
    treerow.appendChild(treecellPermissons);
    treeitem.appendChild(treerow);
    treechildren.appendChild(treeitem);
  }
}

/*
 * Tests if the mouse is clicked over an object in the list */
function getEventElementIndex(event, tree) {
  var row = new Object();
  tree.treeBoxObject.getCellAt( event.clientX, event.clientY, row, {}, {} );

  if( row.value!=-1 && row.value<tree.view.rowCount ) {
    return tree.getElementsByTagName("treechildren")[0].getElementsByTagName("treeitem")[row.value].getElementsByTagName("treerow")[0].getAttribute("directoryIndex");
  }
  else {
    return false;
  }
}


function rename(directoryIndex) {
  var file = new File(directoryList[directoryIndex].path);
  var newFilename;

  if(newFilename = prompt("Filename:", file.leaf)) {
    //This is used to avoid platform dependent code like \ (windows), / (*nix) and : (macos 9)
    file.move(file.path.slice(0, -file.leaf.length) + newFilename);

    setStatusbar('Renamed succesfully');
    readDirectory(file.parent.path);
  }
  else {
    setStatusbar('Renamed cancelled');
  }
}


function deleteFile(directoryIndex) {
  var file = new File(directoryList[directoryIndex].path);

  if(file.isFile()) {
    if(confirm('Are you sure that you want to delete the file?')) {
      file.remove();

      setStatusbar('Deleted succesfully');
      readDirectory(file.parent.path);
    }
  }
  else if(file.isDir()) {
    var dir = new Dir(directoryList[directoryIndex].path);
    if(confirm('Are you sure that you want to delete the directory?')) {
      dir.remove();

      setStatusbar('Deleted succesfully');
      readDirectory(dir.parent.path);
    }
    
  }
}


function createDirectory(path) {
  var directoryname;
  if(directoryname = prompt("Directory name:")) {
    var dirTemp = new Dir(dir.path);
    //directoryname validation missing!!!
    dirTemp.append(directoryname);
    dirTemp.create();
    if(dirTemp.exists()) {
      setStatusbar('Created successfully');
    }
    else {
      setStatusbar('Created error');
    }
    readDirectory(dir.path);
  }
  else {
    setStatusbar('Created cancelled');
  }
}


function fileMouseDown(event) {
  var tree = document.getElementById('local');
  //var treechildren = tree.getElementsByTagName("treechildren")[0];

  if(event.button == 2) {
    var directoryIndex = getEventElementIndex(event, tree);
    if(directoryIndex) {
      if(directoryList[directoryIndex].isFile()) {
        document.getElementById("upload_option").removeAttribute("disabled");

        file = new Object();
        file.type         = 'upload';
        file.locationFrom = directoryList[directoryIndex].path;
        file.locationTo   = '/tmp';

      }
      else {
        document.getElementById("upload_option").setAttribute("disabled", "true");
        document.getElementById("delete_option").setAttribute("disabled", "true");
      }
      document.getElementById("rename_option").removeAttribute("disabled");
      document.getElementById("rename_option").setAttribute("oncommand", "rename(" + directoryIndex + ");");

      document.getElementById("delete_option").removeAttribute("disabled");
      document.getElementById("delete_option").setAttribute("oncommand", "deleteFile(" + directoryIndex + ");");
    }
    else {
      document.getElementById("upload_option").setAttribute("disabled", "true");
      document.getElementById("rename_option").setAttribute("disabled", "true");
      document.getElementById("delete_option").setAttribute("disabled", "true");
    }
  }
}

function fileDoubleClick(event){
  var tree = document.getElementById('local');
  if(event.button == 0) {
    openDir(getEventElementIndex(event, tree));
  }
}


function openDir(directoryIndex) {
  if(directoryList[directoryIndex].isDir()) {
    readDirectory(directoryList[directoryIndex].path);
  }
  else if(directoryList[directoryIndex].isFile()) {
    setStatusbar('This is a file');
  }
}

function action(event) {
  //setStatusbar('Der blev trykket: ' + event.keyCode);
  switch(event.keyCode) {
    //Uppon Enter or right arrow key the enter the selected directory
    case 13:
    case 39:
      var tree=event.target;
      openDir(tree.currentIndex);
      break;
    //Uppon left arrow return to parent directory
    case 37:
      openDir(0);
      break;
  }
}
