#
#       Tests for kdeui module - Copyright 2001 Jim Bublitz <jbublitz@nwinternet.com>
#

from kdeui import KPasswordDialog, KDialogBase, KEdit, KLineEditDlg, KEditListBox,\
        KColor, KListView
from qt import QLabel, SIGNAL, QListViewItem, QPoint

FALSE = 0
TRUE = not FALSE

class testKPasswordDialog (KDialogBase):
        def __init__ (self, parent):
                KDialogBase.__init__ (self, parent, None, TRUE, "Test KPasswordDialog",
                        KDialogBase.Close | KDialogBase.User1 | KDialogBase.User2,
                        KDialogBase.Close, FALSE, "getPassword", "getNewPassword")

                self.setMinimumSize (500, 500)
                vbox = self.makeVBoxMainWidget ()
                QLabel ("Results:", vbox)
                self.ked = KEdit (vbox)
                self.keepToggle = TRUE

                self.connect (self, SIGNAL ("user1Clicked ()"), self.testGetPassword)
                self.connect (self, SIGNAL ("user2Clicked ()"), self.testGetNewPassword)

        def testGetPassword (self):
                self.ked.clear ()
                self.ked.insertLine ("Testing KPasswordDialog.getPassword...")
                self.ked.insertLine ("")

                prompt = "Enter password"
                self.ked.insertLine ("prompt = Enter password")

                keep = self.keepToggle
                self.keepToggle = not self.keepToggle

                if keep:
                        self.ked.insertLine ("keep = TRUE")
                else:
                        self.ked.insertLine ("keep = FALSE")


                result = KPasswordDialog.getPassword (prompt, keep)

                if str(result [0]) == "":
                        self.ked.insertLine ("password was empty")

                self.ked.insertLine ("")
                self.ked.insertLine ("result tuple:")
                self.ked.insertLine ("  [0] password: " + str(result [0]))
                self.ked.insertLine ("  [1] accepted: " + str(result [1]))
                self.ked.insertLine ("  [2] keep:     " + str(result [2]))
                self.ked.insertLine ("")
                self.ked.insertLine ("::press button again for opposite 'keep' value (input)::")



        def testGetNewPassword (self):
                self.ked.clear ()
                self.ked.insertLine ("Testing KPasswordDialog.getNewPassword ...")
                self.ked.insertLine ("")

                prompt = "Enter password"
                self.ked.insertLine ("prompt = Enter password")

                result = KPasswordDialog.getNewPassword (prompt)

                if str(result [0]) == "":
                        self.ked.insertLine ("password was empty")

                self.ked.insertLine ("")
                self.ked.insertLine ("result tuple:")
                self.ked.insertLine ("  [0] password: " + str(result [0]))
                self.ked.insertLine ("  [1] accepted: " + str(result [1]))



class testKMainWindow (KDialogBase):
        def __init__ (self, parent):
                KDialogBase.__init__ (self, parent, None, TRUE, "Test KMainWindow",
                        KDialogBase.Close | KDialogBase.User1,
                        KDialogBase.Close, FALSE, "Test")

                self.setMinimumSize (500, 500)
                vbox = self.makeVBoxMainWidget ()
                QLabel ("Results:", vbox)
                self.ked = KEdit (vbox)

                self.connect (self, SIGNAL ("user1Clicked ()"), self.testMemberList)

        def testMemberList (self):
                self.ked.clear ()
                self.ked.insertLine ("Testing KMainWindow...")
                self.ked.insertLine ("")

                print self.parent ().memberList
                self.ked.insertLine ("member list: %r" %self.parent ().memberList)


class testKLineEditDlg (KDialogBase):
        def __init__ (self, parent):
                KDialogBase.__init__ (self, parent, None, TRUE, "Test KLineEditDlg",
                        KDialogBase.Close | KDialogBase.User1,
                        KDialogBase.Close, FALSE, "Test")

                self.setMinimumSize (500, 500)
                vbox = self.makeVBoxMainWidget ()
                QLabel ("Results:", vbox)
                self.ked = KEdit (vbox)

                self.connect (self, SIGNAL ("user1Clicked ()"), self.testKLineEditDlg)

        def testKLineEditDlg (self):
                self.ked.clear ()
                self.ked.insertLine ("Testing KLineEditDlg ...")
                self.ked.insertLine ("")

                text = "Line edit dialog test"
                self.ked.insertLine ("text = " + text)
                self.ked.insertLine ("")

                value = "<Edit me>"
                self.ked.insertLine ("value = " + value)

                self.ked.insertLine ("")
                self.ked.insertLine ("testing getText ...")
                self.ked.insertLine ("")

                result = KLineEditDlg.getText (text, value, self)
                print result

                if result [0] != None:
                        self.ked.insertLine ("edited value = " + result [0])
                else:
                        self.ked.insertLine ("edited value = None")

                if result [1]:
                        self.ked.insertLine ("ok = TRUE")
                else:
                        self.ked.insertLine ("ok = FALSE")



class testKEditListBox (KDialogBase):
        def __init__ (self, parent):
                KDialogBase.__init__ (self, parent, None, TRUE, "Test KEditListBox",
                        KDialogBase.Close | KDialogBase.User1,
                        KDialogBase.Close, FALSE, "Test")

                self.setMinimumSize (500, 500)
                self.vbox = self.makeVBoxMainWidget ()
                QLabel ("Results:", self.vbox)
                self.ked = KEdit (self.vbox)
                self.kedlb = None

                self.connect (self, SIGNAL ("user1Clicked ()"), self.testKEditListBox)

        def testKEditListBox (self):
                self.ked.clear ()
                self.ked.insertLine ("Testing KLineEditDlg ...")
                self.ked.insertLine ("")

                if self.kedlb == None:
                        self.kedlb = KEditListBox ("KEditListBox", self.vbox)
                        self.kedlb.show ()
                else:
                        self.kedlb.clear ()

                self.ked.insertLine ('Inserting : ["One", "Four", "Five", "Six"]')
                self.ked.insertLine ("")
                self.kedlb.insertStrList (["One", "Four", "Five", "Six"])
                self.ked.insertLine ('Inserting : ["Two", "Three"], 1')
                self.ked.insertLine ("")
                self.kedlb.insertStrList (["Two", "Three"], 1)


class testKEdit (KDialogBase):
        def __init__ (self, parent):
                KDialogBase.__init__ (self, parent, None, TRUE, "Test KEdit",
                        KDialogBase.Close | KDialogBase.User1,
                        KDialogBase.Close, FALSE, "Test")

                self.setMinimumSize (500, 500)
                self.vbox = self.makeVBoxMainWidget ()
                QLabel ("Results:", self.vbox)
                self.ked = KEdit (self.vbox)

                self.connect (self, SIGNAL ("user1Clicked ()"), self.testKEdit)
                self.ked.clear ()
                self.ked.insertLine ("Testing KLineEditDlg ...")
                self.ked.insertLine ("")

                self.ked.insertLine ("Pressing the 'Test' button will execute")
                self.ked.insertLine ("KEdit:posToRowCol, which should find the")
                self.ked.insertLine ("row/col position before the 'X' in the")
                self.ked.insertLine ("lines below. KEdit::setCursorPosition will")
                self.ked.insertLine ("then move the cursor to that point")
                self.ked.insertLine ("")
                self.ked.insertLine ("========================================")
                self.ked.insertLine ("========================================")
                self.ked.insertLine ("========================================")
                self.ked.insertLine ("===================X====================")
                self.ked.insertLine ("========================================")
                self.ked.insertLine ("========================================")

        def testKEdit (self):
                result = self.ked.posToRowCol (367)
                print result [0], result [1]
                self.ked.setFocus ()
                self.ked.setCursorPosition (result [0], result [1])


class testKColor (KDialogBase):
        def __init__ (self, parent):
                KDialogBase.__init__ (self, parent, None, TRUE, "Test KColor",
                        KDialogBase.Close | KDialogBase.User1,
                        KDialogBase.Close, FALSE, "Test")

                self.setMinimumSize (500, 500)
                self.vbox = self.makeVBoxMainWidget ()
                QLabel ("Results:", self.vbox)
                self.ked = KEdit (self.vbox)

                self.connect (self, SIGNAL ("user1Clicked ()"), self.testKColor)

        def testKColor (self):
                self.ked.clear ()
                self.ked.insertLine ("Testing KColor ...")
                self.ked.insertLine ("")

                color = KColor ()
                self.ked.insertLine ("Setting rgb: 128, 255, 0")
                color.setRgb (128, 255, 0)
                self.ked.insertLine ("")
                self.ked.insertLine ("Getting rgb:")
                result = color.rgb ()
                print result
                self.ked.insertLine ("   " + str (result [0]) + "  " + str (result [1]) + "  " + str (result [2]))

                self.ked.insertLine ("")
                self.ked.insertLine ("")
                self.ked.insertLine ("Setting hsv: 327, 156, 80")
                color.setHsv (327, 156, 80)
                self.ked.insertLine ("")
                self.ked.insertLine ("Getting hsv:")
                result = color.hsv ()
                print result
                self.ked.insertLine ("   " + str (result [0]) + "  " + str (result [1]) + "  " + str (result [2]))



class testKListView (KDialogBase):
        def __init__ (self, parent):
                KDialogBase.__init__ (self, parent, None, TRUE, "Test KListView",
                        KDialogBase.Close | KDialogBase.User1,
                        KDialogBase.Close, FALSE, "Test")

                self.setMinimumSize (500, 500)
                self.vbox = self.makeVBoxMainWidget ()
                QLabel ("Results:", self.vbox)
                self.ked = KEdit (self.vbox)
                self.lv = KListView (self.vbox)
                self.lv.addColumn ("Number")
                self.lv.setSorting (1, FALSE)
                self.lv.setSelectionMode (KListView.Multi)

                list = ["One", "Two", "Three", "Four", "Five", "Six"]

                for item in list:
                        lvItem = QListViewItem (self.lv, item)

                self.lv.setDragEnabled (TRUE)
                self.lv.setAcceptDrops (TRUE)
                self.lv.setItemsMovable (TRUE)

                self.connect (self, SIGNAL ("user1Clicked ()"), self.testKListView)

                self.ked.insertLine ("Testing KListView ...")
                self.ked.insertLine ("")
                self.ked.insertLine ("Select one or more items and press test ...")
                self.ked.insertLine ("")

        def testKListView (self):
                print self.lv.selectedItems ()

                self.ked.insertLine ("Selected items:")

                for item in self.lv.selectedItems ():
                        print item.text (0)
                        self.ked.insertLine ("   " +    str (item.text (0)))

                self.ked.insertLine ("")

                self.ked.insertLine ("Testing KListView.findDrop ...")
                self.ked.insertLine ("")
                self.ked.insertLine ("Result should be in area of second item in list")
                self.ked.insertLine ("")
                pt = QPoint (20, 40)
                result = self.lv.findDrop (pt)
                print result

                if result [0] != None:
                        print result [0].text (0)
                        self.ked.insertLine ("parent = " + str (result [0].text (0)))
                else:
                        self.ked.insertLine ("parent = None")

                if result [1] != None:
                        print result [1].text (0)
                        self.ked.insertLine ("listviewitem = " + str (result [1].text (0)))
                else:
                        self.ked.insertLine ("listviewitem = None")
