/***************************************************************************
                          kfilecoderdoc.h  -  description                              
                             -------------------                                         
    begin                : ven avr 23 18:58:17 CEST 1999
                                           
    copyright            : (C) 1999 by Franois Dupoux                         
    email                : fdupoux@free.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KFILECODERDOC_H
#define KFILECODERDOC_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <qlistview.h>
#include <qstrlist.h>
#include <qstring.h>

#include "kfilecoder.h"
#include "struct.h"
#include "resource.h"

#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>

class KURL;
class QProgressDialog;

// ===========================================================================================================================
class KFileCoderDoc
{
 public:
  KFileCoderDoc(QObject*, const char *filename=0L);
  ~KFileCoderDoc();
	
	bool isArchiveOpened()
	{	return m_bArchiveOpened;
	}

	// Pointers to interface elements
	void setMainWnd (QWidget *mainWnd);
	void setListView (QListView *lv);
	char *getArchivePath();
	DWORD getNbFiles();
	DWORD getAlgoUsed();
	
private: // Datas used for KFileCoder
	QWidget *m_mainWnd;
	QListView *m_List;

	// password
	BYTE m_cPassword[MAX_BYTELEN+1];
	
	char m_szArchivePath[MAXPATHLEN+1];
	FILE *m_fArchive; // File descriptor of the current archive	
	bool m_bArchiveOpened; // Is there an archive which is opened ?
	DWORD m_dwNbFiles; // Number of files in the current archive
	DWORD m_dwAlgorithmUsed;
	DWORD m_dwFlags;
	
	// mixer unsed to encode all others mixer numbers
	BYTE m_cMixerCodingMixer[ENCODING_LEN+1];
	BYTE m_cMixerCodingKey[ENCODING_LEN+1]; // Key made from (pass user + m_cMixerCodingMixer) used to encode Mixed numbers
	
	// password test
	BYTE m_cHashTestPass[ENCODING_LEN+1];
	BYTE m_cPasswordTestMixer[ENCODING_LEN+1];
	
public:
	bool m_bIsWorking;

public: // Functions which works for the files: File menu
	int createArchive(const char *szFilename, const BYTE *cPassword, DWORD dwAlgorithmUsed); // Create a new archive and write header: put m_cPassword, m_szArchivePath, m_fdArchive
	int openArchive(const char *szFilename, const BYTE *cPassword); // Open the archive and read header: put m_cPassword, m_szArchivePAth, m_fdArchive
	int closeArchive(bool bClearList = true, bool bErasePassword = true); // Close the current Archive
	
public: // List View
	int listView_Fill();
	int listView_AddItem(const char *szName, const char *szPath, QWORD qwOriginalFileSize, QWORD qwEncodedFileSize, mode_t nPermissions, uid_t userOwner, gid_t groupOwner, DWORD dwCompress);

private: // Internal Functions
	int writeArchiveHeader(); // When creating new archive
	int readArchiveHeader();	// When opening an archive		
	bool isFileSelected(const char *szFileName, const char *szFilePath);
	int getNbSelectedFiles(); // number of selected files in the list view
	bool doesFileExistsInArchive(const char *szFileName, const char *szFilePath);
	int writeFileString(FILE *fOut, const char *szString, BYTE *cKey);
	int readFileString(FILE *fIn, char *szString, BYTE *cKey);
	int deleteFile(char *szFilename);

public: // Functions which works for the files: Archive menu. ONLY if file is opened
	int addFile(KURL urlFile, DWORD dwCompress);
	int addDirectory(QString strDir, DWORD dwCompress, QWORD qwDirSize, QProgressDialog *progress);
	int extractFiles(const char *szDestPath, bool bOnlySelFiles);
	int deleteSelectedFilesInArchive();
	long int testFiles(QString *strErrorFiles);

	
private:
	int writeFileHeader(FILE *fArchive, char *szFullPath, char *szFileName, char *szFilePath, BYTE *cEncodedFileMixer, QWORD qwCompressedFileSize, QWORD qwEncodedFileSize, DWORD dwCompress, BYTE *cHashControl);
	int readFileHeader(FILE *fArchive, char *szFileName, char *szFilePath, QWORD *qwOriginalFileSize, QWORD *qwCompressedFileSize, QWORD *qwEncodedFileSize, mode_t *nPermissions, uid_t *st_uid, gid_t *st_gid, time_t *st_mtime, BYTE *cEncodedFileMixer, DWORD *dwCompress, BYTE *cHashControl);
	QString getUserNameFromUID(uid_t uid);
	QString getGroupNameFromGID(gid_t gid);
	void eraseMemberData(bool bErasePassword);
};

#endif // KFILECODERDOC_H





























































