#include "detailwidget.h"

#include <qlayout.h>
#include <qlabel.h>
#include <kactivelabel.h>
#include <kiconloader.h>

DetailWidget::DetailWidget( const QString& text1, const QString& text2, const QString& pixmap,
		QWidget *parent, const char *name )
	: QWidget( parent, name )
{
	KActiveLabel *t1 = new KActiveLabel( text1, this, "ActiveLabel1" );

	QVBoxLayout *l0 = new QVBoxLayout( this, 0, 10 );
	QHBoxLayout *l1 = new QHBoxLayout( 0, 0, 10 );
	l0->addLayout( l1 );

	if ( !pixmap.isEmpty() )
	{
		QLabel *icon = new QLabel( this );
		icon->setPixmap( KGlobal::iconLoader()->loadIcon( pixmap, KIcon::Desktop ) );
		icon->setSizePolicy( QSizePolicy( QSizePolicy::Minimum, QSizePolicy::Minimum ) );
		l1->addWidget( icon );
	}

	t1->setSizePolicy( QSizePolicy( QSizePolicy::MinimumExpanding, QSizePolicy::Minimum ) );
	l1->addWidget( t1 );

	if ( !text2.isEmpty() )
	{
		QTextEdit *t2 = new QTextEdit( this );
		t2->setReadOnly( true );
		t2->setSizePolicy( QSizePolicy( QSizePolicy::MinimumExpanding, QSizePolicy::MinimumExpanding ) );
		t2->setMinimumHeight( 100 );
		t2->setText( text2 );
		l0->addWidget( t2 );
	}
}

DetailWidget::~DetailWidget()
{
}
