/* This file is part of KDevelop
   Copyright 2005 Adam Treat <treat@kde.org>
   Copyright 2013 Sebastian Kügler <sebas@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef KDEVPLATFORM_PLUGIN_KDEVDOCUMENTVIEW_H
#define KDEVPLATFORM_PLUGIN_KDEVDOCUMENTVIEW_H

#include <QTreeView>
#include <QUrl>

class QSortFilterProxyModel;
class QAction;
class KDevDocumentViewPlugin;
class KDevDocumentModel;
class KDevDocumentViewDelegate;
class KDevDocumentSelection;
class KDevFileItem;
namespace KDevelop
{
    class IDocument;
    class IProject;
}

class KDevCategoryItem;
class KDevDocumentModel;
class KDevDocumentItem;

class KDevDocumentView: public QTreeView
{
    Q_OBJECT
public:
    explicit KDevDocumentView( KDevDocumentViewPlugin *plugin, QWidget *parent );
    ~KDevDocumentView() override;

    KDevDocumentViewPlugin *plugin() const;

signals:
    void activateURL( const QUrl &url );

public slots:
    void opened( KDevelop::IDocument* document );

private slots:
    void activated( KDevelop::IDocument* document );
    void saved( KDevelop::IDocument* document );
    void closed( KDevelop::IDocument* document );
    void contentChanged( KDevelop::IDocument* document );
    void stateChanged( KDevelop::IDocument* document );
    void documentUrlChanged( KDevelop::IDocument* document );
    void updateCategoryItem( KDevCategoryItem *item );
    void updateProjectPaths();

    void saveSelected();
    void reloadSelected();
    void closeSelected();
    void closeUnselected();

protected:
    void mousePressEvent( QMouseEvent * event ) override;
    void contextMenuEvent( QContextMenuEvent * event ) override;
    void drawBranches(QPainter* painter, const QRect& rect,
                      const QModelIndex& index) const override;

private:
    template<typename F> void visitItems(F, bool selectedItems);
    bool selectedDocHasChanges();
    void updateSelectedDocs();
    void appendActions(QMenu* menu, const QList< QAction* >& actions);

private:
    KDevDocumentViewPlugin *m_plugin;
    KDevDocumentModel *m_documentModel;
    KDevDocumentSelection* m_selectionModel;
    QSortFilterProxyModel* m_proxy;
    KDevDocumentViewDelegate* m_delegate;
    QHash< KDevelop::IDocument*, KDevFileItem* > m_doc2index;
    QList<QUrl> m_selectedDocs; // used for ctx menu
    QList<QUrl> m_unselectedDocs; // used for ctx menu

    friend class KDevDocumentViewPluginFactory; // to connect to the private slots stateChanged and documentUrlChanged
};

#endif // KDEVPLATFORM_PLUGIN_KDEVDOCUMENTVIEW_H

