/***************************************************************************
 *
 *   knetworkmanager-state.cpp - A NetworkManager frontend for KDE 
 *
 *   Copyright (C) 2005, 2006 Novell, Inc.
 *
 *   Author: Timo Hoenig <thoenig@suse.de>, <thoenig@nouse.net> 
 *
 *   This program is free software; you can redistribute it and/or modify 
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful, 
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License 
 *   along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 ***************************************************************************/

#include <kstaticdeleter.h>
#include <kdebug.h>

#include "knetworkmanager-state.h"
#include "knetworkmanager-state_dbus.h"

State* State::_instance = 0L;

State*
State::getInstance ()
{
	if (_instance)
		return _instance;
	return (_instance = new State());
}

NMState
State::getConnectionState ()
{
	return _connectionState;
}

void
State::setOfflineMode (bool state)
{
	if (state)
		StateDBus::switchMode ("sleep");
	else {
		StateDBus::switchMode ("wake");
		/* FIXME: to keep the context menu up to date, we're already setting
		   NM's state to NM_STATE_CONNECTING before it tells us. */
		_connectionState = NM_STATE_CONNECTING;
	}
}

bool
State::isNetworkManagerRunning (void)
{
	return StateDBus::isNetworkManagerRunning ();
}

bool
State::isSleeping (void)
{
	if (_connectionState == NM_STATE_ASLEEP) {
		return true;
	}

	return false;
}

bool
State::isConnecting (void)
{
	if (_connectionState == NM_STATE_CONNECTING) {
		return true;
	}

	return false;
}

bool
State::isConnected (void)
{
	if (_connectionState == NM_STATE_CONNECTED) {
		return true;
	}

	return false;
}

bool
State::isDisconnected (void)
{
	if (_connectionState == NM_STATE_DISCONNECTED) {
		return true;
	}

	return false;
}

bool
State::isWirelessEnabled (void)
{
	return _wirelessEnabled;
}

bool
State::isWaitingForKey (void)
{
	return _waitingForKey;
}

void
State::updateWirelessState (bool state)
{
	_wirelessEnabled = state;
}

void
State::setWirelessState (bool state)
{
	StateDBus::switchWireless (state);
	StateDBus::getWirelessState ();
}

bool
State::isDialupActive (void)
{
	return _dialupActive;
}

void
State::setDialupState (bool state)
{
	_dialupActive = state;
}

void
State::setState (NMState nmstate)
{
	if (_connectionState == nmstate)
		return;

	_connectionState = nmstate;
	emit connectionStateChanged ();
	switch ( _connectionState )
	{
		case NM_STATE_ASLEEP:
			emit sleeping();
			break;
		case NM_STATE_CONNECTING:
			emit connecting();
			break;
		case NM_STATE_CONNECTED:
			emit connected();
			break;
		case NM_STATE_DISCONNECTED:
			emit disconnected();
			break;
		default:
			break;
	}
}

void
State::setWaitingForKey(bool state)
{
	_waitingForKey = state;
}

void
State::push (KNetworkManager* ctx)
{
	_ctx = ctx;
	StateDBus::push (ctx);
	/* get NetworkManager state */
	StateDBus::getState ();
	StateDBus::getWirelessState ();
}

QString
State::toString() const
{
// 	QString out("State: %1 - Wireless: %2" );
	QString stateString;
	switch ( _connectionState )
	{
		case NM_STATE_UNKNOWN:
			stateString = "NM_STATE_UNKNOWN";
			break;
		case NM_STATE_ASLEEP:
			stateString = "NM_STATE_ASLEEP";
			break;
		case NM_STATE_CONNECTING:
			stateString = "NM_STATE_CONNECTING";
			break;
		case NM_STATE_CONNECTED:
			stateString = "NM_STATE_CONNECTED";
			break;
		case NM_STATE_DISCONNECTED:
			stateString = "NM_STATE_DISCONNECTED";
			break;
	}
	return stateString;
}


State::State ()
{
	_connectionState = NM_STATE_UNKNOWN;
	_dialupActive = false;
	_waitingForKey = false;
}

State::~State ()
{

}

#include "knetworkmanager-state.moc" 
