/***************************************************************************
                          kbearsitemanagertreeview.cpp  -  description
                             -------------------
    begin                : Sat Sep 16 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kbearsitemanagertreeview.h"

static const int autoOpenTime = 750;
//-----------------------------------------------
KBearSiteManagerTreeView::KBearSiteManagerTreeView(QWidget *parent, const char *name )
	:	KBearTreeView(parent,name,true), dropItem(0)
{
	setItemsMovable( true );
	setSelectionModeExt( KListView::Single );
	setDragEnabled( true );
	setDropVisualizer( true );
	setAcceptDrops( true );
	viewport()->setAcceptDrops( true );
	connect( &myAutoOpenTimer, SIGNAL( timeout() ),	this, SLOT( slotOpenGroup() ) );
}
//-----------------------------------------------
KBearSiteManagerTreeView::~KBearSiteManagerTreeView(){
}
//-----------------------------------------------
void KBearSiteManagerTreeView::slotOpenGroup() {
	myAutoOpenTimer.stop();
	if( dropItem && ! ((KBearTreeViewItem*)dropItem)->isFile( 0 ) )
		dropItem->setOpen( true );
}
//-----------------------------------------------
void KBearSiteManagerTreeView::contentsDragEnterEvent( QDragEnterEvent *e ) {
	QListViewItem *i = itemAt( contentsToViewport( e->pos() ) );
	if ( i ) {
		dropItem = i;
		myAutoOpenTimer.start( autoOpenTime );
	}
	KListView::contentsDragEnterEvent( e );
}
//-----------------------------------------------
void KBearSiteManagerTreeView::contentsDragMoveEvent( QDragMoveEvent *e ) {
	QListViewItem *i = itemAt( contentsToViewport(  e->pos() ) );
	if ( i ) {
		if ( i != dropItem ) {
			myAutoOpenTimer.stop();
			dropItem = i;
			myAutoOpenTimer.start( autoOpenTime );
		}
	}
	else
		myAutoOpenTimer.stop();
	KListView::contentsDragMoveEvent( e );
}
//-----------------------------------------------
void KBearSiteManagerTreeView::contentsDragLeaveEvent( QDragLeaveEvent* e ) {
	myAutoOpenTimer.stop();
	dropItem = 0;
	KListView::contentsDragLeaveEvent( e );
}
//-----------------------------------------------
void KBearSiteManagerTreeView::contentsDropEvent( QDropEvent* e ) {
	myAutoOpenTimer.stop();
	dropItem = 0;
	KListView::contentsDropEvent( e );
}
//-----------------------------------------------
