/*
   This file is part of the Nepomuk KDE project.
   Copyright (C) 2010  Vishesh Handa <handa.vish@gmail.com>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) version 3, or any
   later version accepted by the membership of KDE e.V. (or its
   successor approved by the membership of KDE e.V.), which shall
   act as a proxy defined in Section 6 of version 3 of the license.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library.  If not, see <http://www.gnu.org/licenses/>.
*/


#ifndef DIFFGENERATOR_H
#define DIFFGENERATOR_H

#include <QtCore/QThread>
#include <QtCore/QMutex>
#include <QtCore/QWaitCondition>
#include <QtCore/QQueue>
#include "changelogrecord.h"

namespace Soprano {
    class Model;
    class Statement;
}

namespace Nepomuk {

    namespace Sync {
        class ChangeLog;
    }

    class DiffGenerator : public QThread
    {
        Q_OBJECT
    public :
        DiffGenerator( QObject* parent = 0 );
        virtual ~DiffGenerator();

        void run();

    public Q_SLOTS:
        void statementAdded( const Soprano::Statement & st );
        void statementRemoved( const Soprano::Statement & st );

        //void removeOldRecords();
    private:
        Soprano::Model *m_model;

        QQueue<ChangeLogRecord> m_recordQueue;

        bool m_stopped;
        QMutex m_queueMutex;
        QWaitCondition m_queueWaiter;

        void stop();

        /**
         * Returns true if the statement should be backed up
         * A statement will be backed up if it can not be regenerated or is a part of the
         * InstanceBase OR if the property is a sub property of nao:identifyingProperty.
         * This is done to help to the identification.
         */
        bool backupStatement( const Soprano::Statement & st );

        /// A cache of the discardable graphs to speed up backupStatement()
        QHash<QUrl, bool> m_discardableGraphs;
    };

}
#endif // DIFFGENERATOR_H
