import os
import os.path
import shutil
import stat
import string
import sys
import time
import cStringIO
import SCons.Action
from SCons.Debug import logInstanceCreation
import SCons.Errors
import SCons.Node
import SCons.Sig.MD5
import SCons.Util
import SCons.Warnings
Save_Strings=None
def save_strings(val):
    global Save_Strings
    Save_Strings=val
def _copy_func(src, dest):
    shutil.copy2(src, dest)
    st=os.stat(src)
    os.chmod(dest, stat.S_IMODE(st[stat.ST_MODE]) | stat.S_IWRITE)
Valid_Duplicates=['hard-soft-copy', 'soft-hard-copy', 'hard-copy', 'soft-copy', 'copy']
Link_Funcs=[]
def set_duplicate(duplicate):
    try:
        _hardlink_func=os.link
    except AttributeError:
        _hardlink_func=None
    try:
        _softlink_func=os.symlink
    except AttributeError:
        _softlink_func=None
    link_dict={
        'hard' : _hardlink_func,
        'soft' : _softlink_func,
        'copy' : _copy_func
    }
    if not duplicate in Valid_Duplicates:
        raise SCons.Errors.InternalError, ("The argument of set_duplicate "
                                           "should be in Valid_Duplicates")
    global Link_Funcs
    Link_Funcs=[]
    for func in string.split(duplicate,'-'):
        if link_dict[func]:
            Link_Funcs.append(link_dict[func])
def LinkFunc(target, source, env):
    src=source[0].abspath
    dest=target[0].abspath
    dir, file=os.path.split(dest)
    if dir and not os.path.isdir(dir):
        os.makedirs(dir)
    if not Link_Funcs:
        set_duplicate('hard-soft-copy')
    for func in Link_Funcs:
        try:
            func(src,dest)
            break
        except OSError:
            if func==Link_Funcs[-1]:
                raise
            else:
                pass
    return 0
Link=SCons.Action.Action(LinkFunc, None)
def LocalString(target, source, env):
    return 'Local copy of %s from %s' % (target[0], source[0])
LocalCopy=SCons.Action.Action(LinkFunc, LocalString)
def UnlinkFunc(target, source, env):
    t=target[0]
    t.fs.unlink(t.abspath)
    return 0
Unlink=SCons.Action.Action(UnlinkFunc, None)
def MkdirFunc(target, source, env):
    t=target[0]
    p=t.abspath
    if not t.fs.exists(p):
        t.fs.mkdir(p)
    return 0
Mkdir=SCons.Action.Action(MkdirFunc, None, presub=None)
MkdirBuilder=None
def get_MkdirBuilder():
    global MkdirBuilder
    if MkdirBuilder is None:
        import SCons.Builder
        MkdirBuilder=SCons.Builder.Builder(action=Mkdir, env=None, explain=None)
    return MkdirBuilder
def CacheRetrieveFunc(target, source, env):
    t=target[0]
    fs=t.fs
    cachedir, cachefile=t.cachepath()
    if fs.exists(cachefile):
        fs.copy2(cachefile, t.path)
        st=fs.stat(cachefile)
        fs.chmod(t.path, stat.S_IMODE(st[stat.ST_MODE]) | stat.S_IWRITE)
        return 0
    return 1
def CacheRetrieveString(target, source, env):
    t=target[0]
    cachedir, cachefile=t.cachepath()
    if t.fs.exists(cachefile):
        return "Retrieved `%s' from cache" % t.path
    return None
CacheRetrieve=SCons.Action.Action(CacheRetrieveFunc, CacheRetrieveString)
CacheRetrieveSilent=SCons.Action.Action(CacheRetrieveFunc, None)
def CachePushFunc(target, source, env):
    t=target[0]
    fs=t.fs
    cachedir, cachefile=t.cachepath()
    if fs.exists(cachefile):
        return
    if not fs.isdir(cachedir):
        fs.makedirs(cachedir)
    tempfile=cachefile+'.tmp'
    try:
        fs.copy2(t.path, tempfile)
        fs.rename(tempfile, cachefile)
        st=fs.stat(t.path)
        fs.chmod(cachefile, stat.S_IMODE(st[stat.ST_MODE]) | stat.S_IWRITE)
    except OSError:
        SCons.Warnings.warn(SCons.Warnings.CacheWriteErrorWarning,
                            "Unable to copy %s to cache. Cache file is %s"
                                % (str(target), cachefile))
        return
CachePush=SCons.Action.Action(CachePushFunc, None)
class _Null:
    pass
_null=_Null()
DefaultSCCSBuilder=None
DefaultRCSBuilder=None
def get_DefaultSCCSBuilder():
    global DefaultSCCSBuilder
    if DefaultSCCSBuilder is None:
        import SCons.Builder
        DefaultSCCSBuilder=SCons.Builder.Builder(action='$SCCSCOM',
                                                   env=None)
    return DefaultSCCSBuilder
def get_DefaultRCSBuilder():
    global DefaultRCSBuilder
    if DefaultRCSBuilder is None:
        import SCons.Builder
        DefaultRCSBuilder=SCons.Builder.Builder(action='$RCS_COCOM',
                                                  env=None)
    return DefaultRCSBuilder
class ParentOfRoot:
    def __init__(self):
        self.abspath=''
        self.path=''
        self.name=''
        self.duplicate=0
        self.srcdir=None
        self.build_dirs=[]
    def is_under(self, dir):
        return 0
    def up(self):
        return None
    def getRepositories(self):
        return []
    def get_dir(self):
        return None
    def src_builder(self):
        return _null
    def entry_abspath(self, name):
        return name
    def entry_path(self, name):
        return name
if os.path.normcase("TeSt")==os.path.normpath("TeSt"):
    def _my_normcase(x):
        return x
else:
    def _my_normcase(x):
        return string.upper(x)
class EntryProxy(SCons.Util.Proxy):
    def __get_abspath(self):
        entry=self.get()
        return SCons.Util.SpecialAttrWrapper(entry.get_abspath(),
                                             entry.name + "_abspath")
    def __get_filebase(self):
        name=self.get().name
        return SCons.Util.SpecialAttrWrapper(SCons.Util.splitext(name)[0],
                                             name + "_filebase")
    def __get_suffix(self):
        name=self.get().name
        return SCons.Util.SpecialAttrWrapper(SCons.Util.splitext(name)[1],
                                             name + "_suffix")
    def __get_file(self):
        name=self.get().name
        return SCons.Util.SpecialAttrWrapper(name, name + "_file")
    def __get_base_path(self):
        entry=self.get()
        return SCons.Util.SpecialAttrWrapper(SCons.Util.splitext(entry.get_path())[0],
                                             entry.name + "_base")
    def __get_posix_path(self):
        if os.sep=='/':
            return self
        else:
            entry=self.get()
            r=string.replace(entry.get_path(), os.sep, '/')
            return SCons.Util.SpecialAttrWrapper(r, entry.name + "_posix")
    def __get_srcnode(self):
        return EntryProxy(self.get().srcnode())
    def __get_srcdir(self):
        return EntryProxy(self.get().srcnode().dir)
    def __get_rsrcnode(self):
        return EntryProxy(self.get().srcnode().rfile())
    def __get_rsrcdir(self):
        return EntryProxy(self.get().srcnode().rfile().dir)
    def __get_dir(self):
        return EntryProxy(self.get().dir)
    dictSpecialAttrs={ "base"     : __get_base_path,
                         "posix"    : __get_posix_path,
                         "srcpath"  : __get_srcnode,
                         "srcdir"   : __get_srcdir,
                         "dir"      : __get_dir,
                         "abspath"  : __get_abspath,
                         "filebase" : __get_filebase,
                         "suffix"   : __get_suffix,
                         "file"     : __get_file,
                         "rsrcpath" : __get_rsrcnode,
                         "rsrcdir"  : __get_rsrcdir,
                       }
    def __getattr__(self, name):
        try:
            return self.dictSpecialAttrs[name](self)
        except KeyError:
            try:
                attr=SCons.Util.Proxy.__getattr__(self, name)
            except AttributeError:
                entry=self.get()
                classname=string.split(str(entry.__class__), '.')[-1]
                raise AttributeError, "%s instance '%s' has no attribute '%s'" % (classname, entry.name, name)
            return attr
class Base(SCons.Node.Node):
    def __init__(self, name, directory, fs):
        if __debug__: logInstanceCreation(self, 'Node.FS.Base')
        SCons.Node.Node.__init__(self)
        self.name=name
        self.fs=fs
        self.relpath={self : '.'}
        assert directory, "A directory must be provided"
        self.abspath=directory.entry_abspath(name)
        if directory.path=='.':
            self.path=name
        else:
            self.path=directory.entry_path(name)
        self.dir=directory
        self.cwd=None
        self.duplicate=directory.duplicate
    def clear(self):
        SCons.Node.Node.clear(self)
        try:
            delattr(self, '_exists')
        except AttributeError:
            pass
        try:
            delattr(self, '_rexists')
        except AttributeError:
            pass
        try:
            delattr(self, '_str_val')
        except AttributeError:
            pass
        self.relpath={self : '.'}
    def get_dir(self):
        return self.dir
    def get_suffix(self):
        return SCons.Util.splitext(self.name)[1]
    def rfile(self):
        return self
    def __str__(self):
        try:
            return self._str_val
        except AttributeError:
            global Save_Strings
            if self.duplicate or self.is_derived():
                str_val=self.get_path()
            else:
                str_val=self.srcnode().get_path()
            if Save_Strings:
                self._str_val=str_val
            return str_val
    rstr=__str__
    def exists(self):
        try:
            return self._exists
        except AttributeError:
            self._exists=self.fs.exists(self.abspath)
            return self._exists
    def rexists(self):
        try:
            return self._rexists
        except AttributeError:
            self._rexists=self.rfile().exists()
            return self._rexists
    def is_under(self, dir):
        if self is dir:
            return 1
        else:
            return self.dir.is_under(dir)
    def set_local(self):
        self._local=1
    def srcnode(self):
        try:
            return self._srcnode
        except AttributeError:
            dir=self.dir
            name=self.name
            while dir:
                if dir.srcdir:
                    self._srcnode=self.fs.Entry(name, dir.srcdir, klass=self.__class__)
                    return self._srcnode
                name=dir.name + os.sep + name
                dir=dir.get_dir()
            self._srcnode=self
            return self._srcnode
    def get_path(self, dir=None):
        if not dir:
            dir=self.fs.getcwd()
        try:
            return self.relpath[dir]
        except KeyError:
            path_elems=[]
            d=self
            while d != dir and not isinstance(d, ParentOfRoot):
                path_elems.append(d.name)
                d=d.dir
            path_elems.reverse()
            ret=string.join(path_elems, os.sep)
            self.relpath[dir]=ret
            return ret
    def set_src_builder(self, builder):
        self.sbuilder=builder
        if not self.has_builder():
            self.builder_set(builder)
    def src_builder(self):
        try:
            scb=self.sbuilder
        except AttributeError:
            scb=self.dir.src_builder()
            self.sbuilder=scb
        return scb
    def get_abspath(self):
        return self.abspath
    def for_signature(self):
        return self.name
    def get_subst_proxy(self):
        try:
            return self._proxy
        except AttributeError:
            ret=EntryProxy(self)
            self._proxy=ret
            return ret
class Entry(Base):
    def rfile(self):
        self.__class__=File
        self._morph()
        self.clear()
        return File.rfile(self)
    def get_found_includes(self, env, scanner, target):
        node=self.rfile()
        return node.get_found_includes(env, scanner, target)
    def scanner_key(self):
        return self.get_suffix()
    def get_contents(self):
        if self.fs.isfile(self.abspath):
            self.__class__=File
            self._morph()
            return File.get_contents(self)
        if self.fs.isdir(self.abspath):
            self.__class__=Dir
            self._morph()
            return Dir.get_contents(self)
        if self.fs.islink(self.abspath):
            return ''
        raise AttributeError
    def exists(self):
        if self.fs.isdir(self.abspath):
            self.__class__=Dir
            self._morph()
            return Dir.exists(self)
        else:
            self.__class__=File
            self._morph()
            self.clear()
            return File.exists(self)
    def calc_signature(self, calc=None):
        if self.fs.isdir(self.abspath):
            self.__class__=Dir
            self._morph()
            return Dir.calc_signature(self, calc)
        else:
            self.__class__=File
            self._morph()
            self.clear()
            return File.calc_signature(self, calc)
    def must_be_a_Dir(self):
        self.__class__=Dir
        self._morph()
_classEntry=Entry
class LocalFS:
    def chmod(self, path, mode):
        return os.chmod(path, mode)
    def copy2(self, src, dst):
        return shutil.copy2(src, dst)
    def exists(self, path):
        return os.path.exists(path)
    def getmtime(self, path):
        return os.path.getmtime(path)
    def isdir(self, path):
        return os.path.isdir(path)
    def isfile(self, path):
        return os.path.isfile(path)
    def link(self, src, dst):
        return os.link(src, dst)
    def listdir(self, path):
        return os.listdir(path)
    def makedirs(self, path):
        return os.makedirs(path)
    def mkdir(self, path):
        return os.mkdir(path)
    def rename(self, old, new):
        return os.rename(old, new)
    def stat(self, path):
        return os.stat(path)
    def symlink(self, src, dst):
        return os.symlink(src, dst)
    def open(self, path):
        return open(path)
    def unlink(self, path):
        return os.unlink(path)
    if hasattr(os, 'symlink'):
        def islink(self, path):
            return os.path.islink(path)
        def exists_or_islink(self, path):
            return os.path.exists(path) or os.path.islink(path)
    else:
        def islink(self, path):
            return 0
        exists_or_islink=exists
class FS(LocalFS):
    def __init__(self, path=None):
        if __debug__: logInstanceCreation(self)
        self.Top=None
        if path==None:
            self.pathTop=os.getcwd()
        else:
            self.pathTop=path
        self.Root={}
        self.SConstruct_dir=None
        self.CachePath=None
        self.cache_force=None
        self.cache_show=None
    def set_toplevel_dir(self, path):
        assert not self.Top, "You can only set the top-level path on an FS object that has not had its File, Dir, or Entry methods called yet."
        self.pathTop=path
    def set_SConstruct_dir(self, dir):
        self.SConstruct_dir=dir
    def __setTopLevelDir(self):
        if not self.Top:
            self.Top=self.__doLookup(Dir, os.path.normpath(self.pathTop))
            self.Top.path='.'
            self._cwd=self.Top
    def getcwd(self):
        self.__setTopLevelDir()
        return self._cwd
    def __checkClass(self, node, klass):
        if isinstance(node, klass) or klass==Entry:
            return node
        if node.__class__==Entry:
            node.__class__=klass
            node._morph()
            return node
        raise TypeError, "Tried to lookup %s '%s' as a %s." % \
              (node.__class__.__name__, node.path, klass.__name__)
    def __doLookup(self, fsclass, name, directory=None, create=1):
        if not name:
            name='.'
        path_comp=string.split(name, os.sep)
        drive, path_first=os.path.splitdrive(path_comp[0])
        if not path_first:
            drive=_my_normcase(drive)
            try:
                directory=self.Root[drive]
            except KeyError:
                if not create:
                    raise SCons.Errors.UserError
                directory=RootDir(drive, ParentOfRoot(), self)
                self.Root[drive]=directory
            path_comp=path_comp[1:]
        else:
            path_comp=[ path_first, ] + path_comp[1:]
        if not path_comp:
            path_comp=['']
            
        for path_name in path_comp[:-1]:
            path_norm=_my_normcase(path_name)
            try:
                d=directory.entries[path_norm]
            except KeyError:
                if not create:
                    raise SCons.Errors.UserError
                path=directory.entry_path(path_name)
                if self.isfile(path):
                    raise TypeError, \
                          "File %s found where directory expected." % path
                dir_temp=Dir(path_name, directory, self)
                directory.entries[path_norm]=dir_temp
                directory.add_wkid(dir_temp)
                directory=dir_temp
            else:
                d.must_be_a_Dir()
                directory=d
        entry_norm=_my_normcase(path_comp[-1])
        try:
            e=directory.entries[entry_norm]
        except KeyError:
            if not create:
                raise SCons.Errors.UserError
            path=directory.entry_path(path_comp[-1])
            if fsclass==File:
                if self.isdir(path):
                    raise TypeError, \
                          "Directory %s found where file expected." % path
            elif fsclass==Dir:
                if self.isfile(path):
                    raise TypeError, \
                          "File %s found where directory expected." % path
            result=fsclass(path_comp[-1], directory, self)
            directory.entries[entry_norm]=result 
            directory.add_wkid(result)
        else:
            result=self.__checkClass(e, fsclass)
        return result 
    def __transformPath(self, name, directory):
        self.__setTopLevelDir()
        if name and name[0]=='#':
            directory=self.Top
            name=name[1:]
            if name and (name[0]==os.sep or name[0]=='/'):
                name=name[1:]
            name=os.path.join('.', os.path.normpath(name))
        elif not directory:
            directory=self._cwd
        return (os.path.normpath(name), directory)
    def chdir(self, dir, change_os_dir=0):
        self.__setTopLevelDir()
        curr=self._cwd
        try:
            if not dir is None:
                self._cwd=dir
                if change_os_dir:
                    os.chdir(dir.abspath)
        except OSError:
            self._cwd=curr
            raise
    def Entry(self, name, directory=None, create=1, klass=None):
        if not klass:
            klass=Entry
        if isinstance(name, Base):
            return self.__checkClass(name, klass)
        else:
            if directory and not isinstance(directory, Dir):
                directory=self.Dir(directory)
            name, directory=self.__transformPath(name, directory)
            return self.__doLookup(klass, name, directory, create)
    def File(self, name, directory=None, create=1):
        return self.Entry(name, directory, create, File)
    def Dir(self, name, directory=None, create=1):
        return self.Entry(name, directory, create, Dir)
    def BuildDir(self, build_dir, src_dir, duplicate=1):
        self.__setTopLevelDir()
        if not isinstance(src_dir, SCons.Node.Node):
            src_dir=self.Dir(src_dir)
        if not isinstance(build_dir, SCons.Node.Node):
            build_dir=self.Dir(build_dir)
        if not src_dir.is_under(self.Top):
            raise SCons.Errors.UserError, "Source directory must be under top of build tree."
        if src_dir.is_under(build_dir):
            raise SCons.Errors.UserError, "Source directory cannot be under build directory."
        if build_dir.srcdir:
            if build_dir.srcdir==src_dir:
                return
            raise SCons.Errors.UserError, "'%s' already has a source directory: '%s'."%(build_dir, build_dir.srcdir)
        build_dir.link(src_dir, duplicate)
    def Repository(self, *dirs):
        for d in dirs:
            if not isinstance(d, SCons.Node.Node):
                d=self.Dir(d)
            self.__setTopLevelDir()
            self.Top.addRepository(d)
    def Rsearch(self, path, clazz=_classEntry, cwd=None):
        if isinstance(path, SCons.Node.Node):
            return path
        else:
            name, d=self.__transformPath(path, cwd)
            n=self.__doLookup(clazz, name, d)
            if n.exists():
                return n
            if isinstance(n, Dir):
                reps=filter(lambda x: x.exists(), n.getRepositories())
                if len(reps):
                    return reps[0]
            d=n.get_dir()
            name=n.name
            while d:
                for rep in d.getRepositories():
                    try:
                        rnode=self.__doLookup(clazz, name, rep)
                        if rnode.exists() and \
                           (isinstance(rnode, Dir) or not rnode.is_derived()):
                            return rnode
                    except TypeError:
                        pass
                name=d.name + os.sep + name
                d=d.get_dir()
        return None
    def Rsearchall(self, pathlist, must_exist=1, clazz=_classEntry, cwd=None):
        ret=[]
        if SCons.Util.is_String(pathlist):
            pathlist=string.split(pathlist, os.pathsep)
        if not SCons.Util.is_List(pathlist):
            pathlist=[pathlist]
        for path in filter(None, pathlist):
            if isinstance(path, SCons.Node.Node):
                ret.append(path)
            else:
                name, d=self.__transformPath(path, cwd)
                n=self.__doLookup(clazz, name, d)
                if not must_exist or n.exists():
                    ret.append(n)
                if isinstance(n, Dir):
                    ret.extend(filter(lambda x, me=must_exist, clazz=clazz: isinstance(x, clazz) and (not me or x.exists()), n.getRepositories()))
                    
                d=n.get_dir()
                name=n.name
                while d:
                    for rep in d.getRepositories():
                        try:
                            rnode=self.__doLookup(clazz, name, rep)
                            if (not must_exist or rnode.exists()) and \
                               (not rnode.is_derived() or isinstance(rnode, Dir)):
                                ret.append(rnode)
                        except TypeError:
                            pass
                    name=d.name + os.sep + name
                    d=d.get_dir()
        return ret
    def CacheDir(self, path):
        self.CachePath=path
    def build_dir_target_climb(self, dir, tail):
        targets=[]
        message=None
        while dir:
            for bd in dir.build_dirs:
                p=apply(os.path.join, [bd.path] + tail)
                targets.append(self.Entry(p))
            tail=[dir.name] + tail
            dir=dir.up()
        if targets:
            message="building associated BuildDir targets: %s" % string.join(map(str, targets))
        return targets, message
class DummyExecutor:
    def cleanup(self):
        pass
    def get_raw_contents(self):
        return ''
    def get_contents(self):
        return ''
    def get_timestamp(self):
        return 0
    def get_build_env(self):
        return None
class Dir(Base):
    def __init__(self, name, directory, fs):
        if __debug__: logInstanceCreation(self, 'Node.FS.Dir')
        Base.__init__(self, name, directory, fs)
        self._morph()
    def _morph(self):
        self.repositories=[]
        self.srcdir=None
        self.entries={}
        self.entries['.']=self
        self.entries['..']=self.dir
        self.cwd=self
        self.builder=get_MkdirBuilder()
        self.searched=0
        self._sconsign=None
        self.build_dirs=[]
    def __clearRepositoryCache(self, duplicate=None):
        for node in self.entries.values():
            if node != self.dir:
                if node != self and isinstance(node, Dir):
                    node.__clearRepositoryCache(duplicate)
                else:
                    try:
                        del node._srcreps
                    except AttributeError:
                        pass
                    try:
                        del node._rfile
                    except AttributeError:
                        pass
                    try:
                        del node._rexists
                    except AttributeError:
                        pass
                    try:
                        del node._exists
                    except AttributeError:
                        pass
                    try:
                        del node._srcnode
                    except AttributeError:
                        pass
                    try:
                        del node._str_val
                    except AttributeError:
                        pass
                    if duplicate != None:
                        node.duplicate=duplicate
    def __resetDuplicate(self, node):
        if node != self:
            node.duplicate=node.get_dir().duplicate
    def Entry(self, name):
        return self.fs.Entry(name, self)
    def Dir(self, name):
        return self.fs.Dir(name, self)
    def File(self, name):
        return self.fs.File(name, self)
    def link(self, srcdir, duplicate):
        self.srcdir=srcdir
        self.duplicate=duplicate
        self.__clearRepositoryCache(duplicate)
        srcdir.build_dirs.append(self)
    def getRepositories(self):
        if self.srcdir and not self.duplicate:
            try:
                return self._srcreps
            except AttributeError:
                self._srcreps=self.fs.Rsearchall(self.srcdir.path, clazz=Dir, must_exist=0, cwd=self.fs.Top) + self.repositories
                return self._srcreps
        return self.repositories
    def addRepository(self, dir):
        if not dir in self.repositories and dir != self:
            self.repositories.append(dir)
            self.__clearRepositoryCache()
    def up(self):
        return self.entries['..']
    def root(self):
        if not self.entries['..']:
            return self
        else:
            return self.entries['..'].root()
    def scan(self):
        if not self.implicit is None:
            return
        self.implicit=[]
        self.implicit_dict={}
        self._children_reset()
        try:
            for filename in self.fs.listdir(self.abspath):
                if filename != '.sconsign':
                    self.Entry(filename)
        except OSError:
            pass
        keys=filter(lambda k: k != '.' and k != '..', self.entries.keys())
        kids=map(lambda x, s=self: s.entries[x], keys)
        def c(one, two):
            return cmp(one.abspath, two.abspath)
        kids.sort(c)
        self._add_child(self.implicit, self.implicit_dict, kids)
    def get_actions(self):
        return []
    def build(self, **kw):
        global MkdirBuilder
        if not self.builder is MkdirBuilder:
            apply(SCons.Node.Node.build, [self,], kw)
    def multiple_side_effect_has_builder(self):
        global MkdirBuilder
        return not self.builder is MkdirBuilder and self.has_builder()
    def alter_targets(self):
        return self.fs.build_dir_target_climb(self, [])
    def scanner_key(self):
        return None
    def get_contents(self):
        contents=cStringIO.StringIO()
        for kid in self.children():
            contents.write(kid.get_contents())
        return contents.getvalue()
    
    def prepare(self):
        pass
    def current(self, calc=None):
        if not self.builder is MkdirBuilder and not self.exists():
            return 0
        state=0
        for kid in self.children():
            s=kid.get_state()
            if s and (not state or s > state):
                state=s
        import SCons.Node
        if state==0 or state==SCons.Node.up_to_date:
            return 1
        else:
            return 0
    def rdir(self):
        try:
            return self._rdir
        except AttributeError:
            self._rdir=self
            if not self.exists():
                n=self.fs.Rsearch(self.path, clazz=Dir, cwd=self.fs.Top)
                if n:
                    self._rdir=n
            return self._rdir
    def sconsign(self):
        if not self._sconsign:
            import SCons.SConsign
            self._sconsign=SCons.SConsign.ForDirectory(self)
        return self._sconsign
    def srcnode(self):
        if self.srcdir:
            return self.srcdir
        return Base.srcnode(self)
    def get_timestamp(self):
        stamp=0
        for kid in self.children():
            if kid.get_timestamp() > stamp:
                stamp=kid.get_timestamp()
        return stamp
    def entry_abspath(self, name):
        return self.abspath + os.sep + name
    def entry_path(self, name):
        return self.path + os.sep + name
    def must_be_a_Dir(self):
        pass
class RootDir(Dir):
    def __init__(self, name, directory, fs):
        if __debug__: logInstanceCreation(self, 'Node.FS.RootDir')
        Base.__init__(self, name, directory, fs)
        self.path=self.path + os.sep
        self.abspath=self.abspath + os.sep
        self._morph()
    def entry_abspath(self, name):
        return self.abspath + name
    def entry_path(self, name):
        return self.path + name
class BuildInfo:
    bsig=None
    def __cmp__(self, other):
        try:
            return cmp(self.bsig, other.bsig)
        except AttributeError:
            return 1
class File(Base):
    def __init__(self, name, directory, fs):
        if __debug__: logInstanceCreation(self, 'Node.FS.File')
        Base.__init__(self, name, directory, fs)
        self._morph()
    def Entry(self, name):
        return self.fs.Entry(name, self.cwd)
    def Dir(self, name):
        return self.fs.Dir(name, self.cwd)
    def File(self, name):
        return self.fs.File(name, self.cwd)
    def RDirs(self, pathlist):
        return self.fs.Rsearchall(pathlist, clazz=Dir, must_exist=0, cwd=self.cwd)
    def generate_build_dict(self):
        return {'Dir' : self.Dir,
                'File' : self.File,
                'RDirs' : self.RDirs}
    def _morph(self):
        self.scanner_paths={}
        self.found_includes={}
        if not hasattr(self, '_local'):
            self._local=0
    def root(self):
        return self.dir.root()
    def scanner_key(self):
        return self.get_suffix()
    def get_contents(self):
        if not self.rexists():
            return ''
        return open(self.rfile().abspath, "rb").read()
    def get_timestamp(self):
        if self.rexists():
            return self.fs.getmtime(self.rfile().abspath)
        else:
            return 0
    def store_info(self, obj):
        entry=self.get_stored_info()
        for key, val in obj.__dict__.items():
            entry.__dict__[key]=val
        self.dir.sconsign().set_entry(self.name, entry)
    def get_stored_info(self):
        try:
            stored=self.dir.sconsign().get_entry(self.name)
            if isinstance(stored, BuildInfo):
                return stored
            binfo=BuildInfo()
            for key, val in stored.__dict__.items():
                setattr(binfo, key, val)
            return binfo
        except:
            return BuildInfo()
    def get_stored_implicit(self):
        binfo=self.get_stored_info()
        try:
            return binfo.bimplicit
        except AttributeError:
            return None
    def get_found_includes(self, env, scanner, target):
        if not scanner:
            return []
        try:
            path=target.scanner_paths[scanner]
        except AttributeError:
            try:
                path=self.scanner_paths[scanner]
            except KeyError:
                path=scanner.path(env, self.cwd)
                self.scanner_paths[scanner]=path
        except KeyError:
            path=scanner.path(env, target.cwd)
            target.scanner_paths[scanner]=path
        try:
            includes=self.found_includes[path]
        except KeyError:
            includes=scanner(self, env, path)
            self.found_includes[path]=includes
        return includes
    def _createDir(self):
        listDirs=[]
        parent=self.dir
        while parent:
            if parent.exists():
                break
            listDirs.append(parent)
            p=parent.up()
            if isinstance(p, ParentOfRoot):
                raise SCons.Errors.StopError, parent.path
            parent=p
        listDirs.reverse()
        for dirnode in listDirs:
            try:
                SCons.Node.Node.build(dirnode)
                try:
                    delattr(dirnode, '_exists')
                except AttributeError:
                    pass
                try:
                    delattr(dirnode, '_rexists')
                except AttributeError:
                    pass
            except OSError:
                pass
    def retrieve_from_cache(self):
        b=self.is_derived()
        if not b and not self.has_src_builder():
            return None
        if b and self.fs.CachePath:
            if self.fs.cache_show:
                if CacheRetrieveSilent(self, [], None)==0:
                    self.build(presub=0, execute=0)
                    return 1
            elif CacheRetrieve(self, [], None)==0:
                return 1
        return None
    def built(self):
        if self.fs.CachePath and self.fs.exists(self.path):
            CachePush(self, [], None)
        SCons.Node.Node.built(self)
        self.found_includes={}
        try:
            delattr(self, '_exists')
        except AttributeError:
            pass
        try:
            delattr(self, '_rexists')
        except AttributeError:
            pass
    def visited(self):
        if self.fs.CachePath and self.fs.cache_force and self.fs.exists(self.path):
            CachePush(self, None, None)
    def has_src_builder(self):
        try:
            scb=self.sbuilder
        except AttributeError:
            if self.rexists():
                scb=None
            else:
                scb=self.dir.src_builder()
                if scb is _null:
                    scb=None
                    dir=self.dir.path
                    sccspath=os.path.join('SCCS', 's.' + self.name)
                    if dir != '.':
                        sccspath=os.path.join(dir, sccspath)
                    if self.fs.exists(sccspath):
                        scb=get_DefaultSCCSBuilder()
                    else:
                        rcspath=os.path.join('RCS', self.name + ',v')
                        if dir != '.':
                            rcspath=os.path.join(dir, rcspath)
                        if os.path.exists(rcspath):
                            scb=get_DefaultRCSBuilder()
                self.builder=scb
            self.sbuilder=scb
        return not scb is None
    def alter_targets(self):
        if self.is_derived():
            return [], None
        return self.fs.build_dir_target_climb(self.dir, [self.name])
    def is_pseudo_derived(self):
        return self.has_src_builder()
    def prepare(self):
        SCons.Node.Node.prepare(self)
        if self.get_state() != SCons.Node.up_to_date:
            if self.exists():
                if self.is_derived() and not self.precious:
                    try:
                        Unlink(self, [], None)
                    except OSError, e:
                        raise SCons.Errors.BuildError(node=self, errstr=e.strerror)
                    try:
                        delattr(self, '_exists')
                    except AttributeError:
                        pass
            else:
                try:
                    self._createDir()
                except SCons.Errors.StopError, drive:
                    desc="No drive `%s' for target `%s'." % (drive, self)
                    raise SCons.Errors.StopError, desc
    def remove(self):
        if self.fs.exists_or_islink(self.path):
            self.fs.unlink(self.path)
            return 1
        return None
    def exists(self):
        if self.duplicate and not self.is_derived() and not self.linked:
            src=self.srcnode().rfile()
            if src.exists() and src.abspath != self.abspath:
                self._createDir()
                try:
                    Unlink(self, None, None)
                except OSError:
                    pass
                try:
                    Link(self, src, None)
                except IOError, e:
                    desc="Cannot duplicate `%s' in `%s': %s." % (src, self.dir, e.strerror)
                    raise SCons.Errors.StopError, desc
                self.linked=1
                try:
                    delattr(self, '_exists')
                except AttributeError:
                    pass
                try:
                    delattr(self, '_rexists')
                except AttributeError:
                    pass
        return Base.exists(self)
    def new_binfo(self):
        return BuildInfo()
    def del_cinfo(self):
        try:
            del self.binfo.csig
        except AttributeError:
            pass
        try:
            del self.binfo.timestamp
        except AttributeError:
            pass
    def calc_csig(self, calc=None):
        if calc is None:
            calc=self.calculator()
        try:
            return self.binfo.csig
        except AttributeError:
            pass
        if calc.max_drift >= 0:
            old=self.get_stored_info()
        else:
            old=BuildInfo()
        try:
            mtime=self.get_timestamp()
        except:
            mtime=0
            raise SCons.Errors.UserError, "no such %s" % self
        try:
            if (old.timestamp and old.csig and old.timestamp==mtime):
                csig=old.csig
            else:
                csig=calc.module.signature(self)
        except AttributeError:
            csig=calc.module.signature(self)
        if calc.max_drift >= 0 and (time.time() - mtime) > calc.max_drift:
            try:
                binfo=self.binfo
            except AttributeError:
                binfo=self.binfo=self.new_binfo()
            binfo.csig=csig
            binfo.timestamp=mtime
            self.store_info(binfo)
        return csig
    def current(self, calc=None, scan=1):
        self.binfo=self.gen_binfo(calc)
        if self.always_build:
            return None
        if not self.exists():
            r=self.rfile()
            if r != self:
                old=r.get_stored_info()
                if old==self.binfo:
                    if self._local:
                        LocalCopy(self, r, None)
                        self.store_info(self.binfo)
                    return 1
            self._rfile=self
            return None
        else:
            old=self.get_stored_info()
            return (old==self.binfo)
    def rfile(self):
        try:
            return self._rfile
        except AttributeError:
            self._rfile=self
            if not self.exists():
                n=self.fs.Rsearch(self.path, clazz=File,
                                    cwd=self.fs.Top)
                if n:
                    self._rfile=n
            return self._rfile
    def rstr(self):
        return str(self.rfile())
    def cachepath(self):
        if not self.fs.CachePath:
            return None, None
        if self.binfo.bsig is None:
            raise SCons.Errors.InternalError, "cachepath(%s) found a bsig of None" % self.path
        cache_sig=SCons.Sig.MD5.collect([self.binfo.bsig, self.path])
        subdir=string.upper(cache_sig[0])
        dir=os.path.join(self.fs.CachePath, subdir)
        return dir, os.path.join(dir, cache_sig)
    def target_from_source(self, prefix, suffix, splitext=SCons.Util.splitext):
        return self.dir.File(prefix + splitext(self.name)[0] + suffix)
    def must_be_a_Dir(self):
        raise TypeError, "Tried to lookup File '%s' as a Dir." % self.path
default_fs=FS()
def find_file(filename, paths, node_factory=default_fs.File):
    retval=None
    for dir in paths:
        try:
            node=node_factory(filename, dir)
            if node.is_derived() or \
               node.is_pseudo_derived() or \
               (isinstance(node, SCons.Node.FS.Base) and node.exists()):
                retval=node
                break
        except TypeError:
            pass
    return retval
def find_files(filenames, paths, node_factory=default_fs.File):
    nodes=map(lambda x, paths=paths, node_factory=node_factory: find_file(x, paths, node_factory), filenames)
    return filter(lambda x: x != None, nodes)
