/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */

#ifndef POCOMPENDIUM_H
#define POCOMPENDIUM_H

#include "compendiumdata.h"
#include "searchengine.h"
#include <catalog.h>

#include <qdict.h>
#include <qfile.h>
#include <qguardedptr.h>

class PreferencesWidget;
class KConfigBase;
class QTimer;

class PoCompendium : public SearchEngine
{
	Q_OBJECT

public:
	PoCompendium(QObject *parent=0, const char *name=0);
	virtual ~PoCompendium();

	virtual bool isReady() const;
    
    virtual QString translate(const QString);
    virtual QString fuzzyTranslation(const QString, int &score);

	virtual bool isSearching() const;

	virtual void saveSettings(KConfigBase *config);
	virtual void readSettings(KConfigBase *config);

	virtual PrefWidget *preferencesWidget(QWidget *parent);

	virtual const KAboutData *about() const;

	virtual QString name() const;
	
	virtual QString id() const;

	virtual QString lastError();


public slots:
	virtual bool startSearch(QString);
	virtual void stopSearch();
    virtual void setLanguageCode(QString lang);

protected slots:
	/** reads the current settings from the preferences dialog */
	void applySettings();
    
	/** sets the current settings in the preferences dialog */
	void restoreSettings();

    void slotLoadCompendium();

    void recheckData();
    void removeData();

protected:
	void loadCompendium();
    void addResult(SearchResult *);
    QString maskString(QString string);

    void registerData();
    void unregisterData();

private:
	QGuardedPtr<PreferencesWidget> prefWidget;
    CompendiumData *data;
	PoInfo catalogInfo;
    QTimer *loadTimer;

	QString url;
    QString realURL;
    QString langCode;
	
	bool caseSensitive;
	bool ignoreFuzzy;
    bool wholeWords;

	bool matchEqual;
	bool matchIsContained;
	bool matchContains;
    bool matchWords;
    bool matchNGram;
    
    bool buildIndex;
    uint freeMemDelay;

	bool error;
	QString errorMsg;

	bool stop;
	bool active;
	bool initialized;
    bool loading;

    KConfigBase *conf;
    QString confGroup;

    static QDict<CompendiumData> *_compDict;
    static QDict<CompendiumData> *compendiumDict();
};

#endif
