/***************************************************************************
                            KPushButton.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This is nothing but a QPushButton with drag-support. You have to call
 {@link #setDragEnabled} and override the virtual method 
 {@link #dragObject} to specify the QDragObject to be used.

 See {@link KPushButtonSignals} for signals emitted by KPushButton.

 See {@link KPushButtonEventHandling} for event handlers to override in subclasses of KPushButton.

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A QPushButton with drag-support.
*/
public class KPushButton extends QPushButton  {
	protected KPushButton(Class dummy){super((Class) null);}


/** 
 Default constructor.
     
*/
	private native void newKPushButton( QWidget parent, String name);
	public KPushButton( QWidget parent, String name) {
		super((Class) null);
		newKPushButton( parent, name);
	}
	private native void newKPushButton( QWidget parent);
	public KPushButton( QWidget parent) {
		super((Class) null);
		newKPushButton( parent);
	}

/** 
 Constructor, that sets the button-text to <code>text</code>
     
*/
	private native void newKPushButton( String text, QWidget parent, String name);
	public KPushButton( String text, QWidget parent, String name) {
		super((Class) null);
		newKPushButton( text, parent, name);
	}
	private native void newKPushButton( String text, QWidget parent);
	public KPushButton( String text, QWidget parent) {
		super((Class) null);
		newKPushButton( text, parent);
	}

/** 
 Constructor, that sets an icon and the button-text to <code>text</code>
     
*/
	private native void newKPushButton( QIconSet icon, String text, QWidget parent, String name);
	public KPushButton( QIconSet icon, String text, QWidget parent, String name) {
		super((Class) null);
		newKPushButton( icon, text, parent, name);
	}
	private native void newKPushButton( QIconSet icon, String text, QWidget parent);
	public KPushButton( QIconSet icon, String text, QWidget parent) {
		super((Class) null);
		newKPushButton( icon, text, parent);
	}

/** 
 Destroys the button
     
*/
	protected native void finalize() throws InternalError;

/** 
 Enables/disables drag-support. Default is enabled.
     
*/
	public native void setDragEnabled( boolean enable);

/** 

*/
	public native boolean isDragEnabled();

/** 
 Reimplement this and return the QDragObject that should be used
 for the drag.
 Default implementation returns null, so that no drag is initiated.
     
*/
	protected native QDragObject dragObject();

/** 
 Starts a drag (dragCopy() by default) using {@link #dragObject}
     
*/
	protected native void startDrag();
}
