/***************************************************************************
                            KJanusWidget.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Provides a number of ready to use layouts (faces). It is used
 as an internal widget in {@link KDialogBase}, but can also used as a
 widget of its own.

 It provides TreeList, IconList, Tabbed, Plain and Swallow layouts.

 The TreeList face provides a list in the left area and pages in the
 right. The area are separated by a movable splitter. The style is somewhat
 similar to the layout in the Control Center. A page is raised by
 selecting the corresponding tree list item.

 The IconList face provides an icon list in the left area and pages in the
 right. For each entry the Icon is on top with the text below. The style
 is somewhat similar to the layout of the Eudora configuation dialog box.
 A page is raised by selecting the corresponding icon list item. The
 preferred icon size is 32x32 pixels.

 The Tabbed face is a common tabbed widget. The procedure for creating a
 page is similar for creating a TreeList. This has the advantage that if
 your widget contain too many pages it is trivial to convert it into a
 TreeList. Just change the face in the {@link KJanusWidget} constructor to
 KJanusWidget.TreeList and you have a tree list layout instead.

 The Plain face provides an empty widget (QFrame) where you can place your
 widgets. The KJanusWidget makes no assumptions regarding the contents so
 you are free to add whatever you want.

 The Swallow face is provided in order to simplify the usage of existing
 widgets and to allow changing the visible widget. You specify the widget
 to be displayed by {@link #setSwallowedWidget}. Your widget will be
 reparented inside the widget. You can specify a Null (0) widget. A empty
 space is then displayed.

 For all modes it is important that you specify the {@link QWidget#minimumSize}
 on the page, plain widget or the swallowed widget. If you use a QLayout
 on the page, plain widget or the swallowed widget this will be taken care
 of automatically. The size is used when the KJanusWidget determines its
 own minimum size. You get the minimum size by using the
 {@link #minimumSizeHint} or {@link #sizeHint} methods.

 See {@link KJanusWidgetSignals} for signals emitted by KJanusWidget.

 See {@link KJanusWidgetEventHandling} for event handlers to override in subclasses of KJanusWidget.

 @author Espen Sand (espen@kde.org)
 
 @short Easy to use widget with many layouts.
*/
public class KJanusWidget extends QWidget  {
	protected KJanusWidget(Class dummy){super((Class) null);}


/** 
 Constructor where you specify the face.

*/
	private native void newKJanusWidget( QWidget parent, String name, int face);
	public KJanusWidget( QWidget parent, String name, int face) {
		super((Class) null);
		newKJanusWidget( parent, name, face);
	}
	private native void newKJanusWidget();
	public KJanusWidget() {
		super((Class) null);
		newKJanusWidget();
	}

/** 
 Destructor.
     
*/
	protected native void finalize() throws InternalError;

/** 
 Raises the page which was added by {@link #addPage}.

*/
	public native boolean showPage( int index);

/** 
 Retrieve the index of the page that are currently displayed.

*/
	public native int activePageIndex();

/** 
 Use this to verify
 that no memory allocation failed.

*/
	public native boolean isValid();

/** 
 Retrieve the face type.

*/
	public native int face();

/** 
 Retrieve the minimum size that must be made available for the widget
 so that UIs can be displayed properly

*/
	public native QSize minimumSizeHint();

/** 
 Returns the recommended size for the widget in order to be displayed
 properly.

*/
	public native QSize sizeHint();

/** 
 Retrieve the empty widget that is available in Plain mode.

*/
	public native QFrame plainPage();

/** 
 Add a new page when the class is used in TreeList, IconList or Tabbed
 mode. The returned widget is empty and you must add your widgets
 as children to this widget. In most cases you must create a layout
 manager and associate it with this widget as well.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
	public native QFrame addPage( String item, String header, QPixmap pixmap);
	public native QFrame addPage( String item);

/** 
 This is like addPage just above, with the difference that the first
 element is a list of strings. These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the TreeList face. Later this may
 be added for the IconList face too. In other faces than the
 TreeList, all the strings except the last one is ignored.
 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
	public native QFrame addPage( String[] items, String header, QPixmap pixmap);
	public native QFrame addPage( String[] items);

/** 
 Add a new page when the class is used in TreeList, IconList or Tabbed
 mode. The returned widget is empty and you must add your widgets
 as children to this widget. The returned widget is a {@link QVBox}
 so it contains a QVBoxLayout layout that lines up the child widgets
 are vertically.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
	public native QVBox addVBoxPage( String item, String header, QPixmap pixmap);
	public native QVBox addVBoxPage( String item);

/** 
 This is like addVBoxPage just above, with the difference that the first
 element is a list of strings. These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the TreeList face. Later this may
 be added for the IconList face too. In other faces than the
 TreeList, all the strings except the last one is ignored.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
	public native QVBox addVBoxPage( String[] items, String header, QPixmap pixmap);
	public native QVBox addVBoxPage( String[] items);

/** 
 Add a new page when the class is used in TreeList, IconList or Tabbed
 mode. The returned widget is empty and you must add your widgets
 as children to this widget. The returned widget is a {@link QHBox}
 so it contains a QHBoxLayout layout that lines up the child widgets
 are horizontally.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
	public native QHBox addHBoxPage( String itemName, String header, QPixmap pixmap);
	public native QHBox addHBoxPage( String itemName);

/** 
 This is like addHBoxPage just above, with the difference that the first
 element is a list of strings. These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the TreeList face. Later this may
 be added for the IconList face too. In other faces than the
 TreeList, all the strings except the last one is ignored.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
	public native QHBox addHBoxPage( String[] items, String header, QPixmap pixmap);
	public native QHBox addHBoxPage( String[] items);

/** 
 Add a new page when the class is used in either TreeList or Tabbed
 mode. The returned widget is empty and you must add your widgets
 as children to this widget. The returned widget is a {@link QGrid}
 so it contains a QGridLayout layout that places up the child widgets
 in a grid.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
	public native QGrid addGridPage( int n, int dir, String itemName, String header, QPixmap pixmap);
	public native QGrid addGridPage( int n, int dir, String itemName);

/** 
 This is like addGridPage just above, with the difference that the first
 element is a list of strings. These strings are used to form a path
 of folders down to the given page. The initial elements are names
 for the folders, while the last element is the name of the page.
 Note: This does yet only work for the TreeList face. Later this may
 be added for the IconList face too. In other faces than the
 TreeList, all the strings except the last one is ignored.

 Deleting the returned frame will cause the listitem or tab to be 
 removed (you can re-add a page with the same name later.

*/
	public native QGrid addGridPage( int n, int dir, String[] items, String header, QPixmap pixmap);
	public native QGrid addGridPage( int n, int dir, String[] items);

/** 
 Returns the index of a page created with {@link addPage} ,
 {@link addVBoxPage} , {@link addHBoxPage} or {@link addGridPage} .
 You can can compare this index with the value returned from
 {@link activePageIndex} if you need to do some page specific actions
 in your code.

 The returned index will never change so you can safely use this
 function once and save the value.

*/
	public native int pageIndex( QWidget widget);

/** 
 Defines the widget to be swallowed.

 This method can be used several
 times. Only the latest defined widget will be shown.

*/
	public native boolean setSwallowedWidget( QWidget widget);

/** 
 This function has only effect in TreeList mode.

 Defines how the tree list is resized when the widget is resized
 horizontally. By default the tree list keeps its width when the
 widget becomes wider.

*/
	public native void setTreeListAutoResize( boolean state);

/** 
 This function has only effect in TreeList mode.

 This tells the widgets whether the icons given in the {@link addPage},
 {@link addVBoxPage}, {@link addHBoxPage}, or {@link addGridPage} methods should
 be shown in the TreeList.

 Note: This method must be called before calling any of the methods
 which add icons to the page.

*/
	public native void setShowIconsInTreeList( boolean state);

/** 
 This function has only effect in TreeList mode.

 This tells the widgets whether the root should be decorated.
 For details see {@link QListView#setRootIsDecorated}

*/
	public native void setRootIsDecorated( boolean state);

/** 
 This function has only effect in IconList mode.

 Defines how the icon list widget is displayed. By default it is
 the widgets in the pages that decide the minimum height
 of the toplevel widget. A vertical scrollbar can be used in
 the icon list area.

*/
	public native void setIconListAllVisible( boolean state);

/** 
 Sets the icon used in TreeList Mode for the given path.

*/
	public native void setFolderIcon( String[] path, QPixmap pixmap);

/** 
 Give the keyboard input focus to the widget.
     
*/
	public native void setFocus();

/** 
 This function is used internally when in IconList mode. If you
 reimplement this class a make your own event filter, make sure to
 call this function from your filter.

*/
	public native boolean eventFilter( QObject o, QEvent e);
	protected native boolean showPage( QWidget w);
	protected native void addPageWidget( QFrame page, String[] items, String header, QPixmap pixmap);
	protected native void InsertTreeListItem( String[] items, QPixmap pixmap, QFrame page);
	protected native QWidget FindParent();
	public static final int TreeList = 0;
	public static final int Tabbed = 0;
	public static final int Plain = 1;
	public static final int Swallow = 2;
	public static final int IconList = 3;
}
