/***************************************************************************
                            FileCopyJob.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The FileCopyJob copies data from one place to another.
     
 See {@link FileCopyJobSignals} for signals emitted by FileCopyJob.

 See {@link FileCopyJobEventHandling} for event handlers to override in subclasses of FileCopyJob.

 @short 
 The FileCopyJob copies data from one place to another.
*/
public class FileCopyJob extends Job  {
	protected FileCopyJob(Class dummy){super((Class) null);}

	private native void newFileCopyJob( KURL src, KURL dest, int permissions, boolean move, boolean overwrite, boolean resume, boolean showProgressInfo);
	public FileCopyJob( KURL src, KURL dest, int permissions, boolean move, boolean overwrite, boolean resume, boolean showProgressInfo) {
		super((Class) null);
		newFileCopyJob( src, dest, permissions, move, overwrite, resume, showProgressInfo);
	}
	protected native void finalize() throws InternalError;

/** 
 If you know the size of the source file, call this method
 to inform this job. It will be displayed in the "resume" dialog.
         
*/
//	public native void setSourceSize( off_t size);
	public native KURL srcURL();
	public native KURL destURL();
	public native void slotData( Job arg1, byte[] data);
	public native void slotDataReq( Job arg1, byte[] data);
	protected native void startCopyJob();
	protected native void startCopyJob( KURL slave_url);
	protected native void startDataPump();
	protected native void connectSubjob( SimpleJob job);

/** 
 Called whenever a subjob finishes.
         
*/
	protected native void slotResult( Job job);

/** 
 Forward signal from subjob
         
*/
	protected native void slotProcessedSize( Job arg1, long size);

/** 
 Forward signal from subjob
         
*/
	protected native void slotTotalSize( Job arg1, long size);

/** 
 Forward signal from subjob
         
*/
	protected native void slotPercent( Job arg1, long pct);

/** 
 Forward signal from subjob
         
*/
	protected native void slotCanResume( Job arg1, long offset);
}
