/* Jump to a new context.
   Copyright (C) 2002-2017 Free Software Foundation, Inc.
   This file is part of the GNU C Library.

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library.  If not, see
   <http://www.gnu.org/licenses/>.  */

#include <sysdep.h>
#include <rtld-global-offsets.h>
#include <shlib-compat.h>

#define __ASSEMBLY__
#include <asm/ptrace.h>
#include "ucontext_i.h"

#include <context-e500.h>

#define __CONTEXT_FUNC_NAME __setcontext
#undef __CONTEXT_ENABLE_FPRS
#undef __CONTEXT_ENABLE_VRS

#include "setcontext-common.S"

versioned_symbol (libc, __setcontext, setcontext, GLIBC_2_3_4)

#if SHLIB_COMPAT (libc, GLIBC_2_3_3, GLIBC_2_3_4)

/* For the nofpu case the old/new versions are the same function.  */
strong_alias (__setcontext, __novec_setcontext)

compat_symbol (libc, __novec_setcontext, setcontext, GLIBC_2_3_3)

#endif

#if SHLIB_COMPAT (libc, GLIBC_2_0, GLIBC_2_3_3)

#define _ERRNO_H	1
#include <bits/errno.h>

	compat_text_section
ENTRY (__setcontext_stub)
	li	r3,ENOSYS
	b	__syscall_error@local
END (__setcontext_stub)
	.previous

compat_symbol (libc, __setcontext_stub, setcontext, GLIBC_2_0)

#endif
