/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.Library;
import gnu.jel.TestingUtils;
import gnu.jel.reflect.Double;
import gnu.jel.tests.DoubleObject;
import gnu.jel.tests.IntegerObject;
import gnu.jel.tests.VariableProvider;

public class IntegralDynamicVariablesTest
extends TestingUtils {
    Library lib;
    Object[] rtp;
    VariableProvider vp;

    public IntegralDynamicVariablesTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        Class[] dynamicLib = new Class[1];
        this.rtp = new Object[1];
        this.vp = new VariableProvider();
        Class[] staticLib = new Class[]{Class.forName("java.lang.Math"), this.vp.getClass()};
        this.vp.xvar = 5.0;
        this.vp.strVar = "strVar";
        this.rtp[0] = this.vp;
        dynamicLib[0] = this.vp.getClass();
        Class[] dotLib = new Class[]{Class.forName("java.lang.String"), Class.forName("java.lang.Double"), Class.forName("gnu.jel.reflect.Double"), IntegerObject.class, DoubleObject.class};
        this.lib = new Library(staticLib, dynamicLib, dotLib, this.vp, null);
        this.vp.addProperty("p1", "p1value");
        this.vp.addProperty("p1.s1", "p1s1value");
        this.vp.addProperty("p1.s2", "p1s2value");
        this.vp.addProperty("p1.d1", VariableProvider.makeJELDoubleObject(1.0));
        this.vp.addProperty("p1.s2.ss1", "p1s2ss1value");
        this.vp.addProperty("p1.b1t", VariableProvider.makeJELBooleanObject(true));
        this.vp.addProperty("p1.b1f", VariableProvider.makeJELBooleanObject(false));
    }

    public void test1() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("p1", "p1value", null, this.rtp, this.lib, null);
    }

    public void test2() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("p1.s1", "p1s1value", null, this.rtp, this.lib, null);
    }

    public void test3() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("p1.s2", "p1s2value", null, this.rtp, this.lib, null);
    }

    public void test4() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("p1.s2.ss1", "p1s2ss1value", null, this.rtp, this.lib, null);
    }

    public void test5() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("p1.d1.aMethod()", 1, null, this.rtp, this.lib, null);
    }

    public void test6() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("p1.s2.length()", 9, null, this.rtp, this.lib, null);
    }

    public void test7() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("p1+(p1.d1+p1.s2.length()+1)", "p1value11.0", null, this.rtp, this.lib, null);
    }

    public void test8() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("round(p1.d1)", 1L, null, this.rtp, this.lib, null);
    }

    public void test9() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("round(makeDoubleObject(p1.d1))", 1L, null, this.rtp, this.lib, null);
    }

    public void test10() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"abc\".compareTo(\"\"+makeDoubleObject(p1.d1))>0", Boolean.TRUE, Boolean.TYPE, this.rtp, this.lib, null);
    }

    public void test11() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"abc\".compareTo((2>round(makeDoubleObject(p1.d1))?\"\":\"a\")+makeDoubleObject(p1.d1))>0", Boolean.TRUE, null, this.rtp, this.lib, null);
    }

    public void test12() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("p1.d1>0", true, null, this.rtp, this.lib, null);
    }

    public void test13() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("p1.d1>0?p1.d1:3.0", 1.0, null, this.rtp, this.lib, null);
    }

    public void test14() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("p1.b1t", true, Boolean.TYPE, this.rtp, this.lib, null);
    }

    public void test15() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("(boolean)p1.b1t", true, null, this.rtp, this.lib, null);
    }

    public void test16() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("p1.b1t?1:0", (byte)1, null, this.rtp, this.lib, null);
    }

    public void test17() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("aarr[1][0]", 3.0, null, this.rtp, this.lib, null);
    }

    public void test18() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("aarrDouble[1][0].doubleValue()", 3.0, null, this.rtp, this.lib, null);
    }

    public void test19() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("aarrDouble[1][0]", 3.0, null, this.rtp, this.lib, null);
    }

    public void test20() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"\"+aarr[1][0]", "3.0", null, this.rtp, this.lib, null);
    }

    public void test21() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"\"+aarrDouble[1][0]", "3.0", null, this.rtp, this.lib, null);
    }

    public void test22() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"\"+aarrDouble[1][0].doubleValue", "3.0", null, this.rtp, this.lib, null);
    }

    public void test23() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"\"+\"\"+aarr[1][0]", "3.0", null, this.rtp, this.lib, null);
    }

    public void test24() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"a\"+\"b\"+aarr[1][0]+\"c\"", "ab3.0c", null, this.rtp, this.lib, null);
    }

    public void test25() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"a\"==\"b\"", Boolean.FALSE, null, this.rtp, this.lib, null);
    }

    public void test26() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"a\"==\"a\"", Boolean.TRUE, null, this.rtp, this.lib, null);
    }

    public void test27() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"a\"!=\"b\"", Boolean.TRUE, null, this.rtp, this.lib, null);
    }

    public void test28() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"a\"!=\"a\"", Boolean.FALSE, null, this.rtp, this.lib, null);
    }

    public void test29() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("!(\"a\"!=\"b\")", Boolean.FALSE, null, this.rtp, this.lib, null);
    }

    public void test30() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("!(\"a\"==\"a\")", Boolean.FALSE, null, this.rtp, this.lib, null);
    }

    public void test31() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"a\"+\"b\"==\"ab\"", Boolean.TRUE, null, this.rtp, this.lib, null);
    }

    public void test32() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"a\"+\"b\"!=\"ab\"", Boolean.FALSE, null, this.rtp, this.lib, null);
    }

    public void test33() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"a\"+\"b\"==\"a\"+\"b\"", Boolean.TRUE, null, this.rtp, this.lib, null);
    }

    public void test34() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("!(\"a\"+\"b\"!=\"a\"+\"b\")", Boolean.TRUE, null, this.rtp, this.lib, null);
    }

    public void test35() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"a\"<\"b\"", Boolean.TRUE, null, this.rtp, this.lib, null);
    }

    public void test36() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"a\"<=\"b\"", Boolean.TRUE, null, this.rtp, this.lib, null);
    }

    public void test37() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"a\">=\"b\"", Boolean.FALSE, null, this.rtp, this.lib, null);
    }

    public void test38() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"a\">\"b\"", Boolean.FALSE, null, this.rtp, this.lib, null);
    }

    public void test39() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"b\"<\"a\"", Boolean.FALSE, null, this.rtp, this.lib, null);
    }

    public void test40() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"b\"<=\"a\"", Boolean.FALSE, null, this.rtp, this.lib, null);
    }

    public void test41() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"b\">=\"a\"", Boolean.TRUE, null, this.rtp, this.lib, null);
    }

    public void test42() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"b\">\"a\"", Boolean.TRUE, null, this.rtp, this.lib, null);
    }

    public void test43() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"a\"<\"a\"", Boolean.FALSE, null, this.rtp, this.lib, null);
    }

    public void test44() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"a\">\"a\"", Boolean.FALSE, null, this.rtp, this.lib, null);
    }

    public void test45() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"a\"<=\"a\"", Boolean.TRUE, null, this.rtp, this.lib, null);
    }

    public void test46() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"a\">=\"a\"", Boolean.TRUE, null, this.rtp, this.lib, null);
    }

    public void test47() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"3.0\"==\"\"+aarrDouble[1][0]", Boolean.TRUE, null, this.rtp, this.lib, null);
    }

    public void test48() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"\"==anObject", Boolean.FALSE, null, this.rtp, this.lib, null);
    }

    public void test49() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("anObject==anObject", Boolean.TRUE, null, this.rtp, this.lib, null);
    }

    public void test50() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("anObject!=anObject", Boolean.FALSE, null, this.rtp, this.lib, null);
    }

    public void test51() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("!(anObject==anObject)", Boolean.FALSE, null, this.rtp, this.lib, null);
    }

    public void test52() throws Throwable {
        this.vp.addProperty("\u3050\u3051", "Hiragana");
        IntegralDynamicVariablesTest.simExpression("\u3050\u3051+\"-works\"", "Hiragana-works", null, this.rtp, this.lib, null);
    }

    public void test53() throws Throwable {
        this.vp.addProperty("\u3106\u3107", "Bopomofo");
        IntegralDynamicVariablesTest.simExpression("\u3106\u3107+\"-works\"", "Bopomofo-works", null, this.rtp, this.lib, null);
    }

    public void test54() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"\\u31aE\\u3107\"+\"-works\"", "\u31ae\u3107-works", null, this.rtp, this.lib, null);
    }

    public void test55() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("\"\"+'\\u31aE'+\"-works\"", "\u31ae-works", null, this.rtp, this.lib, null);
    }

    public void test56() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("_T_g", "_U_g", null, this.rtp, this.lib, null);
    }

    public void test57() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("_T_j", "_U_j", null, this.rtp, this.lib, null);
    }

    public void test58() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("_T_j+_T_g", "_U_j_U_g", null, this.rtp, this.lib, null);
    }

    public void test59() throws Throwable {
        double[] atemp = new double[]{1.0, 2.0};
        this.vp.addProperty("A", atemp);
        IntegralDynamicVariablesTest.simExpression("A[0]+3.0", 4.0, null, this.rtp, this.lib, null);
    }

    public void test60() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("overshadowed_inc(1)", 2.0, null, this.rtp, this.lib, null);
    }

    public void test61() throws Throwable {
        this.vp.addProperty("overshadowed_inc", VariableProvider.makeJELDoubleObject(1.0));
        IntegralDynamicVariablesTest.simExpression("overshadowed_inc(1)", 2.0, null, this.rtp, this.lib, null);
    }

    public void test62() throws Throwable {
        Double obj = VariableProvider.makeJELDoubleObject(1.0);
        this.vp.addProperty("overshadowed_inc", obj);
        IntegralDynamicVariablesTest.simExpression("overshadowed_inc", obj, null, this.rtp, this.lib, null);
    }

    public void test63() throws Throwable {
        IntegralDynamicVariablesTest.simExpression("overshadowed_double", 2.0, null, this.rtp, this.lib, null);
    }

    public void test64() throws Throwable {
        Double obj = VariableProvider.makeJELDoubleObject(1.0);
        this.vp.addProperty("overshadowed_double", obj);
        IntegralDynamicVariablesTest.simExpression("overshadowed_double", obj, null, this.rtp, this.lib, null);
    }
}

