/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (opts.h)
 *  
 *  It has been AutoGen-ed  Sunday January  4, 2004 at 03:13:37 PM PST
 *  From the definitions    opts.def
 *  and the template file   options
 */
/*
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the columns program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
#ifndef AUTOOPTS_OPTS_H_GUARD
#define AUTOOPTS_OPTS_H_GUARD

/*
 * columns copyright 1999-2000 Bruce Korb - all rights reserved
 *
 * columns is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2, or (at your option) any later version.
 * 
 * columns is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with columns.  See the file "COPYING".  If not,
 * write to:  The Free Software Foundation, Inc.,
 *            59 Temple Place - Suite 330,
 *            Boston,  MA  02111-1307, USA.
 */
#include <options.h>

/*
 *  Enumeration of each option:
 */
typedef enum {
        INDEX_OPT_WIDTH            =  0,
        INDEX_OPT_COLUMNS          =  1,
        INDEX_OPT_COL_WIDTH        =  2,
        INDEX_OPT_SPREAD           =  3,
        INDEX_OPT_INDENT           =  4,
        INDEX_OPT_FIRST_INDENT     =  5,
        INDEX_OPT_TAB_WIDTH        =  6,
        INDEX_OPT_SORT             =  7,
        INDEX_OPT_FORMAT           =  8,
        INDEX_OPT_SEPARATION       =  9,
        INDEX_OPT_LINE_SEPARATION  = 10,
        INDEX_OPT_BY_COLUMNS       = 11,
        INDEX_OPT_INPUT            = 12,
        INDEX_OPT_VERSION          = 13,
        INDEX_OPT_HELP             = 14,
        INDEX_OPT_MORE_HELP        = 15
} teOptIndex;

#define OPTION_CT    16
#define COLUMNS_VERSION       "1.1"
#define COLUMNS_FULL_VERSION  "columns - Columnize Input Text - Ver. 1.1"

/*
 *  Interface defines for all options.  Replace "n" with
 *  the UPPER_CASED option name (as in the teOptIndex
 *  enumeration above).  e.g. HAVE_OPT( WIDTH )
 */
#define         DESC(n) columnsOptions.pOptDesc[INDEX_OPT_ ## n]
#define     HAVE_OPT(n) (! UNUSED_OPT(& DESC(n)))
#define      OPT_ARG(n) (DESC(n).pzLastArg)
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
#define    COUNT_OPT(n) (DESC(n).optOccCt)
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT;   \
                if ( (DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = NULL )

/*
 *  Interface defines for specific options.
 */
#define VALUE_OPT_WIDTH          'W'
#define OPT_VALUE_WIDTH          (*(unsigned long*)(&OPT_ARG(WIDTH)))
#define VALUE_OPT_COLUMNS        'c'
#define OPT_VALUE_COLUMNS        (*(unsigned long*)(&OPT_ARG(COLUMNS)))
#define VALUE_OPT_COL_WIDTH      'w'
#define OPT_VALUE_COL_WIDTH      (*(unsigned long*)(&OPT_ARG(COL_WIDTH)))
#define VALUE_OPT_SPREAD         3
#define OPT_VALUE_SPREAD         (*(unsigned long*)(&OPT_ARG(SPREAD)))
#define VALUE_OPT_INDENT         'I'
#define VALUE_OPT_FIRST_INDENT   5
#define VALUE_OPT_TAB_WIDTH      6
#define OPT_VALUE_TAB_WIDTH      (*(unsigned long*)(&OPT_ARG(TAB_WIDTH)))
#define VALUE_OPT_SORT           's'
#define VALUE_OPT_FORMAT         'f'
#define VALUE_OPT_SEPARATION     'S'
#define VALUE_OPT_LINE_SEPARATION 10
#define VALUE_OPT_BY_COLUMNS     11
#define VALUE_OPT_INPUT          'i'

#define VALUE_OPT_VERSION        'v'
#define VALUE_OPT_HELP           '?'
#define VALUE_OPT_MORE_HELP      '!'

/*
 *  Interface defines not associated with particular options
 */
#define  ERRSKIP_OPTERR STMTS( columnsOptions.fOptSet &= ~OPTPROC_ERRSTOP )
#define  ERRSTOP_OPTERR STMTS( columnsOptions.fOptSet |= OPTPROC_ERRSTOP )
#define  RESTART_OPT(n) STMTS( \
                columnsOptions.curOptIdx = (n); \
                columnsOptions.pzCurOpt  = NULL )
#define    START_OPT    RESTART_OPT(1)
#define     USAGE(c)    (*columnsOptions.pUsageProc)( &columnsOptions, c )

/* * * * * *
 *
 *  Declare the columns option descriptor.
 */
#ifdef  __cplusplus
extern "C" {
#endif

extern tOptions   columnsOptions;

/* * * * * *
 *
 *  Globals exported from the Columnize Input Text option definitions
 */
#include "config.h"
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "snprintfv/printf.h"

#ifndef _
#  if ENABLE_NLS
#    include <stdio.h>
     static inline char* aoGetsText( const char* pz ) {
         if (pz == NULL) return NULL;
         return (char*)gettext( pz );
     }
#    define _(s)  aoGetsText(s)
#  else  /* ENABLE_NLS */
#    define _(s)  s
#  endif /* ENABLE_NLS */
#endif

#ifdef  __cplusplus
}
#endif
#endif /* AUTOOPTS_OPTS_H_GUARD */
