/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.xmind.ui.forms.WidgetFactory;
import org.xmind.ui.viewers.ICategorizedContentProvider;
import org.xmind.ui.viewers.Messages;

public abstract class CategorizedViewer
extends StructuredViewer {
    public static final Object DEFAULT_CATEGORY = new String(Messages.CategorizedViewer_UnknownCategory);
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private static final List<Object> EMPTY_LIST = Collections.emptyList();
    private Object[] categories = EMPTY_ARRAY;
    private Map<Object, List<Object>> categorizedElements = new HashMap<Object, List<Object>>();
    private Map<Object, Section> sections = new HashMap<Object, Section>();
    private ScrolledForm container = null;
    private WidgetFactory factory;
    private int sectionStyle = 16706;

    public int getSectionStyle() {
        return this.sectionStyle;
    }

    public void setSectionStyle(int sectionStyle) {
        this.sectionStyle = sectionStyle;
    }

    protected ScrolledForm getContainer() {
        return this.container;
    }

    public void createControl(Composite parent, int style) {
        this.container = this.createContainer(parent, style);
        this.hookControl((Control)this.container);
    }

    private ScrolledForm createContainer(Composite parent, int style) {
        if (this.factory == null) {
            this.factory = this.createWidgetFactory(parent.getDisplay());
        }
        ScrolledForm form = new ScrolledForm(parent, 0x2000200);
        form.setExpandHorizontal(true);
        form.setExpandVertical(true);
        form.setBackground(parent.getBackground());
        form.setForeground(parent.getForeground());
        form.setFont(JFaceResources.getHeaderFont());
        this.addHorizontalScrollSupport(form);
        this.container = form;
        this.configureContainer(this.container);
        return this.container;
    }

    private void addHorizontalScrollSupport(final ScrolledForm form) {
        if (Util.isWindows()) {
            form.addListener(38, new Listener(){

                public void handleEvent(Event event) {
                    if (!form.isDisposed()) {
                        int offset = event.count;
                        offset = -((int)(Math.sqrt(Math.abs(offset)) * (double)offset));
                        Point origin = form.getOrigin();
                        form.setOrigin(origin.x + offset, origin.y);
                    }
                }
            });
        }
    }

    protected WidgetFactory createWidgetFactory(Display display) {
        return new WidgetFactory(display);
    }

    protected WidgetFactory getWidgetFactory() {
        return this.factory;
    }

    protected void configureContainer(ScrolledForm container) {
        container.getBody().setLayout(this.createFormLayout());
        container.setMinWidth(1);
    }

    protected Layout createFormLayout() {
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        return layout;
    }

    protected void hookControl(Control control) {
        super.hookControl(control);
        control.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                CategorizedViewer.this.relayout();
            }
        });
    }

    private void relayout() {
        int width = this.getContainer().getClientArea().width;
        for (Section section : this.sections.values()) {
            this.resetWidth(width, (Control)section);
        }
        this.container.reflow(true);
    }

    private void resetWidth(int width, Control control) {
        Object ld = control.getLayoutData();
        if (ld instanceof GridData) {
            GridData gd = (GridData)ld;
            GridLayout gl = (GridLayout)control.getParent().getLayout();
            gd.widthHint = width - gl.marginWidth * 2 - gl.marginLeft - gl.marginRight;
        } else if (ld instanceof RowData) {
            RowData rd = (RowData)ld;
            RowLayout rl = (RowLayout)control.getParent().getLayout();
            rd.width = width - rl.marginWidth * 2 - rl.marginLeft - rl.marginRight;
        }
    }

    protected List<Object> getCategories() {
        return Arrays.asList(this.categories);
    }

    protected List<Object> getElements(Object category) {
        List<Object> elements = this.categorizedElements.get(category);
        if (elements == null) {
            return EMPTY_LIST;
        }
        return Collections.unmodifiableList(elements);
    }

    protected boolean hasCategory(Object category) {
        return this.categorizedElements.containsKey(category);
    }

    protected Composite getSection(Object category) {
        return (Composite)this.sections.get(category);
    }

    protected Widget doFindInputItem(Object element) {
        return this.getControl();
    }

    protected Widget doFindItem(Object element) {
        if (this.hasCategory(element)) {
            return this.getSection(element);
        }
        return this.getControl();
    }

    protected void inputChanged(Object input, Object oldInput) {
        super.inputChanged(input, oldInput);
        this.refresh(true);
    }

    protected void internalRefresh(Object element) {
        this.internalRefresh(element, true);
    }

    protected void internalRefresh(Object element, boolean updateLabels) {
        if (element == this.getInput()) {
            Boolean exp;
            HashMap<Object, Boolean> expansionStates = new HashMap<Object, Boolean>();
            for (Object category : this.getCategories()) {
                exp = this.getExpanded(category);
                if (exp == null) continue;
                expansionStates.put(category, exp);
            }
            this.rebuildMap();
            this.refreshSections();
            for (Object category : this.getCategories()) {
                exp = (Boolean)expansionStates.get(category);
                if (exp == null) continue;
                this.setExpanded(category, exp);
            }
            if (this.getContainer() != null && !this.getContainer().isDisposed()) {
                this.relayout();
            }
        } else if (this.hasCategory(element)) {
            this.rebuildMapForCategory(element);
            if (updateLabels) {
                this.updateSection(element, this.getSection(element));
            }
            this.refreshSectionContent(this.getSectionContent(element), element, null);
        } else {
            Object category = this.getCategory(element);
            if (category != null && this.hasCategory(category)) {
                this.refreshSectionContent(this.getSectionContent(category), category, element);
            }
        }
    }

    public Boolean getExpanded(Object category) {
        Composite section = this.getSection(category);
        if (section instanceof Section) {
            return ((Section)section).isExpanded();
        }
        return null;
    }

    public void setExpanded(Object category, boolean expanded) {
        Composite section = this.getSection(category);
        if (section instanceof Section) {
            ((Section)section).setExpanded(expanded);
        }
    }

    public void setAllExpanded(boolean expanded) {
        for (Section section : this.sections.values()) {
            section.setExpanded(expanded);
        }
    }

    private void rebuildMap() {
        this.categorizedElements.clear();
        if (this.getContentProvider() instanceof ITreeContentProvider) {
            this.categories = this.getSortedChildren(this.getInput());
            int i = 0;
            while (i < this.categories.length) {
                Object category = this.categories[i];
                Object[] children = ((ITreeContentProvider)this.getContentProvider()).getChildren(category);
                ViewerFilter[] filters = this.getFilters();
                if (filters != null && filters.length > 0) {
                    ViewerFilter[] viewerFilterArray = filters;
                    int n = filters.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ViewerFilter f = viewerFilterArray[n2];
                        Object[] filteredChildren = f.filter((Viewer)this, this.getInput(), children);
                        if (filteredChildren != null) {
                            children = filteredChildren;
                        }
                        ++n2;
                    }
                }
                if (this.getSorter() != null) {
                    this.getSorter().sort((Viewer)this, children);
                }
                this.categorizedElements.put(category, Arrays.asList(children));
                ++i;
            }
        } else if (this.getContentProvider() instanceof ICategorizedContentProvider) {
            Object[] elements = this.getSortedChildren(this.getInput());
            ArrayList<Object> rawCategories = new ArrayList<Object>(elements.length);
            Object[] objectArray = elements;
            int n = elements.length;
            int filters = 0;
            while (filters < n) {
                Object element = objectArray[filters];
                Object category = this.getCategory(element);
                List<Object> list = this.categorizedElements.get(category);
                if (list == null) {
                    list = new ArrayList<Object>(elements.length);
                    this.categorizedElements.put(category, list);
                    rawCategories.add(category);
                }
                list.add(element);
                ++filters;
            }
            this.categories = rawCategories.toArray();
            ViewerFilter[] filters2 = this.getFilters();
            if (filters2 != null && filters2.length > 0) {
                ViewerFilter[] viewerFilterArray = filters2;
                int n3 = filters2.length;
                n = 0;
                while (n < n3) {
                    ViewerFilter f = viewerFilterArray[n];
                    Object[] filteredCategories = f.filter((Viewer)this, this.getInput(), this.categories);
                    if (filteredCategories != null) {
                        this.categories = filteredCategories;
                    }
                    ++n;
                }
            }
            if (this.getSorter() != null) {
                this.getSorter().sort((Viewer)this, this.categories);
            }
        }
    }

    private void rebuildMapForCategory(Object category) {
        if (this.getContentProvider() instanceof ITreeContentProvider) {
            Object[] children = ((ITreeContentProvider)this.getContentProvider()).getChildren(category);
            ViewerFilter[] filters = this.getFilters();
            if (filters != null && filters.length > 0) {
                ViewerFilter[] viewerFilterArray = filters;
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    ViewerFilter f = viewerFilterArray[n2];
                    Object[] filteredChildren = f.filter((Viewer)this, this.getInput(), children);
                    if (filteredChildren != null) {
                        children = filteredChildren;
                    }
                    ++n2;
                }
            }
            if (this.getSorter() != null) {
                this.getSorter().sort((Viewer)this, children);
            }
            this.categorizedElements.put(category, Arrays.asList(children));
        } else if (this.getContentProvider() instanceof ICategorizedContentProvider) {
            Object[] elements = this.getSortedChildren(this.getInput());
            ArrayList<Object> elementsInCategory = new ArrayList<Object>(elements.length);
            Object[] objectArray = elements;
            int n = elements.length;
            int n3 = 0;
            while (n3 < n) {
                Object element = objectArray[n3];
                if (this.getCategory(element).equals(category)) {
                    elementsInCategory.add(element);
                }
                ++n3;
            }
            this.categorizedElements.put(category, elementsInCategory);
        }
    }

    protected Object getCategory(Object element) {
        Object category = null;
        if (this.getContentProvider() instanceof ICategorizedContentProvider) {
            category = ((ICategorizedContentProvider)this.getContentProvider()).getCategory(element);
        } else if (this.getContentProvider() instanceof ITreeContentProvider) {
            category = ((ITreeContentProvider)this.getContentProvider()).getParent(element);
        }
        if (category != null) {
            return category;
        }
        return DEFAULT_CATEGORY;
    }

    private void refreshSections() {
        if (this.getContainer() == null || this.getContainer().isDisposed()) {
            return;
        }
        this.getContainer().setRedraw(false);
        try {
            HashSet<Section> sectionsToRemove = new HashSet<Section>(this.sections.values());
            Section lastSection = null;
            Composite parent = this.container.getBody();
            int i = 0;
            while (i < this.categories.length) {
                Object category = this.categories[i];
                Section section = this.sections.get(category);
                if (section == null) {
                    section = this.createSection(parent, category);
                    this.sections.put(category, section);
                }
                this.updateSection(category, (Composite)section);
                this.refreshSectionContent(section.getClient(), category, null);
                section.moveBelow(lastSection);
                lastSection = section;
                sectionsToRemove.remove(section);
                ++i;
            }
            for (Section section : sectionsToRemove) {
                this.disposeSection(section);
            }
        }
        finally {
            if (this.getContainer() != null && !this.getContainer().isDisposed()) {
                this.getContainer().setRedraw(true);
            }
        }
    }

    private void disposeSection(Section section) {
        Object category = section.getData();
        this.sections.remove(category);
        this.disposeSectionContent((Composite)section, category);
        section.setMenu(null);
        section.dispose();
    }

    private Section createSection(Composite parent, Object category) {
        Section section = this.factory.createSection(parent, this.getSectionStyle());
        section.setData(category);
        section.setLayoutData(this.getSectionLayoutData(section, category));
        Control content = this.createSectionContent((Composite)section, category);
        Assert.isNotNull((Object)content);
        section.setClient(content);
        this.configureSection(section, category);
        return section;
    }

    protected void configureSection(Section section, Object category) {
        section.setTitleBarBackground(section.getDisplay().getSystemColor(1));
        section.setTitleBarBorderColor(section.getDisplay().getSystemColor(1));
    }

    protected Object getSectionLayoutData(Section section, Object category) {
        return new GridData(4, 4, true, false);
    }

    private Control getSectionContent(Object category) {
        Composite section = this.getSection(category);
        if (section instanceof Section && !section.isDisposed()) {
            return ((Section)section).getClient();
        }
        return null;
    }

    protected String getText(Object element) {
        if (this.getLabelProvider() instanceof ILabelProvider) {
            return ((ILabelProvider)this.getLabelProvider()).getText(element);
        }
        return element == null ? null : element.toString();
    }

    protected Image getImage(Object element) {
        if (this.getLabelProvider() instanceof ILabelProvider) {
            return ((ILabelProvider)this.getLabelProvider()).getImage(element);
        }
        return null;
    }

    protected Color getForeground(Object element) {
        if (this.getLabelProvider() instanceof IColorProvider) {
            return ((IColorProvider)this.getLabelProvider()).getForeground(element);
        }
        return null;
    }

    protected Color getBackground(Object element) {
        if (this.getLabelProvider() instanceof IColorProvider) {
            return ((IColorProvider)this.getLabelProvider()).getBackground(element);
        }
        return null;
    }

    protected void doUpdateItem(Widget item, Object element, boolean fullMap) {
        if (this.hasCategory(element)) {
            this.updateSection(element, this.getSection(element));
        }
    }

    protected void updateSection(Object category, Composite section) {
        section.setData(category);
        if (section instanceof Section) {
            Color background;
            Color foreground;
            Section s = (Section)section;
            String text = this.getText(category);
            if (text != null) {
                s.setText(text);
            }
            if ((foreground = this.getForeground(category)) != null) {
                s.setTitleBarForeground(foreground);
            }
            if ((background = this.getBackground(category)) != null) {
                s.setTitleBarBackground(background);
            }
        }
    }

    public void reveal(Object element) {
        if (this.hasCategory(element)) {
            this.reveal(element, null);
        } else {
            Object category = this.getCategory(element);
            this.reveal(category, element);
        }
    }

    protected void reveal(Object category, Object element) {
        Composite section = this.getSection(category);
        if (section != null && !section.isDisposed()) {
            if (section instanceof Section) {
                ((Section)section).setExpanded(true);
            }
            Point loc = Display.getCurrent().map((Control)section, (Control)this.getContainer(), 0, 0);
            this.reveal(loc.x, loc.y);
        }
    }

    protected void reveal(int x, int y) {
        Point origin = this.container.getOrigin();
        origin.x += x;
        origin.y += y;
        this.container.setOrigin(origin);
    }

    public Control getControl() {
        return this.container;
    }

    protected List getSelectionFromWidget() {
        ArrayList list = new ArrayList();
        for (Object category : this.getCategories()) {
            this.fillSelection(category, list);
        }
        return list;
    }

    protected void setSelectionToWidget(List l, boolean reveal) {
    }

    protected void setSelectionToWidget(ISelection selection, boolean reveal) {
        Object element;
        for (Object category : this.getCategories()) {
            this.setSelectionToCategory(category, selection, reveal);
        }
        if (reveal && (element = ((IStructuredSelection)this.getSelection()).getFirstElement()) != null) {
            this.reveal(element);
        }
    }

    protected void handleDispose(DisposeEvent event) {
        super.handleDispose(event);
        this.sections.clear();
        this.categories = EMPTY_ARRAY;
        this.categorizedElements.clear();
        if (this.factory != null) {
            this.factory.dispose();
            this.factory = null;
        }
    }

    public void setFocus() {
        for (Object category : this.getCategories()) {
            Composite section = this.getSection(category);
            if (!(section instanceof Section) || !((Section)section).getClient().setFocus()) continue;
            return;
        }
    }

    protected abstract Control createSectionContent(Composite var1, Object var2);

    protected abstract void disposeSectionContent(Composite var1, Object var2);

    protected abstract void refreshSectionContent(Control var1, Object var2, Object var3);

    protected abstract void fillSelection(Object var1, List var2);

    protected abstract void setSelectionToCategory(Object var1, ISelection var2, boolean var3);
}

