/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.util.List;
import org.w3c.dom.Element;
import org.xmind.core.IHyperlinkSpan;
import org.xmind.core.ISpan;
import org.xmind.core.internal.dom.HtmlNotesContentImpl;
import org.xmind.core.internal.dom.SpanImplBase;
import org.xmind.core.internal.dom.WorkbookImpl;
import org.xmind.core.internal.dom.WorkbookUtilsImpl;
import org.xmind.core.util.DOMUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperlinkSpanImpl
extends SpanImplBase
implements IHyperlinkSpan {
    private Element implementation;

    public HyperlinkSpanImpl(Element implementation, HtmlNotesContentImpl owner) {
        super(implementation, owner);
        this.implementation = implementation;
    }

    @Override
    public String getHref() {
        String href = DOMUtils.getAttribute(this.implementation, "xlink:href");
        if (href != null) {
            return href;
        }
        return DOMUtils.getAttribute(this.implementation, "href");
    }

    @Override
    public void setHref(String source) {
        DOMUtils.setAttribute(this.implementation, "xlink:href", source);
        this.getOwner().updateModifiedTime();
    }

    @Override
    public List<ISpan> getSpans() {
        return DOMUtils.getChildren(this.implementation, this.getOwner());
    }

    @Override
    public void addSpan(ISpan span) {
        SpanImplBase base = (SpanImplBase)span;
        this.implementation.appendChild(base.getImplementation());
        base.addNotify(this.getOwner().getRealizedWorkbook());
        this.getOwner().updateModifiedTime();
    }

    @Override
    public void removeSpan(ISpan span) {
        SpanImplBase base = (SpanImplBase)span;
        base.removeNotify(this.getOwner().getRealizedWorkbook());
        this.implementation.removeChild(base.getImplementation());
        this.getOwner().updateModifiedTime();
    }

    @Override
    protected void addNotify(WorkbookImpl workbook) {
        WorkbookUtilsImpl.increaseStyleRef(workbook, this);
        for (ISpan span : this.getSpans()) {
            ((SpanImplBase)span).addNotify(workbook);
        }
    }

    @Override
    protected void removeNotify(WorkbookImpl workbook) {
        for (ISpan span : this.getSpans()) {
            ((SpanImplBase)span).removeNotify(workbook);
        }
        WorkbookUtilsImpl.decreaseStyleRef(workbook, this);
    }
}

