/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal;

import java.util.Collections;
import java.util.List;
import org.xmind.core.IBoundary;
import org.xmind.core.ITopic;
import org.xmind.core.internal.AbstractWorkbookComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Boundary
extends AbstractWorkbookComponent
implements IBoundary {
    protected static final List<ITopic> NO_ENCLOSING_TOPICS = Collections.emptyList();

    @Override
    public String getStyleType() {
        return "boundary";
    }

    @Override
    public String getTitleText() {
        String t = this.getLocalTitleText();
        return t == null ? "" : t;
    }

    @Override
    public boolean hasTitle() {
        return this.getLocalTitleText() != null;
    }

    protected abstract String getLocalTitleText();

    @Override
    public List<ITopic> getEnclosingTopics() {
        List<ITopic> children;
        ITopic parent;
        int startIndex = this.getStartIndex();
        int endIndex = this.getEndIndex();
        if (startIndex >= 0 && endIndex >= 0 && endIndex >= startIndex && (parent = this.getParent()) != null && !(children = parent.getChildren("attached")).isEmpty()) {
            return this.getSubtopics(startIndex, endIndex, children);
        }
        return NO_ENCLOSING_TOPICS;
    }

    @Override
    public boolean encloses(ITopic subtopic) {
        if (subtopic == null) {
            return false;
        }
        ITopic parent = subtopic.getParent();
        if (parent == null || !parent.equals(this.getParent())) {
            return false;
        }
        int startIndex = this.getStartIndex();
        int endIndex = this.getEndIndex();
        int subIndex = subtopic.getIndex();
        return subIndex >= startIndex && subIndex <= endIndex;
    }

    private List<ITopic> getSubtopics(int startIndex, int endIndex, List<ITopic> children) {
        startIndex = Math.min(startIndex, children.size() - 1);
        endIndex = Math.min(endIndex, children.size() - 1);
        return children.subList(startIndex, endIndex + 1);
    }

    public ITopic getStartTopic() {
        return this.getTopic(this.getStartIndex());
    }

    public ITopic getEndTopic() {
        return this.getTopic(this.getEndIndex());
    }

    protected ITopic getTopic(int index) {
        List<ITopic> children;
        ITopic parent;
        if (index >= 0 && (parent = this.getParent()) != null && index < (children = parent.getChildren("attached")).size()) {
            return children.get(index);
        }
        return null;
    }

    public String toString() {
        return "BOUNDARY (" + this.getTitleText() + ")";
    }
}

