/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.aspose.exports;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.xmind.ui.internal.aspose.exports.ExportMessages;
import org.xmind.ui.internal.aspose.exports.document.WordExporter;
import org.xmind.ui.internal.dialogs.DialogMessages;
import org.xmind.ui.wizards.DocumentExportPageBase;

public abstract class MSExportWizardPage
extends DocumentExportPageBase {
    private Button saveScriptCheck;
    private Text saveScriptPathInputText;
    private Button saveScriptPathBrowseButton;

    public MSExportWizardPage(String pageName, String title) {
        super(pageName, title);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (System.getProperty("org.xmind.ui.debug.export.msoffice") != null) {
            Composite composite = (Composite)this.getControl();
            Control saveScriptGroup = this.createSaveScriptGroup(composite);
            saveScriptGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        }
    }

    private Control createSaveScriptGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.saveScriptCheck = new Button(composite, 32);
        this.saveScriptCheck.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.saveScriptCheck.setText(ExportMessages.MSExportWizardPage_SaveScript_Text);
        this.hookWidget((Widget)this.saveScriptCheck, 13);
        Composite pathComposite = new Composite(composite, 0);
        GridLayout pathLayout = new GridLayout(2, false);
        pathLayout.marginWidth = 0;
        pathLayout.marginHeight = 0;
        pathLayout.verticalSpacing = 0;
        pathLayout.horizontalSpacing = 5;
        pathComposite.setLayout((Layout)pathLayout);
        GridData pathLayoutData = new GridData(4, 4, true, false);
        pathLayoutData.horizontalIndent = 15;
        pathComposite.setLayoutData((Object)pathLayoutData);
        this.saveScriptPathInputText = new Text(pathComposite, 2052);
        this.saveScriptPathInputText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.hookWidget((Widget)this.saveScriptPathInputText, 24);
        this.saveScriptPathBrowseButton = new Button(pathComposite, 8);
        this.saveScriptPathBrowseButton.setText(ExportMessages.MSExportWizardPage_Browse_Text);
        this.saveScriptPathBrowseButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
        this.hookWidget((Widget)this.saveScriptPathBrowseButton, 13);
        String path = this.getSaveScriptPath();
        boolean active = path != null;
        this.saveScriptPathInputText.setEnabled(active);
        this.saveScriptPathBrowseButton.setEnabled(active);
        if (path != null) {
            this.saveScriptCheck.setSelection(true);
            this.saveScriptPathInputText.setText(path);
        } else {
            this.saveScriptCheck.setSelection(false);
            this.saveScriptPathInputText.setText("");
        }
        return composite;
    }

    protected void handleWidgetEvent(Event event) {
        Widget widget = event.widget;
        if (widget == this.saveScriptCheck) {
            boolean active = this.shouldSaveScript();
            this.saveScriptPathInputText.setEnabled(active);
            this.saveScriptPathBrowseButton.setEnabled(active);
            if (active) {
                this.setSaveScriptPath(this.saveScriptPathInputText.getText());
            } else {
                this.setSaveScriptPath(null);
            }
            this.updateStatus();
        } else if (widget == this.saveScriptPathInputText) {
            if (this.shouldSaveScript()) {
                this.setSaveScriptPath(this.saveScriptPathInputText.getText());
            }
            this.updateStatus();
        } else if (widget == this.saveScriptPathBrowseButton) {
            this.browseSaveScriptPath();
        } else {
            super.handleWidgetEvent(event);
        }
    }

    private void browseSaveScriptPath() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        String path = this.saveScriptPathInputText.getText();
        dialog.setFilterPath(path);
        dialog.setMessage(ExportMessages.MSExportWizardPage_SelectSaveDirectory_Text);
        dialog.setText(DialogMessages.Save_title);
        path = dialog.open();
        if (path == null) {
            return;
        }
        this.saveScriptPathInputText.setText(path);
    }

    private boolean shouldSaveScript() {
        return this.saveScriptCheck.getSelection();
    }

    private void setSaveScriptPath(String path) {
        IDialogSettings settings;
        if ("".equals(path)) {
            path = null;
        }
        if ((settings = this.getDialogSettings()) != null) {
            settings.put("saveScriptPath", path);
        }
    }

    protected boolean isPageCompletable() {
        return super.isPageCompletable() && (System.getProperty("org.xmind.ui.debug.export.msoffice") == null || !this.shouldSaveScript() || this.hasSaveScriptPath());
    }

    private String getSaveScriptPath() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String path = settings.get("saveScriptPath");
            if ("".equals(path)) {
                path = null;
            }
            return path;
        }
        return null;
    }

    private boolean hasSaveScriptPath() {
        return this.getSaveScriptPath() != null;
    }

    protected void createContentControls() {
        Composite composite = (Composite)this.getControl();
        Composite parent = (Composite)((Composite)composite.getChildren()[0]).getChildren()[0];
        Composite content = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 7;
        content.setLayout((Layout)gridLayout);
        Label label = new Label(content, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(ExportMessages.DocumentPage_ContentLabel);
        final Combo combo = new Combo(content, 12);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 80;
        combo.setLayoutData((Object)gridData);
        combo.setItems(WordExporter.Content.getDescriptions());
        combo.select(this.getContentSelection());
        combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                WordExporter.Content content = WordExporter.Content.values()[combo.getSelectionIndex()];
                MSExportWizardPage.this.getDialogSettings().put("level", content.toString());
                MSExportWizardPage.this.updateStatus();
            }
        });
    }

    protected void createNumberControls() {
        Composite composite = (Composite)this.getControl();
        Composite parent = (Composite)((Composite)composite.getChildren()[0]).getChildren()[0];
        Composite number = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 5;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 7;
        number.setLayout((Layout)gridLayout);
        Label label = new Label(number, 0);
        label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        label.setText(ExportMessages.DocumentPage_NumberLabel);
        final Combo combo = new Combo(number, 12);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        gridData.widthHint = 80;
        combo.setLayoutData((Object)gridData);
        combo.setItems(WordExporter.NumberLevel.getDescriptions());
        combo.select(this.getNumberSelection());
        combo.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                WordExporter.NumberLevel number = WordExporter.NumberLevel.values()[combo.getSelectionIndex()];
                MSExportWizardPage.this.getDialogSettings().put("number", number.toString());
                MSExportWizardPage.this.updateStatus();
            }
        });
    }

    private int getContentSelection() {
        String contentStr = this.getDialogSettings().get("level");
        WordExporter.Content selection = contentStr == null ? WordExporter.Content.Level3 : WordExporter.Content.valueOf(contentStr);
        return this.find((Object[])WordExporter.Content.values(), (Object)selection);
    }

    private int getNumberSelection() {
        String numberStr = this.getDialogSettings().get("number");
        WordExporter.NumberLevel selection = numberStr == null ? WordExporter.NumberLevel.Level3 : WordExporter.NumberLevel.valueOf(numberStr);
        return this.find((Object[])WordExporter.NumberLevel.values(), (Object)selection);
    }

    private int find(Object[] array, Object obj) {
        if (obj != null) {
            int i = 0;
            while (i < array.length) {
                if (array[i].equals(obj)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }
}

