/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.branch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.internal.registry.RegistryReader;
import org.xmind.ui.branch.IBranchPolicy;
import org.xmind.ui.branch.IBranchPolicyCategoryDescriptor;
import org.xmind.ui.branch.IBranchPolicyDescriptor;
import org.xmind.ui.branch.IBranchPolicyManager;
import org.xmind.ui.branch.IBranchPropertyTester;
import org.xmind.ui.branch.IBranchStyleValueProvider;
import org.xmind.ui.internal.branch.BranchPolicy;
import org.xmind.ui.internal.branch.BranchPolicyCategoryDescriptor;
import org.xmind.ui.internal.branch.BranchPropertyTesterProxy;
import org.xmind.ui.internal.branch.ContributedStyleValueProvider;
import org.xmind.ui.internal.branch.DefaultBranchPolicy;
import org.xmind.ui.internal.branch.DefaultStructureDescriptor;
import org.xmind.ui.internal.branch.IStructureDescriptor;
import org.xmind.ui.internal.branch.StructureDescriptor;
import org.xmind.ui.mindmap.IBranchPart;
import org.xmind.ui.util.Logger;

public class BranchPolicyManager
extends RegistryReader
implements IBranchPolicyManager {
    private static final String V_CALLOUT_BRANCHES = "calloutBranches";
    private static final String DEFAULT_BRANCH_POLICY_ID = "org.xmind.ui.map.unbalanced";
    private static final String V_PARENT_BRANCH = "parentBranch";
    private static final String V_SUB_BRANCHES = "subBranches";
    private static final String V_SUMMARY_BRANCHES = "summaryBranches";
    private static final String V_BOUNDARIES = "boundaries";
    private static final String V_SUMMARIES = "summaries";
    private static final String V_TOPIC = "topic";
    private List<IBranchPolicyDescriptor> policyList = null;
    private Map<String, BranchPolicy> policyMap = null;
    private Map<String, StructureDescriptor> structureMap = null;
    private Map<String, BranchPropertyTesterProxy> testerMap = null;
    private Map<String, ContributedStyleValueProvider> valueProviderMap = null;
    private IBranchPolicy defaultBranchPolicy = null;
    private List<IBranchPolicyCategoryDescriptor> categoryList = null;
    private Map<String, BranchPolicyCategoryDescriptor> categoryMap = null;

    static IEvaluationContext createBranchEvaluationContext(IBranchPart branch) {
        EvaluationContext context = new EvaluationContext(null, (Object)branch);
        IBranchPart parentBranch = branch.getParentBranch();
        context.addVariable(V_PARENT_BRANCH, parentBranch == null ? IEvaluationContext.UNDEFINED_VARIABLE : parentBranch);
        context.addVariable(V_SUB_BRANCHES, branch.getSubBranches());
        context.addVariable(V_CALLOUT_BRANCHES, branch.getCalloutBranches());
        context.addVariable(V_SUMMARY_BRANCHES, branch.getSummaryBranches());
        context.addVariable(V_BOUNDARIES, branch.getBoundaries());
        context.addVariable(V_SUMMARIES, branch.getSummaries());
        context.addVariable(V_TOPIC, (Object)branch.getTopic());
        return context;
    }

    @Override
    public List<IBranchPolicyDescriptor> getBranchPolicyDescriptors() {
        this.ensureLoaded();
        return this.policyList;
    }

    @Override
    public List<IBranchPolicyCategoryDescriptor> getBranchPolicyCategoryDescriptors() {
        this.ensureLoaded();
        return this.categoryList;
    }

    private Map<String, BranchPolicy> getPolicyMap() {
        this.ensureLoaded();
        return this.policyMap;
    }

    private Map<String, StructureDescriptor> getStructureMap() {
        this.ensureLoaded();
        return this.structureMap;
    }

    private Map<String, BranchPolicyCategoryDescriptor> getCategoryMap() {
        this.ensureLoaded();
        return this.categoryMap;
    }

    public IStructureDescriptor getStructureDescriptor(String id) {
        StructureDescriptor structure;
        if (id != null && (structure = this.getStructureMap().get(id)) != null) {
            return structure;
        }
        return DefaultStructureDescriptor.getInstance();
    }

    public IBranchPropertyTester getPropertyTester(String id) {
        this.ensureLoaded();
        return this.testerMap.get(id);
    }

    public IBranchStyleValueProvider getValueProvider(String id) {
        this.ensureLoaded();
        return this.valueProviderMap.get(id);
    }

    private BranchPolicy getPolicy(String id) {
        return this.getPolicyMap().get(id);
    }

    @Override
    public IBranchPolicyCategoryDescriptor getBranchPolicyCategoryDescriptor(String categoryId) {
        if (categoryId != null) {
            return this.getCategoryMap().get(categoryId);
        }
        return null;
    }

    @Override
    public IBranchPolicyDescriptor getBranchPolicyDescriptor(String id) {
        return this.getPolicy(id);
    }

    @Override
    public IBranchPolicy getBranchPolicy(String id) {
        BranchPolicy policy = this.getPolicy(id);
        if (policy == null && (policy = this.getPolicy(DEFAULT_BRANCH_POLICY_ID)) == null) {
            return this.getDefaultBranchPolicy();
        }
        return policy;
    }

    @Override
    public IBranchPolicy getDefaultBranchPolicy() {
        if (this.defaultBranchPolicy == null) {
            this.defaultBranchPolicy = new DefaultBranchPolicy(this);
        }
        return this.defaultBranchPolicy;
    }

    @Override
    public String calculateBranchPolicyId(IBranchPart branch, String prefferedPolicyId) {
        BranchPolicy policy;
        String parentId;
        BranchPolicy parentPolicy;
        IBranchPart parent = branch.getParentBranch();
        if (parent != null && (parentPolicy = this.getPolicy(parentId = parent.getBranchPolicyId())) != null && parentPolicy.canOverride(BranchPolicyManager.createBranchEvaluationContext(branch))) {
            return parentId;
        }
        if (prefferedPolicyId != null && (policy = this.getPolicy(prefferedPolicyId)) != null && policy.isApplicableTo(branch)) {
            return prefferedPolicyId;
        }
        if (parent != null && parent.getSubBranches().contains(branch)) {
            return parent.getBranchPolicyId();
        }
        if (parent != null && parent.getCalloutBranches().contains(branch)) {
            return parent.getBranchPolicyId();
        }
        return DEFAULT_BRANCH_POLICY_ID;
    }

    @Override
    public List<IBranchPolicyDescriptor> getApplicableBranchPolicyDescriptors(IBranchPart branch) {
        if (branch == null) {
            return Collections.emptyList();
        }
        ArrayList<IBranchPolicyDescriptor> list = new ArrayList<IBranchPolicyDescriptor>(this.getBranchPolicyDescriptors());
        IEvaluationContext context = BranchPolicyManager.createBranchEvaluationContext(branch);
        Iterator<IBranchPolicyDescriptor> it = list.iterator();
        while (it.hasNext()) {
            if (((BranchPolicy)it.next()).isApplicableTo(context)) continue;
            it.remove();
        }
        return list;
    }

    private void ensureLoaded() {
        if (this.policyMap == null || this.policyList == null || this.structureMap == null || this.testerMap == null || this.valueProviderMap == null || this.categoryList == null || this.categoryMap == null) {
            this.lazyLoad();
        }
        if (this.policyList == null) {
            this.policyList = Collections.emptyList();
        }
        if (this.policyMap == null) {
            this.policyMap = Collections.emptyMap();
        }
        if (this.structureMap == null) {
            this.structureMap = Collections.emptyMap();
        }
        if (this.testerMap == null) {
            this.testerMap = Collections.emptyMap();
        }
        if (this.valueProviderMap == null) {
            this.valueProviderMap = Collections.emptyMap();
        }
        if (this.categoryList == null) {
            this.categoryList = Collections.emptyList();
        }
        if (this.categoryMap == null) {
            this.categoryMap = Collections.emptyMap();
        }
    }

    private void lazyLoad() {
        if (Platform.isRunning()) {
            this.readRegistry(Platform.getExtensionRegistry(), "org.xmind.ui", "branchPolicies");
        }
    }

    protected boolean readElement(IConfigurationElement element) {
        String name = element.getName();
        if ("branchPolicy".equals(name)) {
            this.readBranchPolicy(element);
            this.readElementChildren(element);
            return true;
        }
        if ("structure".equals(name)) {
            this.readStructureAlgorithm(element);
            this.readElementChildren(element);
            return true;
        }
        if ("propertyTester".equals(name)) {
            this.readPropertyTester(element);
            this.readElementChildren(element);
            return true;
        }
        if ("styleValueProvider".equals(name)) {
            this.readStyleValueProvider(element);
            this.readElementChildren(element);
            return true;
        }
        if ("additionalStructures".equals(name)) {
            this.readElementChildren(element);
            return true;
        }
        if ("additionalStructure".equals(name)) {
            this.readElementChildren(element);
            return true;
        }
        if ("branchHook".equals(name)) {
            this.readElementChildren(element);
            return true;
        }
        if ("styleSelector".equals(name)) {
            this.readElementChildren(element);
            return true;
        }
        if ("overridedStyle".equals(name)) {
            this.readElementChildren(element);
            return true;
        }
        if ("unmodifiableProperties".equals(name)) {
            this.readElementChildren(element);
            return true;
        }
        if ("unmodifiableProperty".equals(name)) {
            this.readElementChildren(element);
            return true;
        }
        if ("layer".equals(name)) {
            this.readElementChildren(element);
            return true;
        }
        if ("structureCaches".equals(name)) {
            this.readElementChildren(element);
            return true;
        }
        if ("structureCache".equals(name)) {
            this.readElementChildren(element);
            return true;
        }
        if ("override".equals(name)) {
            this.readElementChildren(element);
            return true;
        }
        if ("advisor".equals(name)) {
            this.readElementChildren(element);
            return true;
        }
        if ("enablement".equals(name)) {
            return true;
        }
        if ("branchPolicyCategory".equals(name)) {
            this.readBranchPolicyCategory(element);
            this.readElementChildren(element);
            return true;
        }
        return false;
    }

    private void readBranchPolicy(IConfigurationElement element) {
        try {
            BranchPolicy descriptor = new BranchPolicy(this, element);
            this.registerBranchPolicy(descriptor);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to load branch policy: " + element.toString());
        }
    }

    private void readStructureAlgorithm(IConfigurationElement element) {
        try {
            StructureDescriptor descriptor = new StructureDescriptor(element);
            this.registryStructureAlgorithm(descriptor);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to load structure algorithm: " + element.toString());
        }
    }

    private void readPropertyTester(IConfigurationElement element) {
        try {
            BranchPropertyTesterProxy proxy = new BranchPropertyTesterProxy(element);
            this.registerPropertyTester(proxy);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to load branch property tester: " + element.toString());
        }
    }

    private void readStyleValueProvider(IConfigurationElement element) {
        try {
            ContributedStyleValueProvider valueProvider = new ContributedStyleValueProvider(element);
            this.registerValueProvider(valueProvider);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to load style value provider: " + element.toString());
        }
    }

    private void readBranchPolicyCategory(IConfigurationElement element) {
        try {
            BranchPolicyCategoryDescriptor descriptor = new BranchPolicyCategoryDescriptor(element);
            this.registerBranchPolicyCategory(descriptor);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to load branch policy category: " + element.toString());
        }
    }

    private void registerBranchPolicy(BranchPolicy descriptor) {
        if (this.policyList == null) {
            this.policyList = new ArrayList<IBranchPolicyDescriptor>();
        }
        this.policyList.add(descriptor);
        if (this.policyMap == null) {
            this.policyMap = new HashMap<String, BranchPolicy>();
        }
        this.policyMap.put(descriptor.getId(), descriptor);
    }

    private void registryStructureAlgorithm(StructureDescriptor descriptor) {
        if (this.structureMap == null) {
            this.structureMap = new HashMap<String, StructureDescriptor>();
        }
        this.structureMap.put(descriptor.getId(), descriptor);
    }

    private void registerPropertyTester(BranchPropertyTesterProxy tester) {
        if (this.testerMap == null) {
            this.testerMap = new HashMap<String, BranchPropertyTesterProxy>();
        }
        this.testerMap.put(tester.getId(), tester);
    }

    private void registerValueProvider(ContributedStyleValueProvider valueProvider) {
        if (this.valueProviderMap == null) {
            this.valueProviderMap = new HashMap<String, ContributedStyleValueProvider>();
        }
        this.valueProviderMap.put(valueProvider.getId(), valueProvider);
    }

    private void registerBranchPolicyCategory(BranchPolicyCategoryDescriptor descriptor) {
        if (this.categoryList == null) {
            this.categoryList = new ArrayList<IBranchPolicyCategoryDescriptor>();
        }
        this.categoryList.add(descriptor);
        if (this.categoryMap == null) {
            this.categoryMap = new HashMap<String, BranchPolicyCategoryDescriptor>();
        }
        this.categoryMap.put(descriptor.getId(), descriptor);
    }

    public void readRegistry(IExtensionRegistry registry, String pluginId, String extensionPoint) {
        IExtensionPoint point = registry.getExtensionPoint(pluginId, extensionPoint);
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        if (extensions.length <= 0) {
            return;
        }
        int i = 0;
        i = 0;
        while (i < extensions.length) {
            this.readExtension(extensions[i]);
            ++i;
        }
    }
}

