// Copyright 2020-2022 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.2.0
// - protoc             (unknown)
// source: buf/alpha/registry/v1alpha1/repository_track_commit.proto

package registryv1alpha1

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

// RepositoryTrackCommitServiceClient is the client API for RepositoryTrackCommitService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type RepositoryTrackCommitServiceClient interface {
	// GetRepositoryTrackCommitByRepositoryCommit returns the RepositoryTrackCommit associated given repository_commit on
	// the given repository_track. Returns NOT_FOUND if the RepositoryTrackCommit does not exist.
	GetRepositoryTrackCommitByRepositoryCommit(ctx context.Context, in *GetRepositoryTrackCommitByRepositoryCommitRequest, opts ...grpc.CallOption) (*GetRepositoryTrackCommitByRepositoryCommitResponse, error)
	// ListRepositoryTrackCommitsByRepositoryTrack lists the RepositoryTrackCommitS associated with a repository track,
	// ordered by their sequence id.
	ListRepositoryTrackCommitsByRepositoryTrack(ctx context.Context, in *ListRepositoryTrackCommitsByRepositoryTrackRequest, opts ...grpc.CallOption) (*ListRepositoryTrackCommitsByRepositoryTrackResponse, error)
	// GetRepositoryTrackCommitByReference returns the RepositoryTrackCommit associated with the given reference.
	GetRepositoryTrackCommitByReference(ctx context.Context, in *GetRepositoryTrackCommitByReferenceRequest, opts ...grpc.CallOption) (*GetRepositoryTrackCommitByReferenceResponse, error)
}

type repositoryTrackCommitServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewRepositoryTrackCommitServiceClient(cc grpc.ClientConnInterface) RepositoryTrackCommitServiceClient {
	return &repositoryTrackCommitServiceClient{cc}
}

func (c *repositoryTrackCommitServiceClient) GetRepositoryTrackCommitByRepositoryCommit(ctx context.Context, in *GetRepositoryTrackCommitByRepositoryCommitRequest, opts ...grpc.CallOption) (*GetRepositoryTrackCommitByRepositoryCommitResponse, error) {
	out := new(GetRepositoryTrackCommitByRepositoryCommitResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.RepositoryTrackCommitService/GetRepositoryTrackCommitByRepositoryCommit", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryTrackCommitServiceClient) ListRepositoryTrackCommitsByRepositoryTrack(ctx context.Context, in *ListRepositoryTrackCommitsByRepositoryTrackRequest, opts ...grpc.CallOption) (*ListRepositoryTrackCommitsByRepositoryTrackResponse, error) {
	out := new(ListRepositoryTrackCommitsByRepositoryTrackResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.RepositoryTrackCommitService/ListRepositoryTrackCommitsByRepositoryTrack", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *repositoryTrackCommitServiceClient) GetRepositoryTrackCommitByReference(ctx context.Context, in *GetRepositoryTrackCommitByReferenceRequest, opts ...grpc.CallOption) (*GetRepositoryTrackCommitByReferenceResponse, error) {
	out := new(GetRepositoryTrackCommitByReferenceResponse)
	err := c.cc.Invoke(ctx, "/buf.alpha.registry.v1alpha1.RepositoryTrackCommitService/GetRepositoryTrackCommitByReference", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// RepositoryTrackCommitServiceServer is the server API for RepositoryTrackCommitService service.
// All implementations should embed UnimplementedRepositoryTrackCommitServiceServer
// for forward compatibility
type RepositoryTrackCommitServiceServer interface {
	// GetRepositoryTrackCommitByRepositoryCommit returns the RepositoryTrackCommit associated given repository_commit on
	// the given repository_track. Returns NOT_FOUND if the RepositoryTrackCommit does not exist.
	GetRepositoryTrackCommitByRepositoryCommit(context.Context, *GetRepositoryTrackCommitByRepositoryCommitRequest) (*GetRepositoryTrackCommitByRepositoryCommitResponse, error)
	// ListRepositoryTrackCommitsByRepositoryTrack lists the RepositoryTrackCommitS associated with a repository track,
	// ordered by their sequence id.
	ListRepositoryTrackCommitsByRepositoryTrack(context.Context, *ListRepositoryTrackCommitsByRepositoryTrackRequest) (*ListRepositoryTrackCommitsByRepositoryTrackResponse, error)
	// GetRepositoryTrackCommitByReference returns the RepositoryTrackCommit associated with the given reference.
	GetRepositoryTrackCommitByReference(context.Context, *GetRepositoryTrackCommitByReferenceRequest) (*GetRepositoryTrackCommitByReferenceResponse, error)
}

// UnimplementedRepositoryTrackCommitServiceServer should be embedded to have forward compatible implementations.
type UnimplementedRepositoryTrackCommitServiceServer struct {
}

func (UnimplementedRepositoryTrackCommitServiceServer) GetRepositoryTrackCommitByRepositoryCommit(context.Context, *GetRepositoryTrackCommitByRepositoryCommitRequest) (*GetRepositoryTrackCommitByRepositoryCommitResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRepositoryTrackCommitByRepositoryCommit not implemented")
}
func (UnimplementedRepositoryTrackCommitServiceServer) ListRepositoryTrackCommitsByRepositoryTrack(context.Context, *ListRepositoryTrackCommitsByRepositoryTrackRequest) (*ListRepositoryTrackCommitsByRepositoryTrackResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRepositoryTrackCommitsByRepositoryTrack not implemented")
}
func (UnimplementedRepositoryTrackCommitServiceServer) GetRepositoryTrackCommitByReference(context.Context, *GetRepositoryTrackCommitByReferenceRequest) (*GetRepositoryTrackCommitByReferenceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRepositoryTrackCommitByReference not implemented")
}

// UnsafeRepositoryTrackCommitServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to RepositoryTrackCommitServiceServer will
// result in compilation errors.
type UnsafeRepositoryTrackCommitServiceServer interface {
	mustEmbedUnimplementedRepositoryTrackCommitServiceServer()
}

func RegisterRepositoryTrackCommitServiceServer(s grpc.ServiceRegistrar, srv RepositoryTrackCommitServiceServer) {
	s.RegisterService(&RepositoryTrackCommitService_ServiceDesc, srv)
}

func _RepositoryTrackCommitService_GetRepositoryTrackCommitByRepositoryCommit_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRepositoryTrackCommitByRepositoryCommitRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryTrackCommitServiceServer).GetRepositoryTrackCommitByRepositoryCommit(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.RepositoryTrackCommitService/GetRepositoryTrackCommitByRepositoryCommit",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryTrackCommitServiceServer).GetRepositoryTrackCommitByRepositoryCommit(ctx, req.(*GetRepositoryTrackCommitByRepositoryCommitRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryTrackCommitService_ListRepositoryTrackCommitsByRepositoryTrack_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRepositoryTrackCommitsByRepositoryTrackRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryTrackCommitServiceServer).ListRepositoryTrackCommitsByRepositoryTrack(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.RepositoryTrackCommitService/ListRepositoryTrackCommitsByRepositoryTrack",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryTrackCommitServiceServer).ListRepositoryTrackCommitsByRepositoryTrack(ctx, req.(*ListRepositoryTrackCommitsByRepositoryTrackRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RepositoryTrackCommitService_GetRepositoryTrackCommitByReference_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRepositoryTrackCommitByReferenceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RepositoryTrackCommitServiceServer).GetRepositoryTrackCommitByReference(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/buf.alpha.registry.v1alpha1.RepositoryTrackCommitService/GetRepositoryTrackCommitByReference",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RepositoryTrackCommitServiceServer).GetRepositoryTrackCommitByReference(ctx, req.(*GetRepositoryTrackCommitByReferenceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// RepositoryTrackCommitService_ServiceDesc is the grpc.ServiceDesc for RepositoryTrackCommitService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var RepositoryTrackCommitService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "buf.alpha.registry.v1alpha1.RepositoryTrackCommitService",
	HandlerType: (*RepositoryTrackCommitServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetRepositoryTrackCommitByRepositoryCommit",
			Handler:    _RepositoryTrackCommitService_GetRepositoryTrackCommitByRepositoryCommit_Handler,
		},
		{
			MethodName: "ListRepositoryTrackCommitsByRepositoryTrack",
			Handler:    _RepositoryTrackCommitService_ListRepositoryTrackCommitsByRepositoryTrack_Handler,
		},
		{
			MethodName: "GetRepositoryTrackCommitByReference",
			Handler:    _RepositoryTrackCommitService_GetRepositoryTrackCommitByReference_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "buf/alpha/registry/v1alpha1/repository_track_commit.proto",
}
