//go:build ignore
// +build ignore

package main

import (
	"flag"
	"fmt"
	"io/ioutil"
	"os"
	"strings"
)

var (
	inputFile  = flag.String("i", "", "input file")
	outputFile = flag.String("o", "", "output file")
	constName  = flag.String("name", "stringdata", "name of Go const")
	pkgName    = flag.String("pkg", "main", "Go package name")
)

func main() {
	flag.Parse()

	if *inputFile == "" || *outputFile == "" {
		flag.Usage()
		os.Exit(1)
	}

	data, err := ioutil.ReadFile(*inputFile)
	if err != nil {
		fmt.Fprintln(os.Stderr, err)
		os.Exit(1)
	}

	output, err := os.Create(*outputFile)
	if err != nil {
		fmt.Fprintln(os.Stderr, err)
		os.Exit(1)
	}
	defer output.Close()
	fmt.Fprintln(output, "// Code generated by stringdata. DO NOT EDIT.")
	fmt.Fprintln(output)
	fmt.Fprintf(output, "package %s\n", *pkgName)
	fmt.Fprintln(output)
	fmt.Fprintf(output, "// %s is the content of the file %q.\n", *constName, *inputFile)
	fmt.Fprintf(output, "const %s = %s", *constName, backtickStringLiteral(string(data)))
	fmt.Fprintln(output)
}

func backtickStringLiteral(data string) string {
	return "`" + strings.ReplaceAll(data, "`", "` + \"`\" + `") + "`"
}
