import { type NodePath } from '@babel/traverse';
import * as t from '@babel/types';
type DefaultColorTheme = 'light' | 'legacy-light';
export default function plugin(): {
    visitor: {
        Program: {
            enter(path: NodePath<t.Program>, state: {
                opts: {
                    /**
                     * @default true
                     */
                    shouldUseAutoFallback?: boolean;
                    /**
                     * @default true
                     */
                    shouldForceAutoFallback?: boolean;
                    forceAutoFallbackExemptions?: string[];
                    defaultTheme?: DefaultColorTheme;
                };
            }): void;
            exit(path: NodePath<t.Program>): void;
        };
    };
};
export {};
