"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScheduler = useScheduler;
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _react = require("react");
var _batchUpdatesForReact = require("../utils/batch-updates-for-react-16");
var idleQueue = {
  status: 'idle'
};
function createScheduler() {
  var queue = idleQueue;
  var schedule = function schedule(callback) {
    /**
     * If the queue is currently idle (no update scheduled) then
     * we should call `setTimeout` to schedule an update.
     */
    if (queue.status === 'idle') {
      queue = {
        status: 'pending',
        timeoutId: setTimeout(flush, 0),
        items: []
      };
    }
    queue.items.push(callback);
  };
  var flush = function flush() {
    if (queue.status === 'idle') {
      return;
    }

    /**
     * Clearing the timeout optimistically in case `flush` was called directly.
     */
    clearTimeout(queue.timeoutId);
    /**
     * A shallow copy is used so that updates which queue further updates
     * are not batched together. This is to more closely match rbd.
     */
    var items = Array.from(queue.items);
    /**
     * The queue is made idle so it is ready to schedule further updates.
     */
    queue = idleQueue;

    /**
     * Scheduled callbacks are batched.
     *
     * The batching is more evident when the page is running more slowly.
     */
    (0, _batchUpdatesForReact.batchUpdatesForReact16)(function () {
      items.forEach(function (callback) {
        return callback();
      });
    });
  };
  return {
    schedule: schedule,
    flush: flush
  };
}

/**
 * Used to schedule callbacks inside of a `setTimeout(fn, 0)`.
 *
 * This is used to match the behavior and timings of `react-beautiful-dnd`.
 */
function useScheduler() {
  var _useState = (0, _react.useState)(createScheduler),
    _useState2 = (0, _slicedToArray2.default)(_useState, 1),
    scheduler = _useState2[0];
  return scheduler;
}