import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _regeneratorRuntime from "@babel/runtime/regenerator";
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
import React, { createContext, useCallback, useContext, useEffect, useRef, useState } from 'react';
import { bind } from 'bind-event-listener';
import { fg } from '@atlaskit/platform-feature-flags';
import { getGlobalTheme, setGlobalTheme, ThemeMutationObserver } from '@atlaskit/tokens';
var defaultThemeSettings = function defaultThemeSettings() {
  return {
    dark: 'dark',
    light: 'light',
    spacing: 'spacing',
    typography: fg('platform-default-typography-modernized') ? 'typography-modernized' : undefined
  };
};
var ColorModeContext = /*#__PURE__*/createContext(undefined);
var SetColorModeContext = /*#__PURE__*/createContext(undefined);
var ThemeContext = /*#__PURE__*/createContext(undefined);
var SetThemeContext = /*#__PURE__*/createContext(undefined);

/**
 * __UNSAFE_useColorModeForMigration()__
 *
 * Returns the current color mode when inside the app provider.
 * Unlike useColorMode, this utility returns undefined, instead of throwing an error, when the app provider is missing.
 * This allows it to be used by components that need to operate with and without an app provider.
 */
export function UNSAFE_useColorModeForMigration() {
  var value = useContext(ColorModeContext);
  return value;
}

/**
 * __useColorMode()__
 *
 * Returns the current color mode when inside the app provider.
 */
export function useColorMode() {
  var value = useContext(ColorModeContext);
  if (!value) {
    throw new Error('useColorMode must be used within AppProvider.');
  }
  return value;
}

/**
 * __useSetColorMode()__
 *
 * Returns the color mode setter when inside the app provider.
 */
export function useSetColorMode() {
  var value = useContext(SetColorModeContext);
  if (!value) {
    throw new Error('useSetColorMode must be used within AppProvider.');
  }
  return value;
}

/**
 * __useTheme()__
 *
 * Returns the current theme settings when inside the app provider.
 */
export function useTheme() {
  var theme = useContext(ThemeContext);
  var _useState = useState(theme || getGlobalTheme()),
    _useState2 = _slicedToArray(_useState, 2),
    resolvedTheme = _useState2[0],
    setResolvedTheme = _useState2[1];
  useEffect(function () {
    // We are using theme from context so no need to reference the DOM
    if (theme) {
      return;
    }
    var observer = new ThemeMutationObserver(setResolvedTheme);
    observer.observe();
    return function () {
      return observer.disconnect();
    };
  }, [theme]);
  return resolvedTheme;
}

/**
 * __useSetTheme()__
 *
 * Returns the theme setter when inside the app provider.
 */
export function useSetTheme() {
  var value = useContext(SetThemeContext);
  if (!value) {
    throw new Error('useSetTheme must be used within AppProvider.');
  }
  return value;
}
var isMatchMediaAvailable = typeof window !== 'undefined' && 'matchMedia' in window;
var prefersDarkModeMql = isMatchMediaAvailable ? window.matchMedia('(prefers-color-scheme: dark)') : undefined;

// TODO: currently 'auto' color mode will always return 'light' in SSR.
// Additional work required: https://product-fabric.atlassian.net/browse/DSP-9781
function getReconciledColorMode(colorMode) {
  if (colorMode === 'auto') {
    return prefersDarkModeMql !== null && prefersDarkModeMql !== void 0 && prefersDarkModeMql.matches ? 'dark' : 'light';
  }
  return colorMode;
}
/**
 * __Theme provider__
 *
 * Provides global theming configuration.
 *
 * @internal
 */
function ThemeProvider(_ref) {
  var children = _ref.children,
    defaultColorMode = _ref.defaultColorMode,
    defaultTheme = _ref.defaultTheme;
  var _useState3 = useState(defaultColorMode),
    _useState4 = _slicedToArray(_useState3, 2),
    chosenColorMode = _useState4[0],
    setChosenColorMode = _useState4[1];
  var _useState5 = useState(getReconciledColorMode(defaultColorMode)),
    _useState6 = _slicedToArray(_useState5, 2),
    reconciledColorMode = _useState6[0],
    setReconciledColorMode = _useState6[1];
  var _useState7 = useState(function () {
      return _objectSpread(_objectSpread({}, defaultThemeSettings()), defaultTheme);
    }),
    _useState8 = _slicedToArray(_useState7, 2),
    theme = _useState8[0],
    setTheme = _useState8[1];
  var setColorMode = useCallback(function (colorMode) {
    setChosenColorMode(colorMode);
    setReconciledColorMode(getReconciledColorMode(colorMode));
  }, []);
  var setPartialTheme = useCallback(function (nextTheme) {
    setTheme(function (theme) {
      return _objectSpread(_objectSpread({}, theme), nextTheme);
    });
  }, []);
  var lastSetGlobalThemePromiseRef = useRef(null);
  useEffect(function () {
    /**
     * We need to wait for any previous `setGlobalTheme` calls to finish before calling it again.
     * This is to prevent race conditions as `setGlobalTheme` is async and mutates the DOM (e.g. sets the
     * `data-color-mode` attribute on the root element).
     *
     * Since we can't safely abort the `setGlobalTheme` execution, we need to wait for it to properly finish before
     * applying the new theme.
     *
     * Without this, we can end up in the following scenario:
     * 1. app loads with the default 'light' theme, kicking off `setGlobalTheme`
     * 2. app switches to 'dark' theme after retrieving value persisted in local storage, calling `setGlobalTheme` again
     * 3. `setGlobalTheme` function execution for `dark` finishes before the initial `light` execution
     * 4. `setGlobalTheme` function execution for `light` then finishes, resulting in the 'light' theme being applied.
     */
    var cleanupLastFnCall = /*#__PURE__*/function () {
      var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
        var unbindFn;
        return _regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) switch (_context.prev = _context.next) {
            case 0:
              if (!lastSetGlobalThemePromiseRef.current) {
                _context.next = 6;
                break;
              }
              _context.next = 3;
              return lastSetGlobalThemePromiseRef.current;
            case 3:
              unbindFn = _context.sent;
              unbindFn();
              lastSetGlobalThemePromiseRef.current = null;
            case 6:
            case "end":
              return _context.stop();
          }
        }, _callee);
      }));
      return function cleanupLastFnCall() {
        return _ref2.apply(this, arguments);
      };
    }();
    var safelySetGlobalTheme = /*#__PURE__*/function () {
      var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2() {
        var promise;
        return _regeneratorRuntime.wrap(function _callee2$(_context2) {
          while (1) switch (_context2.prev = _context2.next) {
            case 0:
              _context2.next = 2;
              return cleanupLastFnCall();
            case 2:
              promise = setGlobalTheme(_objectSpread(_objectSpread({}, theme), {}, {
                colorMode: reconciledColorMode
              }));
              lastSetGlobalThemePromiseRef.current = promise;
            case 4:
            case "end":
              return _context2.stop();
          }
        }, _callee2);
      }));
      return function safelySetGlobalTheme() {
        return _ref3.apply(this, arguments);
      };
    }();
    safelySetGlobalTheme();
    return function cleanup() {
      cleanupLastFnCall();
    };
  }, [theme, reconciledColorMode]);
  useEffect(function () {
    if (!prefersDarkModeMql) {
      return;
    }
    var unbindListener = bind(prefersDarkModeMql, {
      type: 'change',
      listener: function listener(event) {
        if (chosenColorMode === 'auto') {
          setReconciledColorMode(event.matches ? 'dark' : 'light');
        }
      }
    });
    return unbindListener;
  }, [chosenColorMode]);
  return /*#__PURE__*/React.createElement(ColorModeContext.Provider, {
    value: reconciledColorMode
  }, /*#__PURE__*/React.createElement(SetColorModeContext.Provider, {
    value: setColorMode
  }, /*#__PURE__*/React.createElement(ThemeContext.Provider, {
    value: theme
  }, /*#__PURE__*/React.createElement(SetThemeContext.Provider, {
    value: setPartialTheme
  }, children))));
}
export default ThemeProvider;