## TFSA-2021-084: Division by zero in TFLite's implementation of `BatchToSpaceNd`

### CVE Number
CVE-2021-29593

### Impact
The implementation of the `BatchToSpaceNd` TFLite operator is [vulnerable to a
division by zero
error](https://github.com/tensorflow/tensorflow/blob/b5ed552fe55895aee8bd8b191f744a069957d18d/tensorflow/lite/kernels/batch_to_space_nd.cc#L81-L82):

```cc
TF_LITE_ENSURE_EQ(context, output_batch_size % block_shape[dim], 0);
output_batch_size = output_batch_size / block_shape[dim];
```

An attacker can craft a model such that one dimension of the `block` input is 0.
Hence, the corresponding value in `block_shape` is 0.

### Patches
We have patched the issue in GitHub commit
[2c74674348a4708ced58ad6eb1b23354df8ee044](https://github.com/tensorflow/tensorflow/commit/2c74674348a4708ced58ad6eb1b23354df8ee044).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
