# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class SourceIpMappingTestCase(IntegrationTestCase):

    def test_create_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.voice.v1.source_ip_mappings.create(ip_record_sid="ILXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", sip_domain_sid="SDXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")

        values = {
            'IpRecordSid': "ILXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
            'SipDomainSid': "SDXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX",
        }

        self.holodeck.assert_has_request(Request(
            'post',
            'https://voice.twilio.com/v1/SourceIpMappings',
            data=values,
        ))

    def test_create_response(self):
        self.holodeck.mock(Response(
            201,
            '''
            {
                "sid": "IBaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "ip_record_sid": "ILaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "sip_domain_sid": "SDaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2020-03-18T23:31:36Z",
                "date_updated": "2020-03-18T23:31:36Z",
                "url": "https://voice.twilio.com/v1/SourceIpMappings/IBaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.voice.v1.source_ip_mappings.create(ip_record_sid="ILXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", sip_domain_sid="SDXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.voice.v1.source_ip_mappings("IBXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://voice.twilio.com/v1/SourceIpMappings/IBXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "sid": "IBaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "ip_record_sid": "ILaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "sip_domain_sid": "SDaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "date_created": "2020-03-18T23:31:36Z",
                "date_updated": "2020-03-18T23:31:37Z",
                "url": "https://voice.twilio.com/v1/SourceIpMappings/IBaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.voice.v1.source_ip_mappings("IBXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.assertIsNotNone(actual)

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.voice.v1.source_ip_mappings.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://voice.twilio.com/v1/SourceIpMappings',
        ))

    def test_read_full_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://voice.twilio.com/v1/SourceIpMappings?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://voice.twilio.com/v1/SourceIpMappings?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "source_ip_mappings"
                },
                "source_ip_mappings": [
                    {
                        "sid": "IBaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "ip_record_sid": "ILaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "sip_domain_sid": "SDaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "date_created": "2020-03-18T23:31:36Z",
                        "date_updated": "2020-03-18T23:31:37Z",
                        "url": "https://voice.twilio.com/v1/SourceIpMappings/IBaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    }
                ]
            }
            '''
        ))

        actual = self.client.voice.v1.source_ip_mappings.list()

        self.assertIsNotNone(actual)

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://voice.twilio.com/v1/SourceIpMappings?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://voice.twilio.com/v1/SourceIpMappings?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "source_ip_mappings"
                },
                "source_ip_mappings": []
            }
            '''
        ))

        actual = self.client.voice.v1.source_ip_mappings.list()

        self.assertIsNotNone(actual)

    def test_update_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.voice.v1.source_ip_mappings("IBXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").update(sip_domain_sid="SDXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")

        values = {'SipDomainSid': "SDXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX", }

        self.holodeck.assert_has_request(Request(
            'post',
            'https://voice.twilio.com/v1/SourceIpMappings/IBXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
            data=values,
        ))

    def test_update_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "sid": "IBaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "ip_record_sid": "ILaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "sip_domain_sid": "SDaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaab",
                "date_created": "2020-03-18T23:31:36Z",
                "date_updated": "2020-03-18T23:31:37Z",
                "url": "https://voice.twilio.com/v1/SourceIpMappings/IBaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.voice.v1.source_ip_mappings("IBXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").update(sip_domain_sid="SDXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX")

        self.assertIsNotNone(actual)

    def test_delete_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.voice.v1.source_ip_mappings("IBXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").delete()

        self.holodeck.assert_has_request(Request(
            'delete',
            'https://voice.twilio.com/v1/SourceIpMappings/IBXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_delete_response(self):
        self.holodeck.mock(Response(
            204,
            None,
        ))

        actual = self.client.voice.v1.source_ip_mappings("IBXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").delete()

        self.assertTrue(actual)
