/* eslint-disable max-lines */

/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/*
* When adding names to the namespace, ensure that they are added in alphabetical order according to alias (namespace key).
*/

var ns = [];

ns.push({
	'alias': 'capitalize',
	'path': '@stdlib/string/capitalize',
	'value': require( '@stdlib/string/capitalize' ),
	'type': 'Function',
	'related': [
		'@stdlib/string/uncapitalize',
		'@stdlib/string/uppercase'
	]
});

ns.push({
	'alias': 'capitalizeKeys',
	'path': '@stdlib/utils/capitalize-keys',
	'value': require( '@stdlib/utils/capitalize-keys' ),
	'type': 'Function',
	'related': [
		'@stdlib/utils/uncapitalize-keys',
		'@stdlib/utils/uppercase-keys'
	]
});

ns.push({
	'alias': 'CATALAN',
	'path': '@stdlib/constants/float64/catalan',
	'value': require( '@stdlib/constants/float64/catalan' ),
	'type': 'number',
	'related': []
});

ns.push({
	'alias': 'CBRT_EPS',
	'path': '@stdlib/constants/float64/cbrt-eps',
	'value': require( '@stdlib/constants/float64/cbrt-eps' ),
	'type': 'number',
	'related': [
		'@stdlib/constants/float64/eps',
		'@stdlib/constants/float64/sqrt-eps'
	]
});

ns.push({
	'alias': 'CDC_NCHS_US_BIRTHS_1969_1988',
	'path': '@stdlib/datasets/cdc-nchs-us-births-1969-1988',
	'value': require( '@stdlib/datasets/cdc-nchs-us-births-1969-1988' ),
	'type': 'Function',
	'related': [
		'@stdlib/datasets/cdc-nchs-us-births-1994-2003',
		'@stdlib/datasets/ssa-us-births-2000-2014'
	]
});

ns.push({
	'alias': 'CDC_NCHS_US_BIRTHS_1994_2003',
	'path': '@stdlib/datasets/cdc-nchs-us-births-1994-2003',
	'value': require( '@stdlib/datasets/cdc-nchs-us-births-1994-2003' ),
	'type': 'Function',
	'related': [
		'@stdlib/datasets/cdc-nchs-us-births-1969-1988',
		'@stdlib/datasets/ssa-us-births-2000-2014'
	]
});

ns.push({
	'alias': 'CDC_NCHS_US_INFANT_MORTALITY_BW_1915_2013',
	'path': '@stdlib/datasets/cdc-nchs-us-infant-mortality-bw-1915-2013',
	'value': require( '@stdlib/datasets/cdc-nchs-us-infant-mortality-bw-1915-2013' ),
	'type': 'Function',
	'related': []
});

ns.push({
	'alias': 'chdir',
	'path': '@stdlib/process/chdir',
	'value': require( '@stdlib/process/chdir' ),
	'type': 'Function',
	'related': [
		'@stdlib/process/cwd'
	]
});

ns.push({
	'alias': 'chi2gof',
	'path': '@stdlib/stats/chi2gof',
	'value': require( '@stdlib/stats/chi2gof' ),
	'type': 'Function',
	'related': []
});

ns.push({
	'alias': 'chi2test',
	'path': '@stdlib/stats/chi2test',
	'value': require( '@stdlib/stats/chi2test' ),
	'type': 'Function',
	'related': []
});

ns.push({
	'alias': 'circarray2iterator',
	'path': '@stdlib/array/to-circular-iterator',
	'value': require( '@stdlib/array/to-circular-iterator' ),
	'type': 'Function',
	'related': [
		'@stdlib/array/to-iterator',
		'@stdlib/array/to-strided-iterator'
	]
});

ns.push({
	'alias': 'circularArrayStream',
	'path': '@stdlib/streams/node/from-circular-array',
	'value': require( '@stdlib/streams/node/from-circular-array' ),
	'type': 'Function',
	'related': [
		'@stdlib/streams/node/from-array',
		'@stdlib/streams/node/from-iterator',
		'@stdlib/streams/node/from-strided-array'
	]
});

ns.push({
	'alias': 'CircularBuffer',
	'path': '@stdlib/utils/circular-buffer',
	'value': require( '@stdlib/utils/circular-buffer' ),
	'type': 'Function',
	'related': [
		'@stdlib/utils/fifo',
		'@stdlib/utils/stack'
	]
});

ns.push({
	'alias': 'close',
	'path': '@stdlib/fs/close',
	'value': require( '@stdlib/fs/close' ),
	'type': 'Function',
	'related': [
		'@stdlib/fs/exists',
		'@stdlib/fs/open',
		'@stdlib/fs/read-file'
	]
});

ns.push({
	'alias': 'CMUDICT',
	'path': '@stdlib/datasets/cmudict',
	'value': require( '@stdlib/datasets/cmudict' ),
	'type': 'Function',
	'related': []
});

ns.push({
	'alias': 'codePointAt',
	'path': '@stdlib/string/code-point-at',
	'value': require( '@stdlib/string/code-point-at' ),
	'type': 'Function',
	'related': [
		'@stdlib/string/from-code-point'
	]
});

ns.push({
	'alias': 'complex',
	'path': '@stdlib/complex/cmplx',
	'value': require( '@stdlib/complex/cmplx' ),
	'type': 'Function',
	'related': [
		'@stdlib/complex/float64',
		'@stdlib/complex/float32'
	]
});

ns.push({
	'alias': 'Complex64',
	'path': '@stdlib/complex/float32',
	'value': require( '@stdlib/complex/float32' ),
	'type': 'Function',
	'related': [
		'@stdlib/complex/cmplx',
		'@stdlib/complex/float64'
	]
});

ns.push({
	'alias': 'COMPLEX64_NUM_BYTES',
	'path': '@stdlib/constants/complex64/num-bytes',
	'value': require( '@stdlib/constants/complex64/num-bytes' ),
	'type': 'number',
	'related': [
		'@stdlib/constants/complex128/num-bytes',
		'@stdlib/constants/float32/num-bytes'
	]
});

ns.push({
	'alias': 'Complex64Array',
	'path': '@stdlib/array/complex64',
	'value': require( '@stdlib/array/complex64' ),
	'type': 'Function',
	'related': [
		'@stdlib/array/complex128',
		'@stdlib/complex/cmplx',
		'@stdlib/complex/float32'
	]
});

ns.push({
	'alias': 'Complex128',
	'path': '@stdlib/complex/float64',
	'value': require( '@stdlib/complex/float64' ),
	'type': 'Function',
	'related': [
		'@stdlib/complex/cmplx',
		'@stdlib/complex/float32'
	]
});

ns.push({
	'alias': 'COMPLEX128_NUM_BYTES',
	'path': '@stdlib/constants/complex128/num-bytes',
	'value': require( '@stdlib/constants/complex128/num-bytes' ),
	'type': 'number',
	'related': [
		'@stdlib/constants/complex64/num-bytes',
		'@stdlib/constants/float64/num-bytes'
	]
});

ns.push({
	'alias': 'Complex128Array',
	'path': '@stdlib/array/complex128',
	'value': require( '@stdlib/array/complex128' ),
	'type': 'Function',
	'related': [
		'@stdlib/array/complex64',
		'@stdlib/complex/cmplx',
		'@stdlib/complex/float64'
	]
});

ns.push({
	'alias': 'compose',
	'path': '@stdlib/utils/compose',
	'value': require( '@stdlib/utils/compose' ),
	'type': 'Function',
	'related': [
		'@stdlib/utils/async/compose'
	]
});

ns.push({
	'alias': 'composeAsync',
	'path': '@stdlib/utils/async/compose',
	'value': require( '@stdlib/utils/async/compose' ),
	'type': 'Function',
	'related': [
		'@stdlib/utils/compose'
	]
});

ns.push({
	'alias': 'configdir',
	'path': '@stdlib/os/configdir',
	'value': require( '@stdlib/os/configdir' ),
	'type': 'Function',
	'related': [
		'@stdlib/os/homedir',
		'@stdlib/os/tmpdir'
	]
});

ns.push({
	'alias': 'conj',
	'path': '@stdlib/complex/conj',
	'value': require( '@stdlib/complex/conj' ),
	'type': 'Function',
	'related': [
		'@stdlib/complex/imag',
		'@stdlib/complex/real',
		'@stdlib/complex/reim'
	]
});

ns.push({
	'alias': 'constantFunction',
	'path': '@stdlib/utils/constant-function',
	'value': require( '@stdlib/utils/constant-function' ),
	'type': 'Function',
	'related': [
		'@stdlib/utils/argument-function',
		'@stdlib/utils/identity-function'
	]
});

ns.push({
	'alias': 'constantStream',
	'path': '@stdlib/streams/node/from-constant',
	'value': require( '@stdlib/streams/node/from-constant' ),
	'type': 'Function',
	'related': [
		'@stdlib/streams/node/from-array',
		'@stdlib/streams/node/from-iterator'
	]
});

ns.push({
	'alias': 'constructorName',
	'path': '@stdlib/utils/constructor-name',
	'value': require( '@stdlib/utils/constructor-name' ),
	'type': 'Function',
	'related': [
		'@stdlib/utils/function-name'
	]
});

ns.push({
	'alias': 'contains',
	'path': '@stdlib/assert/contains',
	'value': require( '@stdlib/assert/contains' ),
	'type': 'Function',
	'related': []
});

ns.push({
	'alias': 'convertArray',
	'path': '@stdlib/array/convert',
	'value': require( '@stdlib/array/convert' ),
	'type': 'Function',
	'related': [
		'@stdlib/array/convert-same'
	]
});

ns.push({
	'alias': 'convertArraySame',
	'path': '@stdlib/array/convert-same',
	'value': require( '@stdlib/array/convert-same' ),
	'type': 'Function',
	'related': [
		'@stdlib/array/convert'
	]
});

ns.push({
	'alias': 'convertPath',
	'path': '@stdlib/utils/convert-path',
	'value': require( '@stdlib/utils/convert-path' ),
	'type': 'Function',
	'related': []
});

ns.push({
	'alias': 'copy',
	'path': '@stdlib/utils/copy',
	'value': require( '@stdlib/utils/copy' ),
	'type': 'Function',
	'related': [
		'@stdlib/utils/merge'
	]
});

ns.push({
	'alias': 'copyBuffer',
	'path': '@stdlib/buffer/from-buffer',
	'value': require( '@stdlib/buffer/from-buffer' ),
	'type': 'Function',
	'related': [
		'@stdlib/buffer',
		'@stdlib/buffer/alloc',
		'@stdlib/buffer/alloc-unsafe',
		'@stdlib/buffer/ctor'
	]
});

ns.push({
	'alias': 'countBy',
	'path': '@stdlib/utils/count-by',
	'value': require( '@stdlib/utils/count-by' ),
	'type': 'Function',
	'related': [
		'@stdlib/utils/group',
		'@stdlib/utils/group-by'
	]
});

ns.push({
	'alias': 'countByAsync',
	'path': '@stdlib/utils/async/count-by',
	'value': require( '@stdlib/utils/async/count-by' ),
	'type': 'Function',
	'related': [
		'@stdlib/utils/count-by',
		'@stdlib/utils/async/group-by',
		'@stdlib/utils/async/tabulate-by'
	]
});

ns.push({
	'alias': 'curry',
	'path': '@stdlib/utils/curry',
	'value': require( '@stdlib/utils/curry' ),
	'type': 'Function',
	'related': [
		'@stdlib/utils/curry-right',
		'@stdlib/utils/uncurry',
		'@stdlib/utils/uncurry-right'
	]
});

ns.push({
	'alias': 'curryRight',
	'path': '@stdlib/utils/curry-right',
	'value': require( '@stdlib/utils/curry-right' ),
	'type': 'Function',
	'related': [
		'@stdlib/utils/curry',
		'@stdlib/utils/uncurry',
		'@stdlib/utils/uncurry-right'
	]
});

ns.push({
	'alias': 'cwd',
	'path': '@stdlib/process/cwd',
	'value': require( '@stdlib/process/cwd' ),
	'type': 'Function',
	'related': [
		'@stdlib/process/chdir'
	]
});


// EXPORTS //

module.exports = ns;
