/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.gradle.execute;

import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.openide.util.NbBundle.Messages;

/**
 *
 * @author lkishalmi
 */
public class TrustProjectPanel extends javax.swing.JPanel {

    /**
     * Creates new form TrustProjectPanel
     */
    public TrustProjectPanel() {
        this(null);
    }

    @Messages({
        "# {0} = Project name",
        "TrustProjectPanel.INFO=<html><p>NetBeans is about to invoke a Gradle build process of the project: <b>{0}</b>.</p>"
            + " <p>Executing Gradle can be potentially un-safe as it"
            + " allows arbitrary code execution.</p>",
        "TrustProjectPanel.INFO_UNKNOWN=<html><p>NetBeans is about to invoke a Gradle build process.</p>"
            + " <p>Executing Gradle can be potentially un-safe as it"
            + " allows arbitrary code execution.</p>"
    })
    public TrustProjectPanel(Project project) {
        initComponents();
        ProjectInformation info = project != null ? project.getLookup().lookup(ProjectInformation.class) : null;
        if (project == null) {
            cbTrustProject.setEnabled(false);
            cbTrustProject.setVisible(false);
        }
        if (info == null) {
            lbTrustMessage.setText(Bundle.TrustProjectPanel_INFO_UNKNOWN());
        } else {
            lbTrustMessage.setText(Bundle.TrustProjectPanel_INFO(info.getDisplayName()));
        }
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lbTrustMessage = new javax.swing.JLabel();
        cbTrustProject = new javax.swing.JCheckBox();

        lbTrustMessage.setVerticalAlignment(javax.swing.SwingConstants.TOP);

        org.openide.awt.Mnemonics.setLocalizedText(cbTrustProject, org.openide.util.NbBundle.getMessage(TrustProjectPanel.class, "TrustProjectPanel.cbTrustProject.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGap(0, 157, Short.MAX_VALUE)
                        .addComponent(cbTrustProject))
                    .addComponent(lbTrustMessage, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(lbTrustMessage, javax.swing.GroupLayout.DEFAULT_SIZE, 248, Short.MAX_VALUE)
                .addGap(18, 18, 18)
                .addComponent(cbTrustProject)
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    public boolean getTrustInFuture() {
        return cbTrustProject.isSelected();
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox cbTrustProject;
    private javax.swing.JLabel lbTrustMessage;
    // End of variables declaration//GEN-END:variables
}
