/**
 * @file  NbioDefaults.h
 * @brief This file contains the Nbio default configurations
 *
 */
/* Copyright 2022-2023 Advanced Micro Devices, Inc. All rights reserved.    */
// SPDX-License-Identifier: MIT

#pragma once

#define NBIO_PPR_INIT_VALUES_TBL \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_728, \
    SIL_RESERVED_77, \
    0x0 << SIL_RESERVED_78 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_728, \
    SIL_RESERVED_76, \
    0x0 << IOAGR_GLUE_CG_LCLK_CTRL_0_SOFT_OVERRIDE_CLK8_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_728, \
    SIL_RESERVED_74, \
    0x0 << SIL_RESERVED_75 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_728, \
    SIL_RESERVED_72, \
    0x0 << SIL_RESERVED_73 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_728, \
    SIL_RESERVED_70, \
    0x0 << SIL_RESERVED_71 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_728, \
    SIL_RESERVED_68, \
    0x0 << SIL_RESERVED_69 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_728, \
    SIL_RESERVED_66, \
    0x0 << SIL_RESERVED_67 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_728, \
    IOAGR_GLUE_CG_LCLK_CTRL_0_SOFT_OVERRIDE_CLK2_MASK, \
    0x0 << SIL_RESERVED_65 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_728, \
    IOAGR_GLUE_CG_LCLK_CTRL_0_SOFT_OVERRIDE_CLK1_MASK, \
    0x0 << SIL_RESERVED_64 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_728, \
    SIL_RESERVED_62, \
    0x0 << SIL_RESERVED_63  \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_729, \
    IOAGR_GLUE_CG_LCLK_CTRL_1_SOFT_OVERRIDE_CLK9_MASK, \
    0x0 << SIL_RESERVED_93 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_729, \
    SIL_RESERVED_91, \
    0x0 << SIL_RESERVED_92 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_729, \
    IOAGR_GLUE_CG_LCLK_CTRL_1_SOFT_OVERRIDE_CLK7_MASK, \
    0x0 << SIL_RESERVED_90 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_729, \
    SIL_RESERVED_88, \
    0x0 << SIL_RESERVED_89 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_729, \
    IOAGR_GLUE_CG_LCLK_CTRL_1_SOFT_OVERRIDE_CLK5_MASK, \
    0x0 << SIL_RESERVED_87 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_729, \
    SIL_RESERVED_85, \
    0x0 << SIL_RESERVED_86 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_729, \
    SIL_RESERVED_83, \
    0x0 << SIL_RESERVED_84 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_729, \
    SIL_RESERVED_81, \
    0x0 << SIL_RESERVED_82 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_729, \
    IOAGR_GLUE_CG_LCLK_CTRL_1_SOFT_OVERRIDE_CLK1_MASK, \
    0x0 << SIL_RESERVED_80 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_729, \
    IOAGR_GLUE_CG_LCLK_CTRL_1_SOFT_OVERRIDE_CLK0_MASK, \
    0x0 << SIL_RESERVED_79 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_731, \
    SIL_RESERVED_113, \
    0x0 << SIL_RESERVED_114 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_731, \
    SIL_RESERVED_111, \
    0x0 << SIL_RESERVED_112 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_731, \
    SIL_RESERVED_109, \
    0x0 << SIL_RESERVED_110 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_731, \
    SIL_RESERVED_107, \
    0x0 << SIL_RESERVED_108 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_731, \
    SIL_RESERVED_105, \
    0x0 << SIL_RESERVED_106 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_731, \
    SIL_RESERVED_103, \
    0x0 << SIL_RESERVED_104 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_731, \
    SIL_RESERVED_101, \
    0x0 << SIL_RESERVED_102 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_731, \
    IOAPIC_GLUE_CG_LCLK_CTRL_0_SOFT_OVERRIDE_CLK2_MASK, \
    0x0 << SIL_RESERVED_100 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_731, \
    SIL_RESERVED_98, \
    0x0 << SIL_RESERVED_99 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_731, \
    SIL_RESERVED_96, \
    0x0 << SIL_RESERVED_97 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_732, \
    SIL_RESERVED_154, \
    0x0 << SIL_RESERVED_155 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_732, \
    SIL_RESERVED_152, \
    0x0 << SIL_RESERVED_153 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_732, \
    IOHC_GLUE_CG_LCLK_CTRL_0_SOFT_OVERRIDE_CLK7_MASK, \
    0x0 << SIL_RESERVED_151 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_732, \
    SIL_RESERVED_149, \
    0x0 << SIL_RESERVED_150 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_732, \
    SIL_RESERVED_147, \
    0x0 << SIL_RESERVED_148 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_732, \
    SIL_RESERVED_145, \
    0x0 << SIL_RESERVED_146 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_732, \
    SIL_RESERVED_143, \
    0x0 << SIL_RESERVED_144 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_732, \
    SIL_RESERVED_141, \
    0x0 << SIL_RESERVED_142 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_732, \
    SIL_RESERVED_139, \
    0x0 << SIL_RESERVED_140 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_732, \
    SIL_RESERVED_137, \
    0x0 << SIL_RESERVED_138 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_733, \
    SIL_RESERVED_172, \
    0x0 << IOHC_GLUE_CG_LCLK_CTRL_1_SOFT_OVERRIDE_CLK9_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_733, \
    SIL_RESERVED_170, \
    0x0 << SIL_RESERVED_171 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_733, \
    SIL_RESERVED_168, \
    0x0 << SIL_RESERVED_169 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_733, \
    SIL_RESERVED_166, \
    0x0 << SIL_RESERVED_167 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_733, \
    SIL_RESERVED_164, \
    0x0 << SIL_RESERVED_165 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_733, \
    SIL_RESERVED_162, \
    0x0 << SIL_RESERVED_163 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_733, \
    SIL_RESERVED_160, \
    0x0 << SIL_RESERVED_161 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_733, \
    SIL_RESERVED_158, \
    0x0 << SIL_RESERVED_159 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_733, \
    SIL_RESERVED_157, \
    0x0 << SIL_RESERVED_177 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_733, \
    IOHC_GLUE_CG_LCLK_CTRL_1_SOFT_OVERRIDE_CLK0_MASK, \
    0x0 << SIL_RESERVED_156 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_734, \
    SIL_RESERVED_189, \
    0x0 << SIL_RESERVED_190 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_734, \
    SIL_RESERVED_187, \
    0x0 << SIL_RESERVED_188 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_734, \
    IOHC_GLUE_CG_LCLK_CTRL_2_SOFT_OVERRIDE_CLK7_MASK, \
    0x0 << SIL_RESERVED_186 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_734, \
    SIL_RESERVED_185, \
    0x0 << IOHC_GLUE_CG_LCLK_CTRL_2_SOFT_OVERRIDE_CLK6_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_734, \
    SIL_RESERVED_183, \
    0x0 << SIL_RESERVED_184 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_734, \
    SIL_RESERVED_181, \
    0x0 << SIL_RESERVED_182 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_734, \
    SIL_RESERVED_179, \
    0x0 << SIL_RESERVED_180 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_734, \
    IOHC_GLUE_CG_LCLK_CTRL_2_SOFT_OVERRIDE_CLK2_MASK, \
    0x0 << SIL_RESERVED_178 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_734, \
    SIL_RESERVED_175, \
    0x0 << SIL_RESERVED_176 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_734, \
    SIL_RESERVED_173, \
    0x0 << SIL_RESERVED_174 \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOHUB0NBIO0_IOHC_PCIE_CRS_Count_ADDRESS, \
    IOHC_PCIE_CRS_Count_CrsDelayCount_MASK, \
    0x6 << IOHC_PCIE_CRS_Count_CrsDelayCount_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_737, \
    SIL_RESERVED_206, \
    0x1 << SIL_RESERVED_208 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_737, \
    SIL_RESERVED_207, \
    0x0 << SIL_RESERVED_209 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_737, \
    SIL_RESERVED_210, \
    0x0 << SIL_RESERVED_211 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_536, \
    SIL_RESERVED_121, \
    0x0 << SIL_RESERVED_122 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_536, \
    SIL_RESERVED_123, \
    0x0 << SIL_RESERVED_124 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_536, \
    SIL_RESERVED_125, \
    0x0 << SIL_RESERVED_126 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_536, \
    SIL_RESERVED_127, \
    0x0 << SIL_RESERVED_128 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_536, \
    SIL_RESERVED_129, \
    0x0 << SIL_RESERVED_130 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_536, \
    SIL_RESERVED_131, \
    0x0 << SIL_RESERVED_132 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_536, \
    SIL_RESERVED_133, \
    0x0 << SIL_RESERVED_134 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_536, \
    SIL_RESERVED_135, \
    0x0 << SIL_RESERVED_136 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_740, \
    POISON_ACTION_CONTROL_IntPoisonAPMLErrEn_MASK, \
    0x1 << SIL_RESERVED_444 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_740, \
    SIL_RESERVED_445, \
    0x1 << SIL_RESERVED_446 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_740, \
    SIL_RESERVED_447, \
    0x1 << SIL_RESERVED_448 \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOAGR_IOHUB0NBIO0_L1_CLKCNTRL_0_ADDRESS, \
    L1_CLKCNTRL_0_L1_DMA_CLKGATE_EN_MASK, \
    0x1 << L1_CLKCNTRL_0_L1_DMA_CLKGATE_EN_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOAGR_IOHUB0NBIO0_L1_CLKCNTRL_0_ADDRESS, \
    L1_CLKCNTRL_0_L1_CACHE_CLKGATE_EN_MASK, \
    0x1 << L1_CLKCNTRL_0_L1_CACHE_CLKGATE_EN_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOAGR_IOHUB0NBIO0_L1_CLKCNTRL_0_ADDRESS, \
    L1_CLKCNTRL_0_L1_CPSLV_CLKGATE_EN_MASK, \
    0x1 << L1_CLKCNTRL_0_L1_CPSLV_CLKGATE_EN_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOAGR_IOHUB0NBIO0_L1_CLKCNTRL_0_ADDRESS, \
    L1_CLKCNTRL_0_L1_PERF_CLKGATE_EN_MASK, \
    0x1 << L1_CLKCNTRL_0_L1_PERF_CLKGATE_EN_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOAGR_IOHUB0NBIO0_L1_CLKCNTRL_0_ADDRESS, \
    L1_CLKCNTRL_0_L1_MEMORY_CLKGATE_EN_MASK, \
    0x1 << L1_CLKCNTRL_0_L1_MEMORY_CLKGATE_EN_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOAGR_IOHUB0NBIO0_L1_CLKCNTRL_0_ADDRESS, \
    L1_CLKCNTRL_0_L1_REG_CLKGATE_EN_MASK, \
    0x1 << L1_CLKCNTRL_0_L1_REG_CLKGATE_EN_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOAGR_IOHUB0NBIO0_L1_CLKCNTRL_0_ADDRESS, \
    L1_CLKCNTRL_0_L1_HOSTREQ_CLKGATE_EN_MASK, \
    0x1 << L1_CLKCNTRL_0_L1_HOSTREQ_CLKGATE_EN_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOAGR_IOHUB0NBIO0_L1_CLKCNTRL_0_ADDRESS, \
    L1_CLKCNTRL_0_L1_DMARSP_CLKGATE_EN_MASK, \
    0x1 << L1_CLKCNTRL_0_L1_DMARSP_CLKGATE_EN_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOAGR_IOHUB0NBIO0_L1_CLKCNTRL_0_ADDRESS, \
    L1_CLKCNTRL_0_L1_HOSTRSP_CLKGATE_EN_MASK, \
    0x1 << L1_CLKCNTRL_0_L1_HOSTRSP_CLKGATE_EN_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOAGR_IOHUB0NBIO0_L1_CLKCNTRL_0_ADDRESS, \
    L1_CLKCNTRL_0_L1_SION_PERF_CLKGATE_EN_MASK, \
    0x1 << L1_CLKCNTRL_0_L1_SION_PERF_CLKGATE_EN_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOAGR_IOHUB0NBIO0_L1_CLKCNTRL_0_ADDRESS, \
    L1_CLKCNTRL_0_L1_CLKGATE_HYSTERESIS_MASK, \
    0x20 << L1_CLKCNTRL_0_L1_CLKGATE_HYSTERESIS_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOAGR_IOHUB0NBIO0_L1_CLKCNTRL_0_ADDRESS, \
    L1_CLKCNTRL_0_L1_L2_CLKGATE_EN_MASK, \
    0x1 << L1_CLKCNTRL_0_L1_L2_CLKGATE_EN_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOHUB0NBIO0_L2_L2A_CK_GATE_CONTROL_ADDRESS, \
    L2_L2A_CK_GATE_CONTROL_CKGateL2ARegsDisable_MASK, \
    0x0 << L2_L2A_CK_GATE_CONTROL_CKGateL2ARegsDisable_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOHUB0NBIO0_L2_L2A_CK_GATE_CONTROL_ADDRESS, \
    L2_L2A_CK_GATE_CONTROL_CKGateL2ADynamicDisable_MASK, \
    0x0 << L2_L2A_CK_GATE_CONTROL_CKGateL2ADynamicDisable_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOHUB0NBIO0_L2_L2A_CK_GATE_CONTROL_ADDRESS, \
    L2_L2A_CK_GATE_CONTROL_CKGateL2ACacheDisable_MASK, \
    0x0 << L2_L2A_CK_GATE_CONTROL_CKGateL2ACacheDisable_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOHUB0NBIO0_L2_L2B_CK_GATE_CONTROL_ADDRESS, \
    L2_L2B_CK_GATE_CONTROL_CKGateL2BRegsDisable_MASK, \
    0x0 << L2_L2B_CK_GATE_CONTROL_CKGateL2BRegsDisable_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOHUB0NBIO0_L2_L2B_CK_GATE_CONTROL_ADDRESS, \
    L2_L2B_CK_GATE_CONTROL_CKGateL2BDynamicDisable_MASK, \
    0x0 << L2_L2B_CK_GATE_CONTROL_CKGateL2BDynamicDisable_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOHUB0NBIO0_L2_L2B_CK_GATE_CONTROL_ADDRESS, \
    L2_L2B_CK_GATE_CONTROL_CKGateL2BMiscDisable_MASK, \
    0x0 << L2_L2B_CK_GATE_CONTROL_CKGateL2BMiscDisable_OFFSET \
    ), \
  SMN_ENTRY_RMW ( \
    SMN_IOHUB0NBIO0_L2_L2B_CK_GATE_CONTROL_ADDRESS, \
    L2_L2B_CK_GATE_CONTROL_CKGateL2BCacheDisable_MASK, \
    0x0 << L2_L2B_CK_GATE_CONTROL_CKGateL2BCacheDisable_OFFSET \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1322, \
    SIL_RESERVED2_1062, \
    0x1 << SIL_RESERVED2_1063 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1322, \
    SIL_RESERVED2_1062, \
    0x1 << SIL_RESERVED2_1063 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF2, \
    SIL_RESERVED2_1422, \
    SIL_RESERVED2_1062, \
    0x1 << SIL_RESERVED2_1063 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1322, \
    SIL_RESERVED2_1064, \
    0x0 << SIL_RESERVED2_1065 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1322, \
    SIL_RESERVED2_1064, \
    0x0 << SIL_RESERVED2_1065 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF2, \
    SIL_RESERVED2_1422, \
    SIL_RESERVED2_1064, \
    0x0 << SIL_RESERVED2_1065 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1322, \
    SIL_RESERVED2_1060, \
    0x0 << SIL_RESERVED2_1061 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1322, \
    SIL_RESERVED2_1060, \
    0x0 << SIL_RESERVED2_1061 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF2, \
    SIL_RESERVED2_1422, \
    SIL_RESERVED2_1060, \
    0x0 << SIL_RESERVED2_1061 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1322, \
    SIL_RESERVED2_1068, \
    0x0 << SIL_RESERVED2_1069 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1322, \
    SIL_RESERVED2_1068, \
    0x0 << SIL_RESERVED2_1069 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF2, \
    SIL_RESERVED2_1422, \
    SIL_RESERVED2_1068, \
    0x0 << SIL_RESERVED2_1069 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1322, \
    SIL_RESERVED3_1467, \
    0x0 << SIL_RESERVED2_1059 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1322, \
    SIL_RESERVED3_1467, \
    0x0 << SIL_RESERVED2_1059 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF2, \
    SIL_RESERVED2_1422, \
    SIL_RESERVED3_1467, \
    0x0 << SIL_RESERVED2_1059 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED3_1503, \
    SIL_RESERVED3_1502, \
    0x1 << SIL_RESERVED2_1084 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_SST, \
    SIL_RESERVED_758, \
    SIL_RESERVED_484, \
    0x1 << SIL_RESERVED_485 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_SST, \
    SIL_RESERVED_759, \
    SIL_RESERVED_766, \
    0x1 << SIL_RESERVED_767 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_SST, \
    SIL_RESERVED_759, \
    SIL_RESERVED_762, \
    0xf0 << SIL_RESERVED_763 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_SST, \
    SIL_RESERVED_759, \
    SIL_RESERVED_764, \
    0x1 << SIL_RESERVED_765 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED3_1512, \
    0x0 << SIL_RESERVED3_1511 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED3_1512, \
    0x0 << SIL_RESERVED3_1511 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_969, \
    0x0 << SIL_RESERVED3_1513 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_969, \
    0x0 << SIL_RESERVED3_1513 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_971, \
    0x0 << SIL_RESERVED3_1514 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_971, \
    0x0 << SIL_RESERVED3_1514 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_973, \
    0x0 << SIL_RESERVED3_1515 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_973, \
    0x0 << SIL_RESERVED3_1515 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED3_1517, \
    0x0 << SIL_RESERVED3_1516 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED3_1517, \
    0x0 << SIL_RESERVED3_1516 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_976, \
    0x0 << SIL_RESERVED3_1518 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_976, \
    0x0 << SIL_RESERVED3_1518 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_978, \
    0x0 << SIL_RESERVED3_1519 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_978, \
    0x0 << SIL_RESERVED3_1519 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_980, \
    0x0 << SIL_RESERVED2_981 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_980, \
    0x0 << SIL_RESERVED2_981 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_982, \
    0x0 << SIL_RESERVED2_983 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_982, \
    0x0 << SIL_RESERVED2_983 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_984, \
    0x0 << SIL_RESERVED2_985 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_984, \
    0x0 << SIL_RESERVED2_985 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_986, \
    0x0 << SIL_RESERVED3_1520 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_986, \
    0x0 << SIL_RESERVED3_1520 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_987, \
    0x0 << SIL_RESERVED3_1521 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_987, \
    0x0 << SIL_RESERVED3_1521 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_988, \
    0x0 << SIL_RESERVED2_989 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_988, \
    0x0 << SIL_RESERVED2_989 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_990, \
    0x0 << SIL_RESERVED2_991 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1,\
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_990, \
    0x0 << SIL_RESERVED2_991 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0,\
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_992, \
    0x0 << SIL_RESERVED2_993 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_992, \
    0x0 << SIL_RESERVED2_993 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_994, \
    0x0 << SIL_RESERVED3_1522 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_994, \
    0x0 << SIL_RESERVED3_1522 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_995, \
    0x0 << SIL_RESERVED2_996 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_995, \
    0x0 << SIL_RESERVED2_996 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_997, \
    0x0 << SIL_RESERVED2_998 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_997, \
    0x0 << SIL_RESERVED2_998 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_999, \
    0x0 << SIL_RESERVED2_1000  \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED2_999, \
    0x0 << SIL_RESERVED2_1000  \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED3_1523, \
    0x0 << SIL_RESERVED2_1001  \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1317, \
    SIL_RESERVED3_1523, \
    0x0 << SIL_RESERVED2_1001  \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1033, \
    0x0 << SIL_RESERVED2_1034 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1033, \
    0x0 << SIL_RESERVED2_1034 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1035, \
    0x0 << SIL_RESERVED2_1036 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1035, \
    0x0 << SIL_RESERVED2_1036 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED3_1524, \
    0x0 << SIL_RESERVED2_1037 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED3_1524, \
    0x0 << SIL_RESERVED2_1037 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1038, \
    0x0 << SIL_RESERVED3_1525 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1038, \
    0x0 << SIL_RESERVED3_1525 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED3_1526, \
    0x0 << SIL_RESERVED2_1039 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED3_1526, \
    0x0 << SIL_RESERVED2_1039 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED3_1528, \
    0x0 << SIL_RESERVED3_1527 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED3_1528, \
    0x0 << SIL_RESERVED3_1527 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1040, \
    0x0 << SIL_RESERVED2_1041 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1040, \
    0x0 << SIL_RESERVED2_1041 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1042, \
    0x0 << SIL_RESERVED2_1043 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1042, \
    0x0 << SIL_RESERVED2_1043 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1044, \
    0x0 << SIL_RESERVED2_1045 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1044, \
    0x0 << SIL_RESERVED2_1045 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1046, \
    0x0 << SIL_RESERVED2_1047 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1046, \
    0x0 << SIL_RESERVED2_1047 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED3_1529, \
    0x0 << SIL_RESERVED2_1048 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED3_1529, \
    0x0 << SIL_RESERVED2_1048 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1049, \
    0x0 << SIL_RESERVED2_1050 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1049, \
    0x0 << SIL_RESERVED2_1050 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED3_1530, \
    0x0 << SIL_RESERVED2_1051 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED3_1530, \
    0x0 << SIL_RESERVED2_1051 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED3_1531, \
    0x0 << SIL_RESERVED2_1052 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED3_1531, \
    0x0 << SIL_RESERVED2_1052 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED3_1533, \
    0x0 << SIL_RESERVED3_1532 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED3_1533, \
    0x0 << SIL_RESERVED3_1532 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED3_1534, \
    0x0 << SIL_RESERVED2_1053 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED3_1534, \
    0x0 << SIL_RESERVED2_1053 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1054, \
    0x0 << SIL_RESERVED3_1535 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1054, \
    0x0 << SIL_RESERVED3_1535 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED3_1536, \
    0x0 << SIL_RESERVED2_1055 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED3_1536, \
    0x0 << SIL_RESERVED2_1055 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1056, \
    0x0 << SIL_RESERVED2_1057 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1056, \
    0x0 << SIL_RESERVED2_1057 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1058, \
    0x0 << SIL_RESERVED3_1537 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1321, \
    SIL_RESERVED2_1058, \
    0x0 << SIL_RESERVED3_1537 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1324, \
    SIL_RESERVED2_1080, \
    0x1 << SIL_RESERVED2_1081 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF1, \
    SIL_RESERVED2_1324, \
    SIL_RESERVED2_1080, \
    0x1 << SIL_RESERVED2_1081 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED2_1257, \
    0x0 << SIL_RESERVED2_1258 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED2_1257, \
    0x0 << SIL_RESERVED2_1258 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED2_1259, \
    0x0 << SIL_RESERVED3_1538 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED2_1259, \
    0x0 << SIL_RESERVED3_1538 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED2_1260, \
    0x0 << SIL_RESERVED2_1261 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED2_1260, \
    0x0 << SIL_RESERVED2_1261 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED2_1262, \
    0x0 << SIL_RESERVED2_1263 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED2_1262, \
    0x0 << SIL_RESERVED2_1263 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED2_1264, \
    0x0 << SIL_RESERVED2_1265 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED2_1264, \
    0x0 << SIL_RESERVED2_1265 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED2_1266, \
    0x0 << SIL_RESERVED2_1267 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED2_1266, \
    0x0 << SIL_RESERVED2_1267 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED2_1268, \
    0x0 << SIL_RESERVED2_1269 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED2_1268, \
    0x0 << SIL_RESERVED2_1269 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED3_1539, \
    0x0 << SIL_RESERVED2_1270 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED3_1539, \
    0x0 << SIL_RESERVED2_1270 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED2_1271, \
    0x0 << SIL_RESERVED2_1272 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED2_1271, \
    0x0 << SIL_RESERVED2_1272 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED2_1273, \
    0x0 << SIL_RESERVED2_1274 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED2_1273, \
    0x0 << SIL_RESERVED2_1274 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED2_1275, \
    0x0 << SIL_RESERVED2_1276 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED2_1275, \
    0x0 << SIL_RESERVED2_1276 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED2_1277, \
    0x0 << SIL_RESERVED2_1278 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED2_1277, \
    0x0 << SIL_RESERVED2_1278 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED2_1279, \
    0x0 << SIL_RESERVED2_1280 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED2_1279, \
    0x0 << SIL_RESERVED2_1280 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED3_1540, \
    0x0 << SIL_RESERVED2_1281 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED3_1540, \
    0x0 << SIL_RESERVED2_1281 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED2_1282, \
    0x0 << SIL_RESERVED2_1283 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED2_1282, \
    0x0 << SIL_RESERVED2_1283 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED2_1284, \
    0x0 << SIL_RESERVED2_1285 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED2_1284, \
    0x0 << SIL_RESERVED2_1285 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED2_1286, \
    0x0 << SIL_RESERVED2_1287 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED2_1286, \
    0x0 << SIL_RESERVED2_1287 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED3_1541, \
    0x0 << SIL_RESERVED2_1288 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED3_1541, \
    0x0 << SIL_RESERVED2_1288 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED2_1289, \
    0x0 << SIL_RESERVED2_1290 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED2_1289, \
    0x0 << SIL_RESERVED2_1290 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED3_1542, \
    SIL_RESERVED2_1291, \
    0x0 << SIL_RESERVED2_1292 \
    ), \
  SMN_ENTRY_PROPERTY_RMW ( \
    PROPERTY_PRESENT_NBIF0, \
    SIL_RESERVED2_1416, \
    SIL_RESERVED2_1291, \
    0x0 << SIL_RESERVED2_1292 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED2_1366, \
    SIL_RESERVED2_1457, \
    0x1 << SIL_RESERVED2_1458 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED2_1366, \
    SIL_RESERVED2_1457, \
    0x1 << SIL_RESERVED2_1458 \
    ), \
  SMN_ENTRY_RMW ( \
    SIL_RESERVED_739, \
    SIL_RESERVED_219, \
    0x1 << SIL_RESERVED_220 \
    ), \

