# Copyright (c) 2024-2026, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0

import _cython_3_1_4
import enum
from typing import Any, Callable, ClassVar

__pyx_capi__: dict
__test__: dict
block_sparse_contract: _cython_3_1_4.cython_function_or_method
check_status: _cython_3_1_4.cython_function_or_method
contract: _cython_3_1_4.cython_function_or_method
contract_trinary: _cython_3_1_4.cython_function_or_method
create: _cython_3_1_4.cython_function_or_method
create_block_sparse_contraction: _cython_3_1_4.cython_function_or_method
create_block_sparse_tensor_descriptor: _cython_3_1_4.cython_function_or_method
create_contraction: _cython_3_1_4.cython_function_or_method
create_contraction_trinary: _cython_3_1_4.cython_function_or_method
create_elementwise_binary: _cython_3_1_4.cython_function_or_method
create_elementwise_trinary: _cython_3_1_4.cython_function_or_method
create_permutation: _cython_3_1_4.cython_function_or_method
create_plan: _cython_3_1_4.cython_function_or_method
create_plan_preference: _cython_3_1_4.cython_function_or_method
create_reduction: _cython_3_1_4.cython_function_or_method
create_tensor_descriptor: _cython_3_1_4.cython_function_or_method
destroy: _cython_3_1_4.cython_function_or_method
destroy_block_sparse_tensor_descriptor: _cython_3_1_4.cython_function_or_method
destroy_operation_descriptor: _cython_3_1_4.cython_function_or_method
destroy_plan: _cython_3_1_4.cython_function_or_method
destroy_plan_preference: _cython_3_1_4.cython_function_or_method
destroy_tensor_descriptor: _cython_3_1_4.cython_function_or_method
elementwise_binary_execute: _cython_3_1_4.cython_function_or_method
elementwise_trinary_execute: _cython_3_1_4.cython_function_or_method
estimate_workspace_size: _cython_3_1_4.cython_function_or_method
get_cudart_version: _cython_3_1_4.cython_function_or_method
get_error_string: _cython_3_1_4.cython_function_or_method
get_operation_descriptor_attribute_dtype: _cython_3_1_4.cython_function_or_method
get_plan_attribute_dtype: _cython_3_1_4.cython_function_or_method
get_plan_preference_attribute_dtype: _cython_3_1_4.cython_function_or_method
get_version: _cython_3_1_4.cython_function_or_method
handle_read_plan_cache_from_file: _cython_3_1_4.cython_function_or_method
handle_resize_plan_cache: _cython_3_1_4.cython_function_or_method
handle_write_plan_cache_to_file: _cython_3_1_4.cython_function_or_method
logger_force_disable: _cython_3_1_4.cython_function_or_method
logger_open_file: _cython_3_1_4.cython_function_or_method
logger_set_file: _cython_3_1_4.cython_function_or_method
logger_set_level: _cython_3_1_4.cython_function_or_method
logger_set_mask: _cython_3_1_4.cython_function_or_method
operation_descriptor_get_attribute: _cython_3_1_4.cython_function_or_method
operation_descriptor_set_attribute: _cython_3_1_4.cython_function_or_method
permute: _cython_3_1_4.cython_function_or_method
plan_get_attribute: _cython_3_1_4.cython_function_or_method
plan_preference_set_attribute: _cython_3_1_4.cython_function_or_method
read_kernel_cache_from_file: _cython_3_1_4.cython_function_or_method
reduce: _cython_3_1_4.cython_function_or_method
write_kernel_cache_to_file: _cython_3_1_4.cython_function_or_method

class Algo(enum.IntEnum):
    """See `cutensorAlgo_t`."""
    __new__: ClassVar[Callable] = ...
    DEFAULT: ClassVar[Algo] = ...
    DEFAULT_PATIENT: ClassVar[Algo] = ...
    GETT: ClassVar[Algo] = ...
    TGETT: ClassVar[Algo] = ...
    TTGT: ClassVar[Algo] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class AutotuneMode(enum.IntEnum):
    """See `cutensorAutotuneMode_t`."""
    __new__: ClassVar[Callable] = ...
    INCREMENTAL: ClassVar[AutotuneMode] = ...
    NONE: ClassVar[AutotuneMode] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class CacheMode(enum.IntEnum):
    """See `cutensorCacheMode_t`."""
    __new__: ClassVar[Callable] = ...
    NONE: ClassVar[CacheMode] = ...
    PEDANTIC: ClassVar[CacheMode] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class ComputeDesc:
    """See `cutensorComputeDescriptor_t`."""
    COMPUTE_16BF: ClassVar[method] = ...
    COMPUTE_16F: ClassVar[method] = ...
    COMPUTE_32F: ClassVar[method] = ...
    COMPUTE_3XTF32: ClassVar[method] = ...
    COMPUTE_64F: ClassVar[method] = ...
    COMPUTE_TF32: ClassVar[method] = ...

class JitMode(enum.IntEnum):
    """See `cutensorJitMode_t`."""
    __new__: ClassVar[Callable] = ...
    DEFAULT: ClassVar[JitMode] = ...
    NONE: ClassVar[JitMode] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class OperationDescriptorAttribute(enum.IntEnum):
    """See `cutensorOperationDescriptorAttribute_t`."""
    __new__: ClassVar[Callable] = ...
    FLOPS: ClassVar[OperationDescriptorAttribute] = ...
    MOVED_BYTES: ClassVar[OperationDescriptorAttribute] = ...
    PADDING_LEFT: ClassVar[OperationDescriptorAttribute] = ...
    PADDING_RIGHT: ClassVar[OperationDescriptorAttribute] = ...
    PADDING_VALUE: ClassVar[OperationDescriptorAttribute] = ...
    SCALAR_TYPE: ClassVar[OperationDescriptorAttribute] = ...
    TAG: ClassVar[OperationDescriptorAttribute] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class Operator(enum.IntEnum):
    """See `cutensorOperator_t`."""
    __new__: ClassVar[Callable] = ...
    OP_ABS: ClassVar[Operator] = ...
    OP_ACOS: ClassVar[Operator] = ...
    OP_ACOSH: ClassVar[Operator] = ...
    OP_ADD: ClassVar[Operator] = ...
    OP_ASIN: ClassVar[Operator] = ...
    OP_ASINH: ClassVar[Operator] = ...
    OP_ATAN: ClassVar[Operator] = ...
    OP_ATANH: ClassVar[Operator] = ...
    OP_CEIL: ClassVar[Operator] = ...
    OP_CONJ: ClassVar[Operator] = ...
    OP_COS: ClassVar[Operator] = ...
    OP_COSH: ClassVar[Operator] = ...
    OP_EXP: ClassVar[Operator] = ...
    OP_FLOOR: ClassVar[Operator] = ...
    OP_IDENTITY: ClassVar[Operator] = ...
    OP_LOG: ClassVar[Operator] = ...
    OP_MAX: ClassVar[Operator] = ...
    OP_MIN: ClassVar[Operator] = ...
    OP_MISH: ClassVar[Operator] = ...
    OP_MUL: ClassVar[Operator] = ...
    OP_NEG: ClassVar[Operator] = ...
    OP_RCP: ClassVar[Operator] = ...
    OP_RELU: ClassVar[Operator] = ...
    OP_SIGMOID: ClassVar[Operator] = ...
    OP_SIN: ClassVar[Operator] = ...
    OP_SINH: ClassVar[Operator] = ...
    OP_SOFT_PLUS: ClassVar[Operator] = ...
    OP_SOFT_SIGN: ClassVar[Operator] = ...
    OP_SQRT: ClassVar[Operator] = ...
    OP_SWISH: ClassVar[Operator] = ...
    OP_TAN: ClassVar[Operator] = ...
    OP_TANH: ClassVar[Operator] = ...
    OP_UNKNOWN: ClassVar[Operator] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class PlanAttribute(enum.IntEnum):
    """See `cutensorPlanAttribute_t`."""
    __new__: ClassVar[Callable] = ...
    REQUIRED_WORKSPACE: ClassVar[PlanAttribute] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class PlanPreferenceAttribute(enum.IntEnum):
    """See `cutensorPlanPreferenceAttribute_t`."""
    __new__: ClassVar[Callable] = ...
    ALGO: ClassVar[PlanPreferenceAttribute] = ...
    AUTOTUNE_MODE: ClassVar[PlanPreferenceAttribute] = ...
    CACHE_MODE: ClassVar[PlanPreferenceAttribute] = ...
    INCREMENTAL_COUNT: ClassVar[PlanPreferenceAttribute] = ...
    JIT: ClassVar[PlanPreferenceAttribute] = ...
    KERNEL_RANK: ClassVar[PlanPreferenceAttribute] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class Status(enum.IntEnum):
    """See `cutensorStatus_t`."""
    __new__: ClassVar[Callable] = ...
    ALLOC_FAILED: ClassVar[Status] = ...
    ARCH_MISMATCH: ClassVar[Status] = ...
    CUBLAS_ERROR: ClassVar[Status] = ...
    CUDA_ERROR: ClassVar[Status] = ...
    EXECUTION_FAILED: ClassVar[Status] = ...
    INSUFFICIENT_DRIVER: ClassVar[Status] = ...
    INSUFFICIENT_WORKSPACE: ClassVar[Status] = ...
    INTERNAL_ERROR: ClassVar[Status] = ...
    INVALID_VALUE: ClassVar[Status] = ...
    IO_ERROR: ClassVar[Status] = ...
    LICENSE_ERROR: ClassVar[Status] = ...
    MAPPING_ERROR: ClassVar[Status] = ...
    NOT_INITIALIZED: ClassVar[Status] = ...
    NOT_SUPPORTED: ClassVar[Status] = ...
    SUCCESS: ClassVar[Status] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class WorksizePreference(enum.IntEnum):
    """See `cutensorWorksizePreference_t`."""
    __new__: ClassVar[Callable] = ...
    WORKSPACE_DEFAULT: ClassVar[WorksizePreference] = ...
    WORKSPACE_MAX: ClassVar[WorksizePreference] = ...
    WORKSPACE_MIN: ClassVar[WorksizePreference] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _value2member_map_: ClassVar[dict] = ...

class cuTENSORError(Exception):
    """cuTENSORError(status)"""
    def __init__(self, status) -> Any:
        """Initialize self.  See help(type(self)) for accurate signature."""
    def __reduce__(self) -> Any:
        """cuTENSORError.__reduce__(self)"""
