/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.util;

public class Memory {
    public static final double KB = 1024.0;
    public static final double MB = 1048576.0;
    public static final double GB = 1.073741824E9;

    public static long used() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    public static String usedString() {
        return Memory.format(Memory.used());
    }

    public static long free() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.freeMemory();
    }

    public static String freeString() {
        return Memory.format(Memory.free());
    }

    public static long total() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory();
    }

    public static String totalString() {
        return Memory.format(Memory.total());
    }

    public static String usedTotalString() {
        return "Used: " + Memory.usedString() + "   Total: " + Memory.totalString();
    }

    public static String allString() {
        return "Used: " + Memory.usedString() + "   Free: " + Memory.freeString() + "   Total: " + Memory.totalString();
    }

    public static String format(long mem) {
        if ((double)mem < 2048.0) {
            return mem + " bytes";
        }
        if ((double)mem < 2097152.0) {
            return Memory.round((double)mem / 1024.0) + " KB";
        }
        if ((double)mem < 2.147483648E9) {
            return Memory.round((double)mem / 1048576.0) + " MB";
        }
        return Memory.round((double)mem / 1.073741824E9) + " GB";
    }

    public static double round(double d) {
        return Math.ceil(d * 100.0) / 100.0;
    }
}

