/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatumBinder;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.VarnumCopyingBinder;

class OracleNumberBinder
extends DatumBinder {
    Binder theVarnumCopyingBinder = null;

    static void init(Binder x) {
        x.type = (short)6;
        x.bytelen = 22;
    }

    OracleNumberBinder(byte[] val) {
        super(val);
        OracleNumberBinder.init(this);
    }

    @Override
    Binder copyingBinder() {
        if (this.theVarnumCopyingBinder == null) {
            this.theVarnumCopyingBinder = new VarnumCopyingBinder();
        }
        return this.theVarnumCopyingBinder;
    }

    @Override
    long bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues, long localCheckSum, ByteArray bindData, long[] bindDataOffsets, int[] bindDataLengths, int bindDataIndex, boolean bindUseDBA, int formOfUse) throws SQLException {
        byte[] value = this.paramVal;
        if (clearPriorBindValues) {
            this.paramVal = null;
        }
        if (value == null) {
            bindIndicators[indoffset] = -1;
            if (bindUseDBA) {
                bindDataOffsets[bindDataIndex] = -1L;
                bindDataLengths[bindDataIndex] = 0;
            }
        } else {
            bindIndicators[indoffset] = 0;
            if (bindUseDBA) {
                long pos;
                bindDataOffsets[bindDataIndex] = pos = bindData.getPosition();
                stmt.lastBoundDataOffsets[bindPosition] = pos;
                bindData.put(value, 0, value.length);
                bindDataLengths[bindDataIndex] = value.length;
                stmt.lastBoundDataLengths[bindPosition] = value.length;
            } else {
                bindBytes[byteoffset] = (byte)value.length;
                System.arraycopy(value, 0, bindBytes, byteoffset + 1, value.length);
            }
            bindIndicators[lenoffset] = (short)(value.length + 1);
        }
        if (stmt.connection.checksumMode.needToCalculateBindChecksum()) {
            localCheckSum = bindIndicators[indoffset] == -1 ? CRC64.updateChecksum(localCheckSum, Accessor.NULL_DATA_BYTES, 0, Accessor.NULL_DATA_BYTES.length) : CRC64.updateChecksum(localCheckSum, value, 0, value.length);
        }
        return localCheckSum;
    }
}

