/* SPDX-FileCopyrightText: 2007 - 2009 Jesús Barbero Rodríguez <chuchiperriman@gmail.com>
 * SPDX-FileCopyrightText: 2009 - Jesse van den Kieboom <jessevdk@gnome.org>
 * SPDX-License-Identifier: LGPL-2.1-or-later
 */

#pragma once

#if !defined (GTK_SOURCE_H_INSIDE) && !defined (GTK_SOURCE_COMPILATION)
#error "Only <gtksourceview/gtksource.h> can be included directly."
#endif

#include <gtk/gtk.h>
#include <gtksourceview/gtksourcecompletioninfo.h>
#include <gtksourceview/gtksourcecompletionproposal.h>
#include <gtksourceview/gtksourcetypes.h>

G_BEGIN_DECLS

/*
 * Type checking and casting macros
 */
#define GTK_SOURCE_TYPE_COMPLETION              (gtk_source_completion_get_type())
#define GTK_SOURCE_COMPLETION(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), GTK_SOURCE_TYPE_COMPLETION, GtkSourceCompletion))
#define GTK_SOURCE_COMPLETION_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), GTK_SOURCE_TYPE_COMPLETION, GtkSourceCompletionClass))
#define GTK_SOURCE_IS_COMPLETION(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), GTK_SOURCE_TYPE_COMPLETION))
#define GTK_SOURCE_IS_COMPLETION_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), GTK_SOURCE_TYPE_COMPLETION))
#define GTK_SOURCE_COMPLETION_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), GTK_SOURCE_TYPE_COMPLETION, GtkSourceCompletionClass))

/**
 * GTK_SOURCE_COMPLETION_ERROR:
 *
 * Error domain for the completion. Errors in this domain will be from the
 * #GtkSourceCompletionError enumeration. See #GError for more information on
 * error domains.
 */
#define GTK_SOURCE_COMPLETION_ERROR		(gtk_source_completion_error_quark ())

typedef struct _GtkSourceCompletion         GtkSourceCompletion;
typedef struct _GtkSourceCompletionClass    GtkSourceCompletionClass;
typedef struct _GtkSourceCompletionPrivate  GtkSourceCompletionPrivate;

/**
 * GtkSourceCompletionError:
 * @GTK_SOURCE_COMPLETION_ERROR_ALREADY_BOUND: The #GtkSourceCompletionProvider
 * is already bound to the #GtkSourceCompletion object.
 * @GTK_SOURCE_COMPLETION_ERROR_NOT_BOUND: The #GtkSourceCompletionProvider is
 * not bound to the #GtkSourceCompletion object.
 *
 * An error code used with %GTK_SOURCE_COMPLETION_ERROR in a #GError returned
 * from a completion-related function.
 */
typedef enum _GtkSourceCompletionError
{
	GTK_SOURCE_COMPLETION_ERROR_ALREADY_BOUND = 0,
	GTK_SOURCE_COMPLETION_ERROR_NOT_BOUND
} GtkSourceCompletionError;

struct _GtkSourceCompletion
{
	GObject parent_instance;

	GtkSourceCompletionPrivate *priv;
};

struct _GtkSourceCompletionClass
{
	GObjectClass parent_class;

	gboolean 	(* proposal_activated)		(GtkSourceCompletion         *completion,
	                                                 GtkSourceCompletionProvider *provider,
							 GtkSourceCompletionProposal *proposal);
	void 		(* show)			(GtkSourceCompletion         *completion);
	void		(* hide)			(GtkSourceCompletion         *completion);
	void		(* populate_context)		(GtkSourceCompletion         *completion,
							 GtkSourceCompletionContext  *context);

	/* Actions */
	void		(* move_cursor)			(GtkSourceCompletion         *completion,
							 GtkScrollStep                step,
							 gint                         num);
	void		(* move_page)			(GtkSourceCompletion         *completion,
							 GtkScrollStep                step,
							 gint                         num);
	void		(* activate_proposal)		(GtkSourceCompletion         *completion);

	gpointer padding[1];
};

G_MODULE_EXPORT
GType		 gtk_source_completion_get_type			(void) G_GNUC_CONST;

G_MODULE_EXPORT
GQuark		 gtk_source_completion_error_quark		(void);

G_MODULE_EXPORT
gboolean	 gtk_source_completion_add_provider		(GtkSourceCompletion           *completion,
								 GtkSourceCompletionProvider   *provider,
								 GError                       **error);

G_MODULE_EXPORT
gboolean	 gtk_source_completion_remove_provider		(GtkSourceCompletion           *completion,
								 GtkSourceCompletionProvider   *provider,
								 GError                       **error);

G_MODULE_EXPORT
GList		*gtk_source_completion_get_providers		(GtkSourceCompletion           *completion);

G_MODULE_EXPORT
gboolean	 gtk_source_completion_start			(GtkSourceCompletion           *completion,
								 GList                         *providers,
								 GtkSourceCompletionContext    *context);

G_MODULE_EXPORT
void		 gtk_source_completion_hide			(GtkSourceCompletion           *completion);

G_MODULE_EXPORT
GtkSourceCompletionInfo *
		 gtk_source_completion_get_info_window		(GtkSourceCompletion           *completion);

G_MODULE_EXPORT
GtkSourceView	*gtk_source_completion_get_view			(GtkSourceCompletion	       *completion);

G_MODULE_EXPORT
GtkSourceCompletionContext *
		 gtk_source_completion_create_context		(GtkSourceCompletion           *completion,
		 						 GtkTextIter                   *position);

G_MODULE_EXPORT
void		 gtk_source_completion_block_interactive	(GtkSourceCompletion           *completion);

G_MODULE_EXPORT
void		 gtk_source_completion_unblock_interactive	(GtkSourceCompletion           *completion);

G_GNUC_INTERNAL
void		 _gtk_source_completion_add_proposals		(GtkSourceCompletion           *completion,
								 GtkSourceCompletionContext    *context,
								 GtkSourceCompletionProvider   *provider,
								 GList                         *proposals,
								 gboolean                       finished);
G_END_DECLS
