/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.Size;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.build.AllowReflection;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.type.BasicPluralType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicPluralJavaType;
import org.hibernate.type.descriptor.java.ByteArrayJavaType;
import org.hibernate.type.descriptor.java.ByteJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.jdbc.AggregateJdbcType;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.StructAttributeValues;
import org.hibernate.type.descriptor.jdbc.StructHelper;
import org.hibernate.type.descriptor.jdbc.StructuredJdbcType;
import org.hibernate.type.descriptor.jdbc.internal.JdbcLiteralFormatterArray;
import org.hibernate.type.descriptor.sql.spi.DdlTypeRegistry;
import org.hibernate.type.internal.BasicTypeImpl;
import org.hibernate.type.internal.ParameterizedTypeImpl;
import org.hibernate.type.spi.TypeConfiguration;

@AllowReflection
public class ArrayJdbcType
implements JdbcType {
    private final JdbcType elementJdbcType;

    public ArrayJdbcType(JdbcType elementJdbcType) {
        this.elementJdbcType = elementJdbcType;
    }

    @Override
    public int getJdbcTypeCode() {
        return 2003;
    }

    public JdbcType getElementJdbcType() {
        return this.elementJdbcType;
    }

    @Override
    public <T> JavaType<T> getJdbcRecommendedJavaTypeMapping(Integer precision, Integer scale, TypeConfiguration typeConfiguration) {
        JavaType elementJavaType = this.elementJdbcType.getJdbcRecommendedJavaTypeMapping(precision, scale, typeConfiguration);
        JavaType javaType = typeConfiguration.getJavaTypeRegistry().resolveDescriptor(Array.newInstance(elementJavaType.getJavaTypeClass(), 0).getClass());
        if (javaType instanceof BasicPluralType) {
            return javaType;
        }
        return javaType.createJavaType(new ParameterizedTypeImpl(javaType.getJavaTypeClass(), new Type[0], null), typeConfiguration);
    }

    private static JavaType<?> elementJavaType(JavaType<?> javaTypeDescriptor) {
        if (javaTypeDescriptor instanceof ByteArrayJavaType) {
            return ByteJavaType.INSTANCE;
        }
        if (javaTypeDescriptor instanceof BasicPluralJavaType) {
            BasicPluralJavaType basicPluralJavaType = (BasicPluralJavaType)((Object)javaTypeDescriptor);
            return basicPluralJavaType.getElementJavaType();
        }
        throw new IllegalArgumentException("not a BasicPluralJavaType");
    }

    @Override
    public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaType<T> javaTypeDescriptor) {
        return new JdbcLiteralFormatterArray<T>(javaTypeDescriptor, this.elementJdbcType.getJdbcLiteralFormatter(ArrayJdbcType.elementJavaType(javaTypeDescriptor)));
    }

    @Override
    public Class<?> getPreferredJavaTypeClass(WrapperOptions options) {
        return Object[].class;
    }

    protected String getElementTypeName(JavaType<?> javaType, SharedSessionContractImplementor session) {
        JdbcType jdbcType = this.elementJdbcType;
        if (jdbcType instanceof StructuredJdbcType) {
            StructuredJdbcType structJdbcType = (StructuredJdbcType)jdbcType;
            return structJdbcType.getStructTypeName();
        }
        JavaType<?> elementJavaType = ArrayJdbcType.elementJavaType(javaType);
        Size size = session.getJdbcServices().getDialect().getSizeStrategy().resolveSize(this.elementJdbcType, elementJavaType, null, null, null);
        DdlTypeRegistry ddlTypeRegistry = session.getTypeConfiguration().getDdlTypeRegistry();
        String typeName = ddlTypeRegistry.getDescriptor(this.elementJdbcType.getDdlTypeCode()).getTypeName(size, new BasicTypeImpl(elementJavaType, this.elementJdbcType), ddlTypeRegistry);
        int cutIndexBegin = typeName.indexOf(40);
        if (cutIndexBegin > 0) {
            int cutIndexEnd = typeName.lastIndexOf(41);
            assert (cutIndexEnd > cutIndexBegin);
            return typeName.substring(0, cutIndexBegin) + typeName.substring(cutIndexEnd + 1);
        }
        return typeName;
    }

    protected <T> Object[] getArray(BasicBinder<?> binder, ValueBinder<T> elementBinder, T value, WrapperOptions options) throws SQLException {
        JdbcType elementJdbcType = ((ArrayJdbcType)binder.getJdbcType()).getElementJdbcType();
        JavaType<?> javaType = binder.getJavaType();
        if (elementJdbcType instanceof AggregateJdbcType) {
            Object[] domainObjects = javaType.unwrap(value, Object[].class, options);
            Object[] objects = new Object[domainObjects.length];
            for (int i = 0; i < domainObjects.length; ++i) {
                if (domainObjects[i] == null) continue;
                objects[i] = elementBinder.getBindValue(domainObjects[i], options);
            }
            return objects;
        }
        TypeConfiguration typeConfiguration = options.getTypeConfiguration();
        JdbcType underlyingJdbcType = typeConfiguration.getJdbcTypeRegistry().getDescriptor(elementJdbcType.getDefaultSqlTypeCode());
        Class<?> preferredJavaTypeClass = elementJdbcType.getPreferredJavaTypeClass(options);
        Class<?> elementJdbcJavaTypeClass = preferredJavaTypeClass == null ? underlyingJdbcType.getJdbcRecommendedJavaTypeMapping(null, null, typeConfiguration).getJavaTypeClass() : preferredJavaTypeClass;
        Class<?> arrayClass = Array.newInstance(elementJdbcJavaTypeClass, 0).getClass();
        return (Object[])javaType.unwrap(value, arrayClass, options);
    }

    protected <X> X getArray(BasicExtractor<X> extractor, java.sql.Array array, WrapperOptions options) throws SQLException {
        AggregateJdbcType aggregateJdbcType;
        JdbcType jdbcType;
        JavaType<Object> javaType = extractor.getJavaType();
        if (array != null && (jdbcType = this.getElementJdbcType()) instanceof AggregateJdbcType && (aggregateJdbcType = (AggregateJdbcType)jdbcType).getEmbeddableMappingType() != null) {
            EmbeddableMappingType embeddableMappingType = aggregateJdbcType.getEmbeddableMappingType();
            Object rawArray = array.getArray();
            Object[] domainObjects = new Object[Array.getLength(rawArray)];
            for (int i = 0; i < domainObjects.length; ++i) {
                Object rawJdbcValue = Array.get(rawArray, i);
                if (rawJdbcValue == null) {
                    domainObjects[i] = null;
                    continue;
                }
                Object[] aggregateRawValues = aggregateJdbcType.extractJdbcValues(rawJdbcValue, options);
                StructAttributeValues attributeValues = StructHelper.getAttributeValues(embeddableMappingType, aggregateRawValues, options);
                domainObjects[i] = StructHelper.instantiate(embeddableMappingType, attributeValues);
            }
            return javaType.wrap(domainObjects, options);
        }
        return javaType.wrap(array, options);
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaType<X> javaTypeDescriptor) {
        BasicPluralJavaType pluralJavaType = (BasicPluralJavaType)((Object)javaTypeDescriptor);
        final ValueBinder elementBinder = this.elementJdbcType.getBinder(pluralJavaType.getElementJavaType());
        return new BasicBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setArray(index, this.getArray(value, options));
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                java.sql.Array array = this.getArray(value, options);
                try {
                    st.setObject(name, (Object)array, 2003);
                }
                catch (SQLException ex) {
                    throw new HibernateException("JDBC driver does not support named parameters for setArray. Use positional.", ex);
                }
            }

            @Override
            public Object getBindValue(X value, WrapperOptions options) throws SQLException {
                return ((ArrayJdbcType)this.getJdbcType()).getArray(this, elementBinder, value, options);
            }

            private java.sql.Array getArray(X value, WrapperOptions options) throws SQLException {
                ArrayJdbcType arrayJdbcType = (ArrayJdbcType)this.getJdbcType();
                Object[] objects = arrayJdbcType.getArray(this, elementBinder, value, options);
                SharedSessionContractImplementor session = options.getSession();
                String typeName = arrayJdbcType.getElementTypeName(this.getJavaType(), session);
                return session.getJdbcCoordinator().getLogicalConnection().getPhysicalConnection().createArrayOf(typeName, objects);
            }
        };
    }

    @Override
    public <X> ValueExtractor<X> getExtractor(JavaType<X> javaTypeDescriptor) {
        return new BasicExtractor<X>(javaTypeDescriptor, this){

            @Override
            protected X doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return ArrayJdbcType.this.getArray(this, rs.getArray(paramIndex), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return ArrayJdbcType.this.getArray(this, statement.getArray(index), options);
            }

            @Override
            protected X doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return ArrayJdbcType.this.getArray(this, statement.getArray(name), options);
            }
        };
    }

    @Override
    public String getFriendlyName() {
        return "ARRAY";
    }

    public String toString() {
        return "ArrayTypeDescriptor(" + String.valueOf(this.getElementJdbcType()) + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object that) {
        if (!(that instanceof ArrayJdbcType)) return false;
        ArrayJdbcType arrayJdbcType = (ArrayJdbcType)that;
        if (this.getClass() != that.getClass()) return false;
        if (!this.getElementJdbcType().equals(arrayJdbcType.getElementJdbcType())) return false;
        return true;
    }

    public int hashCode() {
        return this.getJdbcTypeCode() + 31 * this.getElementJdbcType().hashCode();
    }
}

