/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSStyleProperties.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "CustomElementReactionQueue.h"
#include "DocumentInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "Settings.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSStylePropertiesConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleProperties_propertyValueForDashedIDLAttribute);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSStyleProperties_propertyValueForDashedIDLAttribute);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleProperties_propertyValueForEpubCasedIDLAttribute);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSStyleProperties_propertyValueForEpubCasedIDLAttribute);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSStyleProperties_cssFloat);
static JSC_DECLARE_CUSTOM_SETTER(setJSCSSStyleProperties_cssFloat);

class JSCSSStylePropertiesPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSStylePropertiesPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSStylePropertiesPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSStylePropertiesPrototype>(vm)) JSCSSStylePropertiesPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSStylePropertiesPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSStylePropertiesPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSStylePropertiesPrototype, JSCSSStylePropertiesPrototype::Base);

using JSCSSStylePropertiesDOMConstructor = JSDOMConstructorNotConstructable<JSCSSStyleProperties>;

template<> const ClassInfo JSCSSStylePropertiesDOMConstructor::s_info = { "CSSStyleProperties"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStylePropertiesDOMConstructor) };

template<> JSValue JSCSSStylePropertiesDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSCSSStyleDeclaration::getConstructor(vm, &globalObject);
}

template<> void JSCSSStylePropertiesDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "CSSStyleProperties"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSStyleProperties::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 1529> JSCSSStylePropertiesPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStylePropertiesConstructor, 0 } },
    HashTableValue { "cssFloat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_cssFloat, setJSCSSStyleProperties_cssFloat } },
    HashTableValue { "AppleColorFilter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "EpubCaptionSide"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "EpubHyphens"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "EpubTextCombine"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "EpubTextEmphasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "EpubTextEmphasisColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "EpubTextEmphasisStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "EpubTextOrientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "EpubTextTransform"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "EpubWordBreak"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "EpubWritingMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitAlignContent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitAlignItems"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitAlignSelf"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitAnimation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitAnimationDelay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitAnimationDirection"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitAnimationDuration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitAnimationFillMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitAnimationIterationCount"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitAnimationName"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitAnimationPlayState"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitAnimationTimingFunction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitAppearance"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBackdropFilter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBackfaceVisibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBackgroundClip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBackgroundOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBackgroundSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderAfterColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderAfterStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderAfterWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderBeforeColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderBeforeStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderBeforeWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderBottomLeftRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderBottomRightRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderEndColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderEndStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderEndWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderHorizontalSpacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderStartColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderStartStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderStartWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderTopLeftRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderTopRightRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBorderVerticalSpacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBoxAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBoxDecorationBreak"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBoxDirection"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBoxFlex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBoxFlexGroup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBoxLines"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBoxOrdinalGroup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBoxOrient"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBoxPack"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBoxReflect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBoxShadow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitBoxSizing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitClipPath"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitColumnAxis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitColumnBreakAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitColumnBreakBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitColumnBreakInside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitColumnCount"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitColumnFill"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitColumnGap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitColumnProgression"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitColumnRule"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitColumnRuleColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitColumnRuleStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitColumnRuleWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitColumnSpan"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitColumnWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitColumns"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitCursorVisibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitFilter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitFlex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitFlexBasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitFlexDirection"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitFlexFlow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitFlexGrow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitFlexShrink"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitFlexWrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitFontKerning"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitFontSmoothing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitHyphenateCharacter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitHyphenateLimitAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitHyphenateLimitBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitHyphenateLimitLines"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitHyphens"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitInitialLetter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitJustifyContent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitJustifyItems"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitLineAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitLineBoxContain"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitLineBreak"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitLineClamp"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitLineGrid"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitLineSnap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitLocale"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitLogicalHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitLogicalWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMarginAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMarginBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMarginEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMarginStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMask"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMaskBoxImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMaskBoxImageOutset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMaskBoxImageRepeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMaskBoxImageSlice"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMaskBoxImageSource"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMaskBoxImageWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMaskClip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMaskComposite"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMaskImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMaskOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMaskPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMaskPositionX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMaskPositionY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMaskRepeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMaskSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMaskSourceType"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMaxLogicalHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMaxLogicalWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMinLogicalHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitMinLogicalWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitNbspMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitOpacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitOrder"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitPaddingAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitPaddingBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitPaddingEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitPaddingStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitPerspective"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitPerspectiveOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitPerspectiveOriginX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitPerspectiveOriginY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitPrintColorAdjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitRtlOrdering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitRubyPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitShapeImageThreshold"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitShapeMargin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitShapeOutside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTapHighlightColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextCombine"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextDecoration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextDecorationColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextDecorationLine"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextDecorationSkip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextDecorationStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextDecorationsInEffect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextEmphasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextEmphasisColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextEmphasisPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextEmphasisStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextFillColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextOrientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextSecurity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextStroke"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextStrokeColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextStrokeWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextUnderlinePosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTextZoom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTransform"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTransformOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTransformOriginX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTransformOriginY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTransformOriginZ"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTransformStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTransition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTransitionDelay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTransitionDuration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTransitionProperty"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitTransitionTimingFunction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitUserDrag"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitUserModify"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitUserSelect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "WebkitWritingMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "accentColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "additiveSymbols"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "alignContent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "alignItems"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "alignSelf"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "alignmentBaseline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "all"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "anchorName"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "anchorScope"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "animation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "animationComposition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "animationDelay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "animationDirection"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "animationDuration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "animationFillMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "animationIterationCount"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "animationName"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "animationPlayState"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "animationRange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "animationRangeEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "animationRangeStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "animationTimeline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "animationTimingFunction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "appearance"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "aspectRatio"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "backdropFilter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "backfaceVisibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "background"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "backgroundAttachment"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "backgroundBlendMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "backgroundClip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "backgroundColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "backgroundImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "backgroundOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "backgroundPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "backgroundPositionX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "backgroundPositionY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "backgroundRepeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "backgroundSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "basePalette"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "baselineShift"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "blockEllipsis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "blockSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "blockStep"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "blockStepAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "blockStepInsert"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "blockStepRound"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "blockStepSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "border"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderBlock"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderBlockColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderBlockEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderBlockEndColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderBlockEndStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderBlockEndWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderBlockStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderBlockStartColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderBlockStartStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderBlockStartWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderBlockStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderBlockWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderBottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderBottomColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderBottomLeftRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderBottomRightRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderBottomStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderBottomWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderCollapse"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderEndEndRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderEndStartRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderImageOutset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderImageRepeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderImageSlice"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderImageSource"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderImageWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderInline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderInlineColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderInlineEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderInlineEndColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderInlineEndStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderInlineEndWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderInlineStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderInlineStartColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderInlineStartStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderInlineStartWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderInlineStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderInlineWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderLeft"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderLeftColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderLeftStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderLeftWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderRight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderRightColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderRightStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderRightWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderSpacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderStartEndRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderStartStartRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderTop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderTopColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderTopLeftRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderTopRightRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderTopStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderTopWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "borderWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "bottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "boxShadow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "boxSizing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "breakAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "breakBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "breakInside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "bufferedRendering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "captionSide"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "caretColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "clear"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "clip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "clipPath"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "clipRule"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "colorAdjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "colorInterpolation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "colorInterpolationFilters"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "colorScheme"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "columnCount"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "columnFill"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "columnGap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "columnRule"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "columnRuleColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "columnRuleStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "columnRuleWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "columnSpan"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "columnWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "columns"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "contain"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "containIntrinsicBlockSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "containIntrinsicHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "containIntrinsicInlineSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "containIntrinsicSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "containIntrinsicWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "container"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "containerName"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "containerType"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "content"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "contentVisibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "continue"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "cornerBottomLeftShape"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "cornerBottomRightShape"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "cornerEndEndShape"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "cornerEndStartShape"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "cornerShape"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "cornerStartEndShape"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "cornerStartStartShape"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "cornerTopLeftShape"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "cornerTopRightShape"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "counterIncrement"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "counterReset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "counterSet"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "cursor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "cx"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "cy"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "d"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "direction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "display"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "dominantBaseline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "dynamicRangeLimit"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "emptyCells"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fallback"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fieldSizing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fill"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fillOpacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fillRule"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "filter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "flex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "flexBasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "flexDirection"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "flexFlow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "flexGrow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "flexShrink"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "flexWrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "float"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "floodColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "floodOpacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "font"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontDisplay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontFamily"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontFeatureSettings"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontKerning"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontOpticalSizing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontPalette"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontSizeAdjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontStretch"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontSynthesis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontSynthesisSmallCaps"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontSynthesisStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontSynthesisWeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontVariant"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontVariantAlternates"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontVariantCaps"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontVariantEastAsian"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontVariantEmoji"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontVariantLigatures"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontVariantNumeric"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontVariantPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontVariationSettings"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontWeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "fontWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "gap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "glyphOrientationHorizontal"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "glyphOrientationVertical"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "grid"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "gridArea"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "gridAutoColumns"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "gridAutoFlow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "gridAutoRows"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "gridColumn"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "gridColumnEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "gridColumnGap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "gridColumnStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "gridGap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "gridRow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "gridRowEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "gridRowGap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "gridRowStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "gridTemplate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "gridTemplateAreas"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "gridTemplateColumns"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "gridTemplateRows"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "hangingPunctuation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "hyphenateCharacter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "hyphens"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "imageOrientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "imageRendering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "inherits"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "initialValue"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "inlineSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "inputSecurity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "inset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "insetBlock"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "insetBlockEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "insetBlockStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "insetInline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "insetInlineEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "insetInlineStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "isolation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "justifyContent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "justifyItems"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "justifySelf"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "left"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "letterSpacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "lightingColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "lineBreak"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "lineClamp"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "lineFitEdge"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "lineHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "listStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "listStyleImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "listStylePosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "listStyleType"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "margin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "marginBlock"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "marginBlockEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "marginBlockStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "marginBottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "marginInline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "marginInlineEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "marginInlineStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "marginLeft"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "marginRight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "marginTop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "marginTrim"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "marker"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "markerEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "markerMid"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "markerStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "mask"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maskBorder"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maskBorderOutset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maskBorderRepeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maskBorderSlice"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maskBorderSource"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maskBorderWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maskClip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maskComposite"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maskImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maskMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maskOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maskPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maskRepeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maskSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maskType"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "mathStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maxBlockSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maxHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maxInlineSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maxLines"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "maxWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "minBlockSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "minHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "minInlineSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "minWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "mixBlendMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "navigation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "negative"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "objectFit"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "objectPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "offset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "offsetAnchor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "offsetDistance"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "offsetPath"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "offsetPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "offsetRotate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "opacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "order"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "orphans"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "outline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "outlineColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "outlineOffset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "outlineStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "outlineWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "overflow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "overflowAnchor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "overflowBlock"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "overflowInline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "overflowWrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "overflowX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "overflowY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "overrideColors"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "overscrollBehavior"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "overscrollBehaviorBlock"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "overscrollBehaviorInline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "overscrollBehaviorX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "overscrollBehaviorY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "pad"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "padding"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "paddingBlock"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "paddingBlockEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "paddingBlockStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "paddingBottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "paddingInline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "paddingInlineEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "paddingInlineStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "paddingLeft"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "paddingRight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "paddingTop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "page"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "pageBreakAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "pageBreakBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "pageBreakInside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "paintOrder"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "perspective"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "perspectiveOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "perspectiveOriginX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "perspectiveOriginY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "placeContent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "placeItems"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "placeSelf"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "pointerEvents"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "positionAnchor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "positionArea"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "positionTry"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "positionTryFallbacks"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "positionTryOrder"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "positionVisibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "prefix"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "printColorAdjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "quotes"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "r"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "range"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "resize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "right"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "rotate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "rowGap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "rubyAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "rubyOverhang"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "rubyPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "rx"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "ry"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scale"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollBehavior"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollMargin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollMarginBlock"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollMarginBlockEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollMarginBlockStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollMarginBottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollMarginInline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollMarginInlineEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollMarginInlineStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollMarginLeft"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollMarginRight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollMarginTop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollPadding"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollPaddingBlock"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollPaddingBlockEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollPaddingBlockStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollPaddingBottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollPaddingInline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollPaddingInlineEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollPaddingInlineStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollPaddingLeft"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollPaddingRight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollPaddingTop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollSnapAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollSnapMargin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollSnapMarginBottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollSnapMarginLeft"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollSnapMarginRight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollSnapMarginTop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollSnapStop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollSnapType"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollTimeline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollTimelineAxis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollTimelineName"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollbarColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollbarGutter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "scrollbarWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "shapeImageThreshold"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "shapeMargin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "shapeOutside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "shapeRendering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "sizeAdjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "speakAs"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "src"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "stopColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "stopOpacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "stroke"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "strokeColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "strokeDasharray"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "strokeDashoffset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "strokeLinecap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "strokeLinejoin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "strokeMiterlimit"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "strokeOpacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "strokeWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "suffix"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "supportedColorSchemes"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "symbols"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "syntax"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "system"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "tabSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "tableLayout"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textAlignLast"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textAnchor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textAutospace"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textBox"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textBoxEdge"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textBoxTrim"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textCombineUpright"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textDecoration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textDecorationColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textDecorationLine"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textDecorationSkip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textDecorationSkipInk"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textDecorationStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textDecorationThickness"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textEmphasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textEmphasisColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textEmphasisPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textEmphasisStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textGroupAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textIndent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textJustify"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textOrientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textOverflow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textRendering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textShadow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textSpacingTrim"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textTransform"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textUnderlineOffset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textUnderlinePosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textWrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textWrapMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "textWrapStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "timelineScope"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "top"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "touchAction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "transform"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "transformBox"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "transformOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "transformOriginX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "transformOriginY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "transformOriginZ"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "transformStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "transition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "transitionBehavior"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "transitionDelay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "transitionDuration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "transitionProperty"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "transitionTimingFunction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "translate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "types"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "unicodeBidi"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "unicodeRange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "vectorEffect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "verticalAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "viewTimeline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "viewTimelineAxis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "viewTimelineInset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "viewTimelineName"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "viewTransitionClass"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "viewTransitionName"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "visibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "whiteSpace"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "whiteSpaceCollapse"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "widows"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "willChange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "wordBreak"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "wordSpacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "wordWrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "writingMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "zIndex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "zoom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute } },
    HashTableValue { "webkitAlignContent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitAlignItems"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitAlignSelf"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitAnimation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitAnimationDelay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitAnimationDirection"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitAnimationDuration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitAnimationFillMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitAnimationIterationCount"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitAnimationName"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitAnimationPlayState"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitAnimationTimingFunction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitAppearance"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBackdropFilter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBackfaceVisibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBackgroundClip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBackgroundOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBackgroundSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderAfterColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderAfterStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderAfterWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderBeforeColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderBeforeStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderBeforeWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderBottomLeftRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderBottomRightRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderEndColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderEndStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderEndWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderHorizontalSpacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderStartColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderStartStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderStartWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderTopLeftRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderTopRightRadius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBorderVerticalSpacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBoxAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBoxDecorationBreak"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBoxDirection"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBoxFlex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBoxFlexGroup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBoxLines"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBoxOrdinalGroup"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBoxOrient"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBoxPack"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBoxReflect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBoxShadow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitBoxSizing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitClipPath"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitColumnAxis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitColumnBreakAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitColumnBreakBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitColumnBreakInside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitColumnCount"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitColumnFill"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitColumnGap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitColumnProgression"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitColumnRule"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitColumnRuleColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitColumnRuleStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitColumnRuleWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitColumnSpan"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitColumnWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitColumns"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitCursorVisibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitFilter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitFlex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitFlexBasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitFlexDirection"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitFlexFlow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitFlexGrow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitFlexShrink"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitFlexWrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitFontKerning"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitFontSmoothing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitHyphenateCharacter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitHyphenateLimitAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitHyphenateLimitBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitHyphenateLimitLines"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitHyphens"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitInitialLetter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitJustifyContent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitJustifyItems"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitLineAlign"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitLineBoxContain"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitLineBreak"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitLineClamp"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitLineGrid"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitLineSnap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitLocale"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitLogicalHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitLogicalWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMarginAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMarginBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMarginEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMarginStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMask"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMaskBoxImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMaskBoxImageOutset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMaskBoxImageRepeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMaskBoxImageSlice"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMaskBoxImageSource"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMaskBoxImageWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMaskClip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMaskComposite"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMaskImage"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMaskOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMaskPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMaskPositionX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMaskPositionY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMaskRepeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMaskSize"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMaskSourceType"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMaxLogicalHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMaxLogicalWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMinLogicalHeight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitMinLogicalWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitNbspMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitOpacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitOrder"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitPaddingAfter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitPaddingBefore"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitPaddingEnd"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitPaddingStart"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitPerspective"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitPerspectiveOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitPerspectiveOriginX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitPerspectiveOriginY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitPrintColorAdjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitRtlOrdering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitRubyPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitShapeImageThreshold"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitShapeMargin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitShapeOutside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTapHighlightColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextCombine"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextDecoration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextDecorationColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextDecorationLine"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextDecorationSkip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextDecorationStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextDecorationsInEffect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextEmphasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextEmphasisColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextEmphasisPosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextEmphasisStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextFillColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextOrientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextSecurity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextStroke"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextStrokeColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextStrokeWidth"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextUnderlinePosition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTextZoom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTransform"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTransformOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTransformOriginX"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTransformOriginY"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTransformOriginZ"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTransformStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTransition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTransitionDelay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTransitionDuration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTransitionProperty"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitTransitionTimingFunction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitUserDrag"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitUserModify"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitUserSelect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "webkitWritingMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute } },
    HashTableValue { "-apple-color-filter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-epub-caption-side"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-epub-hyphens"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-epub-text-combine"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-epub-text-emphasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-epub-text-emphasis-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-epub-text-emphasis-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-epub-text-orientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-epub-text-transform"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-epub-word-break"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-epub-writing-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-align-content"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-align-items"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-align-self"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-animation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-animation-delay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-animation-direction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-animation-duration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-animation-fill-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-animation-iteration-count"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-animation-name"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-animation-play-state"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-animation-timing-function"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-appearance"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-backdrop-filter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-backface-visibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-background-clip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-background-origin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-background-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-after"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-after-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-after-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-after-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-before"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-before-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-before-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-before-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-bottom-left-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-bottom-right-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-end-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-end-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-end-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-horizontal-spacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-image"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-start-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-start-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-start-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-top-left-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-top-right-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-border-vertical-spacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-box-align"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-box-decoration-break"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-box-direction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-box-flex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-box-flex-group"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-box-lines"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-box-ordinal-group"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-box-orient"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-box-pack"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-box-reflect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-box-shadow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-box-sizing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-clip-path"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-column-axis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-column-break-after"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-column-break-before"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-column-break-inside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-column-count"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-column-fill"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-column-gap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-column-progression"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-column-rule"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-column-rule-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-column-rule-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-column-rule-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-column-span"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-column-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-columns"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-cursor-visibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-filter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-flex"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-flex-basis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-flex-direction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-flex-flow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-flex-grow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-flex-shrink"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-flex-wrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-font-kerning"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-font-smoothing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-hyphenate-character"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-hyphenate-limit-after"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-hyphenate-limit-before"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-hyphenate-limit-lines"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-hyphens"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-initial-letter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-justify-content"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-justify-items"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-line-align"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-line-box-contain"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-line-break"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-line-clamp"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-line-grid"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-line-snap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-locale"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-logical-height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-logical-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-margin-after"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-margin-before"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-margin-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-margin-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-mask"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-mask-box-image"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-mask-box-image-outset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-mask-box-image-repeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-mask-box-image-slice"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-mask-box-image-source"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-mask-box-image-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-mask-clip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-mask-composite"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-mask-image"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-mask-origin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-mask-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-mask-position-x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-mask-position-y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-mask-repeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-mask-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-mask-source-type"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-max-logical-height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-max-logical-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-min-logical-height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-min-logical-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-nbsp-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-opacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-order"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-padding-after"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-padding-before"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-padding-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-padding-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-perspective"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-perspective-origin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-perspective-origin-x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-perspective-origin-y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-print-color-adjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-rtl-ordering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-ruby-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-shape-image-threshold"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-shape-margin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-shape-outside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-tap-highlight-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-combine"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-decoration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-decoration-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-decoration-line"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-decoration-skip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-decoration-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-decorations-in-effect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-emphasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-emphasis-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-emphasis-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-emphasis-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-fill-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-orientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-security"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-stroke"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-stroke-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-stroke-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-underline-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-text-zoom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-transform"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-transform-origin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-transform-origin-x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-transform-origin-y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-transform-origin-z"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-transform-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-transition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-transition-delay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-transition-duration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-transition-property"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-transition-timing-function"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-user-drag"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-user-modify"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-user-select"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "-webkit-writing-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "accent-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "additive-symbols"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "align-content"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "align-items"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "align-self"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "alignment-baseline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "anchor-name"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "anchor-scope"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "animation-composition"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "animation-delay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "animation-direction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "animation-duration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "animation-fill-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "animation-iteration-count"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "animation-name"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "animation-play-state"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "animation-range"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "animation-range-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "animation-range-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "animation-timeline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "animation-timing-function"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "aspect-ratio"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "backdrop-filter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "backface-visibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "background-attachment"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "background-blend-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "background-clip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "background-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "background-image"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "background-origin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "background-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "background-position-x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "background-position-y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "background-repeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "background-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "base-palette"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "baseline-shift"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "block-ellipsis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "block-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "block-step"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "block-step-align"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "block-step-insert"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "block-step-round"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "block-step-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-block"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-block-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-block-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-block-end-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-block-end-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-block-end-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-block-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-block-start-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-block-start-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-block-start-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-block-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-block-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-bottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-bottom-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-bottom-left-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-bottom-right-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-bottom-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-bottom-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-collapse"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-end-end-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-end-start-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-image"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-image-outset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-image-repeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-image-slice"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-image-source"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-image-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-inline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-inline-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-inline-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-inline-end-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-inline-end-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-inline-end-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-inline-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-inline-start-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-inline-start-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-inline-start-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-inline-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-inline-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-left"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-left-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-left-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-left-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-right"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-right-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-right-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-right-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-spacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-start-end-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-start-start-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-top"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-top-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-top-left-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-top-right-radius"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-top-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-top-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "border-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "box-shadow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "box-sizing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "break-after"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "break-before"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "break-inside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "buffered-rendering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "caption-side"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "caret-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "clip-path"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "clip-rule"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "color-adjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "color-interpolation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "color-interpolation-filters"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "color-scheme"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "column-count"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "column-fill"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "column-gap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "column-rule"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "column-rule-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "column-rule-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "column-rule-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "column-span"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "column-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "contain-intrinsic-block-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "contain-intrinsic-height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "contain-intrinsic-inline-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "contain-intrinsic-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "contain-intrinsic-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "container-name"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "container-type"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "content-visibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "corner-bottom-left-shape"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "corner-bottom-right-shape"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "corner-end-end-shape"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "corner-end-start-shape"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "corner-shape"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "corner-start-end-shape"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "corner-start-start-shape"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "corner-top-left-shape"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "corner-top-right-shape"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "counter-increment"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "counter-reset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "counter-set"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "dominant-baseline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "dynamic-range-limit"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "empty-cells"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "field-sizing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "fill-opacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "fill-rule"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "flex-basis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "flex-direction"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "flex-flow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "flex-grow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "flex-shrink"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "flex-wrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "flood-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "flood-opacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-display"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-family"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-feature-settings"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-kerning"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-optical-sizing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-palette"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-size-adjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-stretch"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-synthesis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-synthesis-small-caps"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-synthesis-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-synthesis-weight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-variant"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-variant-alternates"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-variant-caps"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-variant-east-asian"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-variant-emoji"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-variant-ligatures"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-variant-numeric"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-variant-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-variation-settings"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-weight"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "font-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "glyph-orientation-horizontal"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "glyph-orientation-vertical"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "grid-area"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "grid-auto-columns"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "grid-auto-flow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "grid-auto-rows"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "grid-column"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "grid-column-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "grid-column-gap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "grid-column-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "grid-gap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "grid-row"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "grid-row-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "grid-row-gap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "grid-row-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "grid-template"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "grid-template-areas"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "grid-template-columns"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "grid-template-rows"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "hanging-punctuation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "hyphenate-character"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "image-orientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "image-rendering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "initial-value"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "inline-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "input-security"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "inset-block"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "inset-block-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "inset-block-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "inset-inline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "inset-inline-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "inset-inline-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "justify-content"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "justify-items"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "justify-self"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "letter-spacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "lighting-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "line-break"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "line-clamp"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "line-fit-edge"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "line-height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "list-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "list-style-image"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "list-style-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "list-style-type"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "margin-block"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "margin-block-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "margin-block-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "margin-bottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "margin-inline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "margin-inline-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "margin-inline-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "margin-left"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "margin-right"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "margin-top"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "margin-trim"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "marker-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "marker-mid"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "marker-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "mask-border"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "mask-border-outset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "mask-border-repeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "mask-border-slice"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "mask-border-source"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "mask-border-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "mask-clip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "mask-composite"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "mask-image"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "mask-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "mask-origin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "mask-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "mask-repeat"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "mask-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "mask-type"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "math-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "max-block-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "max-height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "max-inline-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "max-lines"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "max-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "min-block-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "min-height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "min-inline-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "min-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "mix-blend-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "object-fit"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "object-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "offset-anchor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "offset-distance"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "offset-path"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "offset-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "offset-rotate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "outline-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "outline-offset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "outline-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "outline-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "overflow-anchor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "overflow-block"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "overflow-inline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "overflow-wrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "overflow-x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "overflow-y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "override-colors"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "overscroll-behavior"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "overscroll-behavior-block"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "overscroll-behavior-inline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "overscroll-behavior-x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "overscroll-behavior-y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "padding-block"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "padding-block-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "padding-block-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "padding-bottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "padding-inline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "padding-inline-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "padding-inline-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "padding-left"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "padding-right"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "padding-top"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "page-break-after"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "page-break-before"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "page-break-inside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "paint-order"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "perspective-origin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "perspective-origin-x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "perspective-origin-y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "place-content"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "place-items"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "place-self"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "pointer-events"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "position-anchor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "position-area"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "position-try"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "position-try-fallbacks"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "position-try-order"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "position-visibility"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "print-color-adjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "row-gap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "ruby-align"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "ruby-overhang"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "ruby-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-behavior"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-margin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-margin-block"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-margin-block-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-margin-block-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-margin-bottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-margin-inline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-margin-inline-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-margin-inline-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-margin-left"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-margin-right"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-margin-top"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-padding"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-padding-block"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-padding-block-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-padding-block-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-padding-bottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-padding-inline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-padding-inline-end"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-padding-inline-start"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-padding-left"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-padding-right"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-padding-top"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-snap-align"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-snap-margin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-snap-margin-bottom"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-snap-margin-left"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-snap-margin-right"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-snap-margin-top"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-snap-stop"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-snap-type"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-timeline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-timeline-axis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scroll-timeline-name"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scrollbar-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scrollbar-gutter"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "scrollbar-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "shape-image-threshold"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "shape-margin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "shape-outside"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "shape-rendering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "size-adjust"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "speak-as"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "stop-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "stop-opacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "stroke-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "stroke-dasharray"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "stroke-dashoffset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "stroke-linecap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "stroke-linejoin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "stroke-miterlimit"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "stroke-opacity"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "stroke-width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "supported-color-schemes"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "tab-size"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "table-layout"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-align"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-align-last"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-anchor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-autospace"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-box"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-box-edge"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-box-trim"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-combine-upright"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-decoration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-decoration-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-decoration-line"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-decoration-skip"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-decoration-skip-ink"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-decoration-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-decoration-thickness"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-emphasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-emphasis-color"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-emphasis-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-emphasis-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-group-align"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-indent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-justify"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-orientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-overflow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-rendering"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-shadow"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-spacing-trim"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-transform"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-underline-offset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-underline-position"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-wrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-wrap-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "text-wrap-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "timeline-scope"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "touch-action"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "transform-box"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "transform-origin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "transform-origin-x"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "transform-origin-y"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "transform-origin-z"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "transform-style"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "transition-behavior"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "transition-delay"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "transition-duration"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "transition-property"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "transition-timing-function"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "unicode-bidi"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "unicode-range"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "vector-effect"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "vertical-align"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "view-timeline"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "view-timeline-axis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "view-timeline-inset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "view-timeline-name"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "view-transition-class"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "view-transition-name"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "white-space"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "white-space-collapse"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "will-change"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "word-break"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "word-spacing"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "word-wrap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "writing-mode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "z-index"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForDashedIDLAttribute, setJSCSSStyleProperties_propertyValueForDashedIDLAttribute } },
    HashTableValue { "epubCaptionSide"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForEpubCasedIDLAttribute } },
    HashTableValue { "epubHyphens"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForEpubCasedIDLAttribute } },
    HashTableValue { "epubTextCombine"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForEpubCasedIDLAttribute } },
    HashTableValue { "epubTextEmphasis"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForEpubCasedIDLAttribute } },
    HashTableValue { "epubTextEmphasisColor"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForEpubCasedIDLAttribute } },
    HashTableValue { "epubTextEmphasisStyle"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForEpubCasedIDLAttribute } },
    HashTableValue { "epubTextOrientation"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForEpubCasedIDLAttribute } },
    HashTableValue { "epubTextTransform"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForEpubCasedIDLAttribute } },
    HashTableValue { "epubWordBreak"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForEpubCasedIDLAttribute } },
    HashTableValue { "epubWritingMode"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSStyleProperties_propertyValueForEpubCasedIDLAttribute, setJSCSSStyleProperties_propertyValueForEpubCasedIDLAttribute } },
};

const ClassInfo JSCSSStylePropertiesPrototype::s_info = { "CSSStyleProperties"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStylePropertiesPrototype) };

void JSCSSStylePropertiesPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSStyleProperties::info(), JSCSSStylePropertiesPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().colorFilterEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "AppleColorFilter"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().accentColorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "accentColor"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssAnchorPositioningEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "anchorName"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssAnchorPositioningEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "anchorScope"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "animationRange"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "animationRangeEnd"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "animationRangeStart"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "animationTimeline"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssUnprefixedBackdropFilterEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "backdropFilter"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssLineClampEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "blockEllipsis"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssRhythmicSizingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "blockStep"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssRhythmicSizingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "blockStepAlign"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssRhythmicSizingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "blockStepInsert"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssRhythmicSizingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "blockStepRound"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssRhythmicSizingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "blockStepSize"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssLineClampEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "continue"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCornerShapeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "cornerBottomLeftShape"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCornerShapeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "cornerBottomRightShape"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCornerShapeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "cornerEndEndShape"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCornerShapeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "cornerEndStartShape"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCornerShapeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "cornerShape"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCornerShapeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "cornerStartEndShape"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCornerShapeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "cornerStartStartShape"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCornerShapeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "cornerTopLeftShape"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCornerShapeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "cornerTopRightShape"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssDPropertyEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "d"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().supportHDRDisplayEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "dynamicRangeLimit"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssFieldSizingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "fieldSizing"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssFontVariantEmojiEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "fontVariantEmoji"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssInputSecurityEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "inputSecurity"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssLineClampEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "lineClamp"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssLineFitEdgeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "lineFitEdge"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssLineClampEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "maxLines"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().crossDocumentViewTransitionsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "navigation"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssScrollAnchoringEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overflowAnchor"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscrollBehavior"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscrollBehaviorBlock"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscrollBehaviorInline"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscrollBehaviorX"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscrollBehaviorY"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssAnchorPositioningEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "positionAnchor"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssAnchorPositioningEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "positionArea"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssAnchorPositioningEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "positionTry"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssAnchorPositioningEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "positionTryFallbacks"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssAnchorPositioningEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "positionTryOrder"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssAnchorPositioningPositionVisibilityEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "positionVisibility"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssRubyAlignEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "rubyAlign"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssRubyOverhangEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "rubyOverhang"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scrollTimeline"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scrollTimelineAxis"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scrollTimelineName"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssScrollbarColorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scrollbarColor"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssScrollbarGutterEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scrollbarGutter"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssScrollbarWidthEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scrollbarWidth"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextAutospaceEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "textAutospace"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextBoxTrimEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "textBox"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextBoxTrimEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "textBoxEdge"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextBoxTrimEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "textBoxTrim"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextGroupAlignEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "textGroupAlign"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextJustifyEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "textJustify"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextSpacingTrimEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "textSpacingTrim"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "timelineScope"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().crossDocumentViewTransitionsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "types"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "viewTimeline"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "viewTimelineAxis"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "viewTimelineInset"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "viewTimelineName"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().viewTransitionClassesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "viewTransitionClass"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().viewTransitionsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "viewTransitionName"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().colorFilterEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "-apple-color-filter"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().accentColorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "accent-color"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssAnchorPositioningEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "anchor-name"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssAnchorPositioningEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "anchor-scope"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "animation-range"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "animation-range-end"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "animation-range-start"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "animation-timeline"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssUnprefixedBackdropFilterEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "backdrop-filter"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssLineClampEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "block-ellipsis"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssRhythmicSizingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "block-step"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssRhythmicSizingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "block-step-align"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssRhythmicSizingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "block-step-insert"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssRhythmicSizingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "block-step-round"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssRhythmicSizingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "block-step-size"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCornerShapeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "corner-bottom-left-shape"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCornerShapeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "corner-bottom-right-shape"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCornerShapeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "corner-end-end-shape"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCornerShapeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "corner-end-start-shape"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCornerShapeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "corner-shape"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCornerShapeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "corner-start-end-shape"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCornerShapeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "corner-start-start-shape"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCornerShapeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "corner-top-left-shape"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssCornerShapeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "corner-top-right-shape"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().supportHDRDisplayEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "dynamic-range-limit"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssFieldSizingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "field-sizing"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssFontVariantEmojiEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "font-variant-emoji"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssInputSecurityEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "input-security"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssLineClampEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "line-clamp"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssLineFitEdgeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "line-fit-edge"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssLineClampEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "max-lines"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssScrollAnchoringEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overflow-anchor"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscroll-behavior"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscroll-behavior-block"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscroll-behavior-inline"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscroll-behavior-x"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().overscrollBehaviorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "overscroll-behavior-y"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssAnchorPositioningEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "position-anchor"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssAnchorPositioningEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "position-area"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssAnchorPositioningEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "position-try"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssAnchorPositioningEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "position-try-fallbacks"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssAnchorPositioningEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "position-try-order"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssAnchorPositioningPositionVisibilityEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "position-visibility"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssRubyAlignEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ruby-align"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssRubyOverhangEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "ruby-overhang"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scroll-timeline"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scroll-timeline-axis"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scroll-timeline-name"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssScrollbarColorEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scrollbar-color"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssScrollbarGutterEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scrollbar-gutter"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssScrollbarWidthEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "scrollbar-width"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextAutospaceEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "text-autospace"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextBoxTrimEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "text-box"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextBoxTrimEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "text-box-edge"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextBoxTrimEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "text-box-trim"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextGroupAlignEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "text-group-align"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextJustifyEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "text-justify"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().cssTextSpacingTrimEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "text-spacing-trim"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "timeline-scope"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "view-timeline"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "view-timeline-axis"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "view-timeline-inset"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().scrollDrivenAnimationsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "view-timeline-name"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().viewTransitionClassesEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "view-transition-class"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().viewTransitionsEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "view-transition-name"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSStyleProperties::s_info = { "CSSStyleProperties"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSStyleProperties) };

JSCSSStyleProperties::JSCSSStyleProperties(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSStyleProperties>&& impl)
    : JSCSSStyleDeclaration(structure, globalObject, WTFMove(impl))
{
}

Ref<CSSStyleProperties> JSCSSStyleProperties::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSStyleProperties>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSStyleProperties::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSStylePropertiesPrototype::createStructure(vm, &globalObject, JSCSSStyleDeclaration::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSStylePropertiesPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSStyleProperties::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSStyleProperties>(vm, globalObject);
}

JSValue JSCSSStyleProperties::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSStylePropertiesDOMConstructor, DOMConstructorID::CSSStyleProperties>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStylePropertiesConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSStylePropertiesPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSStyleProperties::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsCSSStyleProperties_propertyValueForCamelCasedIDLAttributeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleProperties& thisObject, PropertyName propertyName)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.propertyValueForCamelCasedIDLAttribute(propertyNameToAtomString(propertyName)))));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleProperties>::getPassingPropertyName<jsCSSStyleProperties_propertyValueForCamelCasedIDLAttributeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttributeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleProperties& thisObject, JSValue value, PropertyName propertyName)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPropertyValueForCamelCasedIDLAttribute(propertyNameToAtomString(propertyName), nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttribute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleProperties>::setPassingPropertyName<setJSCSSStyleProperties_propertyValueForCamelCasedIDLAttributeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttributeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleProperties& thisObject, PropertyName propertyName)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.propertyValueForWebKitCasedIDLAttribute(propertyNameToAtomString(propertyName)))));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleProperties>::getPassingPropertyName<jsCSSStyleProperties_propertyValueForWebKitCasedIDLAttributeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttributeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleProperties& thisObject, JSValue value, PropertyName propertyName)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPropertyValueForWebKitCasedIDLAttribute(propertyNameToAtomString(propertyName), nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttribute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleProperties>::setPassingPropertyName<setJSCSSStyleProperties_propertyValueForWebKitCasedIDLAttributeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSStyleProperties_propertyValueForDashedIDLAttributeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleProperties& thisObject, PropertyName propertyName)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.propertyValueForDashedIDLAttribute(propertyNameToAtomString(propertyName)))));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleProperties_propertyValueForDashedIDLAttribute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleProperties>::getPassingPropertyName<jsCSSStyleProperties_propertyValueForDashedIDLAttributeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSStyleProperties_propertyValueForDashedIDLAttributeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleProperties& thisObject, JSValue value, PropertyName propertyName)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPropertyValueForDashedIDLAttribute(propertyNameToAtomString(propertyName), nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSStyleProperties_propertyValueForDashedIDLAttribute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleProperties>::setPassingPropertyName<setJSCSSStyleProperties_propertyValueForDashedIDLAttributeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSStyleProperties_propertyValueForEpubCasedIDLAttributeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleProperties& thisObject, PropertyName propertyName)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.propertyValueForEpubCasedIDLAttribute(propertyNameToAtomString(propertyName)))));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleProperties_propertyValueForEpubCasedIDLAttribute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleProperties>::getPassingPropertyName<jsCSSStyleProperties_propertyValueForEpubCasedIDLAttributeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSStyleProperties_propertyValueForEpubCasedIDLAttributeSetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleProperties& thisObject, JSValue value, PropertyName propertyName)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setPropertyValueForEpubCasedIDLAttribute(propertyNameToAtomString(propertyName), nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSStyleProperties_propertyValueForEpubCasedIDLAttribute, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleProperties>::setPassingPropertyName<setJSCSSStyleProperties_propertyValueForEpubCasedIDLAttributeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsCSSStyleProperties_cssFloatGetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleProperties& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.cssFloat())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSStyleProperties_cssFloat, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleProperties>::get<jsCSSStyleProperties_cssFloatGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSCSSStyleProperties_cssFloatSetter(JSGlobalObject& lexicalGlobalObject, JSCSSStyleProperties& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    auto nativeValueConversionResult = convert<IDLLegacyNullToEmptyStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    if (nativeValueConversionResult.hasException(throwScope)) [[unlikely]]
        return false;
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setCssFloat(nativeValueConversionResult.releaseReturnValue());
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSCSSStyleProperties_cssFloat, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSStyleProperties>::set<setJSCSSStyleProperties_cssFloatSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSStyleProperties::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSStyleProperties, UseCustomHeapCellType::No>(vm, "JSCSSStyleProperties"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSStyleProperties.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSStyleProperties = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSStyleProperties.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSStyleProperties = std::forward<decltype(space)>(space); }
    );
}

void JSCSSStyleProperties::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSStyleProperties*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSStyleProperties>&& impl)
{
    return createWrapper<CSSStyleProperties>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSStyleProperties& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

CSSStyleProperties* JSCSSStyleProperties::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSCSSStyleProperties*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
