// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "BorderProperty.h"

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::BorderPropertyPrivate
{
public:
    std::optional<LineProperty> left;
    std::optional<LineProperty> right;
    std::optional<LineProperty> top;
    std::optional<LineProperty> bottom;
};

BorderProperty::BorderProperty()
    : d(std::make_unique<BorderPropertyPrivate>())
{
}

BorderProperty::BorderProperty(const BorderProperty &other)
    : d(std::make_unique<BorderPropertyPrivate>())
{
    d->left = other.d->left;
    d->right = other.d->right;
    d->top = other.d->top;
    d->bottom = other.d->bottom;
}

BorderProperty::BorderProperty(BorderProperty &&other)
    : d(std::move(other.d))
{
}

BorderProperty::~BorderProperty() = default;

BorderProperty &BorderProperty::operator=(const BorderProperty &other)
{
    if (this != &other) {
        d->left = other.d->left;
        d->right = other.d->right;
        d->top = other.d->top;
        d->bottom = other.d->bottom;
    }
    return *this;
}

BorderProperty &BorderProperty::operator=(BorderProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

std::optional<LineProperty> BorderProperty::left() const
{
    return d->left;
}

LineProperty BorderProperty::left_or_new() const
{
    return d->left.value_or(LineProperty{});
}

void BorderProperty::setLeft(const std::optional<LineProperty> &newValue)
{
    if (newValue == d->left) {
        return;
    }

    d->left = newValue;
}
std::optional<LineProperty> BorderProperty::right() const
{
    return d->right;
}

LineProperty BorderProperty::right_or_new() const
{
    return d->right.value_or(LineProperty{});
}

void BorderProperty::setRight(const std::optional<LineProperty> &newValue)
{
    if (newValue == d->right) {
        return;
    }

    d->right = newValue;
}
std::optional<LineProperty> BorderProperty::top() const
{
    return d->top;
}

LineProperty BorderProperty::top_or_new() const
{
    return d->top.value_or(LineProperty{});
}

void BorderProperty::setTop(const std::optional<LineProperty> &newValue)
{
    if (newValue == d->top) {
        return;
    }

    d->top = newValue;
}
std::optional<LineProperty> BorderProperty::bottom() const
{
    return d->bottom;
}

LineProperty BorderProperty::bottom_or_new() const
{
    return d->bottom.value_or(LineProperty{});
}

void BorderProperty::setBottom(const std::optional<LineProperty> &newValue)
{
    if (newValue == d->bottom) {
        return;
    }

    d->bottom = newValue;
}

bool BorderProperty::hasAnyValue() const
{
    if (d->left.has_value() && d->left->hasAnyValue()) {
        return true;
    }
    if (d->right.has_value() && d->right->hasAnyValue()) {
        return true;
    }
    if (d->top.has_value() && d->top->hasAnyValue()) {
        return true;
    }
    if (d->bottom.has_value() && d->bottom->hasAnyValue()) {
        return true;
    }
    return false;
}

bool BorderProperty::isEmpty() const
{
    if (!hasAnyValue()) {
        return true;
    }

    if (d->left.has_value() && !d->left->isEmpty()) {
        return false;
    }
    if (d->right.has_value() && !d->right->isEmpty()) {
        return false;
    }
    if (d->top.has_value() && !d->top->isEmpty()) {
        return false;
    }
    if (d->bottom.has_value() && !d->bottom->isEmpty()) {
        return false;
    }

    return true;
}

void BorderProperty::resolveProperties(const BorderProperty &source, BorderProperty &destination)
{
    if (source.d->left.has_value()) {
        LineProperty property;
        if (destination.d->left.has_value()) {
            property = destination.d->left.value();
        }
        LineProperty::resolveProperties(source.d->left.value(), property);
        if (property.hasAnyValue()) {
            destination.d->left = property;
        }
    }
    if (source.d->right.has_value()) {
        LineProperty property;
        if (destination.d->right.has_value()) {
            property = destination.d->right.value();
        }
        LineProperty::resolveProperties(source.d->right.value(), property);
        if (property.hasAnyValue()) {
            destination.d->right = property;
        }
    }
    if (source.d->top.has_value()) {
        LineProperty property;
        if (destination.d->top.has_value()) {
            property = destination.d->top.value();
        }
        LineProperty::resolveProperties(source.d->top.value(), property);
        if (property.hasAnyValue()) {
            destination.d->top = property;
        }
    }
    if (source.d->bottom.has_value()) {
        LineProperty property;
        if (destination.d->bottom.has_value()) {
            property = destination.d->bottom.value();
        }
        LineProperty::resolveProperties(source.d->bottom.value(), property);
        if (property.hasAnyValue()) {
            destination.d->bottom = property;
        }
    }
}

BorderProperty BorderProperty::empty()
{
    BorderProperty result;
    result.d->left = emptyValue<LineProperty>();
    result.d->right = emptyValue<LineProperty>();
    result.d->top = emptyValue<LineProperty>();
    result.d->bottom = emptyValue<LineProperty>();
    return result;
}

bool Union::Properties::operator==(const BorderProperty &left, const BorderProperty &right)
{
    if (left.left() != right.left()) {
        return false;
    }
    if (left.right() != right.right()) {
        return false;
    }
    if (left.top() != right.top()) {
        return false;
    }
    if (left.bottom() != right.bottom()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, const Union::Properties::BorderProperty &type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << "BorderProperty(" //
                    << "left: " << type.left() //
                    << ", right: " << type.right() //
                    << ", top: " << type.top() //
                    << ", bottom: " << type.bottom() //
                    << ")";
    return debug;
}